/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.planmanager.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.eas.csinterface.syncdatabase.ApplicationScopeType;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataMatchType;
import com.kingdee.eas.csinterface.util.CustColor;
import com.kingdee.eas.csinterface.util.PlanManagerHelper;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.List;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.jdom2.Element;

public class BaseDataMapingInfoConverter
extends AbstractDataBaseInfoConverter {
    @Override
    public boolean canConvert(Class type) {
        return BaseDataMapingInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        try {
            BaseDataMapingInfo baseDataMapingInfo = (BaseDataMapingInfo)source;
            WritableWorkbook writableWorkbook = (WritableWorkbook)context.get("WritableWorkbook");
            WritableSheet writableSheet = writableWorkbook.getSheet(0);
            this.marshalEntry(context, baseDataMapingInfo, writableSheet);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private WritableCellFormat getCellFormat() throws Exception {
        WritableCellFormat cellFormat = new WritableCellFormat(NumberFormats.TEXT);
        cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
        cellFormat.setBackground((Colour)CustColor.CustColor_Yellow);
        return cellFormat;
    }

    private void marshalEntry(MarshallingContext context, BaseDataMapingInfo baseDataMapingInfo, WritableSheet writableSheet) throws Exception {
        KDTable kdtEntrys = (KDTable)context.get("kdtEntrys");
        ObjectValueRender destIDRender = (ObjectValueRender)kdtEntrys.getColumn("destID").getRenderer();
        int rowCount = kdtEntrys.getRowCount();
        int baseRowIndex = 1;
        WritableCellFormat cellFormat = this.getCellFormat();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = kdtEntrys.getRow(i);
            String srcID = (String)row.getCell("srcID").getValue();
            String srcDisplay = this.getRowCellValue(row, "srcDisplay");
            String destID = this.getRowCellValue(row, "destID");
            String destDisplay = destIDRender.getText(row.getCell("destDisplay").getValue());
            int lineIndex = baseRowIndex + i;
            writableSheet.addCell((WritableCell)new Label(0, lineIndex, srcID, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(1, lineIndex, srcDisplay, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(2, lineIndex, destID, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(3, lineIndex, destDisplay, (CellFormat)cellFormat));
        }
    }

    private String getRowCellValue(IRow row, String key) {
        Object value = row.getCell(key).getValue();
        if (null == value) {
            return "";
        }
        if (value instanceof DataBaseInfo) {
            return ((DataBaseInfo)value).getNumber();
        }
        return value.toString();
    }

    private void marshalBaseDataMapping(Element root, BaseDataTypeInfo info, MarshallingContext context) {
        if (null == info) {
            return;
        }
        BaseDataMapingCollection mappings = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseDataType", (Object)info.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection selecters = new SelectorItemCollection();
            selecters.add(new SelectorItemInfo("*"));
            selecters.add(new SelectorItemInfo("entrys.*"));
            view.setSelector(selecters);
            mappings = BaseDataMapingFactory.getRemoteInstance().getBaseDataMapingCollection(view);
            if (mappings == null || mappings.size() == 0) {
                return;
            }
            Object object = context.marshall((Object)mappings);
            this.addChild(root, (Element)object);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        BaseDataTypeInfo info = new BaseDataTypeInfo();
        List children = data.getChildren();
        String FID = this.getElementTextByName(children, "FID");
        info.put("baseDataTypeFID_TO_BE_REFERENCED", FID);
        info.setNumber(this.getElementTextByName(children, "txtNumber"));
        info.setName(this.getElementTextByName(children, "txtName"));
        info.setSrcTable(this.getElementTextByName(children, "txtsrcTable"));
        info.setSrcID(this.getElementTextByName(children, "txtsrcID"));
        info.setSrcDisplay(this.getElementTextByName(children, "txtsrcDisplay"));
        String connNum = this.getElementTextByName(children, "connNum");
        try {
            ConnectionInfo connection = ConnectionFactory.getRemoteInstance().getConnectionInfo("where number='" + connNum + "'");
            if (connection != null) {
                info.setConn(connection);
            }
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u5165\u65b9\u6848\u65f6\uff0c\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\uff08" + connNum + "\uff09\u7684\u8fde\u63a5\u914d\u7f6e");
        }
        DataMatchType matchType = DataMatchType.getEnum(this.getElementTextByName(children, "matchType"));
        info.setMatchType(matchType == null ? DataMatchType.NumName : matchType);
        String baseDataInfoFID = this.getElementTextByName(children, "destBaseDataFID");
        if (null != baseDataInfoFID) {
            try {
                BaseDataInfo baseDataInfo = PlanManagerHelper.getBaseDataInfo(baseDataInfoFID);
                info.setDestBaseData(baseDataInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        info.setDestID(this.getElementTextByName(children, "txtdestID"));
        info.setDestDisplay(this.getElementTextByName(children, "txtdestDisplay"));
        String destOrgField = this.getElementTextByName(children, "destOrgField");
        boolean isNullOrgField = StringUtils.isEmpty((String)destOrgField) || StringUtils.equalsIgnoreCase((String)destOrgField, (String)"null");
        destOrgField = isNullOrgField ? null : destOrgField;
        info.setDestOrgField(destOrgField);
        String ruleId = this.getElementTextByName(children, "rule");
        boolean isNullruleId = StringUtils.isEmpty((String)ruleId) || StringUtils.equalsIgnoreCase((String)ruleId, (String)"null");
        ruleId = isNullruleId ? null : ruleId;
        info.setRule(ruleId);
        info.setIsAutoMatch(StringUtils.equals((String)this.getElementTextByName(children, "isAutoMatch"), (String)"1"));
        info.setApplicationScope(ApplicationScopeType.getEnum(this.getElementTextByName(children, "applicationScope")));
        return info;
    }
}

