/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.planmanagergroup.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.planmanager.PlanManagerInfo;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupFactory;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupInfo;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupTreeInfo;
import com.kingdee.eas.csinterface.planmanagergroup.client.AbstractPlanManagerGroupEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class PlanManagerGroupEditUI
extends AbstractPlanManagerGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PlanManagerGroupEditUI.class);

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PlanManagerGroupFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("treeid", (PlanManagerGroupTreeInfo)this.getUIContext().get("ParentNode"));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        PlanManagerGroupInfo objectValue = new PlanManagerGroupInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.hideWorkButtons();
        this.setTxtsDisable();
        this.kdtEntry_detailPanel.setTitle("\u65b9\u6848");
        this.kdtEntry_detailPanel.addRemoveListener(new IDetailPanelListener(){

            public void beforeEvent(DetailPanelEvent event) throws Exception {
                PlanManagerGroupEditUI.this.beforeRemoveEntry();
            }

            public void afterEvent(DetailPanelEvent event) throws Exception {
            }
        });
        KDBizPromptBox promptBox = this.getPromptBox();
        this.initPromptBoxCell4Table(promptBox);
    }

    private void setTxtsDisable() {
        this.contsrcSysName.setEnabled(false);
        this.contsrcSysVersion.setEnabled(false);
        this.contsrcBill.setEnabled(false);
        this.contdestSysVersion.setEnabled(false);
        this.contdestSysName.setEnabled(false);
        this.contdestBill.setEnabled(false);
    }

    private void hideWorkButtons() {
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
    }

    @Override
    protected void kdtEntry_editStopped(KDTEditEvent e) throws Exception {
        KDTable table = (KDTable)e.getSource();
        IRow row = table.getRow(e.getRowIndex());
        PlanManagerInfo info = (PlanManagerInfo)e.getValue();
        this.fillCell(row, info);
        this.fillTxts(info, table);
    }

    private void fillCell(IRow row, PlanManagerInfo info) {
        ICell cell = row.getCell("name");
        if (null != info) {
            cell.setValue((Object)info.getName());
        } else {
            cell.setValue((Object)"");
        }
    }

    private void fillTxts(PlanManagerInfo info, KDTable table) {
        if (1 != table.getRowCount() || info == null) {
            return;
        }
        String srcSys = info.getSrcsysname().trim();
        String srcVersion = info.getSrcsysversion().trim();
        String srcBill = info.getSrcsycbillname().trim();
        String destSys = info.getDestsysname().trim();
        String destVesion = info.getDestsysversion().trim();
        String destBill2 = info.getDestsysbillname().trim();
        this.changeTxts(srcSys, srcVersion, srcBill, destSys, destVesion, destBill2);
        this.changePromptBoxCell4Table(srcSys, srcVersion, srcBill, destSys, destVesion, destBill2);
    }

    private void changePromptBoxCell4Table(String srcSys, String srcVersion, String srcBill, String destSys, String destVesion, String destBill2) {
        EntityViewInfo ev = this.createEntityViewInfo(srcSys, srcVersion, srcBill, destSys, destVesion, destBill2);
        KDBizPromptBox promptBox = this.getPromptBox();
        promptBox.setEntityViewInfo(ev);
        this.initPromptBoxCell4Table(promptBox);
    }

    private void changeTxts(String srcSys, String srcVersion, String srcBill, String destSys, String destVesion, String destBill2) {
        this.txtsrcSysName.setText(srcSys);
        this.txtsrcSysVersion.setText(srcVersion);
        this.txtsrcBill.setText(srcBill);
        this.txtdestSysName.setText(destSys);
        this.txtdestSysVersion.setText(destVesion);
        this.txtdestBill.setText(destBill2);
    }

    private void initPromptBoxCell4Table(KDBizPromptBox promptBox) {
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)promptBox);
        this.kdtEntry.getColumn("planManager").setEditor((ICellEditor)editor);
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntry.getColumn("planManager").setRenderer((IBasicRender)render);
    }

    private final KDBizPromptBox getPromptBox() {
        KDBizPromptBox entryPromptBox = new KDBizPromptBox();
        entryPromptBox.setQueryInfo("com.kingdee.eas.csinterface.planmanager.app.PlanManagerQuery");
        entryPromptBox.setVisible(true);
        entryPromptBox.setEditable(true);
        entryPromptBox.setDisplayFormat("$number$");
        entryPromptBox.setEditFormat("$number$");
        entryPromptBox.setCommitFormat("$number$");
        return entryPromptBox;
    }

    private EntityViewInfo createEntityViewInfo(String srcSys, String srcVersion, String srcBill, String destSys, String destVesion, String destBill2) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("srcsysname", (Object)srcSys, CompareType.EQUALS));
        items.add(new FilterItemInfo("srcsysversion", (Object)srcVersion, CompareType.EQUALS));
        items.add(new FilterItemInfo("srcsycbillname", (Object)srcBill, CompareType.EQUALS));
        items.add(new FilterItemInfo("destsysname", (Object)destSys, CompareType.EQUALS));
        items.add(new FilterItemInfo("destsysversion", (Object)destVesion, CompareType.EQUALS));
        items.add(new FilterItemInfo("destsysbillname", (Object)destBill2, CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        return ev;
    }

    protected void beforeRemoveEntry() {
        if (1 != this.kdtEntry.getRowCount()) {
            return;
        }
        this.cleanTxts();
        KDBizPromptBox promptBox = this.getPromptBox();
        this.initPromptBoxCell4Table(promptBox);
    }

    private void cleanTxts() {
        this.txtsrcSysName.setText("");
        this.txtsrcSysVersion.setText("");
        this.txtsrcBill.setText("");
        this.txtdestSysName.setText("");
        this.txtdestSysVersion.setText("");
        this.txtdestBill.setText("");
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        int count;
        super.verifyInput(e);
        String name = (String)this.txtName.getSelectedItemData();
        if (StringUtils.isEmpty((String)name)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            SysUtil.abort();
        }
        if (0 == (count = this.kdtEntry.getRowCount())) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5fc5\u987b\u542b\u6709\u5206\u5f55!");
            SysUtil.abort();
        }
        for (int i = 0; i < count; ++i) {
            IRow row = this.kdtEntry.getRow(i);
            IObjectValue data = (IObjectValue)row.getUserObject();
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                Object obj = data.get("planmanager");
                if (obj != null) continue;
                MsgBox.showInfo((Component)((Object)this), (String)"\u5206\u5f55\u4e2d\u4e0d\u80fd\u542b\u6709\u7a7a\u884c!");
                SysUtil.abort();
                continue;
            }
            Object id = data.get("id");
            if (null != id) continue;
            MsgBox.showInfo((Component)((Object)this), (String)"\u5206\u5f55\u4e2d\u4e0d\u80fd\u542b\u6709\u7a7a\u884c!");
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setTxtsDisable();
    }
}

