/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.planmanagergroup.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.csinterface.cloud.DescElement;
import com.kingdee.eas.csinterface.cloud.SimpleJSONUtil;
import com.kingdee.eas.csinterface.planmanagergroup.IPlanManagerGroupFacade;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupFacadeFactory;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupFactory;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupInfo;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupTreeFactory;
import com.kingdee.eas.csinterface.planmanagergroup.client.AbstractPlanManagerGroupListUI;
import com.kingdee.eas.csinterface.planmanagergroup.client.PlanManagerGroupTreeEditUI;
import com.kingdee.eas.csinterface.planmanagergroup.download.client.PlanManagerGroupDownloadUI;
import com.kingdee.eas.csinterface.util.EncodingUtils;
import com.kingdee.eas.csinterface.util.Export2FileUtil;
import com.kingdee.eas.csinterface.util.FileContentReader;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.IOUtils;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.csinterface.util.PlanManagerGroupHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PlanManagerGroupListUI
extends AbstractPlanManagerGroupListUI {
    private static final Logger logger = CoreUIObject.getLogger(PlanManagerGroupListUI.class);
    private static final String PLAN_GROUP_SUFFIX = "plangroup";

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PlanManagerGroupFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return PlanManagerGroupTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return PlanManagerGroupTreeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return "\u65b9\u6848\u7ec4\u5408";
    }

    @Override
    protected IObjectValue createNewData() {
        PlanManagerGroupInfo objectValue = new PlanManagerGroupInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnLocate.setVisible(false);
        this.btnMoveTree.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        try {
            File planFile = Export2FileUtil.getDialogFileWithFileName((Component)((Object)this), "\u65b9\u6848\u7ec4\u5408\u5bfc\u5165", "\u6253\u5f00", new String[]{PLAN_GROUP_SUFFIX}, "\u65b9\u6848\u7ec4\u5408", null);
            if (null == planFile) {
                return;
            }
            if (!planFile.getName().endsWith(".plangroup")) {
                MsgBox.showInfo((String)("\u6587\u4ef6\u3010" + planFile.getName() + "\u3011\u4e0d\u662f\u65b9\u6848\u7ec4\u5408\u6587\u4ef6\u3002"));
                return;
            }
            String docXML = FileContentReader.readUTF8FileContent(planFile.getCanonicalPath());
            PlanManagerGroupInfo info = PlanManagerGroupHelper.convertXMLToPlan(docXML);
            if (null != info) {
                IPlanManagerGroupFacade facade = PlanManagerGroupFacadeFactory.getRemoteInstance();
                facade.saveImportPlanGroup(info);
                MsgBox.showInfo((String)"\u5f15\u5165\u5916\u90e8\u65b9\u6848\u7ec4\u5408\u6210\u529f\u3002");
            } else {
                MsgBox.showInfo((String)("\u5f15\u5165\u5916\u90e8\u65b9\u6848\u7ec4\u5408\u6210\u529f\u3002\u89e3\u6790\u65b9\u6848\u7ec4\u5408\u3010" + planFile.getName() + "\u3011\u5931\u8d25\u3002"));
            }
            this.execQuery();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u5f15\u5165\u5916\u90e8\u65b9\u6848\u7ec4\u5408\u5931\u8d25\u3002", (String)exception.getMessage(), (int)1);
        }
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        try {
            File exportFile = Export2FileUtil.getExportFileWithOverrideTip((Component)((Object)this), "\u65b9\u6848\u7ec4\u5408\u5bfc\u51fa", "\u4fdd\u5b58", new String[]{PLAN_GROUP_SUFFIX}, "\u65b9\u6848\u7ec4\u5408", "\u65b9\u6848\u7ec4\u5408\u5bfc\u51fa.plangroup");
            if (null == exportFile) {
                return;
            }
            exportFile = Export2FileUtil.getRealExportPlanFile(exportFile, PLAN_GROUP_SUFFIX);
            this.checkSelected();
            String key = this.getKeyFieldName();
            String[] selectedIDs = MyKDTableUtil.getSelectedListId(this.tblMain, key);
            PlanManagerGroupInfo info = PlanManagerGroupHelper.getPlanManagerGroupInfoWithAllValue(selectedIDs[0]);
            PlanManagerGroupHelper.replaceBOTMappingInfo(info);
            String xmlData = PlanManagerGroupHelper.convertPlanToXML(info);
            byte[] data = EncodingUtils.str2BytesUTF8(xmlData);
            IOUtils.writeToFile(data, exportFile.getAbsolutePath());
            String planName = info.getName();
            planName = null == planName ? "" : "\u3010" + planName + "\u3011";
            MsgBox.showInfo((String)("\u65b9\u6848\u7ec4\u5408 " + planName + "\u5f15\u51fa\u6210\u529f\u3002"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u65b9\u6848\u5f15\u51fa\u5931\u8d25\u3002", (String)exception.getMessage(), (int)1);
        }
    }

    @Override
    protected void btnUpload_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkSelected();
            String key = this.getKeyFieldName();
            String[] selectedIDs = MyKDTableUtil.getSelectedListId(this.tblMain, key);
            if (0 == selectedIDs.length) {
                MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u4e2d\u9700\u8981\u4e0a\u4f20\u7684\u65b9\u6848.");
                return;
            }
            if (0 != MsgBox.showConfirm2((String)"\u60a8\u786e\u5b9a\u8981\u4e0a\u4f20\u8fd9\u4e2a\u6587\u4ef6\u5230\u4e91\u7aef?")) {
                return;
            }
            final PlanManagerGroupInfo info = PlanManagerGroupHelper.getPlanManagerGroupInfoWithAllValue(selectedIDs[0]);
            PlanManagerGroupHelper.replaceBOTMappingInfo(info);
            String xmlData = PlanManagerGroupHelper.convertPlanToXML(info);
            final byte[] data = EncodingUtils.str2BytesUTF8(xmlData);
            final String fileName = PlanManagerGroupHelper.getPlanGroupTargetFileNameInCloud(info);
            if (PlanManagerGroupHelper.isPlanExistInCloud(fileName)) {
                MsgBox.showInfo((String)"\u5b58\u5728\u76f8\u540c\u573a\u666f\u4e0b\u7684\u540c\u540d\u65b9\u6848\u7ec4\u5408\uff0c\u8bf7\u4fee\u6539'\u65b9\u6848\u7ec4\u5408\u540d\u79f0'\u540e\u518d\u4e0a\u4f20.");
                return;
            }
            DescElement desc = new DescElement(info);
            final String filedesc = SimpleJSONUtil.toJson(desc);
            LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u8fdb\u5ea6\u63d0\u793a", "\u60a8\u597d\uff0c\u6587\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u7b49...");
            dialog.setLongTimeTask(new ILongTimeTask2(){

                @Override
                public Object exec() throws Exception {
                    byte[] bytes = PlanManagerGroupHelper.uploadFile(fileName, filedesc, data);
                    String rspStr = EncodingUtils.bytes2StrUTF8(bytes);
                    System.out.println(rspStr);
                    return rspStr;
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    String resultStr = (String)result;
                    if (null != resultStr && -1 != resultStr.indexOf("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f")) {
                        MsgBox.showInfo((String)("\u65b9\u6848\u7ec4\u5408\u3010" + info.getName() + "\u3011\u4e0a\u4f20\u6210\u529f\uff01"));
                    } else {
                        MsgBox.showDetailAndOK(null, (String)("\u65b9\u6848\u7ec4\u5408\u3010" + info.getName() + "\u3011\u4e0a\u4f20\u5931\u8d25\u3002"), (String)resultStr, (int)1);
                    }
                }
            });
            dialog.show();
        }
        catch (AbortException key) {
        }
        catch (Exception exception) {
            MsgBox.showDetailAndOK(null, (String)"\u65b9\u6848\u7ec4\u5408\u4e0a\u4f20\u529f\u80fd\u65e0\u6cd5\u6b63\u5e38\u5b8c\u6210\u3002", (String)exception.getMessage(), (int)1);
        }
    }

    @Override
    protected void btnDownload_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)UIModelDialogFactory.class.getName());
        HashMap uiContext = new HashMap();
        HashMap dataObjects = new HashMap();
        IUIWindow uiWindow = uiFactory.create(PlanManagerGroupDownloadUI.class.getName(), uiContext, dataObjects);
        uiWindow.show();
        this.execQuery();
    }
}

