/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.uiframe.client.UINewFrameFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataMultiPlanEditUI;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataSynEditUI;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataTreeListUI;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.business.client.BizWizardEditUI;
import com.kingdee.eas.csinterface.business.common.BusinessConstants;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.schedule.client.AbstractScheduleConfigListUI;
import com.kingdee.eas.csinterface.schedule.util.CronExpTranslation;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.BtnEASPivot;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.EIPUIClassParamUtil;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ScheduleConfigListUI
extends AbstractScheduleConfigListUI {
    private static final Logger logger = CoreUIObject.getLogger(ScheduleConfigListUI.class);
    private Map<String, Boolean> scheduleStatusMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> emptyBillMappingInfoMap = new HashMap<String, Boolean>();
    private boolean isExeBeforeExecuteQuery = false;
    private static final int STATUS_DISABLED = 1;
    private static final int STATUS_ENABLED = 2;
    private static final int STATUS_BATCH_ENABLED = 3;
    private Set<String> editDataIdset = new HashSet<String>();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ScheduleFactory.getRemoteInstance();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            int idIndex = -1;
            int descriptionIndex = -1;
            int timerRuleExpresssionIndex = -1;
            int enabledIndex = -1;
            int timerStartDateIndex = -1;
            int billMappingInfoIndex = -1;
            ResultSetMetaData metaData = rowSet.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String columnName = metaData.getColumnName(i);
                if ("id".equalsIgnoreCase(columnName)) {
                    idIndex = i;
                    continue;
                }
                if ("description".equalsIgnoreCase(columnName)) {
                    descriptionIndex = i;
                    continue;
                }
                if ("timerRuleExpresssion".equalsIgnoreCase(columnName)) {
                    timerRuleExpresssionIndex = i;
                    continue;
                }
                if ("enabled".equalsIgnoreCase(columnName)) {
                    enabledIndex = i;
                    continue;
                }
                if ("timerStartDate".equalsIgnoreCase(columnName)) {
                    timerStartDateIndex = i;
                    continue;
                }
                if (!"strategy.billMappingName".equalsIgnoreCase(columnName)) continue;
                billMappingInfoIndex = i;
            }
            rowSet.beforeFirst();
            while (rowSet.next()) {
                String timerRuleExpresssion = rowSet.getString(timerRuleExpresssionIndex);
                if (StringUtils.isEmpty((String)timerRuleExpresssion)) continue;
                timerRuleExpresssion = timerRuleExpresssion.replaceAll("[^:]+:", "").trim();
                rowSet.updateString(descriptionIndex, new CronExpTranslation(rowSet.getDate(timerStartDateIndex), timerRuleExpresssion).parse());
                rowSet.updateString(timerRuleExpresssionIndex, timerRuleExpresssion);
                this.scheduleStatusMap.put(rowSet.getString(idIndex), rowSet.getBoolean(enabledIndex));
                this.emptyBillMappingInfoMap.put(rowSet.getString(idIndex), StringUtils.isEmpty((String)rowSet.getString(billMappingInfoIndex)));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void switchButtonsStatus(int status) {
        switch (status) {
            case 1: {
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.enableScheduleButton.setEnabled(false);
                this.disableScheduleButton.setEnabled(true);
                break;
            }
            case 2: {
                this.btnEdit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.enableScheduleButton.setEnabled(true);
                this.disableScheduleButton.setEnabled(false);
                break;
            }
            case 3: {
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.enableScheduleButton.setEnabled(true);
                this.disableScheduleButton.setEnabled(true);
                break;
            }
            default: {
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.enableScheduleButton.setEnabled(false);
                this.disableScheduleButton.setEnabled(false);
            }
        }
    }

    private String getSelectedId() {
        ArrayList ids = this.getSelectedIdValues();
        if (ids != null && ids.size() > 0) {
            return (String)ids.get(0);
        }
        return null;
    }

    private List<String> getSelectedIds() {
        ArrayList<String> selectedIds = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        Object id = "";
        for (int i = 0; i < selectRows.length; ++i) {
            try {
                id = MyKDTableUtil.getTableCellValue(this.tblMain, selectRows[i], "id");
                selectedIds.add(id.toString());
                continue;
            }
            catch (Exception e2) {
                MsgBox.showInfo((String)e2.getMessage());
                e2.printStackTrace();
            }
        }
        return selectedIds;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        String selectedId = this.getSelectedId();
        if (selectedId == null) {
            this.switchButtonsStatus(-1);
            return;
        }
        boolean enable = this.scheduleStatusMap.get(selectedId);
        this.switchButtonsStatus(enable ? 1 : 2);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        BtnEASPivot.btnInVisible(this);
        this.switchButtonsStatus(-1);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.enableScheduleButton.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.disableScheduleButton.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.tblMain.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                ArrayList ids = ScheduleConfigListUI.this.getSelectedIdValues();
                if (ids != null && !ids.isEmpty()) {
                    if (ids.size() > 1) {
                        ScheduleConfigListUI.this.switchButtonsStatus(3);
                    } else {
                        boolean enable = (Boolean)ScheduleConfigListUI.this.scheduleStatusMap.get(ids.get(0));
                        int currenteSelectedRow = e.getSelectBlock().getBeginRow();
                        Object bdObj = ScheduleConfigListUI.this.tblMain.getRow(currenteSelectedRow).getCell("baseDataSynNumber").getValue();
                        Object mappingObj = ScheduleConfigListUI.this.tblMain.getRow(currenteSelectedRow).getCell("baseDataMap").getValue();
                        if (bdObj != null && !StringUtils.isEmpty((String)bdObj.toString())) {
                            ScheduleConfigListUI.this.switchButtonsStatus(enable ? 1 : 2);
                        } else if (mappingObj != null && !StringUtils.isEmpty((String)mappingObj.toString())) {
                            ScheduleConfigListUI.this.switchButtonsStatus(enable ? 1 : 2);
                        } else if (((Boolean)ScheduleConfigListUI.this.emptyBillMappingInfoMap.get(ids.get(0))).booleanValue()) {
                            if (enable) {
                                ScheduleConfigListUI.this.switchButtonsStatus(1);
                                ScheduleConfigListUI.this.disableScheduleButton.setEnabled(true);
                            } else {
                                ScheduleConfigListUI.this.switchButtonsStatus(-1);
                                ScheduleConfigListUI.this.btnRemove.setEnabled(true);
                                ScheduleConfigListUI.this.enableScheduleButton.setEnabled(true);
                            }
                        } else {
                            ScheduleConfigListUI.this.switchButtonsStatus(enable ? 1 : 2);
                        }
                        if (ScheduleConfigListUI.this.enableScheduleButton.isEnabled()) {
                            ScheduleConfigListUI.this.btnEdit.setEnabled(true);
                        }
                    }
                }
            }
        });
        Map uiContext = this.getUIContext();
        Object obj = uiContext.get("BizWizardEditUiKey");
        if (null != obj && obj instanceof BizWizardEditUI && uiContext.get("rootOprtState").equals(OprtState.VIEW)) {
            this.initialBarItem(false);
        }
        this.disableScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedIds = ScheduleConfigListUI.this.getSelectedIds();
                if (selectedIds.size() == 0) {
                    return;
                }
                ScheduleConfigListUI.this.switchButtonsStatus(-1);
                StringBuffer errorMsg = new StringBuffer();
                for (String selectedId : selectedIds) {
                    if (selectedId == null) continue;
                    try {
                        ScheduleFactory.getRemoteInstance().disableSchedule(selectedId);
                    }
                    catch (Exception exp) {
                        errorMsg.append(selectedId + ":" + exp.getMessage() + ";");
                    }
                }
                if (errorMsg.length() > 0) {
                    MsgBox.showError((String)("\u7981\u7528\u8c03\u5ea6\u7b56\u7565\u5931\u8d25:" + errorMsg.toString()));
                }
                try {
                    ScheduleConfigListUI.this.refreshList();
                    if (ScheduleConfigListUI.this.tblMain.getRowCount() > 0) {
                        KDTableUtil.setSelectedRow((KDTable)ScheduleConfigListUI.this.tblMain, (int)0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.enableScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedIds = ScheduleConfigListUI.this.getSelectedIds();
                if (selectedIds.size() == 0) {
                    return;
                }
                ScheduleConfigListUI.this.switchButtonsStatus(-1);
                StringBuffer errorMsg = new StringBuffer();
                for (String selectedId : selectedIds) {
                    if (selectedId == null) continue;
                    try {
                        ScheduleFactory.getRemoteInstance().enableSchedule(selectedId);
                    }
                    catch (Exception exp) {
                        errorMsg.append(selectedId + ":" + exp.getMessage() + ";");
                    }
                }
                if (errorMsg.length() > 0) {
                    MsgBox.showError((String)("\u542f\u7528\u8c03\u5ea6\u7b56\u7565\u5931\u8d25:" + errorMsg.toString()));
                }
                try {
                    ScheduleConfigListUI.this.refreshList();
                    if (ScheduleConfigListUI.this.tblMain.getRowCount() > 0) {
                        KDTableUtil.setSelectedRow((KDTable)ScheduleConfigListUI.this.tblMain, (int)0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedId = ScheduleConfigListUI.this.getSelectedId();
                if (selectedId == null) {
                    return;
                }
                ScheduleInfo scheduleInfo = null;
                try {
                    scheduleInfo = ScheduleFactory.getRemoteInstance().getScheduleInfo((IObjectPK)new ObjectUuidPK(selectedId));
                }
                catch (Exception e1) {
                    SysUtil.abort();
                }
                if (scheduleInfo == null) {
                    ScheduleConfigListUI.this.abort();
                }
                try {
                    IUIFactory uiFactory = UIFactory.createUIFactory((String)UINewFrameFactory.class.getName());
                    if (scheduleInfo.getActionType().getValue() == 600) {
                        scheduleInfo.setBaseDataGroupRule2BaseData(null);
                    }
                    HashMap<String, Object> uiContext = new HashMap<String, Object>();
                    HashMap dataObjects = new HashMap();
                    uiContext.put("Owner", (Object)ScheduleConfigListUI.this);
                    uiContext.put("scheduleInfo", scheduleInfo);
                    uiContext.put("BizWizardEditUiKey", ScheduleConfigListUI.this.getUIContext().get("BizWizardEditUiKey"));
                    IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.csinterface.schedule.client.ScheduleEditUI", uiContext, dataObjects, OprtState.EDIT);
                    uiWindow.show();
                    int index = KDTableUtil.getSelectedRows((KDTable)ScheduleConfigListUI.this.tblMain)[0];
                    ScheduleConfigListUI.this.refreshList();
                    KDTableUtil.setSelectedRow((KDTable)ScheduleConfigListUI.this.tblMain, (int)index);
                }
                catch (Exception exp) {
                    SysUtil.abort();
                }
            }
        });
        if (this.enableScheduleButton.isEnabled()) {
            this.btnRemove.setEnabled(false);
        }
        this.tblMain.getColumn("baseDataFieldMapping").getStyleAttributes().setHided(true);
        Object uiParam = uiContext.get("UIClassParam");
        if (uiParam != null) {
            this.setColumnsVisible(uiParam.toString());
        }
    }

    public void setColumnsVisible(String uiParam) {
        if ("k3Schedule".equalsIgnoreCase(uiParam)) {
            this.tblMain.getColumn("bdrMapping").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bdrMappingGroup").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("baseDataSynNumber").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("baseDataSynName").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("filtedata").getStyleAttributes().setHided(true);
        }
        if ("easSchedule".equalsIgnoreCase(uiParam)) {
            this.tblMain.getColumn("bdrMapping").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bdrMappingGroup").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("filtedata").getStyleAttributes().setHided(true);
        } else if ("commonBaseDataSchedule".equalsIgnoreCase(uiParam)) {
            this.tblMain.getColumn("billMappingNumber").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("botpName").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("baseDataFieldMapping").getStyleAttributes().setHided(false);
        } else if ("commonBillMappingSchedule".equalsIgnoreCase(uiParam)) {
            this.tblMain.getColumn("bdrMapping").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bdrMappingGroup").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("baseDataSynNumber").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("filtedata").getStyleAttributes().setHided(true);
        } else if ("commonReportSchedule".equalsIgnoreCase(uiParam)) {
            this.tblMain.getColumn("bdrMapping").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bdrMappingGroup").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("baseDataSynNumber").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("filtedata").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("botpName").getStyleAttributes().setHided(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        String selectedId = this.getSelectedId();
        if (selectedId == null) {
            return;
        }
        ScheduleInfo scheduleInfo = null;
        try {
            scheduleInfo = ScheduleFactory.getRemoteInstance().getScheduleInfo((IObjectPK)new ObjectUuidPK(selectedId));
        }
        catch (Exception e1) {
            SysUtil.abort();
        }
        if (scheduleInfo == null) {
            this.abort();
        }
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)UINewFrameFactory.class.getName());
            HashMap<String, Object> uiContext = new HashMap<String, Object>();
            HashMap dataObjects = new HashMap();
            uiContext.put("Owner", (Object)this);
            if (scheduleInfo.getActionType().getValue() == 600) {
                scheduleInfo.setBaseDataGroupRule2BaseData(null);
            }
            uiContext.put("scheduleInfo", scheduleInfo);
            uiContext.put("BizWizardEditUiKey", this.getUIContext().get("BizWizardEditUiKey"));
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.csinterface.schedule.client.ScheduleEditUI", uiContext, dataObjects, OprtState.VIEW);
            uiWindow.show();
            int index = KDTableUtil.getSelectedRows((KDTable)this.tblMain)[0];
            this.refreshList();
            KDTableUtil.setSelectedRow((KDTable)this.tblMain, (int)index);
        }
        catch (Exception exp) {
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        UIContext uiContext = new UIContext((Object)this);
        HashMap dataObjects = new HashMap();
        uiContext.put("billMappingId", this.getUIContext().get("billMappingId"));
        uiContext.put("BizWizardEditUiKey", this.getUIContext().get("BizWizardEditUiKey"));
        uiContext.put("UIClassParam", this.getUIContext().get("UIClassParam"));
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.csinterface.schedule.client.ScheduleEditUI", (Map)uiContext, dataObjects, OprtState.ADDNEW);
        uiWindow.show();
        IObjectPK pk = (IObjectPK)uiContext.get("pk");
        try {
            this.refreshList();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        Object id = MyKDTableUtil.getTableCellValue(this.tblMain, selectRows[0], "id");
        super.actionRemove_actionPerformed(e);
        Map uiContext = this.getUIContext();
        Object obj = uiContext.get("Owner");
        if (obj != null && obj instanceof BaseDataSynEditUI) {
            BaseDataSynEditUI editUI = (BaseDataSynEditUI)obj;
            editUI.setHasModified(true);
        }
    }

    protected void Remove() throws Exception {
        String selectedId = this.getSelectedId();
        ScheduleInfo scheduleInfo = null;
        try {
            scheduleInfo = ScheduleFactory.getRemoteInstance().getScheduleInfo((IObjectPK)new ObjectUuidPK(selectedId));
        }
        catch (Exception e1) {
            SysUtil.abort();
        }
        String number = scheduleInfo.getSimpleName();
        IObjectPK pk = LogUtil.beginLog(null, (String)"\u8c03\u5ea6\u7b56\u7565\u5220\u9664", (BOSObjectType)new ScheduleInfo().getBOSType(), null, (String)("\u8c03\u5ea6\u7b56\u7565\u5220\u9664\uff0c\u540d\u79f0\uff1a" + number));
        super.Remove();
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void setHasModifyValue() {
        Object bizward;
        if (this.confirmRemove() && (bizward = this.getUIContext().get("BizWizardEditUiKey")) != null) {
            BizWizardEditUI wizardUi = (BizWizardEditUI)((Object)bizward);
            wizardUi.setHasModified(true);
        }
    }

    private boolean confirmAgentSchedule(String selectedId, String actionName) {
        DataSourceType dsType;
        ScheduleInfo scheduleInfo;
        try {
            scheduleInfo = ScheduleFactory.getRemoteInstance().getScheduleInfo((IObjectPK)new ObjectUuidPK(selectedId));
        }
        catch (Exception ex) {
            MsgBox.showError((String)"\u83b7\u53d6\u8c03\u5ea6\u7b56\u7565\u4fe1\u606f\u5931\u8d25", (String)ex.getMessage());
            return false;
        }
        BillMappingInfo billMappingInfo = scheduleInfo.getStrategy();
        if (billMappingInfo != null && (dsType = billMappingInfo.getDsType()) != null && DataSourceType.agent.getValue().equals(dsType.getValue())) {
            EipUserInfo userInfo = billMappingInfo.getAgentUser();
            int result = MsgBox.showConfirm2((String)("\u662f\u5426\u5206\u914d" + actionName + "\u8c03\u5ea6\u7b56\u7565\u4efb\u52a1\u7ed9\u5ba2\u6237\u7aef\u4ee3\u7406'" + userInfo.getNumber() + "'?"));
            if (0 != result) {
                return false;
            }
        }
        EipUserInfo userInfo = null;
        BaseDataSynHeadInfo baseDataInfo = scheduleInfo.getBaseDataSyn();
        if (baseDataInfo != null) {
            int result;
            IObjectPK pk = CommonUtil.convert2PK(baseDataInfo.getId().toString());
            try {
                BaseDataSynHeadInfo info = BaseDataSynHeadFactory.getRemoteInstance().getBaseDataSynHeadInfo(pk);
                IObjectPK pk2 = CommonUtil.convert2PK(info.getAgent().getId().toString());
                userInfo = EipUserFactory.getRemoteInstance().getEipUserInfo(pk2);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (userInfo != null && 0 != (result = MsgBox.showConfirm2((String)("\u662f\u5426\u5206\u914d" + actionName + "\u8c03\u5ea6\u7b56\u7565\u4efb\u52a1\u7ed9\u5ba2\u6237\u7aef\u4ee3\u7406'" + userInfo.getName() + "'?")))) {
                return false;
            }
        }
        return true;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        this.isExeBeforeExecuteQuery = true;
        Map uiContext = this.getUIContext();
        Object obj = uiContext.get("BizWizardEditUiKey");
        String[][] allFilter = new String[][]{{"mappingType", "strategy.mappingType", "OR", null}, {"baseDataType", "baseDataSyn.baseDataSynType", "OR", null}, {"configType", "baseDataMap.applicationScope", "OR", null}};
        EIPUIClassParamUtil.setFilterByBatchParam(this.getUIContext(), "logType", ev, allFilter);
        if (this.getUIContext().get("UIClassParam") != null && this.getUIContext().get("UIClassParam").toString().equalsIgnoreCase("commonBaseDataSchedule")) {
            EIPUIClassParamUtil.setFilterByBatchParamNew(this.getUIContext(), "logType", ev, allFilter);
        }
        super.beforeExcutQuery(ev);
        if (null != obj && obj instanceof BizWizardEditUI) {
            HashSet<String> idSet = (HashSet<String>)uiContext.get(BusinessConstants.getBtnCodeEntryColName("schedule"));
            FilterInfo filterInfo = new FilterInfo();
            if (idSet == null || idSet.size() == 0) {
                idSet = new HashSet<String>();
                Object billMappingId = uiContext.get("billMappingId");
                if (billMappingId != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("strategy.id", (Object)billMappingId.toString(), CompareType.EQUALS));
                }
            }
            if (idSet.size() != 0 || this.editDataIdset.size() != 0) {
                idSet.addAll(this.editDataIdset);
                filterInfo.getFilterItems().add(new FilterItemInfo("ID", idSet, CompareType.INCLUDE));
            }
            if (null == ev.getFilter() || ev.getFilter().getFilterItems().size() == 0) {
                ev.setFilter(filterInfo);
            } else {
                try {
                    ev.getFilter().mergeFilter(filterInfo, "AND");
                }
                catch (BOSException e) {
                    logger.warn((Object)e.getMessage());
                }
            }
            this.tblMain.getColumn("baseDataSynNumber").setWidth(0);
            this.tblMain.getColumn("baseDataSynName").setWidth(0);
        }
        if (uiContext.get("BDID") != null) {
            IObjectPK[] pks = null;
            try {
                pks = ScheduleFactory.getRemoteInstance().getPKList("where baseDataSyn.id = '" + uiContext.get("BDID").toString() + "'");
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            HashSet<String> idSet = new HashSet<String>();
            if (null != pks) {
                for (IObjectPK pk : pks) {
                    idSet.add(pk.toString());
                }
            }
            FilterInfo filterInfo = new FilterInfo();
            if (idSet == null || idSet.size() == 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("ID", (Object)"NULL", CompareType.IS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("ID", idSet, CompareType.INCLUDE));
            }
            if (null == ev.getFilter() || ev.getFilter().getFilterItems().size() == 0) {
                ev.setFilter(filterInfo);
            } else {
                try {
                    ev.getFilter().mergeFilter(filterInfo, "AND");
                }
                catch (BOSException e) {
                    logger.warn((Object)e.getMessage());
                }
            }
            this.tblMain.getColumn("billMappingNumber").setWidth(0);
            this.tblMain.getColumn("billMappingName").setWidth(0);
            this.tblMain.getColumn("botpName").setWidth(0);
        }
    }

    public boolean destroyWindow() {
        Set<String> idSet;
        EditUI bdUI;
        Object owner;
        Map uiContext = this.getUIContext();
        Object obj = uiContext.get("BizWizardEditUiKey");
        if (null != obj && obj instanceof BizWizardEditUI) {
            Set<String> uuidSet = this.getDataId();
            BizWizardEditUI editUi = (BizWizardEditUI)((Object)obj);
            Set<String> idsSet = this.getDataId();
            editUi.putIdSetToEditUi("schedule", idsSet);
            editUi.setValueToEntryAfterSubmit("schedule", uuidSet);
        }
        if ((owner = uiContext.get("Owner")) != null && owner instanceof BaseDataSynEditUI) {
            bdUI = (BaseDataSynEditUI)owner;
            idSet = this.getDataId();
            bdUI.getBackEditDataId2Romeve(idSet);
        }
        if (owner != null && owner instanceof BaseDataTreeListUI) {
            BaseDataTreeListUI listUI = (BaseDataTreeListUI)((Object)owner);
            listUI.saveScheduleList2Entry(this.getDataId());
        }
        if (owner != null && owner instanceof BaseDataMultiPlanEditUI) {
            bdUI = (BaseDataMultiPlanEditUI)((Object)owner);
            idSet = this.getDataId();
            bdUI.getBackEditDataId2Romeve(idSet);
        }
        return super.destroyWindow();
    }

    private Set<String> getDataId() {
        HashSet<String> uuidSet = new HashSet<String>();
        String key = this.getKeyFieldName();
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow iRow = this.tblMain.getRow(i);
            String value = (String)iRow.getCell(key).getValue();
            if (StringUtils.isEmpty((String)value)) continue;
            uuidSet.add(value);
        }
        return uuidSet;
    }

    public void getBackEditDataId(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        this.editDataIdset.add(id);
    }

    protected void execQuery() {
        if (this.isExeBeforeExecuteQuery) {
            super.execQuery();
            this.isExeBeforeExecuteQuery = false;
            return;
        }
        if (this.editDataIdset == null || this.editDataIdset.size() < 1) {
            super.execQuery();
            return;
        }
        EntityViewInfo mainQuery = this.mainQuery;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("ID", (Object)StringUtils.arrayToString((Object[])this.editDataIdset.toArray(), (String)","), CompareType.INCLUDE));
        if (null == mainQuery.getFilter() || mainQuery.getFilter().getFilterItems().size() == 0) {
            mainQuery.setFilter(filterInfo);
        }
        try {
            mainQuery.getFilter().mergeFilter(filterInfo, "OR");
        }
        catch (BOSException e) {
            logger.warn((Object)e.getMessage());
        }
        super.execQuery();
    }

    private void initialBarItem(boolean enable) {
        this.btnAddNew.setEnabled(enable);
        this.btnEdit.setEnabled(enable);
        this.btnRemove.setEnabled(enable);
        this.enableScheduleButton.setEnabled(enable);
    }
}

