/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.schedule.ScheduleActionEnum;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.schedule.ScheduleTimerEnum;
import com.kingdee.eas.csinterface.schedule.client.AbstractWSScheduleEditUI;
import com.kingdee.eas.csinterface.schedule.util.MyTimer;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeFactory;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceFactory;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.csinterface.webservice.client.util.EditUICheckUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;

public class WSScheduleEditUI
extends AbstractWSScheduleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(WSScheduleEditUI.class);
    private KDCheckBox[] weeks;
    private KDCheckBox[] days;
    static Integer[] hourConsts = new Integer[]{1, 2, 3, 4, 6, 8, 12};
    static Integer[] minusConsts = new Integer[]{1, 2, 3, 4, 5, 6, 10, 12, 15, 20, 30};
    static Integer[] secondeConsts = new Integer[]{5, 6, 10, 12, 15, 20, 30};

    public WSScheduleEditUI() throws Exception {
        this.weeks = new KDCheckBox[]{this.SundayCheckBox, this.MondayCheckBox, this.TuesdayCheckBox, this.WednesdayCheckBox, this.ThursdayCheckBox, this.FridayCheckBox, this.SaturdayCheckBox};
        this.days = new KDCheckBox[]{this.kDCheckBox1, this.kDCheckBox2, this.kDCheckBox3, this.kDCheckBox4, this.kDCheckBox5, this.kDCheckBox6, this.kDCheckBox7, this.kDCheckBox8, this.kDCheckBox9, this.kDCheckBox10, this.kDCheckBox11, this.kDCheckBox12, this.kDCheckBox13, this.kDCheckBox14, this.kDCheckBox15, this.kDCheckBox16, this.kDCheckBox17, this.kDCheckBox18, this.kDCheckBox19, this.kDCheckBox20, this.kDCheckBox21, this.kDCheckBox22, this.kDCheckBox23, this.kDCheckBox24, this.kDCheckBox25, this.kDCheckBox26, this.kDCheckBox27, this.kDCheckBox28, this.kDCheckBox29, this.kDCheckBox30, this.kDCheckBox31};
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.timerDetailContainer.getContentPane().setLayout(new BorderLayout());
        this.showTimeInput(ScheduleTimerEnum.everyNDays);
        this.intervalType.addItems((Object[])MyTimer.INTERVAL_TYPES);
        this.initTimeInterval("\u5c0f\u65f6");
        this.intervalType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String type = (String)e.getItem();
                WSScheduleEditUI.this.initTimeInterval(type);
            }
        });
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData = (ScheduleInfo)this.createNewData();
        } else {
            try {
                Object scheduleId = this.getUIContext().get("ID");
                if (scheduleId != null) {
                    this.editData = ScheduleFactory.getRemoteInstance().getScheduleInfo((IObjectPK)new ObjectUuidPK(scheduleId.toString()));
                }
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
            this.initEditFormData();
        }
        this.menuBar.setVisible(false);
        ScheduleTimerEnum timeType = this.editData.getTimerType();
        if (timeType != null) {
            this.timerTypeComboBox.setSelectedItem((Object)this.editData.getTimerType());
        }
        this.setBounds(this.getX(), this.getY(), 620, 360);
        WSInterfaceInfo wsInfo = this.editData.getWsinterface();
        String wsId = "";
        if (wsInfo != null && wsInfo.getId() != null) {
            wsId = wsInfo.getId().toString();
            wsInfo = WSInterfaceFactory.getRemoteInstance().getWSInterfaceInfo(CommonUtil.convert2PK(wsId));
            this.promWSInterface.setValue((Object)wsInfo);
        }
        WSIdentificationCodeInfo wsCodeInfo = this.editData.getWsIdentificationCode();
        String wsCodeId = "";
        if (wsCodeInfo != null && wsCodeInfo.getId() != null) {
            wsCodeId = wsCodeInfo.getId().toString();
            wsCodeInfo = WSIdentificationCodeFactory.getRemoteInstance().getWSIdentificationCodeInfo(CommonUtil.convert2PK(wsCodeId));
            this.promIdentificationCode.setValue((Object)wsCodeInfo);
        }
        this.txtName.setText(StringUtils.trim((String)this.editData.getName()));
        this.txtNumber.setText(StringUtils.trim((String)this.editData.getNumber()));
        this.timerStartDateDatePicker.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                WSScheduleEditUI.this.lastSuccessDateDatePicker.setValue(WSScheduleEditUI.this.timerStartDateDatePicker.getValue());
            }
        });
        this.actionTimeTimePicker.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                WSScheduleEditUI.this.lastSuccessTimePicker.setValue(WSScheduleEditUI.this.actionTimeTimePicker.getValue());
            }
        });
        this.lastSuccessTimePicker.setEnabled(false);
        this.lastSuccessDateDatePicker.setEnabled(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.EDIT) && this.editData == null) {
            throw new RuntimeException("\u5bf9\u8c61\u4e3a\u7a7a");
        }
        this.check();
        MyTimer timer = this.calculateTimerExpression();
        if (timer == null) {
            return;
        }
        ScheduleInfo scheduleInfo = this.editData;
        if (this.promWSInterface.getValue() != null) {
            scheduleInfo.setWsinterface((WSInterfaceInfo)this.promWSInterface.getValue());
        }
        if (this.promIdentificationCode.getValue() != null) {
            scheduleInfo.setWsIdentificationCode((WSIdentificationCodeInfo)this.promIdentificationCode.getValue());
        }
        scheduleInfo.setName(StringUtils.trim((String)this.txtName.getText()));
        scheduleInfo.setNumber(StringUtils.trim((String)this.txtNumber.getText()));
        scheduleInfo.setSimpleName(StringUtils.trim((String)this.txtName.getText()));
        scheduleInfo.setActionType(ScheduleActionEnum.wsInterface);
        scheduleInfo.setTimerRuleExpresssion(timer.parse2Expression());
        scheduleInfo.setTimerType((ScheduleTimerEnum)((Object)this.timerTypeComboBox.getSelectedItem()));
        Timestamp date = this.lastSuccessDateDatePicker.getTimestamp();
        Timestamp time = this.lastSuccessTimePicker.getTimestamp();
        scheduleInfo.setLastSuccessTimerDate(new Timestamp(date.getYear(), date.getMonth(), date.getDate(), time.getHours(), time.getMinutes(), time.getSeconds(), 0));
        scheduleInfo.setTimerStartDate(this.timerStartDateDatePicker.getTimestamp());
        IObjectPK pk = null;
        pk = this.editData == null ? ScheduleFactory.getRemoteInstance().addnew(scheduleInfo) : ScheduleFactory.getRemoteInstance().save((CoreBaseInfo)scheduleInfo);
        this.editData = ScheduleFactory.getRemoteInstance().getScheduleInfo("where number = '" + scheduleInfo.getNumber() + "'");
        this.setSave(true);
        this.setSaved(true);
        this.showSubmitSuccess();
    }

    private MyTimer calculateTimerExpression() {
        Timestamp actionTime = this.actionTimeTimePicker.getTimestamp();
        ScheduleTimerEnum timerType = (ScheduleTimerEnum)((Object)this.timerTypeComboBox.getSelectedItem());
        MyTimer timer = null;
        if (timerType.getValue() == 0) {
            timer = new MyTimer(timerType, actionTime, 1, null, null, null);
            System.out.println("\u6bcf\u96941\u5929" + timer.parse2Expression());
        } else if (timerType.getValue() == 1) {
            boolean[] daysInWeek = new boolean[this.weeks.length];
            for (int i = 0; i < this.weeks.length; ++i) {
                daysInWeek[i] = this.weeks[i].isSelected();
            }
            timer = new MyTimer(timerType, actionTime, 0, daysInWeek, null, null);
            System.out.println("\u6bcf\u6708" + timer.parse2Expression());
        } else if (timerType.getValue() == 2) {
            boolean hasDays = false;
            boolean[] datesInMonth = new boolean[this.days.length];
            for (int i = 0; i < this.days.length; ++i) {
                boolean isSelected = this.days[i].isSelected();
                if (isSelected && !hasDays) {
                    hasDays = true;
                }
                datesInMonth[i] = isSelected;
            }
            if (!hasDays) {
                MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u6267\u884c\u7684\u65e5\u671f");
                SysUtil.abort();
            }
            timer = new MyTimer(timerType, actionTime, 0, null, datesInMonth, null);
            System.out.println("\u6bcf\u6708" + timer.parse2Expression());
        } else if (timerType.getValue() == 3) {
            timer = new MyTimer((String)this.intervalType.getSelectedItem(), (Integer)this.timeInterval.getSelectedItem());
        } else if (timerType.getValue() == 4) {
            String cronExpressionVal = this.cronExpression.getText();
            if (StringUtils.isEmpty((String)cronExpressionVal)) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u8f93\u5165Cron\u8868\u8fbe\u5f0f");
                return null;
            }
            try {
                new CronExpression(cronExpressionVal);
            }
            catch (ParseException e) {
                MsgBox.showWarning((Component)((Object)this), (String)("\u8868\u8fbe\u5f0f\u683c\u5f0f\u6709\u8bef\uff1a\u201c" + e.getMessage() + "\u201d\uff0c\u5173\u4e8eCron\u8868\u8fbe\u5f0f\u7684\u5199\u6cd5\u8bf7\u67e5\u9605\u76f8\u5173\u8d44\u6599"));
                return null;
            }
            timer = new MyTimer(ScheduleTimerEnum.userDefine, cronExpressionVal);
        } else {
            throw new RuntimeException("\u672a\u77e5\u7684\u8c03\u5ea6\u5b9a\u65f6\u5668\u7c7b\u578b" + timerType.getValue());
        }
        return timer;
    }

    private boolean check() throws Exception {
        EditUICheckUtil.verifyInput((Object)this.txtNumber, this.contNumber);
        EditUICheckUtil.verifyInput((Object)this.txtName, this.contName);
        EditUICheckUtil.verifyInput((Object)this.promWSInterface, this.contWSInterface);
        EditUICheckUtil.verifyInput((Object)this.promIdentificationCode, this.contIdentificationCode);
        boolean isExist = EditUICheckUtil.isExists(this.getBizInterface(), "number", this.contNumber, this.txtNumber.getText(), this.editData.getId());
        if (isExist) {
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
        if (isExist = EditUICheckUtil.isExists(this.getBizInterface(), "name", this.contName, this.txtName.getText(), this.editData.getId())) {
            this.txtName.requestFocusInWindow();
            SysUtil.abort();
        }
        if (null == this.timerStartDateDatePicker.getValue()) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u6267\u884c\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u9009\u62e9\u6267\u884c\u8d77\u59cb\u65e5\u671f");
            return false;
        }
        return true;
    }

    private void showTimeInput(ScheduleTimerEnum timeEnum) {
        if (ScheduleTimerEnum.userDefine == timeEnum) {
            this.timeIntervalContainer.setVisible(false);
            this.intervalType.setVisible(false);
            this.execOneTimeLabel.setVisible(false);
            this.cronExpressionContainer.setVisible(true);
            this.actionTimeTimePicker.setEnabled(false);
        } else if (ScheduleTimerEnum.timeInterval == timeEnum) {
            this.cronExpressionContainer.setVisible(false);
            this.timeIntervalContainer.setVisible(true);
            this.intervalType.setVisible(true);
            this.intervalType.setEnabled(true);
            this.execOneTimeLabel.setVisible(true);
            this.timeIntervalContainer.setEnabled(true);
            this.execOneTimeLabel.setEnabled(true);
            this.actionTimeTimePicker.setEnabled(false);
        } else {
            if (ScheduleTimerEnum.week == timeEnum) {
                this.weekDPanel.setVisible(true);
                this.monthPanel.setVisible(false);
            } else if (ScheduleTimerEnum.month == timeEnum) {
                this.weekDPanel.setVisible(false);
                this.monthPanel.setVisible(true);
            } else {
                this.weekDPanel.setVisible(false);
                this.monthPanel.setVisible(false);
            }
            this.cronExpressionContainer.setVisible(false);
            this.timeIntervalContainer.setEnabled(false);
            this.intervalType.setEnabled(false);
            this.actionTimeTimePicker.setEnabled(true);
        }
    }

    private void initTimeInterval(String intervalType) {
        Object lastSelectItem = this.timeInterval.getSelectedItem();
        this.timeInterval.removeAllItems();
        if ("\u5c0f\u65f6".equals(intervalType)) {
            this.timeInterval.addItems((Object[])hourConsts);
        } else if ("\u5206\u949f".equals(intervalType)) {
            this.timeInterval.addItems((Object[])minusConsts);
        } else if ("\u79d2\u949f".equals(intervalType)) {
            this.timeInterval.addItems((Object[])secondeConsts);
        }
        if (lastSelectItem != null) {
            this.timeInterval.setSelectedItem(lastSelectItem);
        }
    }

    private void initEditFormData() {
        this.timerStartDateDatePicker.setValue((Object)this.editData.getTimerStartDate());
        this.timerTypeChangeAction(this.editData.getTimerType());
        MyTimer myTimer = MyTimer.parse2MyTimer(this.editData.getTimerRuleExpresssion());
        this.actionTimeTimePicker.setValue((Object)myTimer.getActionTimerTime());
        this.actionTimeTimePicker.setTimePattern("HH:mm:ss");
        this.lastSuccessDateDatePicker.setValue((Object)this.editData.getLastSuccessTimerDate());
        this.lastSuccessTimePicker.setValue((Object)this.editData.getLastSuccessTimerDate());
        this.lastSuccessTimePicker.setTimePattern("HH:mm:ss");
        ScheduleTimerEnum timerType = this.editData.getTimerType();
        if (timerType.getValue() == 1) {
            boolean[] daysInWeek = myTimer.getDaysInWeek();
            for (int i = 0; i < this.weeks.length; ++i) {
                this.weeks[i].setSelected(daysInWeek[i]);
            }
        } else if (timerType.getValue() == 2) {
            boolean[] datesInMonth = myTimer.getDatesInMonth();
            for (int i = 0; i < this.days.length; ++i) {
                this.days[i].setSelected(datesInMonth[i]);
            }
        } else if (timerType.getValue() == 3) {
            this.cronExpressionContainer.setVisible(false);
            this.intervalType.setVisible(true);
            this.timeInterval.setVisible(true);
            this.intervalType.setSelectedItem((Object)myTimer.getIntervalType());
            this.timeInterval.setSelectedItem((Object)myTimer.getInterval());
        } else if (timerType.getValue() == 4) {
            this.cronExpressionContainer.setVisible(true);
            this.intervalType.setVisible(false);
            this.timeInterval.setVisible(false);
            this.cronExpression.setText(myTimer.getCornExpression());
        }
        SysContext ctx = SysContext.getSysContext();
        this.timerDetailContainer.setTitle(timerType.getAlias(ctx.getLocale()));
    }

    private void timerTypeChangeAction(ScheduleTimerEnum timerType) {
        if (timerType.getValue() == 1) {
            this.timerDetailContainer.setVisible(true);
            this.timerDetailContainer.getContentPane().removeAll();
            this.timerDetailContainer.getContentPane().add((Component)this.weekDPanel);
            this.showTimeInput(ScheduleTimerEnum.week);
        } else if (timerType.getValue() == 2) {
            this.timerDetailContainer.setVisible(true);
            this.timerDetailContainer.getContentPane().removeAll();
            this.timerDetailContainer.getContentPane().add((Component)this.monthPanel);
            this.showTimeInput(ScheduleTimerEnum.month);
        } else if (timerType.getValue() == 3) {
            this.timerDetailContainer.setVisible(false);
            this.showTimeInput(ScheduleTimerEnum.timeInterval);
        } else if (timerType.getValue() == 4) {
            this.timerDetailContainer.setVisible(false);
            this.showTimeInput(ScheduleTimerEnum.userDefine);
        } else {
            this.showTimeInput(ScheduleTimerEnum.everyNDays);
            this.timerDetailContainer.setVisible(false);
        }
        SysContext ctx = SysContext.getSysContext();
        this.timerDetailContainer.setTitle(timerType.getAlias(ctx.getLocale()));
    }

    public boolean destroyWindow() {
        Object ui = this.getUIContext().get("Owner");
        if (ui instanceof ListUI) {
            ListUI listui = (ListUI)this.getUIContext().get("Owner");
            if (ui != null) {
                try {
                    listui.refreshList();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return super.destroyWindow();
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    @Override
    public void timerTypeChangeAction_actionPerformed(ActionEvent e) throws Exception {
        this.timerDetailContainer.getContentPane().removeAll();
        ScheduleTimerEnum timerType = (ScheduleTimerEnum)((Object)this.timerTypeComboBox.getSelectedItem());
        this.timerTypeChangeAction(timerType);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ScheduleFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ScheduleInfo objectValue = new ScheduleInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }
}

