/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.business.client.BizWizardEditUI;
import com.kingdee.eas.csinterface.converter.core.DefaultStream;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingEntryCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.DataMatchType;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.IConnection;
import com.kingdee.eas.csinterface.syncdatabase.ISQLFacade;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.syncdatabase.client.AbstractBaseDataMapingEditUI;
import com.kingdee.eas.csinterface.syncdatabase.client.BaseDataMapingListUI;
import com.kingdee.eas.csinterface.syncdatabase.client.BaseDataMappingImportUI;
import com.kingdee.eas.csinterface.syncdatabase.client.util.MySCMClientUtils;
import com.kingdee.eas.csinterface.syncdatabase.datafile.DataFile;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataInfoUtil;
import com.kingdee.eas.csinterface.util.CSCheck;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ComponentHelper;
import com.kingdee.eas.csinterface.util.EIPUIClassParamUtil;
import com.kingdee.eas.csinterface.util.ExcelHelper;
import com.kingdee.eas.csinterface.util.Export2FileUtil;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.csinterface.utils.BaseDataMappingUtil;
import com.kingdee.eas.csinterface.utils.KSQLFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jxl.Workbook;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class BaseDataMapingEditUI
extends AbstractBaseDataMapingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BaseDataMapingEditUI.class);
    private static String FILE_PATH = "";
    private static IUIWindow UI_WINDOW = null;
    private static final String SRC_DISPLAY = "srcDisplay";
    private static final String SRC_ID = "srcID";
    public static int DESC_MATCH_MAX_SIZE = 1000;
    private Component[] components;
    ConnectionInfo conn;
    BOSObjectType type;
    BaseDataTypeInfo baseDataTypeInfo;
    EntityViewInfo view;
    FilterInfo filter;
    FilterItemCollection filterItemCollection;
    IObjectCollection coll;

    public BaseDataMapingEditUI() throws Exception {
        this.components = new Component[]{this.txtNumber, this.prmtbaseDataType, this.prmtOrgUnit, this.txtsrcWhere, this.txtdestWhere};
        this.conn = null;
        this.type = null;
        this.baseDataTypeInfo = null;
        this.view = null;
        this.filter = null;
        this.filterItemCollection = null;
        this.coll = null;
        this.initButtons();
        ComponentHelper.setFocusTraversalPolicy((Container)((Object)this), this.components);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.components[0].requestFocusInWindow();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadOrgUnit();
        this.loadTableValue();
        this.updatePrmtbaseDataTypeAndPrmtOrgUnit2EnableOrNot();
    }

    private void initButtons() {
        this.btnUpdateSrcData.setEnabled(false);
        this.autoMatchingButton.setEnabled(false);
        this.prmtbaseDataType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)BaseDataMapingEditUI.this.prmtbaseDataType.getData();
                if (null == baseDataTypeInfo) {
                    BaseDataMapingEditUI.this.btnUpdateSrcData.setEnabled(false);
                    BaseDataMapingEditUI.this.autoMatchingButton.setEnabled(false);
                } else {
                    DataSourceType dsType;
                    String num;
                    if (OprtState.ADDNEW.equalsIgnoreCase(BaseDataMapingEditUI.this.getOprtState()) && StringUtils.isEmpty((String)(num = BaseDataMapingEditUI.this.txtNumber.getText()))) {
                        BaseDataMapingEditUI.this.txtNumber.setText(baseDataTypeInfo.getNumber());
                    }
                    if ((dsType = baseDataTypeInfo.getDsType()) != null && !DataSourceType.jdbc.equals((Object)dsType) && !DataSourceType.file.equals((Object)dsType)) {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8d44\u6e90\u7c7b\u522b'" + dsType.getAlias() + "'");
                    }
                    if (DataSourceType.jdbc.equals((Object)dsType)) {
                        BaseDataMapingEditUI.this.btnUpdateSrcData.setEnabled(true);
                        BaseDataMapingEditUI.this.autoMatchingButton.setEnabled(true);
                    } else {
                        BaseDataMapingEditUI.this.btnUpdateSrcData.setEnabled(false);
                        BaseDataMapingEditUI.this.autoMatchingButton.setEnabled(false);
                    }
                }
            }
        });
    }

    private void loadOrgUnit() {
        BaseDataTypeInfo baseDataType = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        if (null == baseDataType) {
            this.prmtOrgUnit.setEnabled(false);
            return;
        }
        Context ctx = this.getUserContext();
        OrgType orgType = BaseDataMapingEditUI.getOrgType(baseDataType);
        String orgId = this.editData.getOrgUnit();
        CommonUtil.fillOrgUnitF7(ctx, orgType, this.prmtOrgUnit, (CoreUI)this, orgId);
    }

    protected void initPrmtOrgUnit() {
        BaseDataTypeInfo baseDataType = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        if (null != baseDataType) {
            OrgType orgType = BaseDataMapingEditUI.getOrgType(baseDataType);
            CommonUtil.initOrgUnitF7(this.getUserContext(), orgType, this.prmtOrgUnit, (CoreUI)this);
        }
    }

    private static OrgType getOrgType(BaseDataTypeInfo baseDataType) {
        BaseDataInfo baseData = baseDataType.getDestBaseData();
        IObjectPK pk = CommonUtil.convert2PK(baseData.getId().toString());
        try {
            baseData = BaseDataFactory.getRemoteInstance().getBaseDataInfo(pk);
        }
        catch (Exception e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        String queryName = baseData.getQueryName();
        OrgType orgType = CommonUtil.getOrgTypeByQueryName(queryName);
        return orgType;
    }

    protected void loadTableValue() {
        BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        if (null == baseDataTypeInfo) {
            return;
        }
        try {
            Set<String> idSet = this.getFidSet();
            if (idSet.isEmpty()) {
                return;
            }
            Map<String, CoreBaseInfo> map = BaseDataMappingUtil.convertFid2CoreBase(idSet, baseDataTypeInfo);
            if (map == null) {
                return;
            }
            int n = this.kdtEntrys.getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow iRow = this.kdtEntrys.getRow(i);
                String fid = String.valueOf(iRow.getCell("tmpDestID").getValue());
                CoreBaseInfo coreBase = map.get(fid);
                if (coreBase == null) continue;
                iRow.getCell("destID").setValue((Object)coreBase);
                iRow.getCell("destDisplay").setValue((Object)BaseDataMappingUtil.getDestValue((IObjectValue)coreBase, baseDataTypeInfo.getDestDisplay()));
                iRow.getCell("destNum").setValue((Object)BaseDataMappingUtil.getDestValue((IObjectValue)coreBase, baseDataTypeInfo.getDestID()));
                iRow.getCell("tmpDestID").setValue((Object)coreBase.getId().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Set<String> getFidSet() {
        HashSet<String> idSet = new HashSet<String>();
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            String destID = String.valueOf(this.kdtEntrys.getCell(i, "tmpDestID").getValue());
            if (StringUtils.isEmpty((String)destID)) {
                destID = String.valueOf(this.kdtEntrys.getCell(i, "destID").getValue());
            }
            if (StringUtils.isEmpty((String)destID)) continue;
            idSet.add(destID);
        }
        return idSet;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        OrgUnitInfo orgUnit = (OrgUnitInfo)this.prmtOrgUnit.getData();
        if (null != orgUnit) {
            String orgId = orgUnit.getId().toString();
            this.editData.setOrgUnit(orgId);
        }
        this.storeTableValue();
    }

    protected void storeTableValue() {
        int result;
        BaseDataMapingEntryCollection coll = this.editData.getEntrys();
        BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        HashMap<Object, CoreBaseInfo> map = new HashMap<Object, CoreBaseInfo>();
        IRow iRow = null;
        int errorCount = 0;
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            iRow = this.kdtEntrys.getRow(i);
            if (iRow.getCell("destID").getValue() != null) {
                if (iRow.getCell("destID").getValue() instanceof CoreBaseInfo) {
                    map.put(iRow.getCell(SRC_ID).getValue(), (CoreBaseInfo)iRow.getCell("destID").getValue());
                    continue;
                }
                ++errorCount;
                iRow.getCell("destID").setValue(null);
                map.put(iRow.getCell(SRC_ID).getValue(), null);
                continue;
            }
            map.put(iRow.getCell(SRC_ID).getValue(), null);
        }
        if (errorCount > 0 && (result = MsgBox.showConfirm2((String)"\u90e8\u5206\u201c\u76ee\u6807\u7cfb\u7edf\u5b57\u6bb5\u503c\u201d\u4e0d\u5b58\u5728\uff0c\u5df2\u6e05\u7a7a\u3002\u5982\u679c\u9700\u8981\u5220\u9664\u8fd9\u4e9b\u76ee\u6807\u7cfb\u7edf\u503c\u4e3a\u7a7a\u7684\u884c\uff0c\u8bf7\u70b9\u201c\u786e\u5b9a\u201d\u3002\n\u5982\u679c\u9700\u8981\u7ef4\u62a4\u76ee\u6807\u7cfb\u7edf\u503c\u4e3a\u7a7a\u7684\u884c\uff0c\u8bf7\u70b9\u201c\u53d6\u6d88\u201d\uff0c\u7136\u540e\u901a\u8fc7\u5bf9\u76ee\u6807\u7cfb\u7edf\u503c\u8fdb\u884c\u6392\u5e8f\u627e\u5230\u4e3a\u7a7a\u7684\u884c\u3002")) == 2) {
            SysUtil.abort();
        }
        BaseDataMapingEntryInfo baseDataMapingEntryInfo = null;
        int n2 = coll.size();
        for (int i = 0; i < n2; ++i) {
            baseDataMapingEntryInfo = coll.get(i);
            if (map.get(baseDataMapingEntryInfo.getSrcID()) == null) continue;
            CoreBaseInfo coreBaseInfo = (CoreBaseInfo)map.get(baseDataMapingEntryInfo.getSrcID());
            baseDataMapingEntryInfo.setDestID(coreBaseInfo.getId().toString());
            baseDataMapingEntryInfo.setDestNum(BaseDataMappingUtil.getDestValue((IObjectValue)coreBaseInfo, baseDataTypeInfo.getDestID()));
            baseDataMapingEntryInfo.setDestDisplay(BaseDataMappingUtil.getDestValue((IObjectValue)coreBaseInfo, baseDataTypeInfo.getDestDisplay()));
        }
    }

    public void initPrmtState() {
        this.prmtbaseDataType.setHistoryRecordEnabled(false);
        this.prmtOrgUnit.setHistoryRecordEnabled(false);
        String oprtState = this.getOprtState();
        if (OprtState.VIEW.equalsIgnoreCase(oprtState)) {
            this.prmtbaseDataType.setEnabled(false);
            this.prmtOrgUnit.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        DataSourceType dsType;
        super.onLoad();
        Object typeObj = this.getUIContext().get("BaseDataType");
        if (typeObj != null && typeObj instanceof BaseDataTypeInfo) {
            BaseDataTypeInfo typeInfo = BaseDataTypeFactory.getRemoteInstance().getBaseDataTypeInfo(CommonUtil.convert2PK(((BaseDataTypeInfo)typeObj).getId().toString()));
            this.prmtbaseDataType.setValue((Object)typeInfo);
            this.prmtbaseDataType.setEnabled(false);
            this.initPrmtOrgUnit();
        }
        if (this.prmtbaseDataType.getData() != null && DataSourceType.jdbc.equals((Object)(dsType = ((BaseDataTypeInfo)this.prmtbaseDataType.getData()).getDsType())) && this.getOprtState().equals(OprtState.EDIT)) {
            this.btnUpdateSrcData.setEnabled(true);
            this.autoMatchingButton.setEnabled(true);
        }
        ComponentHelper.setVisible(new JComponent[]{this.btnAttachment, this.btnFirst, this.btnPre, this.btnNext, this.btnLast, this.btnPrint, this.btnPrintPreview, this.btnWorkFlowG, this.btnCreateFrom, this.btnCreateTo, this.btnAuditResult, this.btnMultiapprove, this.btnNextPerson}, false);
        this.prmtbaseDataType.setAccessAuthority(0);
        this.prmtOrgUnit.setAccessAuthority(0);
        this.btnSubmit.setVisible(false);
        MyKDTableUtil.setColumnLocked(this.kdtEntrys, "destDisplay");
        MyKDTableUtil.replaceKdtRangeRemoveMethod(this.kdtEntrys, this.kdtEntrys_detailPanel.getRemoveLinesButton());
        this.kdtEntrys.addAfterActionListener(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                switch (e.getType()) {
                    case 0: 
                    case 1: {
                        BaseDataMapingEditUI.this.updatePrmtbaseDataTypeAndPrmtOrgUnit2EnableOrNot();
                        break;
                    }
                }
            }
        });
        this.prmtbaseDataType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BaseDataMapingEditUI.this.initPrmtOrgUnit();
                try {
                    BaseDataMapingEditUI.this.initEntryTable();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.prmtOrgUnit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    BaseDataMapingEditUI.this.initEntryTable();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        try {
            this.initEntryTable();
        }
        catch (Exception e) {
            this.txtdestWhere.requestFocus();
            MsgBox.showDetailAndOK((Component)((Object)this), (String)e.getMessage(), (String)ThrowableHelper.toString(e), (int)0);
            e.printStackTrace();
        }
        this.txtdestWhere.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    BaseDataMapingEditUI.this.initEntryTable();
                }
                catch (ParserException e1) {
                    BaseDataMapingEditUI.this.txtdestWhere.requestFocus();
                    MsgBox.showDetailAndOK((Component)((Object)BaseDataMapingEditUI.this), (String)e1.getMessage(), (String)ThrowableHelper.toString((Exception)((Object)e1)), (int)0);
                    e1.printStackTrace();
                    SysUtil.abort();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Object owner = this.getUIContext().get("Owner");
        if (null != owner && owner instanceof BaseDataMapingListUI) {
            BaseDataMapingListUI list = (BaseDataMapingListUI)((Object)owner);
            Object root = list.getUIContext().get("BizWizardEditUiKey");
            if (null != root && root instanceof BizWizardEditUI) {
                String oprtState = String.valueOf(list.getUIContext().get("rootOprtState"));
                if (oprtState.equals(OprtState.VIEW)) {
                    this.initialBarItem(false);
                    this.prmtbaseDataType.setEnabled(false);
                    this.prmtOrgUnit.setEnabled(false);
                }
            } else {
                this.initialBarItem(true);
            }
        }
        MyKDTableUtil.setColumnLocked(this.kdtEntrys, "systemAuto");
        MyKDTableUtil.setColumnLockedBackground(this.kdtEntrys, "systemAuto");
        this.initPrmtState();
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.prmtbaseDataType.setEnabled(false);
        }
        this.btnCopy.setVisible(false);
        EntityViewInfo ev = this.prmtbaseDataType.getEntityViewInfo();
        if (ev == null) {
            ev = new EntityViewInfo();
            this.prmtbaseDataType.setEntityViewInfo(ev);
        }
        EIPUIClassParamUtil.setFilterByUIParamValue(this.getUIContext(), "configType", "configType", ev, "applicationScope", null, "AND");
    }

    private void updatePrmtbaseDataTypeAndPrmtOrgUnit2EnableOrNot() {
        boolean enabled = 0 == this.kdtEntrys.getRowCount();
        this.prmtbaseDataType.setEnabled(enabled);
        this.prmtOrgUnit.setEnabled(enabled);
        if (null == this.prmtOrgUnit.getData()) {
            this.prmtOrgUnit.setEnabled(false);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.cust_validate_passed()) {
            return;
        }
        this.checkDupNumber();
        if (this.isSaveCurrentData()) {
            String number = this.txtNumber.getStringValue();
            IObjectPK pk = null;
            if (OprtState.ADDNEW.equalsIgnoreCase(this.oprtState)) {
                pk = LogUtil.beginLog(null, (String)"\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04\u65b0\u589e", (BOSObjectType)new BaseDataMapingInfo().getBOSType(), null, (String)("\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04\u65b0\u589e\uff0c\u7f16\u7801\uff1a" + number));
            } else if (OprtState.EDIT.equalsIgnoreCase(this.oprtState)) {
                pk = LogUtil.beginLog(null, (String)"\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04\u4fee\u6539", (BOSObjectType)new BaseDataMapingInfo().getBOSType(), null, (String)("\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04\u4fee\u6539\uff0c\u7f16\u7801\uff1a" + number));
            }
            super.actionSave_actionPerformed(e);
            LogUtil.afterLog(null, pk);
            try {
                this.checkFilter();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                MsgBox.showError((String)"\u627e\u4e0d\u5230\u57fa\u7840\u8d44\u6599\u7c7b\u578b:\u76ee\u6807\u7cfb\u7edf\u8fc7\u6ee4\u6761\u4ef6\u9519\u8bef!");
                SysUtil.abort();
            }
            this.prmtbaseDataType.setEnabled(false);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.cust_validate_passed()) {
            return;
        }
        this.checkDupNumber();
        if (this.isSaveCurrentData()) {
            super.actionSubmit_actionPerformed(e);
            this.backEditData();
            try {
                this.checkFilter();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                MsgBox.showError((String)"\u627e\u4e0d\u5230\u57fa\u7840\u8d44\u6599\u7c7b\u578b:\u8fc7\u6ee4\u6761\u4ef6\u9519\u8bef!");
                SysUtil.abort();
            }
            this.prmtbaseDataType.setEnabled(false);
        }
    }

    public void checkDupNumber() throws EASBizException, BOSException {
        this.checkDup("number", this.txtNumber.getText(), "\u7f16\u7801");
    }

    public void checkDup(String column, String fieldValue, String fieldName) throws EASBizException, BOSException {
        String queryName = "com.kingdee.eas.csinterface.syncdatabase.app.BaseDataMapingQuery";
        IFilterInfoProducer producer = FilterInfoProducerFactory.getControlTypeFilterInfoProducer((String)queryName);
        FilterInfo filter = producer.getFilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(column, (Object)fieldValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS));
        boolean isExist = BaseDataMapingFactory.getRemoteInstance().exists(filter);
        if (isExist) {
            MsgBox.showInfo((String)(fieldName + " : " + fieldValue + "\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u3002"));
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
    }

    private boolean cust_validate_passed() throws Exception {
        if (CSCheck.chenkTxtFieldNotPassed(this.txtNumber, -1, "\u7f16\u7801")) {
            this.txtNumber.requestFocus();
            return false;
        }
        if (CSCheck.checkF7NotPassed(this.prmtbaseDataType.getData(), "\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6620\u5c04")) {
            this.prmtbaseDataType.requestFocus();
            return false;
        }
        return true;
    }

    private void removeUnCompletedLine() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int rowNumber = this.kdtEntrys.getRowCount();
        for (int i = 0; i < rowNumber; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            if (null == row || !this.checkCellIsNoValue(row, SRC_ID) && !this.checkCellIsNoValue(row, "destID")) continue;
            list.add(i);
        }
        Object[] selectRowsIndex = list.toArray(new Integer[0]);
        Arrays.sort(selectRowsIndex);
        for (int i = selectRowsIndex.length - 1; i >= 0; --i) {
            MyKDTableUtil.removeRow(this.kdtEntrys, (Integer)selectRowsIndex[i]);
        }
    }

    private boolean isSaveCurrentData() {
        IRow row;
        int i;
        int rowNumber = this.kdtEntrys.getRowCount();
        Set srcIdSet = this.getSrcIDRowListFromTable(new HashSet());
        HashSet<String> repectSrcId = new HashSet<String>();
        int result = -1;
        boolean flag = false;
        for (i = 0; i < rowNumber; ++i) {
            row = this.kdtEntrys.getRow(i);
            if (flag || !this.checkCellIsNoValue(row, SRC_ID) && !this.checkCellIsNoValue(row, "destID")) continue;
            result = MsgBox.showConfirm2New((Component)((Object)this), (String)"\u4fdd\u5b58\u65f6\u4f1a\u81ea\u52a8\u5220\u9664\u6e90\u7cfb\u7edf\u6807\u8bc6\u503c\u6216\u76ee\u6807\u7cfb\u7edf\u5b57\u6bb5\u503c\u4e3a\u7a7a\u7684\u884c\u3002\u4fdd\u5b58\u540e\u53ef\u4ee5\u901a\u8fc7\u70b9\u51fb\u66f4\u65b0\u6e90\u7cfb\u7edf\u6570\u636e\u91cd\u65b0\u5217\u51fa\u5df2\u5220\u9664\u7684\u884c\u3002\u786e\u5b9a\u4fdd\u5b58\uff1f");
            flag = true;
            break;
        }
        if (result == 0) {
            this.removeUnCompletedLine();
        }
        rowNumber = this.kdtEntrys.getRowCount();
        for (i = 0; i < rowNumber; ++i) {
            row = this.kdtEntrys.getRow(i);
            Object value = row.getCell(SRC_ID).getValue();
            if (value == null || srcIdSet.add(value.toString())) continue;
            repectSrcId.add(value.toString());
        }
        if (repectSrcId.size() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u6e90\u7cfb\u7edf\u6807\u8bc6\u503c\u5b58\u5728\u91cd\u590d\u503c\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)((Object)repectSrcId).toString(), (int)1);
            return false;
        }
        if (flag) {
            return 0 == result;
        }
        return true;
    }

    private boolean checkCellIsNoValue(IRow row, String key) {
        ICell cell = row.getCell(key);
        return null == cell || null == cell.getValue();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int isDelete = MsgBox.showConfirm2((Component)((Object)this), (String)"\u6ce8\u610f\uff1a\u5c06\u5220\u9664\u6240\u6709\u884c\u6570\u636e\uff0c\u5982\u679c\u8981\u5220\u9664\u4e00\u884c\uff0c\u8bf7\u4f7f\u7528\u8868\u53f3\u4e0a\u89d2\u7684\u5220\u9664\u884c\u6309\u94ae\uff01");
        if (isDelete == 0) {
            super.actionRemove_actionPerformed(e);
        }
    }

    @Override
    public void actionUpdateSrcData_actionPerformed(ActionEvent e) throws Exception {
        BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        if (null == baseDataTypeInfo) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002");
            this.prmtbaseDataType.requestFocus();
            return;
        }
        if (!DataSourceType.jdbc.equals((Object)baseDataTypeInfo.getDsType())) {
            MsgBox.showInfo((String)"\u4f9d\u8d56\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u662f\u6570\u636e\u5e93\u8fde\u63a5\u65b9\u5f0f");
            this.prmtbaseDataType.requestFocus();
            return;
        }
        this.baseDataTypeInfo = baseDataTypeInfo;
        IConnection connection = ConnectionFactory.getRemoteInstance();
        this.conn = baseDataTypeInfo.getConn();
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(this.conn.getId().toString());
        }
        catch (NullPointerException ex) {
            MsgBox.showInfo((String)"\u6240\u9009\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e2d\u5f15\u7528\u7684\u8fde\u63a5\u5df2\u4e0d\u5b58\u5728\u3002");
            return;
        }
        if (!connection.exists((IObjectPK)pk)) {
            MsgBox.showInfo((String)"\u6240\u9009\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e2d\u5f15\u7528\u7684\u8fde\u63a5\u5df2\u4e0d\u5b58\u5728\u3002");
            return;
        }
        this.conn = connection.getConnectionInfo((IObjectPK)new ObjectUuidPK(this.conn.getId().toString()));
        ISQLFacade intance = SQLFacadeFactory.getRemoteInstance();
        Object rs = null;
        String normalMsg = "\u6b63\u5728\u83b7\u53d6\u6570\u636e";
        final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", "\u6b63\u5728\u83b7\u53d6\u6570\u636e,\u8bf7\u7a0d\u540e...");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec() throws Exception {
                try {
                    DBType type = BaseDataMapingEditUI.this.conn.getDBType();
                    int dbType = 0;
                    if (DBType.Oracle.equals((Object)type)) {
                        dbType = 2;
                    } else if (DBType.DB2.equals((Object)type)) {
                        dbType = 1;
                    } else if (DBType.SQLServer.equals((Object)type)) {
                        dbType = 3;
                    } else if (DBType.PostgreSQL.equals((Object)type)) {
                        dbType = 5;
                    }
                    ISQLFacade intance = SQLFacadeFactory.getRemoteInstance();
                    IRowSet rs = null;
                    dialog.updateMsg("\u6b63\u5728\u83b7\u53d6\u6570\u636e(1/1)");
                    String sql = null;
                    sql = DBType.MySql.equals((Object)type) ? BaseDataMapingEditUI.this.getSrcSql((BaseDataTypeInfo)BaseDataMapingEditUI.this.prmtbaseDataType.getData(), 1, 0) : TransUtil.Translate((String)BaseDataMapingEditUI.this.getSrcSql((BaseDataTypeInfo)BaseDataMapingEditUI.this.prmtbaseDataType.getData(), 1, 0), (int)dbType);
                    rs = intance.getTargetRowset(BaseDataMapingEditUI.this.conn, sql);
                    BaseDataMapingEditUI.this.updateEntryTable(rs);
                    String string = "success";
                    return string;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.exception = exc;
                    String string = "fail";
                    return string;
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (this.exception != null) {
                    MsgBox.showDetailAndOK((Component)((Object)dialog), (String)"\u66f4\u65b0\u6e90\u7cfb\u7edf\u6570\u636e\u5931\u8d25\u3002", (String)ThrowableHelper.toString(this.exception), (int)1);
                }
            }
        });
        dialog.show();
    }

    private String getSrcSql(BaseDataTypeInfo editData, int pageSize, int page) {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct ");
        sql.append(editData.getSrcID());
        if (editData.getSrcDisplay() != null) {
            sql.append(",");
            sql.append(editData.getSrcDisplay());
        }
        sql.append(" from " + editData.getSrcTable() + " ");
        String srcWhere = this.txtsrcWhere.getText();
        if (!StringUtils.isEmpty((String)srcWhere)) {
            int beginIndex = 0;
            for (int i = 0; i < srcWhere.length(); ++i) {
                if (" ".equals(String.valueOf(srcWhere.charAt(i)))) {
                    ++beginIndex;
                    continue;
                }
                srcWhere = srcWhere.substring(beginIndex);
                break;
            }
            if (!StringUtils.startsWithIgnoreCase((String)srcWhere, (String)"where")) {
                srcWhere = " where " + srcWhere;
            }
        }
        if (!StringUtils.isEmpty((String)srcWhere)) {
            srcWhere = srcWhere.trim();
            sql.append(srcWhere);
        }
        sql.append(" order by " + editData.getSrcID() + " ");
        return sql.toString();
    }

    private int getTotalSrcSize(ConnectionInfo conn) throws Exception {
        int result = 0;
        ISQLFacade intance = SQLFacadeFactory.getRemoteInstance();
        IRowSet rowset = null;
        DBType type = conn.getDBType();
        int dbType = 0;
        if (DBType.Oracle.equals((Object)type)) {
            dbType = 2;
        } else if (DBType.Oracle.equals((Object)type)) {
            dbType = 1;
        } else if (DBType.Oracle.equals((Object)type)) {
            dbType = 3;
        }
        rowset = intance.getTargetRowset(conn, this.getTotalSQL(this.baseDataTypeInfo));
        if (null != rowset) {
            while (rowset.next()) {
                result = rowset.getInt(1);
            }
        }
        return result;
    }

    private String getTotalSQL(BaseDataTypeInfo editData) {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(distinct ");
        sql.append(editData.getSrcID());
        sql.append(" )  count from ");
        sql.append(editData.getSrcTable());
        String srcWhere = this.txtsrcWhere.getText();
        if (!StringUtils.isEmpty((String)srcWhere)) {
            srcWhere = srcWhere.trim();
            sql.append(" ");
            sql.append(srcWhere);
        }
        return sql.toString();
    }

    protected void initEntryTable() throws ParserException, BOSException {
        BaseDataTypeInfo baseDataType = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        if (null == baseDataType) {
            return;
        }
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setQueryInfo(BaseDataInfoUtil.getQueryName(baseDataType));
        promptBox.setVisible(true);
        promptBox.setEditable(true);
        promptBox.setDisplayFormat("$" + baseDataType.getDestID() + "$");
        promptBox.setEditFormat("$" + baseDataType.getDestID() + "$");
        promptBox.setCommitFormat("$" + baseDataType.getDestID() + "$");
        EntityViewInfo ev = null;
        String where = this.txtdestWhere.getText();
        if (StringUtils.isEmpty((String)where)) {
            ev = new EntityViewInfo();
        } else {
            if (!StringUtils.startsWithIgnoreCase((String)where, (String)"where")) {
                where = " where " + where;
            }
            ev = new EntityViewInfo(where);
        }
        if (null == ev.getFilter()) {
            ev.setFilter(new FilterInfo());
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        this.filtWithOrgUnitInfo(fic);
        if (fic.size() > 0) {
            ev.getFilter().mergeFilter(filter, "AND");
        }
        if (!where.isEmpty()) {
            this.checkFilter();
        }
        promptBox.setEntityViewInfo(ev);
        IColumn destIDColumn = this.kdtEntrys.getColumn("destID");
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)promptBox);
        destIDColumn.setEditor((ICellEditor)editor);
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat((IDataFormat)new BizDataFormat("$" + baseDataType.getDestID() + "$"));
        destIDColumn.setRenderer((IBasicRender)render);
    }

    private void checkFilter() throws BOSException, ParserException {
        BaseDataTypeInfo baseDataType = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        EntityViewInfo ev = null;
        String where = this.txtdestWhere.getText();
        if (StringUtils.isEmpty((String)where)) {
            ev = new EntityViewInfo();
        } else {
            if (!StringUtils.startsWithIgnoreCase((String)where, (String)"where")) {
                where = " where " + where;
            }
            ev = new EntityViewInfo(where);
        }
        MetaDataPK queryPK = MetaDataPK.create((String)BaseDataInfoUtil.getQueryName(baseDataType));
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)queryPK, (Context)this.getMainOrgContext());
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)queryPK);
        SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
        SubEntityInfo mainEntityInfo = null;
        if (mainObjectInfo instanceof SubEntityInfo) {
            mainEntityInfo = (SubEntityInfo)mainObjectInfo;
            mainEntityInfo.getEntityRef();
        }
        BOSObjectType type = null;
        if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
            type = mainEntityInfo.getEntityRef().getType();
        }
        IDynamicObject instance = DynamicObjectFactory.getRemoteInstance();
        ev.setTopCount(1);
        exec.setObjectView(ev);
        try {
            IObjectCollection coll = instance.getCollection(type, ev);
            if (coll.size() <= 0) {
                this.txtdestWhere.requestFocus();
                MsgBox.showError((String)"\u627e\u4e0d\u5230\u57fa\u7840\u8d44\u6599\u7c7b\u578b:\u76ee\u6807\u7cfb\u7edf\u8fc7\u6ee4\u6761\u4ef6\u9519\u8bef!");
            }
        }
        catch (BOSException e) {
            throw new ParserException("\u76ee\u6807\u7cfb\u7edf\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\uff01", (Throwable)e);
        }
    }

    private void filtWithDestWhere(FilterItemCollection fic) {
        String where = this.txtdestWhere.getText();
        if (StringUtils.isEmpty((String)where)) {
            return;
        }
        if (StringUtils.startsWithIgnoreCase((String)where, (String)"where")) {
            where = StringUtils.replaceIgnoreCase((String)where, (String)"where", (String)"");
        }
        fic.add(new FilterItemInfo(where));
    }

    private void filtWithOrgUnitInfo(FilterItemCollection fic) {
        OrgUnitInfo orgUnitInfo;
        Object object;
        OrgUnitInfo cuid = (OrgUnitInfo)this.prmtOrgUnit.getData();
        if (null == cuid) {
            return;
        }
        BaseDataTypeInfo baseDataType = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        if (null == baseDataType) {
            return;
        }
        String destOrgField = baseDataType.getDestOrgField();
        if (StringUtils.isEmpty((String)destOrgField)) {
            return;
        }
        String orgUnitId = cuid.getId().toString();
        fic.add(new FilterItemInfo(destOrgField, (Object)orgUnitId, CompareType.EQUALS));
        OrgType orgType = BaseDataMapingEditUI.getOrgType(baseDataType);
        if (this.isAccountBaseType(baseDataType) && OrgType.Company.equals((Object)orgType) && (object = (orgUnitInfo = (OrgUnitInfo)this.prmtOrgUnit.getData()).get("accounttable")) != null) {
            try {
                String accountTableIDValue = this.getAccountTableInfoId(object);
                fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTableIDValue, CompareType.EQUALS));
                fic.add(new FilterItemInfo("isleaf", (Object)1, CompareType.EQUALS));
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
    }

    private String getAccountTableInfoIdBySQL(String orgUnitId) {
        String accountTableIDValue = null;
        try {
            IRowSet rowset = KSQLFacadeFactory.getRemoteInstance().queryRowset("select faccounttableid from t_bd_accountview where faccounttableid in(select faccounttableid from t_org_company where fid ='" + orgUnitId + "') and fcompanyid='" + orgUnitId + "'");
            if (rowset.next()) {
                accountTableIDValue = rowset.getString("faccounttableid");
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return accountTableIDValue;
    }

    private String getAccountTableInfoId(Object object) {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.kingdee.eas.basedata.master.account.AccountTableInfo");
            Method getId = clazz.getMethod("getId", new Class[0]);
            BOSUuid bosUuid = (BOSUuid)getId.invoke(object, new Object[0]);
            return bosUuid.toString();
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
            return null;
        }
    }

    private boolean isAccountBaseType(BaseDataTypeInfo baseDataType) {
        BaseDataInfo baseDataInfo = baseDataType.getDestBaseData();
        if (null != baseDataInfo) {
            try {
                String id = baseDataInfo.getId().toString();
                BaseDataInfo o = BaseDataFactory.getRemoteInstance().getBaseDataInfo((IObjectPK)new ObjectUuidPK(id));
                if (null != o) {
                    return "com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery".equalsIgnoreCase(o.getQueryName());
                }
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
        return false;
    }

    private Map<String, DisValueDTO> getSrcRowMap() {
        HashMap<String, DisValueDTO> rowMap = new HashMap<String, DisValueDTO>();
        int entryCount = this.kdtEntrys.getRowCount();
        for (int i = 0; i < entryCount; ++i) {
            DisValueDTO srcValueDTO = new DisValueDTO(i, String.valueOf(this.kdtEntrys.getCell(i, SRC_DISPLAY).getValue()));
            rowMap.put(String.valueOf(this.kdtEntrys.getCell(i, SRC_ID).getValue()), srcValueDTO);
        }
        return rowMap;
    }

    private List getSrcIDRowList() {
        ArrayList srcIDList = new ArrayList();
        Set<Object> set = new HashSet<Object>();
        int entryCount = this.kdtEntrys.getRowCount();
        for (int i = 0; i < entryCount; ++i) {
            set.add(this.kdtEntrys.getCell(i, SRC_ID).getValue());
        }
        set = this.getSrcIDRowListFromTable(set);
        srcIDList.addAll(set);
        return srcIDList;
    }

    private Set getSrcIDRowListFromTable(Set set) {
        if (set == null) {
            set = new HashSet<String>();
        }
        BaseDataTypeInfo typeInfo = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        try {
            FilterItemInfo filterItem;
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            BOSUuid id = this.editData.getId();
            if (id != null) {
                filterItem = new FilterItemInfo("id", (Object)id.toString(), CompareType.NOTEQUALS);
                view.getFilter().getFilterItems().add(filterItem);
            }
            filterItem = new FilterItemInfo("baseDataType.id", (Object)typeInfo.getId().toString(), CompareType.EQUALS);
            view.getFilter().getFilterItems().add(filterItem);
            BaseDataMapingCollection coll = BaseDataMapingFactory.getRemoteInstance().getBaseDataMapingCollection(view);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                BaseDataMapingInfo mapping = (BaseDataMapingInfo)it.next();
                Iterator entries = mapping.getEntrys().iterator();
                while (entries.hasNext()) {
                    BaseDataMapingEntryInfo entry = (BaseDataMapingEntryInfo)entries.next();
                    set.add(entry.getSrcID());
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return set;
    }

    private void updateEntryTable(IRowSet rowset) throws SQLException {
        Map<String, DisValueDTO> srcMap = this.getSrcRowMap();
        Set<String> keySet = srcMap.keySet();
        if (null != rowset) {
            while (rowset.next()) {
                if (!keySet.contains(rowset.getString(1))) {
                    IRow iRow = this.kdtEntrys.addRow();
                    iRow.getCell("systemAuto").setValue((Object)false);
                    iRow.getCell(SRC_ID).setValue((Object)rowset.getString(1));
                    iRow.getCell(SRC_DISPLAY).setValue((Object)rowset.getString(2));
                    continue;
                }
                if (StringUtils.equals((String)srcMap.get(rowset.getString(1)).getSrcValue(), (String)rowset.getString(2))) continue;
                int rowIndex = srcMap.get(rowset.getString(1)).getSeq();
                int columnIndex = this.kdtEntrys.getColumnIndex(SRC_DISPLAY);
                ICell srcDisplayCell = this.kdtEntrys.getCell(rowIndex, columnIndex);
                srcDisplayCell.setValue((Object)rowset.getString(2));
            }
        }
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        if (e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
            int index = e.getRowIndex();
            ICell destDisplayCell = this.kdtEntrys.getCell(index, "destDisplay");
            ICell destIDCell = this.kdtEntrys.getCell(index, "destID");
            IObjectValue destID = (IObjectValue)destIDCell.getValue();
            BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
            String destDisplay = baseDataTypeInfo.getDestDisplay();
            String value = UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)destID, (String)destDisplay));
            destDisplayCell.setValue((Object)value);
        } else if (e.getValue() == null) {
            int index = e.getRowIndex();
            ICell destDisplayCell = this.kdtEntrys.getCell(index, "destDisplay");
            destDisplayCell.setValue(null);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        BaseDataMapingInfo objectValue = new BaseDataMapingInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setBizDate(MySCMClientUtils.getServerDate2());
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable arg0) {
        BaseDataMapingEntryInfo baseDataMapingEntryInfo = new BaseDataMapingEntryInfo();
        return baseDataMapingEntryInfo;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    public void loadDataFromExcel(String filePath) throws Exception {
        FILE_PATH = filePath;
        if (null != UI_WINDOW) {
            UI_WINDOW.close();
        }
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", "\u6b63\u5728\u5bfc\u5165\u57fa\u7840\u8d44\u6599,\u8bf7\u7a0d\u540e...");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec() throws Exception {
                HashMap valueMap = new HashMap();
                HashMap<String, String> rowMap = new HashMap<String, String>();
                ArrayList<String> importIdList = new ArrayList<String>();
                List srcIDList = BaseDataMapingEditUI.this.getSrcIDRowList();
                try {
                    String[] lineData;
                    int i;
                    String[][] execlData = ExcelHelper.getStringData(FILE_PATH, 0, 0, Integer.MAX_VALUE, 0, 3);
                    BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)BaseDataMapingEditUI.this.prmtbaseDataType.getData();
                    String destDisplay = baseDataTypeInfo.getDestDisplay();
                    for (i = 1; i < execlData.length; ++i) {
                        lineData = execlData[i];
                        if (CommonUtil.isBlankLineData(lineData) || srcIDList.contains(lineData[0])) continue;
                        String str = lineData[2];
                        if (str != null && str.toString().contains(".")) {
                            str.toString().replace('.', '!');
                            rowMap.put(lineData[0], str.toString());
                        } else {
                            rowMap.put(lineData[0], lineData[2]);
                        }
                        importIdList.add(str);
                    }
                    if (importIdList.size() != 0) {
                        BaseDataMapingEditUI.this.getEntryBaseDataInfos(valueMap, rowMap, importIdList);
                        for (i = 1; i < execlData.length; ++i) {
                            lineData = execlData[i];
                            if (CommonUtil.isBlankLineData(lineData)) continue;
                            IRow iRow = BaseDataMapingEditUI.this.kdtEntrys.addRow();
                            iRow.getCell(BaseDataMapingEditUI.SRC_ID).setValue((Object)lineData[0]);
                            iRow.getCell(BaseDataMapingEditUI.SRC_DISPLAY).setValue((Object)lineData[1]);
                            IObjectValue ojectValue = (IObjectValue)valueMap.get(rowMap.get(lineData[0]));
                            if (null == ojectValue) continue;
                            iRow.getCell("destID").setValue((Object)ojectValue);
                            String value = UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)ojectValue, (String)destDisplay));
                            iRow.getCell("destDisplay").setValue((Object)value);
                        }
                    }
                    String string = "success";
                    return string;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.exception = exc;
                    String string = "fail";
                    return string;
                }
                finally {
                    valueMap.clear();
                    rowMap.clear();
                    srcIDList.clear();
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (null != this.exception) {
                    Exception ca = this.exception;
                    MsgBox.showDetailAndOK((Component)((Object)BaseDataMapingEditUI.this), (String)("\u57fa\u7840\u8d44\u6599\u5bfc\u5165\u5931\u8d25\uff1a" + this.exception.getMessage()), (String)ThrowableHelper.toString((Throwable)ca), (int)1);
                } else {
                    MsgBox.showInfo((String)"\u57fa\u7840\u8d44\u6599\u5bfc\u5165\u6210\u529f\u3002");
                }
            }
        });
        dialog.show();
    }

    private void getEntryBaseDataInfos(Map<String, IObjectValue> valueMap, Map<String, String> rowMap, List srcIDList) throws Exception {
        BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        String queryName = BaseDataInfoUtil.getQueryName(baseDataTypeInfo);
        MetaDataPK queryPK = MetaDataPK.create((String)queryName);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)queryPK, (Context)this.getMainOrgContext());
        IFilterInfoProducer producer = FilterInfoProducerFactory.getControlTypeFilterInfoProducer((String)queryName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)queryPK);
        SelectorItemCollection sic = new SelectorItemCollection();
        ArrayList resultArray = new ArrayList();
        try {
            SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
            SubEntityInfo mainEntityInfo = null;
            if (mainObjectInfo instanceof SubEntityInfo) {
                mainEntityInfo = (SubEntityInfo)mainObjectInfo;
                mainEntityInfo.getEntityRef();
            }
            BOSObjectType type = null;
            if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
                type = mainEntityInfo.getEntityRef().getType();
            }
            int listSize = srcIDList.size();
            int page = listSize / DESC_MATCH_MAX_SIZE;
            int expl = listSize % DESC_MATCH_MAX_SIZE;
            if (expl > 0) {
                ++page;
            }
            List tmpList = null;
            int endSize = 0;
            int i = 0;
            IDynamicObject instance = DynamicObjectFactory.getRemoteInstance();
            for (i = 0; i < page; ++i) {
                endSize = (i + 1) * DESC_MATCH_MAX_SIZE > listSize ? listSize : (i + 1) * DESC_MATCH_MAX_SIZE;
                tmpList = srcIDList.subList(i * DESC_MATCH_MAX_SIZE, endSize);
                FilterInfo filter = (FilterInfo)producer.getFilterInfo().clone();
                FilterItemInfo filterItem = new FilterItemInfo();
                filterItem.setPropertyName(baseDataTypeInfo.getDestID());
                filterItem.setCompareValue((Object)tmpList.toString());
                filterItem.setCompareType(CompareType.INCLUDE);
                filter.getFilterItems().add(filterItem);
                EntityViewInfo view = null;
                String where = this.txtdestWhere.getText();
                if (StringUtils.isEmpty((String)where)) {
                    view = new EntityViewInfo();
                } else {
                    if (!StringUtils.startsWithIgnoreCase((String)where, (String)"where")) {
                        where = " where " + where;
                    }
                    view = new EntityViewInfo(where);
                }
                if (null == view.getFilter()) {
                    view.setFilter(new FilterInfo());
                }
                this.filtWithOrgUnitInfo(filter.getFilterItems());
                if (filter.getFilterItems().size() > 0) {
                    view.getFilter().mergeFilter(filter, "AND");
                }
                exec.setObjectView(view);
                IObjectCollection coll = instance.getCollection(type, view);
                int count = coll.size();
                for (int j = 0; j < count; ++j) {
                    IObjectValue object = coll.getObject(j);
                    String number = String.valueOf(object.get(baseDataTypeInfo.getDestID()));
                    if (!srcIDList.contains(number) || valueMap.containsKey(number)) continue;
                    valueMap.put(number, object);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("\u76ee\u6807\u7cfb\u7edf\u8fc7\u6ee4\u6761\u4ef6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!", e);
        }
    }

    private IObjectValue getEntryBaseDataInfo(String baseDataInfoNumber) throws Exception {
        BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        String queryName = BaseDataInfoUtil.getQueryName(baseDataTypeInfo);
        MetaDataPK queryPK = MetaDataPK.create((String)queryName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)queryPK);
        SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
        SubEntityInfo mainEntityInfo = null;
        if (mainObjectInfo instanceof SubEntityInfo) {
            mainEntityInfo = (SubEntityInfo)mainObjectInfo;
            mainEntityInfo.getEntityRef();
        }
        BOSObjectType type = null;
        if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
            type = mainEntityInfo.getEntityRef().getType();
        }
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)queryPK, (Context)this.getMainOrgContext());
        IFilterInfoProducer producer = FilterInfoProducerFactory.getControlTypeFilterInfoProducer((String)queryName);
        FilterInfo filter = producer.getFilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo();
        filterItem.setPropertyName(baseDataTypeInfo.getDestID());
        filterItem.setCompareValue((Object)baseDataInfoNumber);
        filterItem.setCompareType(CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = null;
        String where = this.txtdestWhere.getText();
        view = StringUtils.isEmpty((String)where) ? new EntityViewInfo() : new EntityViewInfo(where);
        if (null == view.getFilter()) {
            view.setFilter(new FilterInfo());
        }
        this.filtWithOrgUnitInfo(filter.getFilterItems());
        if (filter.getFilterItems().size() > 0) {
            view.getFilter().mergeFilter(filter, "AND");
        }
        exec.setObjectView(view);
        IDynamicObject instance = DynamicObjectFactory.getRemoteInstance();
        IObjectCollection coll = instance.getCollection(type, view);
        int count = coll.size();
        for (int j = 0; j < count; ++j) {
            IObjectValue object = coll.getObject(j);
            String number = String.valueOf(object.get(baseDataTypeInfo.getDestID()));
            if (!baseDataInfoNumber.equals(number)) continue;
            return object;
        }
        return null;
    }

    private List getValues(IMetaDataPK pk, List<String> queryValues) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo queryInfo = loader.getQuery(pk);
        SelectorItemCollection sic = new SelectorItemCollection();
        ArrayList resultArray = new ArrayList();
        try {
            SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
            SubEntityInfo mainEntityInfo = null;
            if (mainObjectInfo instanceof SubEntityInfo) {
                mainEntityInfo = (SubEntityInfo)mainObjectInfo;
                mainEntityInfo.getEntityRef();
            }
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo fInfo = new FilterInfo();
            HashSet<String> queryValueSet = new HashSet<String>();
            queryValueSet.addAll(queryValues);
            fInfo.getFilterItems().add(new FilterItemInfo("id", queryValueSet, CompareType.INCLUDE));
            evInfo.setFilter(fInfo);
            evInfo.getSelector().addObjectCollection((IObjectCollection)sic);
            BOSObjectType type = null;
            if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
                type = mainEntityInfo.getEntityRef().getType();
            }
            IObjectCollection coll = DynamicObjectFactory.getRemoteInstance().getCollection(type, evInfo);
            ArrayList<IObjectValue> result = new ArrayList<IObjectValue>();
            int count = coll.size();
            for (int i = 0; i < count; ++i) {
                IObjectValue ov = coll.getObject(i);
                result.add(ov);
            }
            return result;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private void checkExcelData(String[][] execlData, Map map) throws Exception {
        if (execlData.length < 1) {
            throw new Exception("\u5f85\u5bfc\u5165\u6587\u4ef6\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u4efb\u4f55\u503c\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u6dfb\u52a0\u540e\u518d\u5bfc\u5165\u3002");
        }
        ArrayList<String> srcIds = new ArrayList<String>();
        for (int i = 0; i < execlData.length; ++i) {
            if (srcIds.contains(execlData[i][0])) {
                throw new Exception("\u6e90\u7cfb\u7edf\u6807\u8bc6\u503c\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002");
            }
            srcIds.add(execlData[i][0]);
        }
    }

    @Override
    public void actionAutoMatching_actionPerformed(ActionEvent e) throws Exception {
        this.coll = null;
        this.view = null;
        this.type = null;
        this.baseDataTypeInfo = null;
        this.filter = null;
        this.filterItemCollection = null;
        this.baseDataTypeInfo = (BaseDataTypeInfo)this.prmtbaseDataType.getData();
        if (this.baseDataTypeInfo == null) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6620\u5c04");
            SysUtil.abort();
        }
        this.editData.setBaseDataType(this.baseDataTypeInfo);
        this.checkNeedAutoMatch();
        String queryName = BaseDataInfoUtil.getQueryName(this.baseDataTypeInfo);
        MetaDataPK queryPK = MetaDataPK.create((String)queryName);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)queryPK, (Context)this.getMainOrgContext());
        IFilterInfoProducer producer = FilterInfoProducerFactory.getControlTypeFilterInfoProducer((String)queryName);
        this.filter = producer.getFilterInfo();
        String where = this.txtdestWhere.getText();
        this.view = StringUtils.isEmpty((String)where) ? new EntityViewInfo() : new EntityViewInfo(where);
        if (null == this.view.getFilter()) {
            this.view.setFilter(new FilterInfo());
        }
        this.filterItemCollection = this.filter.getFilterItems();
        this.filtWithOrgUnitInfo(this.filterItemCollection);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)queryPK);
        SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
        SubEntityInfo mainEntityInfo = null;
        if (mainObjectInfo instanceof SubEntityInfo) {
            mainEntityInfo = (SubEntityInfo)mainObjectInfo;
        }
        if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
            this.type = mainEntityInfo.getEntityRef().getType();
        }
        String normalMsg = "\u6b63\u5728\u6267\u884c\u81ea\u52a8\u5339\u914d";
        final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", "\u6b63\u5728\u6267\u884c\u81ea\u52a8\u5339\u914d,\u8bf7\u7a0d\u540e...");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec() throws Exception {
                try {
                    BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)BaseDataMapingEditUI.this.prmtbaseDataType.getData();
                    HashMap unMatchValue = new HashMap();
                    BaseDataMapingEditUI.this.getUnMatchValue(unMatchValue, BaseDataMapingEditUI.this.kdtEntrys.getRowCount(), 0);
                    int totalSize = BaseDataMapingEditUI.this.kdtEntrys.getRowCount();
                    int tmp_Size = DESC_MATCH_MAX_SIZE > totalSize ? totalSize : DESC_MATCH_MAX_SIZE;
                    int page = totalSize / tmp_Size + (totalSize % tmp_Size > 0 ? 1 : 0);
                    if (BaseDataMapingEditUI.this.filter.getFilterItems().size() > 0) {
                        BaseDataMapingEditUI.this.view.getFilter().mergeFilter(BaseDataMapingEditUI.this.filter, "AND");
                    }
                    for (int i = 0; i < page; ++i) {
                        dialog.updateMsg("\u6b63\u5728\u6267\u884c\u81ea\u52a8\u5339\u914d(" + (i + 1) + "/" + page + ")");
                        EntityViewInfo viewTmp = (EntityViewInfo)BaseDataMapingEditUI.this.view.clone();
                        FilterInfo filterNow = new FilterInfo();
                        boolean needQuery = BaseDataMapingEditUI.this.filterWithMatchType(baseDataTypeInfo, filterNow, tmp_Size, i);
                        if (!needQuery) continue;
                        if (filterNow.getFilterItems().size() > 0) {
                            viewTmp.getFilter().mergeFilter(filterNow, "AND");
                        }
                        if (BaseDataMapingEditUI.this.coll == null) {
                            BaseDataMapingEditUI.this.coll = DynamicObjectFactory.getRemoteInstance().getCollection(BaseDataMapingEditUI.this.type, viewTmp);
                        } else {
                            BaseDataMapingEditUI.this.coll.addObjectCollection(DynamicObjectFactory.getRemoteInstance().getCollection(BaseDataMapingEditUI.this.type, viewTmp));
                        }
                        if (BaseDataMapingEditUI.this.coll == null || BaseDataMapingEditUI.this.coll.size() == 0) continue;
                        HashMap<String, IObjectValue> numberMap = new HashMap<String, IObjectValue>();
                        HashMap<String, IObjectValue> nameMap = new HashMap<String, IObjectValue>();
                        int count = BaseDataMapingEditUI.this.coll.size();
                        for (int j = 0; j < count; ++j) {
                            IObjectValue object = BaseDataMapingEditUI.this.coll.getObject(j);
                            String number = String.valueOf(object.get(baseDataTypeInfo.getDestID()));
                            String name = String.valueOf(object.get(baseDataTypeInfo.getDestDisplay()));
                            if (!StringUtils.isEmpty((String)number)) {
                                numberMap.put(number, object);
                            }
                            if (StringUtils.isEmpty((String)name)) continue;
                            nameMap.put(name, object);
                        }
                        DataMatchType matchType = baseDataTypeInfo.getMatchType();
                        IObjectValue value = null;
                        int begin = tmp_Size * i;
                        int end = tmp_Size * (i + 1);
                        int rowCount = BaseDataMapingEditUI.this.kdtEntrys.getRowCount();
                        end = end > rowCount ? rowCount : end;
                        for (int j = begin; j < end; ++j) {
                            ICell cell = BaseDataMapingEditUI.this.kdtEntrys.getCell(j, "destID");
                            if (null != cell.getValue()) continue;
                            ICell srcCell = BaseDataMapingEditUI.this.kdtEntrys.getCell(j, BaseDataMapingEditUI.SRC_DISPLAY);
                            ICell srcIdCell = BaseDataMapingEditUI.this.kdtEntrys.getCell(j, BaseDataMapingEditUI.SRC_ID);
                            String name = String.valueOf(srcCell.getValue());
                            String number = String.valueOf(srcIdCell.getValue());
                            if (matchType == null || matchType.equals((Object)DataMatchType.NumName)) {
                                if (!BaseDataMapingEditUI.this.matchNumber(number, numberMap) && !BaseDataMapingEditUI.this.matchName(name, nameMap)) continue;
                                value = numberMap.get(number) == null ? (IObjectValue)nameMap.get(name) : (IObjectValue)numberMap.get(number);
                            } else if (matchType.equals((Object)DataMatchType.NumAndName)) {
                                if (!BaseDataMapingEditUI.this.matchNumber(number, numberMap) || !StringUtils.equals((String)String.valueOf(((IObjectValue)numberMap.get(number)).get("name")), (String)name)) continue;
                                value = (IObjectValue)nameMap.get(name);
                            } else if (matchType.equals((Object)DataMatchType.OnlyNum)) {
                                if (!BaseDataMapingEditUI.this.matchNumber(number, numberMap)) continue;
                                value = (IObjectValue)numberMap.get(number);
                            } else if (matchType.equals((Object)DataMatchType.OnlyName)) {
                                if (!BaseDataMapingEditUI.this.matchName(name, nameMap)) continue;
                                value = (IObjectValue)nameMap.get(name);
                            }
                            cell.setValue((Object)value);
                            ICell destDisplayCell = BaseDataMapingEditUI.this.kdtEntrys.getCell(j, "destDisplay");
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            destDisplayCell.setValue((Object)value.getString("name"));
                        }
                        numberMap = null;
                        nameMap = null;
                    }
                    String string = "success";
                    return string;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.exception = exc;
                    String string = "fail";
                    return string;
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
        this.getUILifeCycleHandler().excuteChangeEventListener(true);
    }

    private boolean filterWithMatchType(BaseDataTypeInfo baseDataTypeInfo, FilterInfo filterTmp, int maxSize, int page) {
        HashMap<String, String> unMatchValue = new HashMap<String, String>();
        this.getUnMatchValue(unMatchValue, maxSize, page);
        if (unMatchValue.size() == 0) {
            return false;
        }
        FilterItemCollection filterItemCollection = filterTmp.getFilterItems();
        DataMatchType matchType = baseDataTypeInfo.getMatchType();
        if (matchType == null || matchType.equals((Object)DataMatchType.NumName)) {
            this.filterWithMatchType(baseDataTypeInfo, filterItemCollection, unMatchValue, "number", matchType);
            this.filterWithMatchType(baseDataTypeInfo, filterItemCollection, unMatchValue, "name", matchType);
            filterTmp.setMaskString("#0 or #1");
        } else if (matchType.equals((Object)DataMatchType.NumAndName)) {
            this.filterWithMatchType(baseDataTypeInfo, filterItemCollection, unMatchValue, "both", matchType);
        } else {
            this.filterWithMatchType(baseDataTypeInfo, filterItemCollection, unMatchValue, "", matchType);
        }
        return true;
    }

    private void getUnMatchValue(Map<String, String> unMatchValue, int maxSize, int page) {
        int begin = maxSize * page;
        int end = maxSize * (page + 1);
        int rowCount = this.kdtEntrys.getRowCount();
        end = end > rowCount ? rowCount : end;
        String rule = this.editData.getBaseDataType().getRule();
        boolean appendBefore = false;
        boolean appendAfter = false;
        String append = "";
        if (!StringUtils.isEmpty((String)rule)) {
            String[] replace = rule.split("\\?");
            appendBefore = StringUtils.isEmpty((String)replace[0]);
            if (appendBefore) {
                append = replace[1];
            }
            if (appendAfter = StringUtils.isEmpty((String)replace[1])) {
                append = replace[0];
            }
        }
        for (int i = begin; i < end; ++i) {
            ICell cell = this.kdtEntrys.getCell(i, "destID");
            if (cell == null || null != cell.getValue()) continue;
            String number = String.valueOf(MyKDTableUtil.getTableCellValue(this.kdtEntrys, i, SRC_ID));
            if (appendBefore) {
                number = append + number;
            }
            if (appendAfter) {
                number = number + append;
            }
            String name = String.valueOf(MyKDTableUtil.getTableCellValue(this.kdtEntrys, i, SRC_DISPLAY));
            unMatchValue.put(number, name);
        }
    }

    private void filterWithMatchType(BaseDataTypeInfo baseDataTypeInfo, FilterItemCollection filterItemCollection, Map<String, String> unMatchValue, String type, DataMatchType matchType) {
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.addAll(unMatchValue.values());
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(unMatchValue.keySet());
        if (StringUtils.equals((String)type, (String)"number")) {
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestID(), keySet, CompareType.INCLUDE));
        } else if (StringUtils.equals((String)type, (String)"name")) {
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestDisplay(), valueSet, CompareType.INCLUDE));
        } else if (matchType.equals((Object)DataMatchType.NumAndName)) {
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestID(), keySet, CompareType.INCLUDE));
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestDisplay(), valueSet, CompareType.INCLUDE));
        } else if (matchType.equals((Object)DataMatchType.OnlyNum)) {
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestID(), keySet, CompareType.INCLUDE));
        } else if (matchType.equals((Object)DataMatchType.OnlyName)) {
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestDisplay(), valueSet, CompareType.INCLUDE));
        }
    }

    private boolean matchNumber(String number, Map<String, IObjectValue> numberMap) {
        IObjectValue value = numberMap.get(number);
        return value != null;
    }

    private boolean matchName(String name, Map<String, IObjectValue> nameMap) {
        IObjectValue value = nameMap.get(name);
        return value != null;
    }

    @Override
    protected void importButton_actionPerformed(ActionEvent e) throws Exception {
        if (CSCheck.checkF7NotPassed(this.prmtbaseDataType.getData(), "\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6620\u5c04")) {
            this.prmtbaseDataType.requestFocus();
            return;
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        HashMap<String, BaseDataMapingEditUI> uiContext = new HashMap<String, BaseDataMapingEditUI>();
        uiContext.put("Owner", this);
        HashMap dataObjects = new HashMap();
        IUIWindow uiWindow = uiFactory.create(BaseDataMappingImportUI.class.getName(), uiContext, dataObjects, OprtState.ADDNEW);
        BaseDataMappingImportUI baseDataMappingImportUI = (BaseDataMappingImportUI)uiWindow.getUIObject();
        baseDataMappingImportUI.builderInfo(DataFile.class, "BaseDataMappingImportTemplate.xls", "\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04");
        UI_WINDOW = uiWindow;
        uiWindow.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportButton_actionPerformed(ActionEvent e) throws Exception {
        if (CSCheck.checkF7NotPassed(this.prmtbaseDataType.getData(), "\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6620\u5c04")) {
            this.prmtbaseDataType.requestFocus();
            return;
        }
        File file = Export2FileUtil.getExportFileWithOverrideTip((Component)((Object)this), "\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04\u5bfc\u51fa", "\u4fdd\u5b58", new String[]{"xls"}, "Excel 1997\u62162003\u7248\u672c", "\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04\u5bfc\u51fa.xls");
        if (null == file) {
            return;
        }
        MarshallingContext marshallingContext = DefaultStream.getInstance().getMarshallingContext();
        WritableWorkbook writableWorkbook = null;
        InputStream is = null;
        try {
            is = DataFile.class.getResourceAsStream("BaseDataMappingExportTemplate.xls");
            Workbook copy = Workbook.getWorkbook((InputStream)is);
            writableWorkbook = Workbook.createWorkbook((File)file, (Workbook)copy);
            marshallingContext.put("WritableWorkbook", writableWorkbook);
            marshallingContext.put("kdtEntrys", this.kdtEntrys);
            marshallingContext.marshall(this.getDataObject());
            writableWorkbook.write();
            MsgBox.showInfo((Component)((Object)this), (String)"\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04\u5bfc\u51fa\u6210\u529f\u3002");
        }
        catch (Exception ex) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04\u5bfc\u51fa\u5931\u8d25\u3002", (String)ex.getMessage(), (int)8188);
        }
        finally {
            marshallingContext.remove("WritableWorkbook");
            marshallingContext.remove("kdtEntrys");
            try {
                if (null != writableWorkbook) {
                    writableWorkbook.close();
                }
            }
            catch (Exception ex) {}
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("BaseDataType", this.prmtbaseDataType.getValue());
        super.actionAddNew_actionPerformed(e);
        BaseDataMapingEditUI.resetOwer(this.getUIContext());
        this.onLoad();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        BaseDataMapingEditUI.resetOwer(this.getUIContext());
        this.kDDateCreateTime.setValue(null);
    }

    public static void resetOwer(Map uiContext) throws Exception {
        BaseDataMapingListUI editUi;
        Object bizward;
        Object obj = uiContext.get("Owner");
        if (null != obj && obj instanceof BaseDataMapingListUI && (bizward = (editUi = (BaseDataMapingListUI)((Object)obj)).getUIContext().get("BizWizardEditUiKey")) != null) {
            uiContext.put("BizWizardEditUiKey", bizward);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        DataSourceType dsType = ((BaseDataTypeInfo)this.prmtbaseDataType.getData()).getDsType();
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            this.btnUpdateSrcData.setEnabled(true);
            this.autoMatchingButton.setEnabled(true);
        }
        this.loadFields();
        this.prmtbaseDataType.setEnabled(false);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public boolean destroyWindow() {
        this.backEditData();
        return super.destroyWindow();
    }

    private void initialBarItem(boolean enable) {
        this.btnAddNew.setEnabled(enable);
        this.btnEdit.setEnabled(enable && this.btnEdit.isEnabled());
        this.btnRemove.setEnabled(enable);
        this.btnCopy.setEnabled(enable);
        this.btnUpdateSrcData.setEnabled(enable);
        this.autoMatchingButton.setEnabled(enable);
        this.importButton.setEnabled(enable);
    }

    public void backEditData() {
        Object obj;
        this.getUIContext();
        Object bizward = this.getUIContext().get("BizWizardEditUiKey");
        if (bizward != null && null != (obj = this.getUIContext().get("Owner")) && obj instanceof BaseDataMapingListUI) {
            BaseDataMapingListUI editUi = (BaseDataMapingListUI)((Object)obj);
            if (null != this.getUIContext().get("ID")) {
                editUi.getBackEditDataId(this.getUIContext().get("ID").toString());
                try {
                    editUi.refreshList();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BizWizardEditUI wizardUi = (BizWizardEditUI)((Object)bizward);
                wizardUi.setHasModified(true);
            }
        }
    }

    private void checkNeedAutoMatch() {
        boolean needCount = false;
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            String srcDisplay = (String)row.getCell(SRC_DISPLAY).getValue();
            String srcID = (String)row.getCell(SRC_ID).getValue();
            Object o = row.getCell("destID").getValue();
            if (StringUtils.isEmpty((String)srcID) && StringUtils.isEmpty((String)srcDisplay) || o != null) continue;
            needCount = true;
            break;
        }
        if (!needCount) {
            MsgBox.showInfo((String)"\u6ca1\u6709\u9700\u8981\u5339\u914d\u7684\u6570\u636e");
            SysUtil.abort();
        }
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
        super.applyDefaultValue(vo);
        EIPUIClassParamUtil.applyDefaultValue(this.getUIContext(), "configType", "configType", vo, "applicationScope", null);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("destBaseData.queryName"));
        sic.add(new SelectorItemInfo("applicationScope"));
        sic.add(new SelectorItemInfo("baseDataType.*"));
        return sic;
    }

    private class DisValueDTO {
        private int seq;
        private String srcValue;

        public DisValueDTO(int seq, String srcValue) {
            this.seq = seq;
            this.srcValue = srcValue;
        }

        public int getSeq() {
            return this.seq;
        }

        public String getSrcValue() {
            return this.srcValue;
        }
    }
}

