/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.NumberFormatterEx;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.business.client.BizWizardEditUI;
import com.kingdee.eas.csinterface.business.common.BusinessConstants;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionTreeInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.syncdatabase.client.AbstractConnectionEditUI;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ConnectionEditUI
extends AbstractConnectionEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ConnectionEditUI.class);
    private static final int ORACLEPORT = 1521;
    private static final int SQLSERVER = 1433;
    private static final int MYSQL = 3306;
    private static final int DB2 = 50000;

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState() == OprtState.EDIT) {
            boolean state = false;
            try {
                state = ConnectionFactory.getRemoteInstance().canModifyConnection(this.editData);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.setButtonState(state);
        }
    }

    public ConnectionEditUI() throws Exception {
        this.setCustComponentTabIndex();
        NumberFormatterEx f = (NumberFormatterEx)this.txtPort.getDispalyFormatter();
        f.setFormat(null);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.txtNumber.requestFocusInWindow();
    }

    private void setCustComponentTabIndex() {
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.txtNumber, this.txtName, this.DBType, this.txtIP, this.txtPort, this.txtinstance, this.txtusername, this.txtpassword, this.txtedition, this.txtDescription}));
    }

    private String getDbInfo(String data, String errorInfo) {
        if (data != null && data.trim().length() > 0) {
            data = data.trim();
        } else {
            MsgBox.showInfo((String)("\u5b57\u6bb5" + errorInfo + "\u7684\u503c\u672a\u8bbe\u7f6e\u3002"));
            SysUtil.abort();
        }
        return data;
    }

    @Override
    public void actionTestConn_actionPerformed(ActionEvent e) throws Exception {
        DBType dbType = (DBType)((Object)this.DBType.getSelectedItem());
        String ip = this.txtIP.getText();
        ip = this.getDbInfo(ip, "IP\u5730\u5740");
        String port = null;
        if (this.txtPort.getIntegerValue() != null) {
            port = this.txtPort.getIntegerValue().toString();
        }
        this.getDbInfo(port, "\u7aef\u53e3");
        String dbName = this.txtinstance.getText();
        dbName = this.getDbInfo(dbName, "\u6570\u636e\u5e93\u540d");
        String userName = this.txtusername.getText();
        userName = this.getDbInfo(userName, "\u7528\u6237\u540d");
        char[] pwdChar = this.txtpassword.getPassword();
        StringBuilder builder = new StringBuilder();
        builder.append(pwdChar);
        Arrays.fill((char[])pwdChar, (char)' ');
        if (StringUtils.isEmpty((String)builder.toString())) {
            MsgBox.showInfo((String)"\u5b57\u6bb5\u5bc6\u7801\u7684\u503c\u672a\u8bbe\u7f6e\u3002");
            SysUtil.abort();
        }
        try {
            boolean result = SQLFacadeFactory.getRemoteInstance().DBConnection(dbType.toString(), ip, port, dbName, userName, builder.toString());
            if (result) {
                MsgBox.showInfo((String)"\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f\uff01");
            } else {
                MsgBox.showInfo((String)"\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u6570\u636e\u5e93IP\u5730\u5740\u3001\u7aef\u53e3\u3001\u7528\u6237\u540d\u548c\u5bc6\u7801\u7b49\u662f\u5426\u6b63\u786e\u3002");
            }
        }
        catch (Exception ex) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u6570\u636e\u5e93IP\u5730\u5740\u3001\u7aef\u53e3\u3001\u7528\u6237\u540d\u548c\u5bc6\u7801\u7b49\u662f\u5426\u6b63\u786e\u3002", (String)ex.getMessage(), (int)2);
        }
        super.actionTestConn_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ConnectionFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("treeid", (ConnectionTreeInfo)this.getUIContext().get("ParentNode"));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        ConnectionInfo objectValue = new ConnectionInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
    }

    public void onLoad() throws Exception {
        Map uiContext = this.getUIContext();
        Object obj = uiContext.get("BizWizardEditUiKey");
        if (null != obj && obj instanceof BizWizardEditUI) {
            String dbConnId = (String)uiContext.get(BusinessConstants.getBtnCodeEntryColName("dbConn"));
            if (!StringUtils.isEmpty((String)dbConnId)) {
                uiContext.put("ID", dbConnId);
            }
            this.btnAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.btnSubmit.setVisible(false);
            this.btnCopy.setVisible(false);
        }
        super.onLoad();
        this.txtpassword.setBackground(UIManager.getColor("TextField.requiredBackground"));
        if (this.txtPort.getValue() == null || this.txtPort.getValue().equals(0)) {
            this.txtPort.setValue((Object)1521);
        }
        this.DBType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.dbTypeChanged();
            }

            private void dbTypeChanged() {
                if (ConnectionEditUI.this.DBType.getSelectedItem().equals((Object)com.kingdee.eas.csinterface.syncdatabase.DBType.SQLServer)) {
                    ConnectionEditUI.this.txtPort.setValue((Object)1433);
                } else if (ConnectionEditUI.this.DBType.getSelectedItem().equals((Object)com.kingdee.eas.csinterface.syncdatabase.DBType.Oracle)) {
                    ConnectionEditUI.this.txtPort.setValue((Object)1521);
                } else if (ConnectionEditUI.this.DBType.getSelectedItem().equals((Object)com.kingdee.eas.csinterface.syncdatabase.DBType.DB2)) {
                    ConnectionEditUI.this.txtPort.setValue((Object)50000);
                } else if (ConnectionEditUI.this.DBType.getSelectedItem().equals((Object)com.kingdee.eas.csinterface.syncdatabase.DBType.MySql)) {
                    ConnectionEditUI.this.txtPort.setValue((Object)3306);
                }
            }
        });
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.txtName.setText(null);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.setButtonState(true);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String username;
        String ipText;
        StringBuffer ipBuf;
        String operate = this.getOprtState();
        String oldName = this.editData.getName();
        String oldNumber = this.editData.getNumber();
        String objName = this.txtName.getText();
        String strNumber = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)strNumber)) {
            MsgBox.showInfo((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[ ]", strNumber)) {
            MsgBox.showInfo((String)"\u7f16\u7801\u4e2d\u4e0d\u80fd\u6709\u7a7a\u683c\uff01");
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
        if (objName == null || StringUtils.isEmpty((String)objName.toString())) {
            MsgBox.showInfo((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.txtName.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[ ]", objName)) {
            MsgBox.showInfo((String)"\u540d\u79f0\u4e2d\u4e0d\u80fd\u6709\u7a7a\u683c\uff01");
            this.txtName.requestFocusInWindow();
            SysUtil.abort();
        }
        this.editData.setNumber(strNumber);
        this.editData.setName(objName.toString());
        ConnectionFactory.getRemoteInstance().checkNumberBlank(this.editData);
        ConnectionFactory.getRemoteInstance().checkNameBlank(this.editData);
        if (OprtState.EDIT.equals(operate)) {
            if (!StringUtils.equals((String)oldNumber, (String)strNumber)) {
                ConnectionFactory.getRemoteInstance().checkNumberDup(this.editData);
            }
            if (!StringUtils.equals((String)oldName, (String)objName.toString())) {
                ConnectionFactory.getRemoteInstance().checkNameDup(this.editData);
            }
        }
        if (OprtState.ADDNEW.equals(operate)) {
            ConnectionFactory.getRemoteInstance().checkNameDup(this.editData);
            ConnectionFactory.getRemoteInstance().checkNumberDup(this.editData);
        }
        if ((ipBuf = new StringBuffer(ipText = this.txtIP.getText())).length() == 0) {
            MsgBox.showInfo((String)"IP\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.txtIP.requestFocusInWindow();
            SysUtil.abort();
        }
        Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        String[] ipArr = ipText.split(",");
        for (int i = 0; i < ipArr.length; ++i) {
            String eachIP = ipArr[i];
            if (StringUtils.isEmpty((String)eachIP)) {
                MsgBox.showInfo((String)"\u975e\u6cd5\u7684ip\u683c\u5f0f\uff01");
                this.txtIP.requestFocusInWindow();
                SysUtil.abort();
                continue;
            }
            Matcher matcher = pattern.matcher(eachIP);
            if (matcher.matches()) continue;
            MsgBox.showInfo((String)"\u975e\u6cd5\u7684ip\u683c\u5f0f\uff01");
            this.txtIP.requestFocusInWindow();
            SysUtil.abort();
        }
        String port = this.txtPort.getText();
        if (StringUtils.isEmpty((String)port)) {
            MsgBox.showInfo((String)"\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.txtPort.requestFocusInWindow();
            SysUtil.abort();
        } else if (StringUtils.equals((String)port, (String)"0")) {
            MsgBox.showInfo((String)"\u7aef\u53e3\u4e0d\u80fd\u4e3a0\uff01");
            this.txtPort.requestFocusInWindow();
            SysUtil.abort();
        }
        String instance = this.txtinstance.getText();
        if (StringUtils.isEmpty((String)instance)) {
            MsgBox.showInfo((String)"\u6570\u636e\u5e93\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.txtinstance.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[\u4e00-\u9fa5]", instance)) {
            MsgBox.showInfo((String)"\u6570\u636e\u5e93\u540d\u79f0\u4e0d\u80fd\u6709\u4e2d\u6587\uff01");
            this.txtinstance.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[ ]", instance)) {
            MsgBox.showInfo((String)"\u6570\u636e\u5e93\u540d\u79f0\u4e2d\u4e0d\u80fd\u6709\u7a7a\u683c\uff01");
            this.txtinstance.requestFocusInWindow();
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)(username = this.txtusername.getText()))) {
            MsgBox.showInfo((String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.txtusername.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[ ]", username)) {
            MsgBox.showInfo((String)"\u7528\u6237\u540d\u4e2d\u4e0d\u80fd\u6709\u7a7a\u683c\uff01");
            this.txtusername.requestFocusInWindow();
            SysUtil.abort();
        }
        char[] pwdChar = this.txtpassword.getPassword();
        StringBuilder builder = new StringBuilder();
        builder.append(pwdChar);
        Arrays.fill((char[])pwdChar, (char)' ');
        if (StringUtils.isEmpty((String)builder.toString()) || builder.toString().length() > 100) {
            MsgBox.showInfo((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\uff01");
            this.txtpassword.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[ ]", builder.toString())) {
            MsgBox.showInfo((String)"\u5bc6\u7801\u4e2d\u4e0d\u80fd\u6709\u7a7a\u683c\uff01");
            this.txtpassword.requestFocusInWindow();
            SysUtil.abort();
        }
        try {
            this.chkMenuItemSubmitAndAddNew.setSelected(false);
            this.editData.setOriginType(false);
            super.actionSubmit_actionPerformed(e);
        }
        catch (Exception ex) {
            Exception cause = ex;
            String errmsg = null;
            errmsg = ex instanceof BOSException ? ThrowableHelper.toString((Throwable)cause) : ExceptionMessageUtility.getMessage((Throwable)ex);
            if (this.getOprtState() == OprtState.EDIT) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u90e8\u5206\u6570\u636e\u4e0d\u80fd\u4fee\u6539\uff0c\u5177\u4f53\u539f\u56e0\u89c1\u8be6\u7ec6\u4fe1\u606f\u3002", (String)errmsg, (int)8188);
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u65b0\u589e\u5931\u8d25\uff0c\u5177\u4f53\u539f\u56e0\u89c1\u8be6\u7ec6\u4fe1\u606f\u3002", (String)errmsg, (int)8188);
        }
    }

    public boolean isContainChar(String reg, String str) {
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(str);
        return m.find();
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        super.doAfterSubmit(pk);
        Map uiContext = this.getUIContext();
        Object obj = uiContext.get("BizWizardEditUiKey");
        if (null != obj && obj instanceof BizWizardEditUI) {
            BizWizardEditUI editUi = (BizWizardEditUI)((Object)obj);
            editUi.setValueAfterSubmit("dbConn", pk.toString());
        }
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    private void setButtonState(boolean enable) {
        this.txtIP.setEditable(enable);
        this.txtinstance.setEditable(enable);
        this.txtPort.setEditable(enable);
        this.DBType.setEnabled(enable);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        boolean state = ConnectionFactory.getRemoteInstance().canModifyConnection(this.editData);
        this.setButtonState(state);
    }
}

