/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapType;
import com.kingdee.eas.csinterface.syncdatabase.client.AbstractMultiToMultiMapImportUI;
import com.kingdee.eas.csinterface.syncdatabase.client.MultiToMultiMapEditUI;
import com.kingdee.eas.csinterface.syncdatabase.datafile.DataFile;
import com.kingdee.eas.csinterface.util.Export2FileUtil;
import com.kingdee.eas.csinterface.util.IOUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class MultiToMultiMapImportUI
extends AbstractMultiToMultiMapImportUI {
    private static final Logger logger = CoreUIObject.getLogger(MultiToMultiMapImportUI.class);
    private MultiToMultiMapType type = null;

    public void onLoad() throws Exception {
        this.btnChoose.setLimitedSize(false);
        this.btnChoose.setSize(27, 21);
        super.onLoad();
        this.templateTipLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MultiToMultiMapImportUI.this.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MultiToMultiMapImportUI.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                MultiToMultiMapImportUI.this.downloadExcelTemplate();
            }
        });
        this.type = (MultiToMultiMapType)((Object)this.getUIContext().get("multiMapType"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadExcelTemplate() {
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            File file = Export2FileUtil.getExportFileWithOverrideTip((Component)((Object)this), "\u57fa\u7840\u8d44\u6599\u7ec4\u5408\u6620\u5c04\u5bfc\u5165\u6a21\u677f", "\u4fdd\u5b58", new String[]{"xls"}, "Excel 1997\u62162003\u7248\u672c", "\u57fa\u7840\u8d44\u6599\u7ec4\u5408\u6620\u5c04\u5bfc\u5165\u6a21\u677f.xls");
            if (null != file) {
                if (MultiToMultiMapType.easAssistAccount.equals((Object)this.type) || MultiToMultiMapType.easAssistAccount.equals((Object)this.type)) {
                    inputStream = DataFile.class.getResourceAsStream("MultiToMultiMapEasAsstImportTemplate.xls");
                } else if (MultiToMultiMapType.easCashFlower.equals((Object)this.type)) {
                    inputStream = DataFile.class.getResourceAsStream("MultiToMultiMapEasCashImportTemplate.xls");
                } else if (MultiToMultiMapType.baseDataMap.equals((Object)this.type)) {
                    inputStream = DataFile.class.getResourceAsStream("MultiToMultiMapBaseDataImportTemplate.xls");
                }
                outputStream = new FileOutputStream(file);
                IOUtils.copy(inputStream, outputStream);
                MsgBox.showInfo((Component)((Object)this), (String)"\u57fa\u7840\u8d44\u6599\u7ec4\u5408\u6620\u5c04\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u6210\u529f\u3002");
            }
        }
        catch (Exception ex) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u57fa\u7840\u8d44\u6599\u7ec4\u5408\u6620\u5c04\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25\u3002", (String)ex.getMessage(), (int)8188);
        }
        finally {
            IOUtils.closeInputStreamQuietly(inputStream);
            IOUtils.closeOutputStreamQuietly(outputStream);
        }
    }

    @Override
    protected void btnChoose_actionPerformed(ActionEvent e) throws Exception {
        File file = Export2FileUtil.getDialogFile((Component)((Object)this), "\u9009\u62e9\u5bfc\u5165\u6587\u4ef6", "\u6253\u5f00", new String[]{"xls"}, "Excel 1997\u62162003\u7248\u672c");
        if (null != file) {
            this.importFilePath.setText(file.getPath());
        } else {
            this.importFilePath.setText(null);
        }
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        String filePath = this.importFilePath.getText();
        if (null == filePath || filePath.trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u5bfc\u5165\u6587\u4ef6\u3002");
            return;
        }
        try {
            this.loadExcelData(filePath);
            this.destroyWindow();
        }
        catch (Exception ex) {
            MsgBox.showInfo((Component)((Object)this), (String)("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\u3002" + ex.getMessage()));
        }
    }

    private void loadExcelData(String filePath) throws Exception {
        Object object = this.getUIContext().get("Owner");
        if (null == object || !(object instanceof MultiToMultiMapEditUI)) {
            throw new Exception("\u627e\u4e0d\u5230\u5f15\u7528\u7684MultiToMultiMapEditUI\u5bf9\u8c61\u3002\u5f00\u53d1\u9519\u8bef\u3002");
        }
        MultiToMultiMapEditUI editUI = (MultiToMultiMapEditUI)((Object)object);
        editUI.loadDataFromExcel(filePath);
    }

    @Override
    protected void exitButton_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

