/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.eas.csinterface.util.FileFilterHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;

public class Export2FileUtil {
    private static File currencyFile = null;

    public static File getExportFileWithOverrideTip(Component parent, String dialogTitle, String approveButtonText, String[] exts, String description, String fileName) {
        File file = Export2FileUtil.getDialogFileWithFileName(parent, dialogTitle, approveButtonText, exts, description, fileName);
        return Export2FileUtil.checkExistFileWithDialog(file);
    }

    public static File getExportFileWithOutsOverrideTip(Component parent, String dialogTitle, String approveButtonText, String[] exts, String description, String fileName) {
        File file = Export2FileUtil.getDialogFileWithDirectoryName(parent, dialogTitle, approveButtonText, exts, description, fileName);
        return Export2FileUtil.checkExistFileWithDialog(file);
    }

    private static File checkExistFileWithDialog(File file) {
        if (null != file && file.exists() && file.isFile()) {
            int result = MsgBox.showConfirm2((String)("\u6587\u4ef6\u3010" + file.getName() + "\u3011\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\u539f\u6587\u4ef6\uff1f"));
            if (0 == result) {
                return file;
            }
            return null;
        }
        return file;
    }

    public static File getDialogFile(Component parent, String dialogTitle, String approveButtonText, String[] exts, String description) {
        return Export2FileUtil.getDialogFileWithFileName(parent, dialogTitle, approveButtonText, exts, description, null);
    }

    public static File getDialogFileWithFileName(Component parent, String dialogTitle, String approveButtonText, String[] exts, String description, String fileName) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        FileFilterHelper filter = new FileFilterHelper(exts, description);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(dialogTitle);
        chooser.setApproveButtonText(approveButtonText);
        chooser.addChoosableFileFilter(filter);
        if (null != fileName) {
            chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), fileName));
        }
        if (currencyFile != null && currencyFile.exists()) {
            chooser.setCurrentDirectory(currencyFile);
        }
        if ((returnVal = chooser.showOpenDialog(parent)) != 0) {
            return null;
        }
        File file = null;
        file = exts != null && exts.length > 0 ? Export2FileUtil.getRealExportPlanFile(chooser.getSelectedFile(), exts[0]) : Export2FileUtil.getRealExportPlanFile(chooser.getSelectedFile(), "plan");
        currencyFile = file;
        return file;
    }

    public static File getDialogFileWithDirectoryName(Component parent, String dialogTitle, String approveButtonText, String[] exts, String description, String fileName) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        FileFilterHelper filter = new FileFilterHelper(exts, description);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(dialogTitle);
        chooser.setApproveButtonText(approveButtonText);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(filter);
        if (null != fileName) {
            chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), fileName));
        }
        if ((returnVal = chooser.showOpenDialog(parent)) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        return file;
    }

    public static File getRealExportPlanFile(File orgFile, String ext) {
        String suffix;
        String fileName = orgFile.getName();
        if (!fileName.endsWith(suffix = "." + ext)) {
            fileName = fileName + suffix;
        }
        File realFile = new File(orgFile.getParent(), fileName);
        return realFile;
    }
}

