/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CustomizedSchemeCollection;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.client.AbstractCustomizedSchemeSelectorUI;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class CustomizedSchemeSelectorUI
extends AbstractCustomizedSchemeSelectorUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomizedSchemeSelectorUI.class);
    public static final String SELECTED_DEPENDS = "selected_depends";
    public boolean isConfirem = false;
    private CustomizedSchemeInfo csInfo;
    private CustomizedSchemeCollection depends;
    private CustomizedSchemeCollection canDepends = new CustomizedSchemeCollection();
    private CustomizedSchemeCollection cannotDepends = new CustomizedSchemeCollection();

    public CustomizedSchemeSelectorUI() throws Exception {
        this.depends = new CustomizedSchemeCollection();
        this.tableList.checkParsed(true);
        this.tableList.getSelectManager().setSelectMode(10);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("InitDataObject");
        if (obj != null && obj instanceof CustomizedSchemeInfo) {
            this.csInfo = (CustomizedSchemeInfo)obj;
        }
        CustomizedSchemeCollection collection = CustomizedSchemeFactory.getRemoteInstance().getCustomizedSchemeCollection();
        this.filterDependCusSchemes(collection);
        int size = this.depends.size();
        for (int i = 0; i < size; ++i) {
            CustomizedSchemeInfo info = this.depends.get(i);
            IRow row = this.tableList.addRow();
            row.setUserObject((Object)info);
            row.getCell(0).setValue((Object)info.getId().toString());
            row.getCell(1).setValue((Object)info.getName());
            row.getCell(2).setValue((Object)info.getAlias());
            row.getCell(3).setValue((Object)info.getDescription());
            if (!"CS_SYSTEM".equalsIgnoreCase(info.getBuildNumber())) continue;
            row.getStyleAttributes().setBackground(new Color(233, 226, 184));
        }
        Object object = this.getUIContext().get(SELECTED_DEPENDS);
        if (object instanceof CustomizedSchemeInfo[]) {
            CustomizedSchemeInfo[] selected = (CustomizedSchemeInfo[])object;
            size = this.tableList.getRowCount();
            block1: for (int i = 0; i < selected.length; ++i) {
                String id = selected[i].getId().toString();
                for (int j = 0; j < size; ++j) {
                    IRow row = this.tableList.getRow(j);
                    if (!id.equals(row.getCell("id").getValue())) continue;
                    row.getStyleAttributes().setBackground(new Color(255, 255, 128));
                    continue block1;
                }
            }
        }
    }

    private void filterDependCusSchemes(CustomizedSchemeCollection collection) {
        if (collection == null) {
            return;
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            CustomizedSchemeCollection cache;
            CustomizedSchemeInfo depend = collection.get(i);
            if (!this.canDepend(depend, cache = new CustomizedSchemeCollection())) continue;
            this.depends.add(depend);
        }
    }

    private boolean canDepend(CustomizedSchemeInfo depend, CustomizedSchemeCollection cache) {
        if (depend == null || this.cannotDepends.contains(depend)) {
            return false;
        }
        if (this.canDepends.contains(depend)) {
            return true;
        }
        if (cache.contains(depend) || this.csInfo != null && this.csInfo.getId().equals((Object)depend.getId())) {
            this.cannotDepends.add(depend);
            return false;
        }
        cache.add(depend);
        String innerDepends = depend.getDepend();
        if (StringUtils.isEmpty((String)innerDepends) || this.depends.contains(depend)) {
            this.canDepends.add(depend);
            return true;
        }
        try {
            ICustomizedScheme ics = CustomizedSchemeFactory.getRemoteInstance();
            for (String id : StringUtils.split((String)innerDepends, (String)";")) {
                if (StringUtils.isEmpty((String)id) || "null".equalsIgnoreCase(id)) continue;
                CustomizedSchemeInfo innerDepend = ics.getCustomizedSchemeInfo("where id= '" + id + "'");
                if (innerDepend == null || this.csInfo != null && this.csInfo.getId().equals((Object)innerDepend.getId())) {
                    this.cannotDepends.add(depend);
                    return false;
                }
                if (this.canDepend(innerDepend, cache)) continue;
                this.cannotDepends.add(depend);
                return false;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.canDepends.add(depend);
        return true;
    }

    public CustomizedSchemeInfo[] getSelectedDepends() {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        CustomizedSchemeInfo[] schemes = new CustomizedSchemeInfo[rowIndex.length];
        for (int i = 0; i < rowIndex.length; ++i) {
            IRow row = this.tableList.getRow(rowIndex[i]);
            if (!(row.getUserObject() instanceof CustomizedSchemeInfo)) continue;
            schemes[i] = (CustomizedSchemeInfo)row.getUserObject();
        }
        return schemes;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirem = true;
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirem = false;
        this.getUIWindow().close();
    }
}

