/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.EPException;
import com.kingdee.eas.ep.client.CustomizedUnitBasePanel;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.EditorSaver;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.ctrl.EditorTabbedPane;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.policy.tab.CommonTabPolicy;
import com.kingdee.eas.ep.client.policy.tab.EditUITabPolicy;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CustomizedUnitEditorPanel
extends CustomizedUnitBasePanel {
    private static final Logger logger = CoreUIObject.getLogger(CustomizedUnitEditorPanel.class);
    protected EditorTabbedPane kDTabbedPane;
    private EditorSaver saver = new EditorSaver();

    public CustomizedUnitEditorPanel(CustomizedUnitUI ui) {
        super(ui);
        this.init();
    }

    protected void init() {
        this.setBounds(new Rectangle(0, 0, 750, 629));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 750, 629));
        this.kDTabbedPane = new EditorTabbedPane();
        this.kDTabbedPane.setBounds(new Rectangle(0, 0, 750, 629));
        this.kDTabbedPane.setCustomizedUnitUI(this.ui);
        this.add((Component)((Object)this.kDTabbedPane), new KDLayout.Constraints(0, 0, 750, 629, 15));
        this.regeistListners();
    }

    private void regeistListners() {
        this.kDTabbedPane.addEditorTabPolicy(new CommonTabPolicy());
        this.kDTabbedPane.addEditorTabPolicy(new EditUITabPolicy());
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomizedUnitEditorPanel.this.ui.btnSave.isEnabled()) {
                    CustomizedUnitEditorPanel.this.doSave();
                }
            }
        };
        ActionMap actionMap = this.getActionMap();
        actionMap.put("CSTLSACTION", actionListener);
        KeyStroke controlAlt7 = KeyStroke.getKeyStroke(83, 2);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(controlAlt7, "CSTLSACTION");
        this.setActionMap(actionMap);
    }

    public void setSelectedComponent(Component comp) {
        this.kDTabbedPane.setSelectedComponent(comp);
    }

    public void setSelectedIndex(int index) {
        this.kDTabbedPane.setSelectedIndex(index);
    }

    public void addSubTabPanel(IEditorTabPanel subPanel, String title, IEditorTabPanel mainPanel) {
        this.addTabPanelNotSave(subPanel, title);
        this.saver.addSubTabPane(mainPanel, subPanel);
    }

    public void addTabPanelNotSave(IEditorTabPanel panel, String title) {
        if (panel instanceof KDPanel) {
            this.kDTabbedPane.add((Component)((KDPanel)panel), title);
        }
    }

    public void addTabPanel(IEditorTabPanel panel, String title) {
        this.addTabPanelNotSave(panel, title);
        this.saver.addTabPane(panel);
    }

    public void addTabPanelNotSave(IEditorTabPanel panel, String title, int index) {
        if (panel instanceof KDPanel) {
            this.kDTabbedPane.add((Component)((KDPanel)panel), title, index);
        }
    }

    public void addTabPanel(IEditorTabPanel panel, String title, int index) {
        this.addTabPanelNotSave(panel, title, index);
        this.saver.addTabPane(panel);
    }

    public String getTitleAt(int index) {
        return this.kDTabbedPane.getTitleAt(index);
    }

    public int getTabCount() {
        return this.kDTabbedPane.getTabCount();
    }

    public IEditorTabPanel[] getTabPanel() {
        ArrayList<Component> list = new ArrayList<Component>();
        Component[] components = this.kDTabbedPane.getComponents();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            if (!(components[i] instanceof IEditorTabPanel)) continue;
            list.add(components[i]);
        }
        IEditorTabPanel[] tabs = new IEditorTabPanel[list.size()];
        list.toArray(tabs);
        return tabs;
    }

    public void removeTabPanel(int index) {
        IEditorTabPanel tab = (IEditorTabPanel)((Object)this.kDTabbedPane.getComponentAt(index));
        try {
            tab.destory();
            this.kDTabbedPane.remove(index);
            this.saver.removeTabPane(tab);
        }
        catch (Exception e) {
            ExceptionHandler.handleError((Component)((Object)this), e, "\u9500\u6bc1\u9875\u7b7e\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    public void removeTabPanelForce(Component comp) {
        try {
            this.kDTabbedPane.remove(comp);
            if (comp instanceof IEditorTabPanel) {
                this.saver.removeTabPane((IEditorTabPanel)((Object)comp));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleError((Component)((Object)this), e, "\u9500\u6bc1\u9875\u7b7e\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    public void removeAllTabPanel() {
        int size = this.kDTabbedPane.getTabCount();
        for (int i = 0; i < size; ++i) {
            IEditorTabPanel tab = (IEditorTabPanel)((Object)this.kDTabbedPane.getComponentAt(0));
            try {
                tab.destory();
                this.kDTabbedPane.remove(0);
            }
            catch (Exception e) {
                ExceptionHandler.handleError((Component)((Object)this), e, "\u9500\u6bc1\u9875\u7b7e\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
            this.saver.removeAll();
        }
    }

    public IEditorTabPanel getActiveTab() {
        int index = this.kDTabbedPane.getSelectedIndex();
        if (index < 0 || index > this.kDTabbedPane.getTabCount() - 1) {
            return null;
        }
        return (IEditorTabPanel)((Object)this.kDTabbedPane.getComponentAt(index));
    }

    public IEditorTabPanel getTabPanel(int index) {
        if (index < 0 || index > this.kDTabbedPane.getTabCount() - 1) {
            return null;
        }
        return (IEditorTabPanel)((Object)this.kDTabbedPane.getComponentAt(index));
    }

    public boolean isDirty() {
        int size = this.kDTabbedPane.getTabCount();
        for (int i = 0; i < size; ++i) {
            IEditorTabPanel tab = (IEditorTabPanel)((Object)this.kDTabbedPane.getComponentAt(i));
            if (!tab.isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean needSave() {
        return this.isDirty() && !this.isSystemScheme();
    }

    public void doSave(int index) {
        this.doSave((IEditorTabPanel)((Object)this.kDTabbedPane.getComponentAt(index)));
    }

    private void doSave(IEditorTabPanel tab) {
        if (tab != null) {
            try {
                this.beforeSave();
                if (this.saver.doSave(tab)) {
                    MsgBox.showInfo((Component)((Object)this.ui), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
                }
            }
            catch (EPException e) {
                ExceptionHandler.handleError((Component)((Object)this), (Exception)((Object)e), e.getMessage());
            }
            catch (BOSException e2) {
                ExceptionHandler.handleError((Component)((Object)this), (Exception)((Object)e2), "\u4fdd\u5b58\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                SysUtil.abort();
            }
            catch (Exception e) {
                ExceptionHandler.handleError((Component)((Object)this), e, "\u4fdd\u5b58\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
        }
    }

    public void doSave() {
        this.doSave(this.getActiveTab());
    }

    public boolean doSaveAll() {
        boolean flag = false;
        try {
            this.beforeSave();
            if (this.saver.doSaveAll()) {
                MsgBox.showInfo((Component)((Object)this.ui), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
                flag = true;
            }
        }
        catch (EPException e) {
            ExceptionHandler.handleError((Component)((Object)this), (Exception)((Object)e), e.getMessage());
        }
        catch (BOSException e2) {
            SysUtil.abort();
        }
        catch (Exception e) {
            ExceptionHandler.handleError((Component)((Object)this), e, "\u4fdd\u5b58\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
        return flag;
    }

    public void beforeSave() throws EPException {
        if (this.isSystemScheme()) {
            throw new EPException(EPException.SYSTEM_SCHEME_NOT_MODIFY);
        }
    }

    private boolean isSystemScheme() {
        try {
            IEditorTabPanel tab = this.getActiveTab();
            String id = tab.getDepends().getId();
            return CustomSchemeUtil.isSystemScheme(id);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isStartScheme() {
        try {
            IEditorTabPanel tab = this.getActiveTab();
            String id = tab.getDepends().getId();
            return CustomSchemeUtil.isStartScheme(id);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }
}

