/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.ScriptDebuggerFacadeFactory;
import com.kingdee.eas.ep.client.AbstractCustomizedUnitUI;
import com.kingdee.eas.ep.client.CustomizedSchemeManagementUI;
import com.kingdee.eas.ep.client.CustomizedUnitEditorPanel;
import com.kingdee.eas.ep.client.CustomizedUnitExplorerPanel;
import com.kingdee.eas.ep.client.CustomizedUnitTreePanel;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.MetaDataDebugUI;
import com.kingdee.eas.ep.client.MetadataCheckUI;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.ep.client.figure.FigureHelper;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.policy.tree.StatusManagerPolicy;
import com.kingdee.eas.ep.plugin.Logger4Script;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.SAXBuilderFactory;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;
import org.jdom2.input.SAXBuilder;

public class CustomizedUnitUI
extends AbstractCustomizedUnitUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomizedUnitUI.class);
    private CustomizedUnitExplorerPanel explorerPanel;
    private CustomizedUnitEditorPanel editorPanel;
    private Process debug = null;
    private String groupId = "";
    private String communityId = "";
    private String domain = "";
    private String token = "";
    private String tokenSecret = "";
    private String configFile = "weiboConfig.xml";
    private static SAXBuilder sb = SAXBuilderFactory.create();

    public void initLayout() {
        super.initLayout();
    }

    public void onLoad() throws Exception {
        this.initUI();
        super.onLoad();
        this.addKeyToMenu((CoreUIObject)this, this.menuFile);
    }

    public void addKeyToMenu(CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift Q"){

            public void action_actionPerformed() {
                String clientName = SysContext.getSysContext().getClientName();
                try {
                    SysContext.getSysContext().setClientName("WEB_Dev_Debug");
                    CustomizedUnitUI.this.btnRefresh_actionPerformed(null);
                }
                catch (Exception e) {
                    SysUtil.abort((Throwable)e);
                }
                finally {
                    SysContext.getSysContext().setClientName(clientName);
                }
            }
        });
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnSave);
        this.toolBar.add((Component)this.btnRefresh);
        this.toolBar.add((Component)this.btnCancel);
        this.toolBar.add((Component)this.btnStart);
        this.toolBar.add((Component)this.btnScheme);
        this.toolBar.add((Component)this.btnPageSetup);
        this.toolBar.add((Component)this.btnScriptDebugger);
        this.toolBar.add((Component)this.btnScriptLogger);
        this.toolBar.add((Component)this.btnMDChecker);
        this.toolBar.add((Component)this.btnMDvalidate);
        this.toolBar.add((Component)this.btnClearDebugger);
    }

    public void onShow() throws Exception {
        KDTree tree;
        super.onShow();
        IUIWindow uiWindow = super.getUIWindow();
        if (uiWindow instanceof JFrame) {
            ((JFrame)uiWindow).setExtendedState(6);
        }
        if ((tree = this.getExplorerPanel().getCustomizedUnitTreePanel().getTree()).getSelectionPath() == null) {
            this.btnMDChecker.setEnabled(false);
            this.btnMDvalidate.setEnabled(false);
        }
    }

    protected void initUI() throws Exception {
        this.setUITitle();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnScheme.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnScriptDebugger.setIcon(EASResource.getIcon((String)"imgTbtn_analyze"));
        this.btnScriptLogger.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnMDChecker.setIcon((Icon)FigureHelper.getImageIcon("designer/search.gif"));
        this.btnKDWeibo.setIcon((Icon)FigureHelper.getImageIcon("designer/weibo.gif"));
        KDMenuItem guiMenuStart = new KDMenuItem("\u542f\u52a8");
        guiMenuStart.setEnabled(true);
        guiMenuStart.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionStartServer), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        guiMenuStart.setText("\u542f\u52a8");
        this.btnScriptDebugger.addAssistMenuItem((JMenuItem)guiMenuStart);
        KDMenuItem guiMenuStop = new KDMenuItem("\u5173\u95ed");
        guiMenuStop.setEnabled(true);
        guiMenuStop.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionStopServer), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        guiMenuStop.setText("\u5173\u95ed");
        this.btnScriptDebugger.addAssistMenuItem((JMenuItem)guiMenuStop);
        KDMenuItem menuEnable = new KDMenuItem("\u542f\u7528");
        menuEnable.setEnabled(true);
        menuEnable.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionEnableLogger), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        menuEnable.setText("\u542f\u7528");
        this.btnScriptLogger.addAssistMenuItem((JMenuItem)menuEnable);
        KDMenuItem menuDisable = new KDMenuItem("\u53cd\u542f\u7528");
        menuDisable.setEnabled(true);
        menuDisable.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionDisableLogger), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        menuDisable.setText("\u53cd\u542f\u7528");
        this.btnScriptLogger.addAssistMenuItem((JMenuItem)menuDisable);
        this.explorerPanel = new CustomizedUnitExplorerPanel(this);
        this.explorerPanel.getCustomizedUnitTreePanel().setSimpleView(this.isStandEdition());
        this.explorerPanel.init();
        this.editorPanel = new CustomizedUnitEditorPanel(this);
        this.mainSplitPane.add((Component)((Object)this.explorerPanel), (Object)"left");
        this.mainSplitPane.add((Component)((Object)this.editorPanel), (Object)"right");
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setUI(new JSplitPane().getUI());
    }

    public CustomizedUnitExplorerPanel getExplorerPanel() {
        return this.explorerPanel;
    }

    public CustomizedUnitEditorPanel getEditorPanel() {
        return this.editorPanel;
    }

    @Override
    protected void btnScheme_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CustomizedSchemeManagementUI.class.getName(), (Map)uiContext);
        CustomizedSchemeManagementUI ui = (CustomizedSchemeManagementUI)uiWindow.getUIObject();
        ui.setCustomizedUnitUI(this);
        uiWindow.getUIObject().setUITitle("\u52a8\u6001\u6269\u5c55\u65b9\u6848\u7ba1\u7406\u5668");
        uiWindow.show();
        KDTree tree = this.getExplorerPanel().getCustomizedUnitTreePanel().getTree();
        if (tree.getSelectionPath() == null) {
            this.btnMDChecker.setEnabled(false);
            this.btnMDvalidate.setEnabled(false);
        } else {
            this.btnMDChecker.setEnabled(true);
            this.btnMDvalidate.setEnabled(true);
        }
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        this.editorPanel.doSave();
    }

    @Override
    public void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        CustomizedUnitTreePanel treePanel = this.getExplorerPanel().getCustomizedUnitTreePanel();
        treePanel.refresh(3);
        IEditorTabPanel tab = this.getEditorPanel().getActiveTab();
        if (tab != null) {
            tab.loadData();
        }
        StatusManagerPolicy policy = new StatusManagerPolicy(this, treePanel.getTree());
        policy.resetStatus();
    }

    @Override
    protected void btnMDChecker_actionPerformed(ActionEvent e) throws Exception {
        KDTree tree = this.getExplorerPanel().getCustomizedUnitTreePanel().getTree();
        Object node = tree.getSelectionPath().getLastPathComponent();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selected node", node);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MetaDataDebugUI.class.getName(), (Map)uiContext);
        MetaDataDebugUI ui = (MetaDataDebugUI)uiWindow.getUIObject();
        uiWindow.show();
    }

    @Override
    public void actionStartServer_actionPerformed(ActionEvent e) throws Exception {
        int p = 10080;
        String port = System.getProperty("SCRIPT_DEBUG_PORT");
        if (!StringUtils.isEmpty((String)port)) {
            p = Integer.parseInt(port);
        }
        try {
            ScriptDebuggerFacadeFactory.getRemoteInstance().startDebugServer(p);
        }
        catch (BOSException de) {
            logger.error((Object)("script debug server start fail. Port:" + p), (Throwable)de);
            p = 10088;
            logger.info((Object)("try start standby debug server.Port:" + p));
            try {
                ScriptDebuggerFacadeFactory.getRemoteInstance().startDebugServer(p);
            }
            catch (BOSException be) {
                logger.error((Object)("standby debug server start fail. Port:" + p), (Throwable)be);
                MsgBox.showInfo((String)"\u811a\u672c\u8fdc\u7a0b\u8c03\u8bd5\u542f\u52a8\u5931\u8d25\uff0c\u8be6\u7ec6\u4fe1\u606f\u89c1\u65e5\u5fd7\uff01");
                return;
            }
        }
        this.startDebugClient(p);
    }

    private void startDebugClient(int port) throws Exception {
        if (this.debug != null) {
            return;
        }
        String eas_home = System.getProperty("EAS_HOME");
        String bat = eas_home + "/client/bin/scriptDebugClient.bat";
        this.debug = Runtime.getRuntime().exec("cmd.exe /c start " + bat + " " + this.getURL() + " " + port);
    }

    private String getURL() {
        String url = null;
        if (System.getProperty("EAS_SERVER") != null) {
            url = System.getProperty("EAS_SERVER");
        } else {
            try {
                Class<?> c = Class.forName("com.kingdee.eas.base.uiframe.client.UIConfig");
                Method m = c.getMethod("getUrl", null);
                url = (String)m.invoke(null, null);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        if (url == null) {
            return "127.0.0.1";
        }
        url = url.substring(url.indexOf("//") + 2, url.lastIndexOf(":"));
        return url;
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.debug != null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u811a\u672c\u8fdc\u7a0b\u8c03\u8bd5\u672a\u5173\u95ed\uff01");
            return false;
        }
        return super.checkBeforeWindowClosing();
    }

    @Override
    public void actionStopServer_actionPerformed(ActionEvent e) throws Exception {
        if (this.debug != null) {
            this.debug.destroy();
            this.debug = null;
        }
        ScriptDebuggerFacadeFactory.getRemoteInstance().stopDebugServer();
        MsgBox.showInfo((String)"\u811a\u672c\u8fdc\u7a0b\u8c03\u8bd5\u5df2\u5173\u95ed\uff01");
    }

    @Override
    public void actionDisableLogger_actionPerformed(ActionEvent e) throws Exception {
        Logger4Script.disableLog();
        ScriptDebuggerFacadeFactory.getRemoteInstance().disableLogger();
        MsgBox.showInfo((String)"\u65e5\u5fd7\u8bb0\u5f55\u53cd\u542f\u7528\u5b8c\u6210\uff01");
    }

    @Override
    public void actionEnableLogger_actionPerformed(ActionEvent e) throws Exception {
        Logger4Script.enableLog();
        ScriptDebuggerFacadeFactory.getRemoteInstance().enableLogger();
        MsgBox.showInfo((String)"\u65e5\u5fd7\u8bb0\u5f55\u542f\u7528\u5b8c\u6210\uff01");
    }

    @Override
    protected void btnMDvalidate_actionPerformed(ActionEvent e) throws Exception {
        KDTree tree = this.getExplorerPanel().getCustomizedUnitTreePanel().getTree();
        Object node = tree.getSelectionPath().getLastPathComponent();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selected node", node);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MetadataCheckUI.class.getName(), (Map)uiContext);
        MetadataCheckUI ui = (MetadataCheckUI)uiWindow.getUIObject();
        uiWindow.show();
    }

    @Override
    public void actionClearDebugger_actionPerformed(ActionEvent e) throws Exception {
        ScriptDebuggerFacadeFactory.getRemoteInstance().clearDebugger();
        MsgBox.showInfo((Component)((Object)this), (String)"\u811a\u672c\u8c03\u8bd5\u4fe1\u606f\u6e05\u9664\u5b8c\u6210\uff01");
    }

    public KDWorkButton getbtnStart() {
        return this.btnStart;
    }

    public KDWorkButton getbtnCancel() {
        return this.btnCancel;
    }

    public KDWorkButton getbtnSave() {
        return this.btnSave;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        CustomizedUnitTreeNode node = this.explorerPanel.getCustomizedUnitTreePanel().getSelectedTreeNode();
        if (node != null && !StringUtils.isEmpty((String)node.getCustomizedSchemeID())) {
            try {
                CustomSchemeUtil.disableScheme(node.getCustomizedSchemeID());
                this.btnStart.setVisible(true);
                this.btnCancel.setVisible(false);
                this.btnSave.setEnabled(true);
                this.btnSave.setToolTipText("\u4fdd\u5b58");
            }
            catch (Exception ex) {
                MsgBox.showInfo((String)("\u53cd\u542f\u7528\u65b9\u6848\u5931\u8d25  " + ex.getMessage()));
            }
        }
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        CustomizedUnitTreeNode node = this.explorerPanel.getCustomizedUnitTreePanel().getSelectedTreeNode();
        if (node != null && !StringUtils.isEmpty((String)node.getCustomizedSchemeID())) {
            try {
                CustomSchemeUtil.enableScheme(node.getCustomizedSchemeID());
                this.btnStart.setVisible(false);
                this.btnCancel.setVisible(true);
                this.btnSave.setEnabled(false);
                this.btnSave.setToolTipText("\u53cd\u542f\u7528\u65b9\u6848\u540e\u4fdd\u5b58");
            }
            catch (Exception ex) {
                MsgBox.showInfo((String)("\u542f\u7528\u65b9\u6848\u5931\u8d25  " + ex.getMessage()));
            }
        }
    }

    public boolean destroyWindow() {
        if (this.editorPanel.isDirty()) {
            int result = MsgBox.showConfirm3((Component)((Object)this.editorPanel), (String)"\u6570\u636e\u8fd8\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u8fdb\u884c\u4fdd\u5b58\uff1f");
            if (0 == result) {
                try {
                    this.editorPanel.doSaveAll();
                }
                catch (Exception e) {
                    ExceptionHandler.handleError((Component)((Object)this), e, "\u4fdd\u5b58\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                    return false;
                }
            } else if (1 != result && 2 == result) {
                SysUtil.abort();
            }
        }
        return super.destroyWindow();
    }

    public void setUITitle() {
    }

    public boolean isStandEdition() {
        return false;
    }

    @Override
    protected void btnKDWeibo_actionPerformed(ActionEvent e) throws Exception {
        super.btnKDWeibo_actionPerformed(e);
        String url = "http://club.kisdee.com/forum.php?mod=forumdisplay&fid=832";
        FrameWorkUtils.openByDefaultBrowser((String)url);
    }
}

