/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.eas.ep.client.DebugCallback;
import com.kingdee.eas.ep.client.DebugWindow;
import com.kingdee.eas.ep.client.DebuggerEvent;
import com.kingdee.eas.ep.client.EvaluatorUI;
import com.kingdee.eas.ep.client.ScriptUI;
import com.kingdee.eas.ep.client.UIParam;
import com.kingdee.eas.ep.debug.Dim;
import com.kingdee.eas.ep.debug.ScopeProviderProxy;
import com.kingdee.eas.ep.plugin.ExtendMethodInfo;
import javax.swing.SwingUtilities;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class DebugSkeleton {
    private DebugWindow window;
    private final Dim dim;
    private final ImporterTopLevel global;
    private final UIParam param;
    private final ExtendMethodInfo mInfo;
    private volatile Throwable exception = null;

    DebugSkeleton(DebugWindow window, UIParam param, ExtendMethodInfo mInfo) {
        this.window = window;
        this.param = param;
        this.mInfo = mInfo;
        ScriptUI scriptUI = new ScriptUI();
        this.dim = new Dim(0);
        this.dim.setGuiCallback(scriptUI);
        this.dim.setBreak();
        window.debuggerEventPerformed(new DebuggerEvent(this.dim, scriptUI));
        EvaluatorUI evaluatorUI = new EvaluatorUI();
        evaluatorUI.setDebugger(new DebugCallback(){

            @Override
            public String eval(String expr) {
                return DebugSkeleton.this.dim.eval(expr);
            }

            @Override
            public boolean stringIsCompilableUnit(String str) {
                return DebugSkeleton.this.dim.stringIsCompilableUnit(str);
            }
        });
        window.addScriptUI(scriptUI, evaluatorUI);
        ContextFactory ctxFactory = ContextFactory.getGlobal();
        this.dim.attachTo(ctxFactory);
        this.global = new ImporterTopLevel();
        ctxFactory.call(new ContextAction(){

            public Object run(Context cx) {
                DebugSkeleton.this.global.initStandardObjects(cx, false);
                DebugSkeleton.this.global.put("pluginCtx", (Scriptable)DebugSkeleton.this.global, (Object)DebugSkeleton.this.param);
                DebugSkeleton.this.global.put("methodCtx", (Scriptable)DebugSkeleton.this.global, (Object)DebugSkeleton.this.mInfo);
                return null;
            }
        });
        this.dim.setScopeProvider(ScopeProviderProxy.newScopeProvider((Scriptable)this.global));
    }

    public void debug(final String script) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugSkeleton.this.exception = null;
                try {
                    DebugSkeleton.this.dim.call(new ContextAction(){

                        public Object run(Context cx) {
                            Object result = cx.evaluateString((Scriptable)DebugSkeleton.this.global, script, null, 1, null);
                            return result;
                        }
                    });
                }
                catch (Throwable e) {
                    DebugSkeleton.this.exception = e;
                }
                finally {
                    DebugSkeleton.this.window.close();
                    DebugSkeleton.this.dim.dispose();
                }
            }
        });
        this.window.open();
    }

    public Throwable getDebugException() {
        return this.exception;
    }
}

