/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.eas.ep.client.ScriptArea;
import com.kingdee.eas.ep.client.ScriptUI;
import com.kingdee.eas.ep.client.ScriptWindow;
import com.kingdee.eas.ep.debug.IDebugger;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DebuggerEvent {
    private ScriptArea area;
    private ScriptWindow window;
    private ScriptUI ui;
    private IDebugger dim;

    DebuggerEvent(IDebugger dim, ScriptUI ui) {
        this.dim = dim;
        this.ui = ui;
        this.window = ui.scriptWindow;
        this.area = this.window.textArea;
    }

    public void register() {
        new ScriptAreaPerformed().register();
    }

    public void setBreak() {
        this.dim.setBreak();
    }

    public void go() {
        this.dim.setReturnValue(3);
    }

    public void stepInto() {
        this.dim.setReturnValue(1);
    }

    public void stepOut() {
        this.dim.setReturnValue(2);
    }

    public void stepOver() {
        this.dim.setReturnValue(0);
    }

    private class ScriptAreaPerformed
    implements ActionListener,
    PopupMenuListener,
    KeyListener,
    MouseListener {
        private PopupMenu popup;

        private ScriptAreaPerformed() {
        }

        void register() {
            this.popup = new PopupMenu();
            this.popup.addPopupMenuListener(this);
            DebuggerEvent.this.area.addMouseListener(this);
            DebuggerEvent.this.area.addKeyListener(this);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show((JComponent)((Object)DebuggerEvent.this.area), e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
            DebuggerEvent.this.area.requestFocus();
            DebuggerEvent.this.area.getCaret().setVisible(true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos = DebuggerEvent.this.area.viewToModel(new Point(this.popup.x, this.popup.y));
            this.popup.setVisible(false);
            String cmd = e.getActionCommand();
            int line = -1;
            try {
                line = DebuggerEvent.this.area.getLineOfOffset(pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cmd.equals("Set Breakpoint")) {
                DebuggerEvent.this.window.setBreakPoint(line + 1);
            } else if (cmd.equals("Clear Breakpoint")) {
                DebuggerEvent.this.window.clearBreakPoint(line + 1);
            } else if (cmd.equals("Run")) {
                DebuggerEvent.this.dim.setReturnValue(3);
            } else if (cmd.equals("Step")) {
                DebuggerEvent.this.dim.setReturnValue(1);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 8: 
                case 9: 
                case 10: 
                case 127: {
                    e.consume();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        class PopupMenu
        extends JPopupMenu {
            private static final long serialVersionUID = 3589525009546013565L;
            int x;
            int y;

            public PopupMenu() {
                JMenuItem item = new JMenuItem("Set Breakpoint");
                this.add(item);
                item.addActionListener(ScriptAreaPerformed.this);
                item = new JMenuItem("Clear Breakpoint");
                this.add(item);
                item.addActionListener(ScriptAreaPerformed.this);
                item = new JMenuItem("Run");
                this.add(item);
                item.addActionListener(ScriptAreaPerformed.this);
                item = new JMenuItem("Step");
                this.add(item);
                item.addActionListener(ScriptAreaPerformed.this);
            }

            public void show(JComponent comp, int x, int y) {
                this.x = x;
                this.y = y;
                super.show(comp, x, y);
            }
        }
    }
}

