/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.AbstractDownFromSharePlatformUI;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class DownFromSharePlatformUI
extends AbstractDownFromSharePlatformUI {
    private static final Logger logger = CoreUIObject.getLogger(DownFromSharePlatformUI.class);
    protected String EXIT_STATUS = null;
    public static final String ROOTURL = "rootUrl";
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    public static final String SCRIPTID = "dep.script";
    public static final String SCHEMEID = "dep.scheme";
    private String rootUrl = "";
    private String fileName = "";
    private String resourceID;
    private List resourceList = new ArrayList();
    private String[] contentsArr;
    private List libScriptTreeList;
    private String url = "";
    public File file;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOk.setEnabled(false);
        Map uiContext = this.getUIContext();
        Object obj = uiContext.get(ROOTURL);
        if (obj != null && obj instanceof String) {
            this.rootUrl = obj.toString();
        }
        this.buildTree();
    }

    private void buildTree() {
        DefaultKingdeeTreeNode rootNode = null;
        if (this.rootUrl.indexOf(SCRIPTID) > -1) {
            this.resourceID = SCRIPTID;
            rootNode = new DefaultKingdeeTreeNode((Object)"dep\u811a\u672c");
        } else if (this.rootUrl.indexOf(SCHEMEID) > -1) {
            this.resourceID = SCHEMEID;
            rootNode = new DefaultKingdeeTreeNode((Object)"\u52a8\u6001\u6269\u5c55\u65b9\u6848");
            this.kDLabel1.setText("\u8bf7\u9009\u62e9\u8981\u5bfc\u5165\u7684\u65b9\u6848");
        }
        ((DefaultTreeModel)this.tree.getModel()).setRoot((TreeNode)rootNode);
        if (this.resourceList.size() <= 0) {
            this.resourceList = this.getFile(this.resourceID);
        }
        if (this.resourceList.size() <= 0) {
            return;
        }
        int j = this.resourceList.size();
        for (int i = 0; i < j; ++i) {
            List fileList = (List)this.resourceList.get(i);
            DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)fileList);
            if (fileList.get(0) != null && !StringUtils.isEmpty((String)fileList.get(0).toString())) {
                treeNode.setText(fileList.get(0).toString());
            }
            this.tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)rootNode, i);
        }
        this.tree.expandAllNodes(true, (TreeNode)rootNode);
    }

    public List getFile(String resourceID) {
        ArrayList resourceList = new ArrayList();
        try {
            URL depUrl = new URL("http://web20.kingdee.com/app/rest/resource/" + resourceID + "/0");
            SAXBuilder wfbuilder = new SAXBuilder();
            Document depDoc = wfbuilder.build(depUrl);
            Element deproot = depDoc.getRootElement();
            List files = deproot.getChildren();
            for (int k = 0; k < files.size(); ++k) {
                ArrayList<String> fileList = new ArrayList<String>();
                Element file = (Element)files.get(k);
                String fileName = file.getAttributeValue("filename");
                String fileUri = "http://web20.kingdee.com" + file.getAttributeValue("uri");
                String fileDesc = file.getAttributeValue("desc");
                fileList.add(fileName);
                fileList.add(fileDesc);
                fileList.add(fileUri);
                resourceList.add(fileList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"DownFromSharePlatformUI.getResourceMap", (Throwable)e);
        }
        return resourceList;
    }

    @Override
    protected void tree_mouseClicked(MouseEvent e) throws Exception {
        super.tree_mouseClicked(e);
        if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && !StringUtils.isEmpty((String)this.fileName)) {
            this.doImport();
            this.EXIT_STATUS = CONFIRM_EXIT;
            this.disposeUIWindow();
        }
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.tree_valueChanged(e);
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
            if (treeNode.getUserObject() instanceof List) {
                this.btnOk.setEnabled(true);
                this.fileName = treeNode.getText();
                Object des = ((List)treeNode.getUserObject()).get(1);
                Object fileUrl = ((List)treeNode.getUserObject()).get(2);
                this.txtDes.setText(des == null ? "\u65e0\u63cf\u8ff0" : des.toString());
                this.url = fileUrl == null ? "" : fileUrl.toString();
            } else {
                this.btnOk.setEnabled(false);
                this.fileName = "";
                this.txtDes.setText("");
                this.url = "";
            }
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.doImport();
        this.disposeUIWindow();
    }

    @Override
    protected void btnCance_actionPerformed(ActionEvent e) throws Exception {
        super.btnCance_actionPerformed(e);
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImport() throws IOException {
        block18: {
            BufferedReader reader = null;
            StringBuffer buffer = null;
            try {
                if (StringUtils.isEmpty((String)this.url)) {
                    return;
                }
                String temp = "";
                boolean isTreeInfo = true;
                URL actionUrl = new URL(this.url);
                URLConnection uc = actionUrl.openConnection();
                InputStream in = uc.getInputStream();
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                buffer = new StringBuffer();
                if (SCRIPTID.equals(this.resourceID)) {
                    this.libScriptTreeList = new ArrayList();
                    while ((temp = reader.readLine()) != null) {
                        buffer.append(temp);
                        buffer.append("\n");
                        if (temp.startsWith("treeLongNumber:") && isTreeInfo) {
                            isTreeInfo = false;
                        }
                        if (!isTreeInfo || StringUtils.isEmpty((String)temp)) continue;
                        this.libScriptTreeList.add(temp);
                    }
                    String xml = buffer.toString();
                    this.dealfnXml(xml);
                    break block18;
                }
                if (!SCHEMEID.equals(this.resourceID)) break block18;
                ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
                byte[] buff = new byte[1024];
                int rc = 0;
                while ((rc = in.read(buff, 0, 1024)) > 0) {
                    swapStream.write(buff, 0, rc);
                }
                String fileRoot = File.listRoots()[0].getPath();
                this.file = new File(StringUtils.split((String)fileRoot, (String)":")[0].toString() + "://depScheme");
                if (!this.file.exists()) {
                    this.file.mkdir();
                }
                if (!this.fileName.endsWith(".jar")) {
                    this.fileName = this.fileName + ".jar";
                }
                String fname = this.file.getAbsolutePath() + "\\" + this.fileName;
                this.file = new File(fname);
                BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(this.file));
                try {
                    outStream.write(swapStream.toByteArray());
                }
                finally {
                    outStream.flush();
                    outStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (buffer != null) {
                    buffer.setLength(0);
                    buffer = null;
                }
            }
        }
    }

    private void dealfnXml(String xml) {
        String[] fnArr = xml.split("treeLongNumber:");
        this.contentsArr = new String[fnArr.length - 1];
        String note = "";
        int j = fnArr.length;
        for (int i = 1; i < j; ++i) {
            String content = fnArr[i].toString();
            this.contentsArr[i - 1] = "treeLongNumber:" + fnArr[i].toString();
        }
    }

    private void dealfnXml1(String xml) {
        String[] fnArr = xml.split("function");
        ArrayList<String> contentsList = new ArrayList<String>();
        contentsList.add(fnArr[0]);
        boolean isWhole = true;
        int j = fnArr.length;
        for (int i = 1; i < j; ++i) {
            String content = fnArr[i];
            int ulen = content.split("\\{").length;
            int llen = content.split("\\}").length;
            if (isWhole) {
                if (i != 1) {
                    contentsList.add("function" + content);
                } else {
                    contentsList.set(0, fnArr[0] + "function" + content);
                }
                if (ulen == llen) continue;
                isWhole = false;
                continue;
            }
            contentsList.set(contentsList.size() - 1, contentsList.get(contentsList.size() - 1) + "function" + content);
            if (ulen == llen) continue;
            isWhole = true;
        }
        this.contentsArr = new String[contentsList.size()];
        String note = "";
        int n = contentsList.size();
        for (int m = 0; m < n; ++m) {
            String content = contentsList.get(m).toString();
            this.contentsArr[m] = note + content.substring(0, content.lastIndexOf("}") + 2);
            note = content.substring(content.lastIndexOf("}") + 2);
        }
    }

    public String[] getContentsArr() {
        return this.contentsArr;
    }

    public List getLibScriptTreeList() {
        return this.libScriptTreeList;
    }

    public String getFileName() {
        return this.fileName;
    }

    public File getFile() {
        return this.file;
    }
}

