/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.eas.ep.client.DebugCallback;
import com.kingdee.eas.ep.client.PagePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.apache.log4j.Logger;

public class EvaluatorUI
extends PagePanel {
    private JTabbedPane tabs;
    private MyTableModel tableModel;
    private Evaluator evaluator = new Evaluator();
    private EvalTextArea cmdLine;
    private DebugCallback debugger = null;
    private static final Logger logger = Logger.getLogger(EvaluatorUI.class);

    EvaluatorUI() {
        this.evaluator.setAutoResizeMode(4);
        this.tableModel = this.evaluator.tableModel;
        KDScrollPane jsp = new KDScrollPane((Component)this.evaluator);
        this.cmdLine = new EvalTextArea();
        this.tabs = new JTabbedPane(3);
        this.tabs.add("\u67e5\u770b", (Component)jsp);
        this.tabs.add("\u663e\u793a", (Component)new KDScrollPane((Component)this.cmdLine));
        this.tabs.setPreferredSize(new Dimension(500, 300));
        this.setBounds(new Rectangle(0, 0, 500, 300));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 500, 300));
        this.add(this.tabs, new KDLayout.Constraints(0, 0, 500, 300, 15));
        this.doLayout();
    }

    void setDebugger(DebugCallback debugger) {
        this.debugger = debugger;
    }

    class EvalTextArea
    extends JTextArea
    implements KeyListener,
    DocumentListener {
        private static final long serialVersionUID = -3918033649601064194L;
        private List history = Collections.synchronizedList(new ArrayList());
        private int historyIndex = -1;
        private int outputMark;

        public EvalTextArea() {
            Document doc = this.getDocument();
            doc.addDocumentListener(this);
            this.addKeyListener(this);
            this.setLineWrap(true);
            this.setFont(new Font("Monospaced", 0, 12));
            this.append("% ");
            this.outputMark = doc.getLength();
        }

        @Override
        public void select(int start, int end) {
            super.select(start, end);
        }

        private synchronized void returnPressed() {
            Document doc = this.getDocument();
            int len = doc.getLength();
            Segment segment = new Segment();
            try {
                doc.getText(this.outputMark, len - this.outputMark, segment);
            }
            catch (BadLocationException ignored) {
                logger.error((Object)"EvaluatorUI.EvalTextArea.returnPressed", (Throwable)ignored);
            }
            String text = segment.toString();
            if (EvaluatorUI.this.debugger.stringIsCompilableUnit(text)) {
                if (text.trim().length() > 0) {
                    this.history.add(text);
                    this.historyIndex = this.history.size();
                }
                this.append("\n");
                String result = EvaluatorUI.this.debugger.eval(text);
                if (result.length() > 0) {
                    this.append(result);
                    this.append("\n");
                }
                this.append("% ");
                this.outputMark = doc.getLength();
            } else {
                this.append("\n");
            }
        }

        public synchronized void write(String str) {
            this.insert(str, this.outputMark);
            int len = str.length();
            this.outputMark += len;
            this.select(this.outputMark, this.outputMark);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 8 || code == 37) {
                if (this.outputMark == this.getCaretPosition()) {
                    e.consume();
                }
            } else if (code == 36) {
                int caretPos = this.getCaretPosition();
                if (caretPos == this.outputMark) {
                    e.consume();
                } else if (caretPos > this.outputMark && !e.isControlDown()) {
                    if (e.isShiftDown()) {
                        this.moveCaretPosition(this.outputMark);
                    } else {
                        this.setCaretPosition(this.outputMark);
                    }
                    e.consume();
                }
            } else if (code == 10) {
                this.returnPressed();
                e.consume();
            } else if (code == 38) {
                --this.historyIndex;
                if (this.historyIndex >= 0) {
                    if (this.historyIndex >= this.history.size()) {
                        this.historyIndex = this.history.size() - 1;
                    }
                    if (this.historyIndex >= 0) {
                        String str = (String)this.history.get(this.historyIndex);
                        int len = this.getDocument().getLength();
                        this.replaceRange(str, this.outputMark, len);
                        int caretPos = this.outputMark + str.length();
                        this.select(caretPos, caretPos);
                    } else {
                        ++this.historyIndex;
                    }
                } else {
                    ++this.historyIndex;
                }
                e.consume();
            } else if (code == 40) {
                int caretPos = this.outputMark;
                if (this.history.size() > 0) {
                    ++this.historyIndex;
                    if (this.historyIndex < 0) {
                        this.historyIndex = 0;
                    }
                    int len = this.getDocument().getLength();
                    if (this.historyIndex < this.history.size()) {
                        String str = (String)this.history.get(this.historyIndex);
                        this.replaceRange(str, this.outputMark, len);
                        caretPos = this.outputMark + str.length();
                    } else {
                        this.historyIndex = this.history.size();
                        this.replaceRange("", this.outputMark, len);
                    }
                }
                this.select(caretPos, caretPos);
                e.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char keyChar = e.getKeyChar();
            if (keyChar == '\b') {
                if (this.outputMark == this.getCaretPosition()) {
                    e.consume();
                }
            } else if (this.getCaretPosition() < this.outputMark) {
                this.setCaretPosition(this.outputMark);
            }
        }

        @Override
        public synchronized void keyReleased(KeyEvent e) {
        }

        @Override
        public synchronized void insertUpdate(DocumentEvent e) {
            int len = e.getLength();
            int off = e.getOffset();
            if (this.outputMark > off) {
                this.outputMark += len;
            }
        }

        @Override
        public synchronized void removeUpdate(DocumentEvent e) {
            int len = e.getLength();
            int off = e.getOffset();
            if (this.outputMark > off) {
                this.outputMark = this.outputMark >= off + len ? (this.outputMark -= len) : off;
            }
        }

        public synchronized void postUpdateUI() {
            this.setCaret(this.getCaret());
            this.select(this.outputMark, this.outputMark);
        }

        @Override
        public synchronized void changedUpdate(DocumentEvent e) {
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2971618907207577000L;
        private List expressions = Collections.synchronizedList(new ArrayList());
        private List values = Collections.synchronizedList(new ArrayList());

        public MyTableModel() {
            this.expressions.add("");
            this.values.add("");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.expressions.size();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "\u53d8\u91cf";
                }
                case 1: {
                    return "\u503c";
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.expressions.get(row);
                }
                case 1: {
                    return this.values.get(row);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            switch (column) {
                case 0: {
                    String expr = value.toString();
                    this.expressions.set(row, expr);
                    String result = "";
                    if (expr.length() > 0 && (result = EvaluatorUI.this.debugger.eval(expr)) == null) {
                        result = "";
                    }
                    this.values.set(row, result);
                    this.updateModel();
                    if (row + 1 != this.expressions.size()) break;
                    this.expressions.add("");
                    this.values.add("");
                    this.fireTableRowsInserted(row + 1, row + 1);
                    break;
                }
                case 1: {
                    this.fireTableDataChanged();
                }
            }
        }

        void updateModel() {
            for (int i = 0; i < this.expressions.size(); ++i) {
                String expr = (String)this.expressions.get(i);
                String result = "";
                if (expr.length() > 0) {
                    result = EvaluatorUI.this.debugger.eval(expr);
                    if (result == null) {
                        result = "";
                    }
                } else {
                    result = "";
                }
                result = result.replace('\n', ' ');
                this.values.set(i, result);
            }
            this.fireTableDataChanged();
        }
    }

    class Evaluator
    extends JTable {
        private static final long serialVersionUID = 8133672432982594256L;
        MyTableModel tableModel;

        public Evaluator() {
            super(new MyTableModel());
            this.tableModel = (MyTableModel)this.getModel();
        }
    }
}

