/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodCollection;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.event.FormalParameterCollection;
import com.kingdee.bos.metadata.event.FormalParameterInfo;
import com.kingdee.bos.metadata.event.ParameterMappingCollection;
import com.kingdee.bos.metadata.event.ParameterMappingInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.AbstractEventDefinitionUI;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.MethodListUI;
import com.kingdee.eas.ep.client.SimpleMetaDataSelector;
import com.kingdee.eas.ep.client.util.DataTransUtils;
import com.kingdee.eas.ep.client.util.EditorCreator;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.plugin.PluginUtils;
import com.kingdee.eas.ep.util.EPUtils;
import com.kingdee.eas.tools.datatask.client.SimpleValueObjectInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class EventDefinitionUI
extends AbstractEventDefinitionUI
implements IEditorTabPanel {
    private static final Logger logger = CoreUIObject.getLogger(EventDefinitionUI.class);
    private String customizedSchemeID;
    private Project depend;
    private EntityObjectInfo meta;
    private EventInfo currEvent = null;
    private int index = 0;
    private boolean isDirty = false;
    private MethodInfo currentMethodInfo = null;

    public EventDefinitionUI(EntityObjectInfo meta, Project depend, String customizedSchemeID) throws Exception {
        this.meta = meta;
        this.depend = depend;
        this.customizedSchemeID = customizedSchemeID;
        this.init();
    }

    void init() {
        this.btnAddEvent.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDelEvent.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnAddParam.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelParam.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnImpMethod.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelMethod.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.tblEParam.checkParsed();
        this.tblMParam.checkParsed();
        this.tblMParam.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMParam.getColumn("alias").getStyleAttributes().setLocked(true);
        this.tblMParam.getColumn("type").getStyleAttributes().setLocked(true);
        this.tblMParam.getColumn("description").getStyleAttributes().setLocked(true);
        this.lstEvents.setSelectionMode(0);
        this.lstEvents.setCellRenderer((ListCellRenderer)((Object)new EventsListRenderer()));
        this.lstMethods.setSelectionMode(0);
        KDBizPromptBox prmtEntity = new KDBizPromptBox();
        prmtEntity.setSelector((KDPromptSelector)new SimpleMetaDataSelector((IUIObject)this, "bizentity", this.depend));
        prmtEntity.setEditable(false);
        this.tblEParam.getColumn("entity").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtEntity));
        this.tblEParam.getColumn("type").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getDataTypeEditor(null)));
        this.txtName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                EventDefinitionUI.this.isValidateName();
            }
        });
        this.txtName.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                EventDefinitionUI.this.isValidateName();
            }
        });
        this.txtAlias.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                EventDefinitionUI.this.isValidateAlias();
            }
        });
        this.txtAlias.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                EventDefinitionUI.this.isValidateAlias();
            }
        });
        this.tblEParam.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    Object value;
                    if (EventDefinitionUI.this.tblEParam.getColumnIndex("type") == e.getColIndex()) {
                        EventDefinitionUI.this.tblEParam.getCell(e.getRowIndex(), "entity").setValue(null);
                        value = e.getValue();
                        EventDefinitionUI.this.tblEParam.getCell(e.getRowIndex(), "entity").getStyleAttributes().setLocked(!"ObjectValue".equals(value) && !"ObjectCollection".equals(value));
                    } else if (EventDefinitionUI.this.tblEParam.getColumnIndex("name") == e.getColIndex() && !StringUtils.isJavaIdentifier((String)(value = (String)e.getValue()))) {
                        MsgBox.showInfo((String)"\u53c2\u6570\u540d\u4e0d\u7b26\u5408\u89c4\u8303");
                        EventDefinitionUI.this.tblEParam.getCell(e.getRowIndex(), "name").setValue(null);
                        return;
                    }
                    IRow row = EventDefinitionUI.this.tblEParam.getRow(e.getRowIndex());
                    EventDefinitionUI.this.storeEventParam(row);
                    EventDefinitionUI.this.tblMParam.getColumn("eventParam").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EventDefinitionUI.this.getFMEditor(EventDefinitionUI.this.currEvent.getFormalParameters())));
                }
                catch (Exception exc) {
                    EventDefinitionUI.this.handUIException(exc);
                }
            }
        });
        this.lstEvents.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EventDefinitionUI.this.storeEvent(EventDefinitionUI.this.currEvent);
                EventDefinitionUI.this.currEvent = (EventInfo)EventDefinitionUI.this.lstEvents.getSelectedValue();
                if (EventDefinitionUI.this.currEvent != null) {
                    EventDefinitionUI.this.btnAddParam.setEnabled(true);
                    EventDefinitionUI.this.btnDelParam.setEnabled(true);
                    EventDefinitionUI.this.btnUp.setEnabled(true);
                    EventDefinitionUI.this.btnDown.setEnabled(true);
                } else if (EventDefinitionUI.this.currEvent == null) {
                    EventDefinitionUI.this.btnAddParam.setEnabled(false);
                    EventDefinitionUI.this.btnDelParam.setEnabled(false);
                    EventDefinitionUI.this.btnUp.setEnabled(false);
                    EventDefinitionUI.this.btnDown.setEnabled(false);
                }
                EventDefinitionUI.this.loadEvent(EventDefinitionUI.this.currEvent);
            }
        });
        this.lstEvents.setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
        this.lstMethods.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EventMethodProxy mInfo = (EventMethodProxy)EventDefinitionUI.this.lstMethods.getSelectedValue();
                EventDefinitionUI.this.loadEventMethod(mInfo, EventDefinitionUI.this.currEvent);
            }
        });
        if (this.currEvent == null) {
            this.btnAddParam.setEnabled(false);
            this.btnDelParam.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
        }
    }

    void isValidateName() {
        String name = this.txtName.getText();
        if (this.currEvent != null && !StringUtils.isEmpty((String)name)) {
            EventCollection ec = this.meta.getEvents();
            int size = ec.size();
            for (int i = 0; i < size; ++i) {
                if (ec.get(i) != this.currEvent && ec.get(i).getName().equalsIgnoreCase(name)) {
                    int k = 1;
                    String newName = name + String.valueOf(k);
                    for (int j = 0; j < ec.size(); ++j) {
                        if (!newName.equalsIgnoreCase(ec.get(j).getName())) continue;
                        newName = name + String.valueOf(++k);
                    }
                    MsgBox.showError((String)"\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u4e8b\u4ef6\uff0c\u8bf7\u4fee\u6539\uff01");
                    this.txtName.setText(newName);
                    name = newName;
                    continue;
                }
                this.currEvent.setName(name.trim());
                this.lstEvents.repaint();
            }
        } else if (this.currEvent != null && StringUtils.isEmpty((String)name)) {
            this.txtName.setText(this.currEvent.getName());
        }
    }

    void isValidateAlias() {
        String alias = this.txtAlias.getText();
        if (this.currEvent != null && !StringUtils.isEmpty((String)alias)) {
            EventCollection ec = this.meta.getEvents();
            int size = ec.size();
            for (int i = 0; i < size; ++i) {
                if (ec.get(i) != this.currEvent && ec.get(i).getAlias().equalsIgnoreCase(alias)) {
                    int k = 1;
                    String newAlias = alias + String.valueOf(k);
                    for (int j = 0; j < ec.size(); ++j) {
                        if (!newAlias.equalsIgnoreCase(ec.get(j).getAlias())) continue;
                        newAlias = alias + String.valueOf(++k);
                    }
                    MsgBox.showError((String)"\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u522b\u540d\u7684\u4e8b\u4ef6\uff0c\u8bf7\u4fee\u6539\uff01");
                    this.txtAlias.setText(newAlias);
                    alias = newAlias;
                    continue;
                }
                this.currEvent.setAlias(alias.trim());
                this.lstEvents.repaint();
            }
        } else if (this.currEvent != null && StringUtils.isEmpty((String)alias)) {
            this.txtAlias.setText(this.currEvent.getAlias());
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.contEvents.addButton((JButton)this.btnAddEvent);
        this.contEvents.addButton((JButton)this.btnDelEvent);
        this.contEParam.addButton((JButton)this.btnAddParam);
        this.contEParam.addButton((JButton)this.btnDelParam);
        this.contEParam.addButton((JButton)this.btnUp);
        this.contEParam.addButton((JButton)this.btnDown);
        this.contMethods.addButton((JButton)this.btnImpMethod);
        this.contMethods.addButton((JButton)this.btnDelMethod);
    }

    @Override
    public void destory() throws Exception {
    }

    @Override
    public void doSave() throws Exception {
        this.isDirty = false;
    }

    protected void verfiy() {
        if (EPUtils.isContainChinese(this.txtName.getText())) {
            MsgBox.showWarning((String)"\u65b9\u6cd5\u540d\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u5b57\u7b26");
            this.abort();
        }
    }

    private boolean isLegalName(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        String PROPERTY_REGEX = "[a-zA-Z_]+[a-zA-Z0-9_]*";
        Pattern pattern = Pattern.compile(PROPERTY_REGEX);
        Matcher m = pattern.matcher(str);
        return m.matches();
    }

    @Override
    public void beforeSave() throws Exception {
        this.storeEvent(this.currEvent);
    }

    void storeEvent(EventInfo event) {
        int i;
        if (event == null) {
            return;
        }
        event.setName(this.txtName.getText());
        event.setAlias(this.txtAlias.getText());
        event.setDescription(this.txtDescription.getText());
        int size = this.tblEParam.getRowCount();
        for (i = 0; i < size; ++i) {
            this.storeEventParam(this.tblEParam.getRow(i));
        }
        size = this.tblMParam.getRowCount();
        for (i = 0; i < size; ++i) {
            this.storeMapping(this.tblMParam.getRow(i));
        }
    }

    void storeEventParam(IRow row) {
        String dataType;
        FormalParameterInfo fpInfo = (FormalParameterInfo)row.getUserObject();
        if (fpInfo == null) {
            return;
        }
        ParameterInfo pInfo = fpInfo.getParameter();
        pInfo.setName((String)row.getCell("name").getValue());
        pInfo.setAlias((String)row.getCell("alias").getValue());
        String desc = (String)row.getCell("description").getValue();
        if (!StringUtils.isEmpty((String)desc)) {
            pInfo.setDescription(desc.trim());
        }
        if ("ObjectValue".equals(dataType = (String)row.getCell("type").getValue()) || "ObjectCollection".equals(dataType)) {
            SimpleValueObjectInfo entity = (SimpleValueObjectInfo)row.getCell("entity").getValue();
            if (entity != null) {
                pInfo.setMetadataRef(entity.getValue());
            } else {
                dataType = "ObjectValue".equals(dataType) ? "com.kingdee.bos.dao.IObjectValue" : "com.kingdee.bos.dao.IObjectCollection";
            }
        }
        pInfo.setDataType(dataType);
    }

    void storeMapping(IRow row) {
        ParameterMappingInfo pm = (ParameterMappingInfo)row.getUserObject();
        if (pm == null) {
            return;
        }
        pm.setBOPK(((Boolean)row.getCell("key").getValue()).booleanValue());
        SimpleValueObjectInfo s = (SimpleValueObjectInfo)row.getCell("eventParam").getValue();
        FormalParameterInfo fp = (FormalParameterInfo)DataTransUtils.trans(s);
        if (fp != null) {
            pm.setFormalParameterInnerID(fp.getInnerID());
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void loadData() throws Exception {
        if (this.meta == null) {
            return;
        }
        this.lstEvents.removeAllElements();
        EventCollection ec = this.meta.getEvents();
        if (ec != null) {
            int size = ec.size();
            for (int i = 0; i < size; ++i) {
                this.lstEvents.addElement((Object)ec.get(i));
            }
        }
    }

    EventInfo createEvent() {
        EventInfo event = new EventInfo();
        String name = this.invadateName();
        event.setName(name);
        String alias = this.invadateAlias(name);
        event.setAlias(alias);
        event.setConfigured(true);
        return event;
    }

    private String invadateName() {
        String name = "newEvent" + this.index++;
        EventCollection events = this.meta.getEvents();
        int j = events.size();
        for (int i = 0; i < j; ++i) {
            if (!name.equals(events.get(i).getName())) continue;
            name = this.invadateName();
            break;
        }
        return name;
    }

    private String invadateAlias(String alias) {
        EventCollection ec = this.meta.getEvents();
        int size = ec.size();
        for (int i = 0; i < size; ++i) {
            if (!ec.get(i).getAlias().equalsIgnoreCase(alias)) continue;
            int k = 1;
            String newAlias = alias + String.valueOf(k);
            for (int j = 0; j < ec.size(); ++j) {
                if (!newAlias.equalsIgnoreCase(ec.get(j).getAlias())) continue;
                newAlias = alias + String.valueOf(++k);
            }
            alias = newAlias;
            break;
        }
        return alias;
    }

    void loadEvent(EventInfo event) {
        if (event == null) {
            return;
        }
        this.txtName.setText(event.getName());
        this.txtAlias.setText(event.getAlias());
        this.txtDescription.setText(event.getDescription());
        IRow row = null;
        FormalParameterCollection pCol = event.getFormalParameters();
        this.tblEParam.removeRows();
        FormalParameterInfo fpInfo = null;
        ParameterInfo pInfo = null;
        int size = pCol.size();
        for (int i = 0; i < size; ++i) {
            fpInfo = pCol.get(i);
            pInfo = fpInfo.getParameter();
            row = this.tblEParam.addRow();
            row.setUserObject((Object)fpInfo);
            row.getCell("name").setValue((Object)pInfo.getName());
            row.getCell("alias").setValue((Object)pInfo.getAlias());
            String type = pInfo.getDataType();
            row.getCell("type").setValue((Object)type);
            row.getCell("description").setValue((Object)pInfo.getDescription());
            String entity = pInfo.getMetaDataRef();
            if (!StringUtils.isEmpty((String)entity)) {
                EntityObjectInfo me = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(entity), this.depend);
                SimpleValueObjectInfo e = DataTransUtils.trans((AbstractMetaDataValue)me);
                row.getCell("entity").setValue((Object)e);
            }
            row.getCell("entity").getStyleAttributes().setLocked(!"ObjectValue".equals(type) && !"ObjectCollection".equals(type));
        }
        EventMethodCollection mCol = event.getEventMethods();
        EventMethodInfo mInfo = null;
        this.lstMethods.removeAllElements();
        this.tblMParam.removeRows();
        int size2 = mCol.size();
        for (int i = 0; i < size2; ++i) {
            mInfo = mCol.get(i);
            this.lstMethods.addElement((Object)EventMethodProxy.getInstance(mInfo));
        }
    }

    private KDComboBox getFMEditor(FormalParameterCollection pCol) {
        KDComboBox combo = new KDComboBox();
        DefaultComboBoxModel<SimpleValueObjectInfo> model = new DefaultComboBoxModel<SimpleValueObjectInfo>();
        int size = pCol.size();
        for (int i = 0; i < size; ++i) {
            FormalParameterInfo pInfo = pCol.get(i);
            ParameterInfo parameter = pInfo.getParameter();
            if (parameter == null) continue;
            String name = parameter.getName();
            String dataType = parameter.getDataType();
            if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)dataType)) continue;
            model.addElement(DataTransUtils.trans(pCol.get(i)));
        }
        combo.setModel(model);
        return combo;
    }

    void loadEventMethod(EventMethodProxy mInfo, EventInfo event) {
        if (mInfo == null || event == null) {
            return;
        }
        IRow row = null;
        ParameterMappingCollection mCol = mInfo.getEventMethodInfo().getParameterMappings();
        MethodInfo method = mInfo.getEventMethodInfo().getMethodRef();
        ParameterMappingInfo pm = null;
        this.tblMParam.removeRows();
        FormalParameterCollection pCol = event.getFormalParameters();
        this.tblMParam.getColumn("eventParam").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.getFMEditor(pCol)));
        ParameterCollection mpCol = method.getParameters();
        ParameterInfo pi = null;
        int size = mCol.size();
        block0: for (int i = 0; i < size; ++i) {
            pm = mCol.get(i);
            row = this.tblMParam.addRow();
            row.setUserObject((Object)pm);
            row.getCell("key").setValue((Object)pm.isBOPK());
            pi = mpCol.get(pm.getActualParameterIndex());
            row.getCell("name").setValue((Object)pi.getName());
            row.getCell("alias").setValue((Object)pi.getAlias());
            row.getCell("description").setValue((Object)pi.getDescription());
            row.getCell("type").setValue((Object)pi.getDataType());
            int s = pCol.size();
            for (int j = 0; j < s; ++j) {
                if (!pCol.get(j).getInnerID().equals(pm.getFormalParameterInnerID())) continue;
                SimpleValueObjectInfo trans = DataTransUtils.trans(pCol.get(j));
                row.getCell("eventParam").setValue((Object)trans);
                continue block0;
            }
        }
    }

    @Override
    public void setBosObjectType(BOSObjectType type) {
    }

    @Override
    public void setCustomizedSchemeID(String id) {
    }

    @Override
    public void setDepends(Project depend) {
    }

    @Override
    public void setMetadataPK(String pk) {
    }

    @Override
    public CustomizedUnitUI getCustomizedUnitUI() {
        return null;
    }

    @Override
    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
    }

    @Override
    public void actionAddEvent_actionPerformed(ActionEvent e) throws Exception {
        EventInfo event = this.createEvent();
        EventCollection ec = this.meta.getEvents();
        ec.add(event);
        this.lstEvents.addElement((Object)event);
        this.lstEvents.setSelectedValue((Object)event, true);
        this.isDirty = true;
    }

    @Override
    public void actionDelEvent_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstEvents.getSelectedIndex();
        if (index < 0 || index > this.lstEvents.getElementCount()) {
            return;
        }
        EventInfo event = (EventInfo)this.lstEvents.getElement(index);
        if (event == null) {
            return;
        }
        this.meta.getEvents().remove(event);
        this.lstEvents.removeElement((Object)event);
        if (this.lstEvents.getElementCount() > 0) {
            this.lstEvents.setSelectedIndex(0);
        } else {
            this.txtName.setText(null);
            this.txtAlias.setText(null);
            this.txtDescription.setText(null);
            this.tblEParam.removeRows();
            this.tblMParam.removeRows();
            this.lstMethods.removeAllElements();
        }
        this.isDirty = true;
    }

    @Override
    public void actionAddParam_actionPerformed(ActionEvent e) throws Exception {
        FormalParameterInfo fpInfo = new FormalParameterInfo();
        IRow row = this.tblEParam.addRow();
        row.setUserObject((Object)fpInfo);
        fpInfo.setParameter(new ParameterInfo());
        if (this.currEvent != null) {
            this.currEvent.getFormalParameters().add(fpInfo);
        }
        this.isDirty = true;
    }

    @Override
    public void actionDelParam_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblEParam);
        if (selectRows.length > 0) {
            IRow row = this.tblEParam.removeRow(selectRows[0]);
            if (this.currEvent != null) {
                this.currEvent.getFormalParameters().removeObject(row.getUserObject());
                this.tblMParam.getColumn("eventParam").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.getFMEditor(this.currEvent.getFormalParameters())));
            }
        }
        this.isDirty = true;
    }

    @Override
    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblEParam);
        int count = this.tblEParam.getRowCount();
        if (selectRows.length > 0 && selectRows[0] < count - 1) {
            IRow row = this.tblEParam.removeRow(selectRows[0]);
            this.tblEParam.addRow(selectRows[0] + 1, row);
            if (this.currEvent != null) {
                FormalParameterCollection fpc = this.currEvent.getFormalParameters();
                if (fpc == null || fpc.size() < 1) {
                    return;
                }
                fpc.changeIndex(selectRows[0], selectRows[0] + 1);
            }
        }
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblEParam);
        if (selectRows.length > 0 && selectRows[0] > 0) {
            IRow row = this.tblEParam.removeRow(selectRows[0]);
            this.tblEParam.addRow(selectRows[0] - 1, row);
            if (this.currEvent != null) {
                FormalParameterCollection fpc = this.currEvent.getFormalParameters();
                if (fpc == null || fpc.size() < 1) {
                    return;
                }
                fpc.changeIndex(selectRows[0], selectRows[0] - 1);
            }
        }
    }

    @Override
    public void actionImpMethod_actionPerformed(ActionEvent e) throws Exception {
        if (this.currEvent == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("data", PluginUtils.getAllMethods((BusinessObjectInfo)this.meta));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MethodListUI.class.getName(), (Map)uiContext);
        MethodListUI ui = (MethodListUI)uiWindow.getUIObject();
        uiWindow.show();
        MethodInfo m = ui.getMethod();
        if (m != null) {
            EventMethodInfo mInfo = new EventMethodInfo();
            mInfo.setMethodRef(m);
            mInfo.setName(m.getInnerID());
            ParameterCollection pCol = m.getParameters();
            ParameterMappingInfo pm = null;
            int size = pCol.size();
            for (int i = 0; i < size; ++i) {
                pm = new ParameterMappingInfo();
                pm.setActualParameterIndex(i);
                mInfo.getParameterMappings().add(pm);
            }
            this.lstMethods.addElement((Object)EventMethodProxy.getInstance(mInfo));
            if (this.currEvent != null) {
                this.currEvent.getEventMethods().add(mInfo);
            }
            this.isDirty = true;
        }
    }

    @Override
    public void actionDelMethod_actionPerformed(ActionEvent e) throws Exception {
        if (this.currEvent == null) {
            return;
        }
        int index = this.lstMethods.getSelectedIndex();
        if (index < 0 || index > this.lstMethods.getElementCount() - 1) {
            return;
        }
        EventMethodProxy mInfo = (EventMethodProxy)this.lstMethods.getElement(index);
        if (mInfo == null) {
            return;
        }
        this.lstMethods.removeElement((Object)mInfo);
        this.tblMParam.removeRows();
        if (this.currEvent != null) {
            this.currEvent.getEventMethods().remove(mInfo.getEventMethodInfo());
        }
        if (this.lstMethods.getElementCount() > 0) {
            this.lstMethods.setSelectedIndex(0);
        }
        this.isDirty = true;
    }

    @Override
    public Project getDepends() {
        return this.depend;
    }

    static class EventMethodProxy {
        private EventMethodInfo eventMethodInfo = null;
        private String alias = null;

        private EventMethodProxy(EventMethodInfo em) {
            this.eventMethodInfo = em;
            if (em != null && em.getMethodRef() != null) {
                this.alias = em.getMethodRef().getAlias();
            }
        }

        static EventMethodProxy getInstance(EventMethodInfo em) {
            if (em == null) {
                return null;
            }
            return new EventMethodProxy(em);
        }

        EventMethodInfo getEventMethodInfo() {
            return this.eventMethodInfo;
        }

        public String toString() {
            return this.alias;
        }
    }

    private class EventsListRenderer
    extends DefaultKingdeeListCellRenderer {
        private EventsListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ctrl = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof EventInfo) {
                EventInfo event = (EventInfo)value;
                this.setText(event.getAlias());
            }
            this.setIcon(EASResource.getIcon((String)"imgTbtn_sortorder"));
            return ctrl;
        }
    }

    private static class CustomListCellRender
    extends DefaultKingdeeListCellRenderer {
        private CustomListCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ctrl = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            EventInfo item = (EventInfo)value;
            if (item.isConfigured()) {
                Color fc = Color.BLUE;
                Color bc = list.getBackground();
                if (isSelected) {
                    ctrl.setForeground(bc);
                    ctrl.setBackground(fc);
                } else {
                    ctrl.setForeground(fc);
                    ctrl.setBackground(bc);
                }
            }
            return ctrl;
        }
    }
}

