/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.AbstractExportSchemeToSQLUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ExportSchemeToSQLUI
extends AbstractExportSchemeToSQLUI {
    private static final Logger logger = CoreUIObject.getLogger(ExportSchemeToSQLUI.class);
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";

    public void onLoad() throws Exception {
        super.onLoad();
        this.tf_exportPath.setEditable(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void filelook_actionPerformed(ActionEvent e) throws Exception {
        int select;
        KDFileChooser fileChooser = this.getKDFileChooser();
        int result = fileChooser.showSaveDialog((Component)((Object)this));
        if (result != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (!file.getAbsolutePath().endsWith(".jar")) {
            file = new File(file.getAbsolutePath() + ".jar");
        }
        if (file.exists() && (select = MsgBox.showConfirm2((Component)((Object)this), (String)"\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f")) == 2) {
            return;
        }
        String exportPath = file.getAbsolutePath();
        this.tf_exportPath.setText(exportPath);
    }

    private KDFileChooser getKDFileChooser() throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle("\u9009\u62e9\u5bfc\u51fa\u8def\u5f84");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null) {
                    return extension.equalsIgnoreCase("jar");
                }
                return false;
            }

            private String getExtension(File f) {
                String ext = null;
                String s = f.getName();
                int i = s.lastIndexOf(46);
                if (i > 0 && i < s.length() - 1) {
                    ext = s.substring(i + 1).toLowerCase();
                }
                return ext;
            }

            @Override
            public String getDescription() {
                return "jar (*.jar)";
            }
        });
        return fileChooser;
    }

    @Override
    protected void btn_confirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.tf_exportPath.getText().trim().equals("")) {
            MsgBox.showInfo((String)"\u5bfc\u51fa\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return;
        }
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.disposeUIWindow();
    }

    @Override
    protected void btn_cancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }

    public String getRelativePath() {
        String path = this.tf_relativePath.getText();
        if (!StringUtils.isEmpty((String)path)) {
            return path.trim();
        }
        return null;
    }

    public String getExportPath() {
        String path = this.tf_exportPath.getText();
        if (!StringUtils.isEmpty((String)path)) {
            return path.trim();
        }
        return null;
    }
}

