/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.ExtendPointCollection;
import com.kingdee.eas.ep.ExtendPointFactory;
import com.kingdee.eas.ep.ExtendPointInfo;
import com.kingdee.eas.ep.ExtendPointPK;
import com.kingdee.eas.ep.ExtendPointParamCollection;
import com.kingdee.eas.ep.PlugInCollection;
import com.kingdee.eas.ep.PlugInFactory;
import com.kingdee.eas.ep.PlugInInfo;
import com.kingdee.eas.ep.client.IEntityPanelListener;
import com.kingdee.eas.ep.client.PagePanel;
import com.kingdee.eas.ep.plugin.PluginUtils;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ExtendPointUI
extends PagePanel {
    private KDSplitPane mainPanel = null;
    private KDTreeView treeView = null;
    private KDTree tree = null;
    private KDTextArea txtDesc = null;
    private List itemChanged = new ArrayList();
    private final String schemeID;
    private Project depend;
    private BOSObjectType bosType = null;
    private AbstractMetaDataValue md = null;
    private boolean filter = false;
    private KDWorkButton btnFilter = null;
    private Set addListeners = new HashSet();
    private final Color dynColor = new Color(0, 91, 46);

    public ExtendPointUI(String schemeID, Project depend, BOSObjectType bosType, AbstractMetaDataValue md) throws Exception {
        this.schemeID = schemeID;
        this.depend = depend;
        this.bosType = bosType;
        this.md = md;
        this.init();
        this.loadPoints();
    }

    private void init() {
        this.setBounds(new Rectangle(0, 0, 200, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 200, 600));
        this.tree = new KDTree();
        this.treeView = new KDTreeView(this.tree);
        this.txtDesc = new KDTextArea();
        this.txtDesc.setEditable(false);
        this.txtDesc.setAutoscrolls(true);
        this.mainPanel = new KDSplitPane(0);
        this.mainPanel.setBounds(new Rectangle(0, 0, 200, 600));
        this.mainPanel.setPreferredSize(new Dimension(200, 600));
        this.mainPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 200, 600));
        this.add((Component)this.mainPanel, new KDLayout.Constraints(0, 0, 200, 600, 15));
        this.mainPanel.setResizeWeight(0.8);
        this.mainPanel.setOneTouchExpandable(true);
        this.treeView.setPreferredSize(new Dimension(200, 480));
        this.treeView.setMinimumSize(new Dimension(0, 0));
        this.mainPanel.add((Component)this.treeView, (Object)"top");
        KDWorkButton btnRefresh = new KDWorkButton();
        btnRefresh.setText(null);
        btnRefresh.setToolTipText("\u5237\u65b0");
        btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.treeView.getControlPane().add((Component)btnRefresh);
        this.btnFilter = new KDWorkButton();
        this.btnFilter.setText(null);
        this.btnFilter.setToolTipText("\u811a\u672c\u8fc7\u6ee4");
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_partshow"));
        this.treeView.getControlPane().add((Component)this.btnFilter);
        KDScrollPane scrollPane2 = new KDScrollPane((Component)this.txtDesc);
        scrollPane2.setMinimumSize(new Dimension(0, 0));
        scrollPane2.setPreferredSize(new Dimension(200, 111));
        this.mainPanel.add((Component)scrollPane2, (Object)"bottom");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                KDTreeNode node = ExtendPointUI.this.getSelectedTreeNode();
                Item item = null;
                if (node != null && node.getUserObject() instanceof Item) {
                    item = (Item)node.getUserObject();
                    ExtendPointUI.this.txtDesc.setText(item.getDescription() + " ( " + item.getExtendPointName() + " )");
                }
                int size = ExtendPointUI.this.itemChanged.size();
                for (int i = 0; i < size; ++i) {
                    ((ItemChangedListener)ExtendPointUI.this.itemChanged.get(i)).itemChanged(item);
                }
            }
        });
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExtendPointUI.this.loadPoints();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Component)((Object)ExtendPointUI.this), (Throwable)ex);
                }
            }
        });
        this.btnFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendPointUI.this.filter = !ExtendPointUI.this.filter;
                ExtendPointUI.this.filterPoints();
            }
        });
        this.addAddListener(new actionAddOrDelListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddListener(IEntityPanelListener listener) {
        Set set = this.addListeners;
        synchronized (set) {
            this.addListeners.add(listener);
        }
    }

    public Set getAddListeners() {
        return this.addListeners;
    }

    private void filterPoints() {
        if (this.filter) {
            this.btnFilter.setToolTipText("\u5c55\u793a\u5168\u90e8");
            this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_entirely"));
        } else {
            this.btnFilter.setToolTipText("\u811a\u672c\u8fc7\u6ee4");
            this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_partshow"));
        }
        try {
            this.loadPoints();
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.tree.getLastSelectedPathComponent();
    }

    public void registerItemChangedListener(ItemChangedListener listener) {
        this.itemChanged.add(listener);
    }

    void loadPoints() throws Exception {
        if (this.bosType == null || this.md == null) {
            return;
        }
        Model model = this.createModel(this.bosType, this.md);
        KDTreeNode rootNode = this.buildTreeNode(model);
        if (rootNode == null) {
            this.tree.setModel(null);
        } else {
            this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootNode));
        }
        this.tree.expandOnLevel(4);
    }

    KDTreeNode buildTreeNode(Model model) throws Exception {
        KDTreeNode root = new KDTreeNode((Object)model);
        Group rt = model.getRoot();
        this.buildTreeNode(root, rt);
        return root;
    }

    void buildTreeNode(KDTreeNode root, Group rt) throws Exception {
        if (rt == null || root == null) {
            return;
        }
        List groups = rt.getGroups();
        KDTreeNode node = null;
        Group g = null;
        int size = groups.size();
        for (int i = 0; i < size; ++i) {
            g = (Group)groups.get(i);
            node = new KDTreeNode((Object)g);
            root.add((MutableTreeNode)node);
            this.buildTreeNode(node, g);
        }
        List items = rt.getItems();
        Item item = null;
        int size2 = items.size();
        for (int i = 0; i < size2; ++i) {
            item = (Item)items.get(i);
            item.setHaveScript();
            if (this.filter) {
                if (!item.isHaveScript()) continue;
                node = new KDTreeNode((Object)item);
                node.setTextColor(this.dynColor);
                root.add((MutableTreeNode)node);
                continue;
            }
            node = new KDTreeNode((Object)item);
            root.add((MutableTreeNode)node);
            if (item.isHaveScript()) {
                node.setTextColor(this.dynColor);
            }
            if (!item.getExtendPoint().isConfigured()) continue;
            node.setTextColor(Color.BLUE);
        }
    }

    private Model createModel(BOSObjectType bosType, AbstractMetaDataValue md) throws Exception {
        Model model = new Model(bosType, md, this.schemeID, this.depend);
        if (MetaDataTypeList.UIOBJECT.equals((Object)bosType)) {
            new UIExtendPointCreator().create(model);
        } else if (MetaDataTypeList.ENTITY.equals((Object)bosType)) {
            new EntityExtendPointCreator().create(model);
        } else if (MetaDataTypeList.FACADE.equals((Object)bosType)) {
            new FacadeExtendPointCreator().create(model);
        } else if (MetaDataTypeList.WEBUIOBJECT.equals((Object)bosType)) {
            new WebUIExtendPointCreator().create(model);
        }
        return model;
    }

    public static interface ItemChangedListener {
        public void itemChanged(Item var1);
    }

    public static class Item {
        private Model model = null;
        private ExtendPointInfo extendPoint = null;
        private PlugInInfo plugIn = null;
        private boolean haveScript = false;
        private boolean overrideSupport = false;

        Item(Model model) {
            this(model, null);
        }

        Item(ExtendPointInfo extendPoint) {
            this(null, extendPoint);
        }

        Item(Model model, ExtendPointInfo extendPoint) {
            this.model = model;
            this.extendPoint = extendPoint;
        }

        public String toString() {
            if (this.extendPoint == null) {
                return null;
            }
            String display = this.extendPoint.getName();
            if (!StringUtils.isEmpty((String)this.extendPoint.getAlias())) {
                display = this.extendPoint.getAlias() + "(" + display + ")";
            }
            return display;
        }

        public Model getModel() {
            return this.model;
        }

        public void setModel(Model model) {
            this.model = model;
        }

        public ExtendPointInfo getExtendPoint() {
            return this.extendPoint;
        }

        public void setExtendPoint(ExtendPointInfo extendPoint) {
            this.extendPoint = extendPoint;
        }

        public boolean isHaveScript() {
            return this.haveScript;
        }

        public void setHaveScript() throws Exception {
            ExtendPointCollection epc = this.model.getExtendPointsWithScript();
            this.haveScript = false;
            if (epc != null) {
                int size = epc.size();
                for (int i = 0; i < size; ++i) {
                    if (!PluginUtils.isExtendPointEqual(this.extendPoint, epc.get(i))) continue;
                    this.haveScript = true;
                    break;
                }
            }
        }

        public boolean isOverrideSupport() {
            return this.overrideSupport;
        }

        public void setOverrideSupport(boolean overrideSupport) {
            this.overrideSupport = overrideSupport;
        }

        public PlugInInfo getPlugIn() throws Exception {
            if (this.plugIn == null) {
                String key = this.model.getMD().getFullName();
                PlugInCollection col = PlugInFactory.getRemoteInstance().getPlugIn(this.model.getSchemeID(), key, this.extendPoint);
                if (col == null || col.size() <= 0) {
                    this.plugIn = new PlugInInfo();
                    this.plugIn.setPoint(this.extendPoint);
                    this.plugIn.setOwner(key);
                    this.plugIn.setSchemeID(this.model.getSchemeID());
                } else {
                    this.plugIn = col.get(0);
                }
            }
            return this.plugIn;
        }

        String getDescription() {
            if (this.extendPoint == null) {
                return null;
            }
            return this.extendPoint.getDescription();
        }

        String getExtendPointName() {
            if (this.extendPoint == null) {
                return null;
            }
            return this.extendPoint.getName();
        }

        public void setPlugIn(PlugInInfo plugIn) {
            this.plugIn = plugIn;
        }
    }

    static class Group {
        private Model model = null;
        private List groups = new ArrayList();
        private List items = new ArrayList();
        private String name = null;

        Group(String name) {
            this(null, name);
        }

        Group(Model model) {
            this(model, null);
        }

        Group(Model model, String name) {
            this.model = model;
            this.name = name;
        }

        void setName(String name) {
            this.name = name;
        }

        void setModel(Model model) {
            this.model = model;
        }

        List getGroups() {
            return this.groups;
        }

        List getItems() {
            return this.items;
        }

        void add(Group g) {
            if (g == null) {
                return;
            }
            this.groups.add(g);
            g.setModel(this.model);
        }

        void add(Item item) {
            if (item == null) {
                return;
            }
            item.setModel(this.model);
            this.items.add(item);
        }

        public String toString() {
            return this.name;
        }
    }

    static class Model {
        private Group root = null;
        private AbstractMetaDataValue md = null;
        private BOSObjectType bosType = null;
        private final String schemeID;
        private Project depend;
        private ExtendPointCollection epHasScript = null;

        Model(BOSObjectType bosType, AbstractMetaDataValue md, String schemeID, Project depend) {
            this.bosType = bosType;
            this.md = md;
            this.schemeID = schemeID;
            this.depend = depend;
        }

        public AbstractMetaDataValue getMD() {
            return this.md;
        }

        public String getSchemeID() {
            return this.schemeID;
        }

        public Project getDepend() {
            return this.depend;
        }

        public BOSObjectType getBosType() {
            return this.bosType;
        }

        public Group createGroup() {
            Group g = new Group(this);
            return g;
        }

        public void setRoot(Group root) {
            this.root = root;
            root.setModel(this);
        }

        public Group getRoot() {
            return this.root;
        }

        public String toString() {
            if (this.root != null) {
                return this.root.toString();
            }
            return super.toString();
        }

        public ExtendPointCollection getExtendPointsWithScript() throws Exception {
            if (this.epHasScript == null) {
                this.epHasScript = PlugInFactory.getRemoteInstance().getExtendPoints(this.schemeID, this.md.getFullName());
            }
            return this.epHasScript;
        }
    }

    class WebUIExtendPointCreator {
        WebUIExtendPointCreator() {
        }

        void create(Model model) throws Exception {
            WebUIObjectInfo ui = (WebUIObjectInfo)model.getMD();
            Group root = model.createGroup();
            root.setName("\u6269\u5c55\u70b9");
            model.setRoot(root);
            Group template = new Group("\u4e8b\u4ef6\u7c7b\u578b");
            root.add(template);
            ExtendPointCollection col = ExtendPointFactory.getRemoteInstance().getExtendPointCollection("select * where inner = 0 and key in (" + this.getParentUI(ui) + ")");
            if (col != null) {
                Item item = null;
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    item = new Item(col.get(i));
                    item.setOverrideSupport(true);
                    template.add(item);
                }
            }
        }

        String getParentUI(WebUIObjectInfo ui) {
            StringBuffer p = null;
            for (WebUIObjectInfo tmp = ui; tmp != null; tmp = tmp.getParent()) {
                if (p == null) {
                    p = new StringBuffer();
                } else {
                    p.append(",");
                }
                p.append("'");
                p.append(tmp.getFullName());
                p.append("'");
            }
            return p.toString() + ",'com.kingdee.eas.framework.web.CoreUI'";
        }
    }

    class UIExtendPointCreator {
        UIExtendPointCreator() {
        }

        void create(Model model) throws Exception {
            UIObjectInfo ui = (UIObjectInfo)model.getMD();
            Group root = model.createGroup();
            root.setName("\u6269\u5c55\u70b9");
            model.setRoot(root);
            Group template = new Group("\u6a21\u677f\u65b9\u6cd5");
            root.add(template);
            ExtendPointCollection col = ExtendPointFactory.getRemoteInstance().getExtendPointCollection("select *,param.* where inner = 1 and key in (" + this.getParentUI(ui) + ")");
            if (col != null) {
                Item item = null;
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    item = new Item(col.get(i));
                    item.setOverrideSupport(true);
                    template.add(item);
                }
            }
            Group actions = new Group("\u64cd\u4f5c");
            root.add(actions);
            this.getActions(ui, actions);
        }

        String getParentUI(UIObjectInfo ui) {
            StringBuffer p = null;
            for (UIObjectInfo tmp = ui; tmp != null; tmp = tmp.getParent()) {
                if (p == null) {
                    p = new StringBuffer();
                } else {
                    p.append(",");
                }
                p.append("'");
                p.append(tmp.getFullName());
                p.append("'");
            }
            return p.toString();
        }

        void getActions(UIObjectInfo ui, Group root) {
            if (ui == null) {
                return;
            }
            ActionCollection actions = ui.getActions();
            if (actions != null) {
                ExtendPointInfo point = null;
                ActionInfo action = null;
                int size = actions.size();
                for (int i = 0; i < size; ++i) {
                    action = actions.get(i);
                    point = PluginUtils.getExtendPoint(action.getClassName());
                    point.setAlias(action.getShortDesc());
                    point.setDescription("Action\u5b9a\u4e49\u4e8e" + ui.getName());
                    point.setSchemeID(ExtendPointUI.this.schemeID);
                    point.setConfigured(action.isConfigured());
                    root.add(new Item(point));
                }
            }
        }
    }

    class EntityExtendPointCreator {
        EntityExtendPointCreator() {
        }

        void create(Model model) throws Exception {
            Group root = model.createGroup();
            root.setName("\u6269\u5c55\u70b9");
            model.setRoot(root);
            HashSet methods = new HashSet();
            this.getMethods((EntityObjectInfo)model.getMD(), root, methods);
        }

        String buildDescription(String entity, ExtendPointInfo point, MethodInfo method) {
            if (point == null || method == null) {
                return null;
            }
            StringBuffer description = null;
            description = new StringBuffer();
            description.append(method.toString());
            description.append("\n\u65b9\u6cd5\u5b9a\u4e49\u4e8e\u5b9e\u4f53");
            description.append(entity);
            description.append("\n\u8fd4\u56de\u503c\uff1a\n");
            description.append(point.getResult());
            description.append("\n\u53c2\u6570\uff1a");
            ExtendPointParamCollection params = point.getParam();
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                description.append("\n");
                description.append(params.get(i).getSeq());
                description.append(" - ");
                description.append(params.get(i).getType());
            }
            return description.toString();
        }

        void getMethods(EntityObjectInfo entity, Group root, Set methods) {
            if (entity == null) {
                return;
            }
            Group ms = new Group(entity.getName());
            root.add(ms);
            MethodCollection mcol = entity.getMethods();
            if (mcol != null) {
                MethodInfo m = null;
                ExtendPointInfo point = null;
                ExtendPointPK pointPK = null;
                Item item = null;
                int size = mcol.size();
                for (int i = 0; i < size; ++i) {
                    m = mcol.get(i);
                    point = PluginUtils.getExtendPoint(m);
                    pointPK = ExtendPointPK.build(point);
                    if (methods.contains(pointPK)) continue;
                    methods.add(pointPK);
                    point.setSchemeID(ExtendPointUI.this.schemeID);
                    point.setConfigured(m.isConfigured());
                    point.setDescription(this.buildDescription(entity.getName(), point, m));
                    item = new Item(point);
                    item.setOverrideSupport(true);
                    ms.add(item);
                }
            }
            if (entity.getParent() != null && entity.getParent() instanceof EntityObjectInfo) {
                this.getMethods((EntityObjectInfo)entity.getParent(), root, methods);
            }
        }
    }

    class FacadeExtendPointCreator {
        FacadeExtendPointCreator() {
        }

        void create(Model model) throws Exception {
            Group root = model.createGroup();
            root.setName("\u6269\u5c55\u70b9");
            model.setRoot(root);
            HashSet methods = new HashSet();
            this.getMethods((FacadeInfo)model.getMD(), root, methods);
        }

        String buildDescription(String entity, ExtendPointInfo point, MethodInfo method) {
            if (point == null || method == null) {
                return null;
            }
            StringBuffer description = null;
            description = new StringBuffer();
            description.append(method.toString());
            description.append("\n\u65b9\u6cd5\u5b9a\u4e49\u4e8e\u5b9e\u4f53");
            description.append(entity);
            description.append("\n\u8fd4\u56de\u503c\uff1a\n");
            description.append(point.getResult());
            description.append("\n\u53c2\u6570\uff1a");
            ExtendPointParamCollection params = point.getParam();
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                description.append("\n");
                description.append(params.get(i).getSeq());
                description.append(" - ");
                description.append(params.get(i).getType());
            }
            return description.toString();
        }

        void getMethods(FacadeInfo facade, Group root, Set methods) {
            if (facade == null) {
                return;
            }
            Group ms = new Group(facade.getName());
            root.add(ms);
            MethodCollection mcol = facade.getMethods();
            if (mcol != null) {
                MethodInfo m = null;
                ExtendPointInfo point = null;
                ExtendPointPK pointPK = null;
                Item item = null;
                int size = mcol.size();
                for (int i = 0; i < size; ++i) {
                    m = mcol.get(i);
                    point = PluginUtils.getExtendPoint(m);
                    pointPK = ExtendPointPK.build(point);
                    if (methods.contains(pointPK)) continue;
                    methods.add(pointPK);
                    point.setSchemeID(ExtendPointUI.this.schemeID);
                    point.setConfigured(m.isConfigured());
                    point.setDescription(this.buildDescription(facade.getName(), point, m));
                    item = new Item(point);
                    item.setOverrideSupport(true);
                    ms.add(item);
                }
            }
            if (facade.getParent() != null && facade.getParent() instanceof EntityObjectInfo) {
                this.getMethods((FacadeInfo)facade.getParent(), root, methods);
            }
        }
    }

    class actionAddOrDelListener
    implements IEntityPanelListener {
        actionAddOrDelListener() {
        }

        @Override
        public void afterAddOrDel() throws Exception {
            ExtendPointUI.this.loadPoints();
        }
    }
}

