/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.bo.TransactionAttribute;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.resource.BizExceptionCollection;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.client.AbstractFacadeEditorUI;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.SimpleMetaDataSelector;
import com.kingdee.eas.ep.client.util.DataTransUtils;
import com.kingdee.eas.ep.client.util.EditorCreator;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.tools.datatask.client.SimpleValueObjectInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FacadeEditorUI
extends AbstractFacadeEditorUI
implements IEditorTabPanel {
    private static final long serialVersionUID = -1451058509666458343L;
    private String customizedSchemeID;
    private Project depend;
    private FacadeInfo meta;
    private MethodInfo currMethod = null;
    private int index = 0;
    private boolean isDirty = false;

    public FacadeEditorUI(FacadeInfo meta, Project depend, String customizedSchemeID) throws Exception {
        this.meta = meta;
        this.depend = depend;
        this.customizedSchemeID = customizedSchemeID;
        this.init();
    }

    void init() {
        this.btnAddException.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelException.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddMethodParam.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelMethodParam.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddOprt.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDelOprt.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.actionAddOprt.setEnabled(true);
        this.setEnableForIsConfigMethod(false);
        this.lsMethod.setSelectionMode(0);
        this.refreshEnumList(this.cbChildModel, SubClassingMode.iterator());
        this.refreshEnumList(this.cbVisitLevel, AccessLevel.iterator());
        this.cbVisitLevel.setEnabled(false);
        this.refreshEnumList(this.cbTranProperty, TransactionAttribute.iterator());
        EditorCreator.getDataTypeEditor(this.cbReturnType);
        this.cbReturnType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FacadeEditorUI.this.prmtEntity.setData(null);
                Object item = e.getItem();
                FacadeEditorUI.this.prmtEntity.setEnabled("ObjectValue".equals(item) || "ObjectCollection".equals(item));
            }
        });
        this.prmtEntity.setSelector((KDPromptSelector)new SimpleMetaDataSelector((IUIObject)this, "bizentity", this.depend));
        this.prmtEntity.setEditable(false);
        this.prmtEntity.setEnabled(false);
        this.chkIsEventMethod.setEnabled(false);
        this.tblException.checkParsed(true);
        KDBizPromptBox prmtEntity1 = new KDBizPromptBox();
        prmtEntity1.setSelector((KDPromptSelector)new SimpleMetaDataSelector((IUIObject)this, "bizentity", this.depend));
        prmtEntity1.setEditable(false);
        this.tblMetholdParam.checkParsed(true);
        this.tblMetholdParam.getColumn("entity").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtEntity1));
        this.tblMetholdParam.getColumn("type").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getDataTypeEditor(null)));
        this.tblMetholdParam.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    if (FacadeEditorUI.this.tblMetholdParam.getColumnIndex("type") == e.getColIndex()) {
                        if (e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
                            FacadeEditorUI.this.tblMetholdParam.getCell(e.getRowIndex(), "entity").setValue(null);
                        }
                        Object value = e.getValue();
                        FacadeEditorUI.this.tblMetholdParam.getCell(e.getRowIndex(), "entity").getStyleAttributes().setLocked(!"ObjectValue".equals(value) && !"ObjectCollection".equals(value));
                    }
                }
                catch (Exception exc) {
                    FacadeEditorUI.this.handUIException(exc);
                }
            }
        });
        this.lsMethod.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FacadeEditorUI.this.storeOperation(FacadeEditorUI.this.currMethod);
                FacadeEditorUI.this.currMethod = (MethodInfo)FacadeEditorUI.this.lsMethod.getSelectedValue();
                if (FacadeEditorUI.this.currMethod == null) {
                    return;
                }
                FacadeEditorUI.this.setEnableForIsConfigMethod(FacadeEditorUI.this.currMethod.isConfigured());
                FacadeEditorUI.this.loadOperation(FacadeEditorUI.this.currMethod);
            }
        });
        this.lsMethod.setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
        this.useExBox.setEnabled(!this.meta.isDynamic());
        this.useExBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FacadeEditorUI.this.meta.setExtendedProperty("controllerBeanEx", FacadeEditorUI.this.useExBox.isSelected() ? FacadeEditorUI.this.meta.getBusinessControllerBean() + "Ex" : null);
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.contMethod.addButton((JButton)this.btnAddOprt);
        this.contMethod.addButton((JButton)this.btnDelOprt);
        this.contException.addButton((JButton)this.btnAddException);
        this.contException.addButton((JButton)this.btnDelException);
        this.contMetholdParam.addButton((JButton)this.btnAddMethodParam);
        this.contMetholdParam.addButton((JButton)this.btnDelMethodParam);
    }

    @Override
    public void destory() throws Exception {
    }

    @Override
    public void beforeSave() throws Exception {
        this.storeOperation(this.currMethod);
    }

    @Override
    public void doSave() throws Exception {
        this.meta.validate();
        UictUtils.saveMetadata((AbstractMetaDataValue)this.meta, this.customizedSchemeID, this.depend);
        this.loadData();
        this.isDirty = false;
    }

    void loadOperation(MethodInfo oprt) {
        IRow row;
        if (oprt == null) {
            return;
        }
        this.txtName.setText(oprt.getName());
        this.txtAlias.setText(oprt.getAlias());
        this.txtDescription.setText(oprt.getDescription());
        this.cbVisitLevel.setSelectedItem((Object)oprt.getAccessLevel());
        this.cbChildModel.setSelectedItem((Object)oprt.getSubClassingMode());
        this.cbTranProperty.setSelectedItem((Object)oprt.getTransactionAttribute());
        this.cbReturnType.setSelectedItem((Object)oprt.getDataType());
        String entity = oprt.getMetaDataRef();
        if (!StringUtils.isEmpty((String)entity)) {
            EntityObjectInfo me = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(entity), this.depend);
            this.prmtEntity.setData((Object)DataTransUtils.trans((AbstractMetaDataValue)me));
        }
        oprt.setIsListenerMethod(this.chkIsEventMethod.isSelected());
        this.tblException.removeRows();
        BizExceptionCollection bizExceptions = oprt.getBizExceptions();
        int size = bizExceptions.size();
        for (int i = 0; i < size; ++i) {
            BizExceptionInfo bizException = bizExceptions.get(i);
            row = this.tblException.addRow();
            if (bizException != null) {
                row.getCell("packgeName").setValue((Object)bizException.getPackage());
                row.getCell("className").setValue((Object)bizException.getName());
            } else {
                bizException = new BizExceptionInfo();
                bizExceptions.set(i, bizException);
            }
            row.setUserObject((Object)bizException);
        }
        this.tblMetholdParam.removeRows();
        ParameterCollection params = oprt.getParameters();
        int size2 = params.size();
        for (int i = 0; i < size2; ++i) {
            ParameterInfo param = params.get(i);
            row = this.tblMetholdParam.addRow();
            row.setUserObject((Object)param);
            row.getCell("name").setValue((Object)param.getName());
            row.getCell("alias").setValue((Object)param.getAlias());
            row.getCell("type").setValue((Object)param.getDataType());
            row.getCell("description").setValue((Object)param.getDescription());
            entity = param.getMetaDataRef();
            if (StringUtils.isEmpty((String)entity)) continue;
            EntityObjectInfo me = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(entity), this.depend);
            row.getCell("entity").setValue((Object)DataTransUtils.trans((AbstractMetaDataValue)me));
        }
    }

    void storeOperation(MethodInfo oprt) {
        IRow row;
        int i;
        if (oprt == null) {
            return;
        }
        oprt.setName(this.txtName.getText());
        oprt.setAlias(this.txtAlias.getText());
        oprt.setDescription(this.txtDescription.getText());
        oprt.setAccessLevel((AccessLevel)this.cbVisitLevel.getSelectedItem());
        oprt.setSubClassingMode((SubClassingMode)this.cbChildModel.getSelectedItem());
        oprt.setTransactionAttribute((TransactionAttribute)this.cbTranProperty.getSelectedItem());
        String dataType = (String)this.cbReturnType.getSelectedItem();
        if ("ObjectValue".equals(dataType) || "ObjectCollection".equals(dataType)) {
            SimpleValueObjectInfo entity = (SimpleValueObjectInfo)this.prmtEntity.getData();
            if (entity != null) {
                oprt.setMetadataRef(entity.getValue());
            } else {
                String string = dataType = "ObjectValue".equals(dataType) ? "com.kingdee.bos.dao.IObjectValue" : "com.kingdee.bos.dao.IObjectCollection";
            }
        }
        if (dataType != null) {
            oprt.setDataType(dataType);
        }
        oprt.setIsListenerMethod(this.chkIsEventMethod.isSelected());
        int size = this.tblException.getRowCount();
        for (i = 0; i < size; ++i) {
            row = this.tblException.getRow(i);
            this.storeException(row);
        }
        size = this.tblMetholdParam.getRowCount();
        for (i = 0; i < size; ++i) {
            row = this.tblMetholdParam.getRow(i);
            this.storeParam(row);
        }
    }

    private void storeException(IRow row) {
        BizExceptionInfo bizException = (BizExceptionInfo)row.getUserObject();
        if (bizException == null) {
            return;
        }
        bizException.setPackage((String)row.getCell("packgeName").getValue());
        bizException.setName((String)row.getCell("className").getValue());
        bizException.setClassName((String)row.getCell("packgeName").getValue() + "." + (String)row.getCell("className").getValue());
    }

    private void storeParam(IRow row) {
        ParameterInfo param = (ParameterInfo)row.getUserObject();
        if (param == null) {
            return;
        }
        param.setName((String)row.getCell("name").getValue());
        param.setAlias((String)row.getCell("alias").getValue());
        String dataType = (String)row.getCell("type").getValue();
        if ("ObjectValue".equals(dataType) || "ObjectCollection".equals(dataType)) {
            SimpleValueObjectInfo entity = (SimpleValueObjectInfo)row.getCell("entity").getValue();
            if (entity != null) {
                param.setMetadataRef(entity.getValue());
            } else {
                dataType = "ObjectValue".equals(dataType) ? "com.kingdee.bos.dao.IObjectValue" : "com.kingdee.bos.dao.IObjectCollection";
            }
        }
        param.setDataType(dataType);
        param.setDescription((String)row.getCell("description").getValue());
    }

    MethodInfo createMethodInfo() {
        MethodInfo oprt = new MethodInfo();
        oprt.setName("newMethod" + this.index);
        oprt.setAlias("newMethod" + this.index);
        oprt.setConfigured(true);
        ++this.index;
        return oprt;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void loadData() throws Exception {
        if (this.meta == null) {
            return;
        }
        this.currMethod = null;
        this.lblFacade.setText(this.meta.getFullName());
        this.useExBox.setSelected(this.meta.getExtendedProperty("controllerBeanEx") != null);
        MethodCollection oCol = this.meta.getMethods();
        MethodInfo oprt = null;
        this.lsMethod.removeAllElements();
        int size = oCol.size();
        for (int i = 0; i < size; ++i) {
            oprt = oCol.get(i);
            this.lsMethod.addElement((Object)oprt);
        }
    }

    @Override
    public void setBosObjectType(BOSObjectType type) {
    }

    @Override
    public void setCustomizedSchemeID(String id) {
    }

    @Override
    public void setDepends(Project depend) {
    }

    @Override
    public void setMetadataPK(String pk) {
    }

    @Override
    public CustomizedUnitUI getCustomizedUnitUI() {
        return null;
    }

    @Override
    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
    }

    @Override
    public void actionAddOprt_actionPerformed(ActionEvent e) throws Exception {
        MethodInfo oprt = this.createMethodInfo();
        this.meta.getMethods().add(oprt);
        this.meta.getMethods().add(oprt);
        this.lsMethod.addElement((Object)oprt);
        this.lsMethod.setSelectedValue((Object)oprt, true);
        this.isDirty = true;
    }

    @Override
    public void actionDelOprt_actionPerformed(ActionEvent e) throws Exception {
        if (this.lsMethod.getSelectedIndex() < 0) {
            return;
        }
        MethodInfo se = (MethodInfo)this.lsMethod.getElement(this.lsMethod.getSelectedIndex());
        if (se == null) {
            return;
        }
        this.lsMethod.removeElement((Object)se);
        this.meta.getMethods().remove(se);
        if (this.lsMethod.getElementCount() > 0) {
            this.lsMethod.setSelectedIndex(0);
        }
        this.isDirty = true;
    }

    @Override
    public void actionAddMethodParam_actionPerformed(ActionEvent e) throws Exception {
        ParameterInfo param = new ParameterInfo();
        IRow row = this.tblMetholdParam.addRow();
        row.setUserObject((Object)param);
        if (this.currMethod != null) {
            this.currMethod.getParameters().add(param);
        }
        this.isDirty = true;
    }

    @Override
    public void actionDelMethodParam_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMetholdParam);
        if (selectRows.length > 0) {
            IRow row = this.tblMetholdParam.removeRow(selectRows[0]);
            if (this.currMethod != null) {
                this.currMethod.getParameters().remove((ParameterInfo)row.getUserObject());
            }
        }
        this.isDirty = true;
    }

    @Override
    public void actionAddException_actionPerformed(ActionEvent e) throws Exception {
        BizExceptionInfo bizException = new BizExceptionInfo();
        IRow row = this.tblException.addRow();
        row.getCell("packgeName").setValue((Object)"com.kingdee.eas.common");
        row.getCell("className").setValue((Object)"EASBizException");
        row.setUserObject((Object)bizException);
        if (this.currMethod != null) {
            this.currMethod.getBizExceptions().add(bizException);
        }
        this.isDirty = true;
    }

    @Override
    public void actionDelException_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblException);
        if (selectRows.length > 0) {
            IRow row = this.tblException.removeRow(selectRows[0]);
            if (this.currMethod != null) {
                this.currMethod.getBizExceptions().remove((BizExceptionInfo)row.getUserObject());
            }
        }
        this.isDirty = true;
    }

    public void refreshEnumList(KDComboBox list, Iterator itor) {
        list.removeAllItems();
        if (itor != null) {
            while (itor.hasNext()) {
                list.addItem(itor.next());
            }
        }
    }

    protected void setEnableForIsConfigMethod(boolean isConfigMethod) {
        this.actionDelOprt.setEnabled(isConfigMethod);
        this.actionAddException.setEnabled(isConfigMethod);
        this.actionDelException.setEnabled(isConfigMethod);
        this.actionAddMethodParam.setEnabled(isConfigMethod);
        this.actionDelMethodParam.setEnabled(isConfigMethod);
        this.txtName.setEnabled(isConfigMethod);
        this.txtAlias.setEnabled(isConfigMethod);
        this.cbChildModel.setEnabled(false);
        this.cbTranProperty.setEnabled(isConfigMethod);
        this.cbReturnType.setEnabled(isConfigMethod);
        this.tblMetholdParam.setEnabled(isConfigMethod);
        this.tblException.setEnabled(isConfigMethod);
    }

    @Override
    public Project getDepends() {
        return this.depend;
    }

    private static class CustomListCellRender
    extends DefaultKingdeeListCellRenderer {
        private CustomListCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ctrl = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            MethodInfo item = (MethodInfo)value;
            if (item.isConfigured()) {
                Color fc = Color.BLUE;
                Color bc = list.getBackground();
                if (isSelected) {
                    ctrl.setForeground(bc);
                    ctrl.setBackground(fc);
                } else {
                    ctrl.setForeground(fc);
                    ctrl.setBackground(bc);
                }
            }
            return ctrl;
        }
    }
}

