/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.AbstractFieldIndexSetUI;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.util.UictUtils;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FieldIndexSetUI
extends AbstractFieldIndexSetUI {
    private static final Logger logger = CoreUIObject.getLogger(FieldIndexSetUI.class);
    private UIObjectInfo uiModel;
    private List orderedFieldList;
    private UictEditPartViewer viewer;
    ComponentInfo allComponents;
    ComponentCollection col;

    public FieldIndexSetUI() throws Exception {
        this.setUITitle("\u8bbe\u7f6eTab\u987a\u5e8f");
    }

    public void init(Context context) {
        this.uiModel = (UIObjectInfo)context.getUiModel();
        this.viewer = (UictEditPartViewer)context.getRootViewer();
        this.allComponents = this.uiModel.getMainPanelComponent();
        this.col = this.allComponents.getComponents();
        this.loadData();
    }

    private void loadData() {
        this.table.checkParsed();
        this.table.getColumn("isSelect").getStyleAttributes().setHided(true);
        this.table.setEnabled(false);
        this.btnAllSelect.setVisible(false);
        this.btnAllUnselected.setVisible(false);
        this.table.getSelectManager().setSelectMode(2);
        this.orderedFieldList = this.getOrderedTabIndexComponent();
        int index = 1;
        for (ComponentInfo allComponent : this.orderedFieldList) {
            IRow row = this.table.addRow();
            row.getCell("nameColumn").setValue((Object)allComponent.getName());
            BizConfigureItemCollection items = (BizConfigureItemCollection)this.viewer.getNode().getConfigureItems();
            int j = items.size();
            for (int i = 0; i < j; ++i) {
                BizConfigureItemInfo item = (BizConfigureItemInfo)items.get(i);
                if (!item.getComponent().equals((Object)allComponent)) continue;
                BizConfigureItemInfoAdapter model = new BizConfigureItemInfoAdapter(item);
                row.getCell("aliasColumn").setValue(model.get("Label"));
            }
            if ((row.getCell("aliasColumn").getValue() == null || "".equals(row.getCell("aliasColumn").getValue().toString())) && allComponent.getParent() != null && allComponent.getParent().getParent() != null) {
                row.getCell("aliasColumn").setValue((Object)UictUtils.getAlias(allComponent.getParent()));
            }
            if (row.getCell("aliasColumn").getValue() == null || "".equals(row.getCell("aliasColumn").getValue().toString())) {
                row.getCell("aliasColumn").setValue((Object)UictUtils.getAlias(allComponent));
            }
            row.getCell("isSelect").setValue((Object)Boolean.TRUE);
            row.setUserObject((Object)allComponent);
            ++index;
        }
    }

    public List getOrderedTabIndexComponent() {
        int i;
        ArrayList result = new ArrayList();
        HashMap tmp = new HashMap();
        ArrayList tmp1 = new ArrayList();
        HashMap tmp2 = new HashMap();
        ArrayList tmp21 = new ArrayList();
        ComponentInfo allComponents = this.uiModel.getMainPanelComponent();
        ComponentCollection col = allComponents.getComponents();
        int size = col.size();
        for (i = 0; i < size; ++i) {
            ComponentInfo allComponent = col.get(i);
            Integer listTabIndex = new Integer(allComponent.getTabIndex());
            ComponentInfo[] childCol = this.order(allComponent);
            if (childCol.length > 0) {
                this.setChildTmps(allComponent, tmp, tmp1, tmp2, tmp21);
                continue;
            }
            this.setTmps(allComponent, allComponent, listTabIndex, tmp, tmp1, tmp2, tmp21);
        }
        Collections.sort(tmp1);
        for (i = 0; i < tmp1.size(); ++i) {
            Integer listTabIndex = (Integer)tmp1.get(i);
            List tmpList = (List)tmp.get(listTabIndex);
            for (int j = 0; j < tmpList.size(); ++j) {
                result.add(tmpList.get(j));
            }
        }
        Collections.sort(tmp21);
        for (i = 0; i < tmp21.size(); ++i) {
            List tmpList = (List)tmp2.get(tmp21.get(i));
            for (int j = 0; j < tmpList.size(); ++j) {
                result.add(tmpList.get(j));
            }
        }
        return result;
    }

    private void setChildTmps(ComponentInfo parent, Map tmp, List tmp1, Map tmp2, List tmp21) {
        ComponentInfo[] childCol = this.order(parent);
        for (int j = 0; j < childCol.length; ++j) {
            ComponentInfo ctrl = childCol[j];
            if (ctrl == null) continue;
            Integer listTabIndex = new Integer(ctrl.getTabIndex());
            ComponentInfo[] childCol2 = this.order(ctrl);
            if (childCol2.length > 0) {
                this.setChildTmps(ctrl, tmp, tmp1, tmp2, tmp21);
                continue;
            }
            this.setTmps(ctrl, parent, listTabIndex, tmp, tmp1, tmp2, tmp21);
        }
    }

    private void setTmps(ComponentInfo ctrl, ComponentInfo parent, Integer listTabIndex, Map tmp, List tmp1, Map tmp2, List tmp21) {
        if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButtonGroup".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDSeparator".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTree".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTreeView".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDSlider".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDProgressBar".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDPanel".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDScrollPane".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDSplitPane".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDContainer".equals(ctrl.getClassType()) || "com.kingdee.bos.ctrl.swing.KDToolBar".equals(ctrl.getClassType()) || "javax.swing.JToolBar.Separator".equals(ctrl.getClassType())) {
            return;
        }
        double rowOrder = 0.0;
        double x = 0.0;
        if (listTabIndex > 0) {
            if (tmp.containsKey(listTabIndex)) {
                List tmpList = (List)tmp.get(listTabIndex);
                tmpList.add(ctrl);
                tmp.put(listTabIndex, tmpList);
            } else {
                ArrayList<ComponentInfo> tmpList = new ArrayList<ComponentInfo>();
                tmpList.add(ctrl);
                tmp.put(listTabIndex, tmpList);
                tmp1.add(listTabIndex);
            }
        } else {
            if (parent.getConstraint() instanceof Rectangle) {
                rowOrder = ((Rectangle)parent.getConstraint()).getY();
                x = ((Rectangle)parent.getConstraint()).getX();
            }
            if (tmp2.containsKey(new Double(rowOrder))) {
                List tmpList = (List)tmp2.get(new Double(rowOrder));
                boolean flag = false;
                for (int k = 0; k < tmpList.size(); ++k) {
                    ComponentInfo cInfo = ((ComponentInfo)tmpList.get(k)).getParent();
                    if (!(cInfo.getConstraint() instanceof Rectangle) || !(x < ((Rectangle)cInfo.getConstraint()).getX())) continue;
                    tmpList.add(k, ctrl);
                    flag = true;
                    break;
                }
                if (!flag) {
                    tmpList.add(ctrl);
                }
                tmp2.put(new Double(rowOrder), tmpList);
            } else {
                ArrayList<ComponentInfo> tmpList = new ArrayList<ComponentInfo>();
                tmpList.add(ctrl);
                tmp2.put(new Double(rowOrder), tmpList);
                tmp21.add(new Double(rowOrder));
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private ComponentInfo[] order(ComponentInfo cInfo) {
        if (cInfo == null) {
            return new ComponentInfo[0];
        }
        Object[] components = cInfo.getComponents().toArray();
        Arrays.sort(components, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof ComponentInfo && arg1 instanceof ComponentInfo) {
                    ComponentInfo info0 = (ComponentInfo)arg0;
                    ComponentInfo info1 = (ComponentInfo)arg1;
                    if (info0.getConstraint() instanceof Integer && info1.getConstraint() instanceof Integer) {
                        Integer index0 = (Integer)info0.getConstraint();
                        Integer index1 = (Integer)info1.getConstraint();
                        return index0.compareTo(index1);
                    }
                    return -1;
                }
                return -1;
            }
        });
        ComponentInfo[] cs = new ComponentInfo[components.length];
        System.arraycopy(components, 0, cs, 0, components.length);
        return cs;
    }

    @Override
    protected void okKDButton_actionPerformed(ActionEvent e) throws Exception {
        super.okKDButton_actionPerformed(e);
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            ComponentInfo componentInfo = (ComponentInfo)row.getUserObject();
            componentInfo.setTabIndex(i + 1);
        }
        this.getUIWindow().close();
    }

    @Override
    protected void reductionButton_actionPerformed(ActionEvent e) throws Exception {
        super.reductionButton_actionPerformed(e);
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            ComponentInfo componentInfo = (ComponentInfo)row.getUserObject();
            componentInfo.setTabIndex(0);
        }
        this.getUIWindow().close();
    }

    @Override
    protected void cancelKDButton_actionPerformed(ActionEvent e) throws Exception {
        super.cancelKDButton_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnUp_actionPerformed(e);
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex > 0) {
            IRow row1 = this.table.getRow(rowIndex);
            ComponentInfo omponentInfo = (ComponentInfo)row1.getUserObject();
            this.table.removeRow(rowIndex);
            IRow row = this.table.addRow(rowIndex - 1);
            row.getCell("nameColumn").setValue(row1.getCell("nameColumn").getValue());
            row.getCell("aliasColumn").setValue(row1.getCell("aliasColumn").getValue());
            row.setUserObject((Object)omponentInfo);
            this.table.getSelectManager().select(rowIndex - 1, 0);
        }
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnDown_actionPerformed(e);
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && rowIndex != this.table.getRowCount() - 1) {
            IRow row1 = this.table.getRow(rowIndex);
            ComponentInfo omponentInfo = (ComponentInfo)row1.getUserObject();
            this.table.removeRow(rowIndex);
            IRow row = this.table.addRow(rowIndex + 1);
            row.getCell("nameColumn").setValue(row1.getCell("nameColumn").getValue());
            row.getCell("aliasColumn").setValue(row1.getCell("aliasColumn").getValue());
            row.setUserObject((Object)omponentInfo);
            this.table.getSelectManager().select(rowIndex + 1, 0);
        }
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        super.btnTop_actionPerformed(e);
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex > 0) {
            IRow row1 = this.table.getRow(rowIndex);
            ComponentInfo omponentInfo = (ComponentInfo)row1.getUserObject();
            this.table.removeRow(rowIndex);
            IRow row = this.table.addRow(0);
            row.getCell("nameColumn").setValue(row1.getCell("nameColumn").getValue());
            row.getCell("aliasColumn").setValue(row1.getCell("aliasColumn").getValue());
            row.setUserObject((Object)omponentInfo);
            this.table.getSelectManager().select(0, 0);
        }
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        super.btnBottom_actionPerformed(e);
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && rowIndex != this.table.getRowCount() - 1) {
            IRow row1 = this.table.getRow(rowIndex);
            ComponentInfo omponentInfo = (ComponentInfo)row1.getUserObject();
            this.table.removeRow(rowIndex);
            IRow row = this.table.addRow(this.table.getRowCount());
            row.getCell("nameColumn").setValue(row1.getCell("nameColumn").getValue());
            row.getCell("aliasColumn").setValue(row1.getCell("aliasColumn").getValue());
            row.setUserObject((Object)omponentInfo);
            this.table.getSelectManager().select(this.table.getRowCount(), 0);
        }
    }

    @Override
    protected void btnAllSelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnAllSelect_actionPerformed(e);
        int j = this.table.getRowCount();
        for (int i = 0; i < j; ++i) {
            this.table.getRow(i).getCell("isSelect").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnAllUnselected_actionPerformed(ActionEvent e) throws Exception {
        super.btnAllUnselected_actionPerformed(e);
        int j = this.table.getRowCount();
        for (int i = 0; i < j; ++i) {
            this.table.getRow(i).getCell("isSelect").setValue((Object)Boolean.FALSE);
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }
}

