/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.swing.KDImageIcon;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.KDPictureViwer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.border.LineBorder;

public class KDPictureBox
extends KDPanel {
    private KDPictureViwer viwer = null;
    private IUIWindow uiWindow;
    private byte[] picture;
    private KDImageIcon icon;
    private KDLabel lbl;
    private KDPopupMenu popMenu;
    Action OpenAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                KDPictureBox.this.openViwer();
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
    };
    Action DeleteAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                KDPictureBox.this.setPicture(null);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
    };

    public KDPictureBox() throws Exception {
        this.initBox();
        this.addListener();
    }

    private void initBox() {
        UIContext uiContext = new UIContext();
        try {
            this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(KDPictureViwer.class.getName(), (Map)uiContext);
        }
        catch (UIException e) {
            e.printStackTrace();
        }
        this.icon = new KDImageIcon();
        this.lbl = new KDLabel();
        this.popMenu = new KDPopupMenu();
        JMenuItem menu1 = this.popMenu.add(this.OpenAction);
        menu1.setText("\u4e0a\u4f20\u56fe\u7247");
        JMenuItem menu2 = this.popMenu.add(this.DeleteAction);
        menu2.setText("\u5220\u9664\u56fe\u7247");
        this.lbl.setIcon((Icon)this.icon);
        this.lbl.setVisible(true);
        this.add((Component)this.lbl);
        LineBorder lineBorder = (LineBorder)BorderFactory.createLineBorder(Color.black);
        this.setBorder(lineBorder);
    }

    private void addListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    try {
                        KDPictureBox.this.openViwer();
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                } else if (e.getButton() == 3) {
                    KDPictureBox.this.showPopMenu(e.getX(), e.getY());
                }
            }
        });
        this.lbl.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    try {
                        KDPictureBox.this.openViwer();
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                } else if (e.getButton() == 3) {
                    KDPictureBox.this.showPopMenu(e.getX(), e.getY());
                }
            }
        });
    }

    private void showPopMenu(int x, int y) {
        this.popMenu.show((Component)((Object)this), x, y);
    }

    private void openViwer() throws Exception {
        this.viwer = (KDPictureViwer)this.uiWindow.getUIObject();
        if (this.picture != null) {
            this.viwer.showPicture(KDPictureViwer.getBufferedImgByByteArr(this.picture));
        } else {
            this.viwer.showPicture(null);
        }
        this.uiWindow.show();
        if (!this.viwer.canceled) {
            this.setPicture(this.viwer.getSrcImage());
        }
    }

    public KDPictureViwer getViwer() {
        return this.viwer;
    }

    public void setViwer(KDPictureViwer viwer) {
        this.viwer = viwer;
    }

    public byte[] getPicture() throws Exception {
        return this.picture;
    }

    public void setPicture(byte[] img) throws IOException {
        this.picture = img;
        this.remove((Component)this.lbl);
        this.repaint();
        this.icon = new KDImageIcon();
        if (this.picture != null) {
            this.icon.setImage((Image)KDPictureViwer.getBufferedImgByByteArr(this.picture));
        }
        this.lbl = new KDLabel();
        this.lbl.setBounds(5, 5, this.getParent().getWidth() - 110, this.getParent().getHeight() - 10);
        this.lbl.setIcon((Icon)this.icon);
        this.add((Component)this.lbl);
        this.addListener();
    }
}

