/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDImageIcon;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.AbstractKDPictureViwer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class KDPictureViwer
extends AbstractKDPictureViwer {
    private static final Logger logger = CoreUIObject.getLogger(KDPictureViwer.class);
    public byte[] srcImage = null;
    private KDImageIcon icon;
    private KDLabel lblPic;
    private JScrollPane scrollPane;
    private Image defaultImage;
    public boolean canceled;

    public byte[] getSrcImage() throws Exception {
        return this.srcImage;
    }

    public void setSrcImage(byte[] srcImage) throws IOException {
        this.srcImage = srcImage;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.defaultImage = this.getdefPic();
        this.icon = new KDImageIcon();
        this.icon.setImage(this.defaultImage);
        this.lblPic = new KDLabel((Icon)this.icon);
        this.scrollPane = new JScrollPane();
        LineBorder lineBorder = (LineBorder)BorderFactory.createLineBorder(Color.black);
        this.ImageSource.setBorder((Border)lineBorder);
        this.ImageSource.add((Component)this.scrollPane);
        this.scrollPane.setViewportView((Component)this.lblPic);
        this.ImageSource.setVisible(true);
        this.scrollPane.setBounds(2, 2, this.ImageSource.getWidth() - 5, this.ImageSource.getHeight() - 5);
    }

    @Override
    protected void CoreUI_mouseClicked(MouseEvent e) throws Exception {
        super.CoreUI_mouseClicked(e);
    }

    @Override
    protected void KDBrowser_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter((FileFilter)new photoFileFilter());
        fileChooser.showOpenDialog((Component)((Object)this));
        File selectFile = fileChooser.getSelectedFile();
        if (selectFile != null) {
            BufferedImage bufferedImg = ImageIO.read(selectFile);
            this.showPicture(bufferedImg);
        }
    }

    private Image getdefPic() throws IOException {
        URL url = KDPictureViwer.class.getResource("default.jpg");
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public void showPicture(BufferedImage bufferedImg) throws Exception {
        if (bufferedImg == null) {
            this.icon.setImage(this.defaultImage);
        } else {
            this.srcImage = KDPictureViwer.getImageBytesByBufferedImg(bufferedImg);
            this.icon.setImage((Image)bufferedImg);
        }
        int height = this.icon.getIconHeight();
        int width = this.icon.getIconWidth();
        this.lblPic.setBounds(0, 0, width, height);
        this.lblPic.setVisible(true);
        this.revalidate();
    }

    @Override
    protected void cancel_actionPerformed(ActionEvent e) throws Exception {
        this.canceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void sure_actionPerformed(ActionEvent e) throws Exception {
        this.canceled = false;
        this.getUIWindow().close();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    public static byte[] getImageBytesByBufferedImg(BufferedImage img) throws Exception {
        if (img != null) {
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "jpg", outs);
            return outs.toByteArray();
        }
        return null;
    }

    public static BufferedImage getBufferedImgByByteArr(byte[] img) throws IOException {
        if (img != null) {
            ByteArrayInputStream in = new ByteArrayInputStream(img);
            BufferedImage image = ImageIO.read(in);
            return image;
        }
        return null;
    }

    class photoFileFilter
    extends FileFilter {
        photoFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = FileUtil.getExtension((File)f);
            if (extension != null) {
                return extension.equals("gif") || extension.equals("jpeg") || extension.equals("jpg") || extension.equals("png");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "JPEG ( *.jpg;*.jpeg ), PNG, Gif";
        }
    }

    class photoFileNameFilter
    implements FilenameFilter {
        photoFileNameFilter() {
        }

        public boolean isTiff(String file) {
            return file.toLowerCase(Locale.ENGLISH).endsWith(".tiff");
        }

        public boolean isGif(String file) {
            return file.toLowerCase(Locale.ENGLISH).endsWith(".gif");
        }

        public boolean isJpg(String file) {
            return file.toLowerCase(Locale.ENGLISH).endsWith(".jpg");
        }

        public boolean isPng(String file) {
            return file.toLowerCase(Locale.ENGLISH).endsWith(".png");
        }

        @Override
        public boolean accept(File dir, String fname) {
            return this.isGif(fname) || this.isJpg(fname) || this.isPng(fname);
        }
    }
}

