/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.LibScriptFactory;
import com.kingdee.eas.ep.LibScriptInfo;
import com.kingdee.eas.ep.LibScriptTreeInfo;
import com.kingdee.eas.ep.client.AbstractLibScriptEditUI;
import com.kingdee.eas.ep.client.LibScriptUI;
import com.kingdee.eas.ep.client.ScriptArea;
import com.kingdee.eas.ep.client.ScriptPanel;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class LibScriptEditUI
extends AbstractLibScriptEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LibScriptEditUI.class);
    private ScriptArea txtContent = null;
    private String schemeID = null;
    private Project depend = null;
    private KDSplitPane panel = null;
    private LibScriptUI ui;
    private String parentNumber = null;

    public LibScriptEditUI() throws Exception {
        this.init();
    }

    private void init() {
        this.txtContent = new ScriptArea();
        this.dataBinder.registerBinding("content", String.class, (Component)((Object)this.txtContent), "text");
        this.contcontent.setBoundEditor((JComponent)((Object)new ScriptPanel(this.txtContent)));
    }

    private void inStallListeners() {
        this.ui.addLibScriptApply(new LibScriptUI.LibScriptApply(){

            @Override
            public void apply(LibScriptInfo item) {
                if (!LibScriptEditUI.this.txtContent.isEditable()) {
                    return;
                }
                StringBuffer script = new StringBuffer("$");
                script.append(item.getNumber());
                script.append(".");
                script.append(item.getName());
                int position = LibScriptEditUI.this.txtContent.getCaretPosition();
                LibScriptEditUI.this.txtContent.insert(script.toString(), position);
            }
        });
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibScriptEditUI.this.btnSubmit.getAction().actionPerformed(actionEvent);
            }
        };
        ActionMap actionMap = this.getActionMap();
        actionMap.put("CSTLSACTION", actionListener);
        KeyStroke controlAlt7 = KeyStroke.getKeyStroke(83, 2);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(controlAlt7, "CSTLSACTION");
        this.setActionMap(actionMap);
    }

    public void onLoad() throws Exception {
        this.schemeID = (String)this.getUIContext().get("SCHEME_ID");
        this.depend = (Project)this.getUIContext().get("PROJECT_DEPEND");
        super.onLoad();
        LibScriptTreeInfo tree = (LibScriptTreeInfo)this.getUIContext().get("ParentNode");
        if (tree != null && tree.getLongNumber() != null && tree.getLongNumber().startsWith("dep")) {
            this.parentNumber = tree.getLongNumber();
            this.btnRemove.setEnabled(false);
        }
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.txtContent.setEditable(false);
    }

    protected void unLockUI() {
        super.unLockUI();
        this.txtContent.setEditable(true);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("content"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("paramCount"));
        return selector;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LibScriptFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String regEx;
        Pattern p;
        Matcher m;
        String content = this.txtContent.getText();
        if (StringUtils.isEmpty((String)content)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
        }
        if (!(m = (p = Pattern.compile(regEx = "function\\s+.+\\(.*\\)\n*\\{")).matcher(content)).find()) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u4e0d\u6ee1\u8db3\u811a\u672c\u683c\u5f0f\uff08function fnName(a,b){...}\uff09");
            SysUtil.abort();
        }
        if ((m = (p = Pattern.compile(regEx = "\\$.+\n*\\..+\\(.+\\)")).matcher(content)).find()) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5e93\u811a\u672c\u4e4b\u95f4\u4e0d\u652f\u6301\u5f15\u7528");
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        String content = this.txtContent.getText();
        String function = content.substring(content.indexOf("function") + "function".length(), content.indexOf("{")).trim();
        String name = function.substring(0, function.indexOf("(")).trim();
        String params = function.substring(function.indexOf("(") + 1, function.indexOf(")"));
        int count = 0;
        if (!StringUtils.isEmpty((String)params)) {
            count = StringUtils.split((String)params, (String)",").length;
        }
        this.editData.setName(name);
        this.editData.setParamCount(count);
        String description = this.editData.getDescription();
        if (StringUtils.isEmpty((String)description)) {
            description = function;
        }
        this.editData.setDescription(description);
        if (this.parentNumber != null && this.parentNumber.startsWith("dep")) {
            this.editData.setSchemeID("always_on");
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    @Override
    protected IObjectValue createNewData() {
        LibScriptInfo objectValue = new LibScriptInfo();
        objectValue.setSchemeID(this.schemeID);
        LibScriptTreeInfo tree = (LibScriptTreeInfo)this.getUIContext().get("ParentNode");
        if (tree == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u6839\u8282\u70b9\u4e0d\u80fd\u65b0\u5efa\u811a\u672c");
            SysUtil.abort();
        }
        objectValue.put("treeid", tree);
        objectValue.setNumber(StringUtils.replace((String)tree.getLongNumber(), (String)"!", (String)"_"));
        return objectValue;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
    }
}

