/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.kdf.table.BasicView;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTViewManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.maintain.res.share.ResFile;
import com.kingdee.bos.maintain.res.share.Resource;
import com.kingdee.bos.maintain.res.share.client.ResShareCenterUI;
import com.kingdee.bos.maintain.res.share.client.ResShareNewUI;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.LibScriptCollection;
import com.kingdee.eas.ep.LibScriptFactory;
import com.kingdee.eas.ep.LibScriptInfo;
import com.kingdee.eas.ep.LibScriptTreeCollection;
import com.kingdee.eas.ep.LibScriptTreeFactory;
import com.kingdee.eas.ep.LibScriptTreeInfo;
import com.kingdee.eas.ep.client.AbstractLibScriptListUI;
import com.kingdee.eas.ep.client.LibScriptTreeEditUI;
import com.kingdee.eas.ep.client.ScriptArea;
import com.kingdee.eas.ep.client.ScriptPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.ep.depend.VersionManager;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class LibScriptListUI
extends AbstractLibScriptListUI {
    private static final Logger logger = CoreUIObject.getLogger(LibScriptListUI.class);
    public static final String SCHEME_ID = "SCHEME_ID";
    public static final String PROJECT_DEPEND = "PROJECT_DEPEND";
    public static final String METATYPE = "metaType";
    public static final String DEP = "dep";
    public static final String TREELONGNUMBER = "treeLongNumber:";
    public static final String TREEINFO = "treeInfo:";
    public static final String DEPSTANDARDFILENAME = "dep\u6807\u51c6\u811a\u672c.js";
    private ScriptArea txtContent = null;
    private String schemeID = null;
    private Project depend = null;
    private BOSObjectType metaType = null;
    private boolean isPermission = false;
    public static final String longNumberClientNode = "dep!client%";
    public static final String longNumberServerNode = "dep!server%";

    public LibScriptListUI() throws Exception {
        this.init();
    }

    private void init() {
        this.txtContent = new ScriptArea();
        this.txtContent.setEditable(false);
    }

    private void setBtnStatus() {
        this.chkIncludeChild.setVisible(true);
        if (CustomSchemeUtil.isSystemScheme(this.schemeID) || this.isPermission) {
            this.btnGroupAddNew.setEnabled(false);
            this.btnGroupEdit.setEnabled(false);
            this.btnGroupRemove.setEnabled(false);
            this.btnAddNew.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    private void setBtnsStatu() {
        int[] rowIndex;
        this.btnGroupAddNew.setEnabled(true);
        this.btnGroupEdit.setEnabled(true);
        this.btnGroupRemove.setEnabled(true);
        this.btnAddNew.setEnabled(false);
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            this.btnAddNew.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            String number = ((LibScriptTreeInfo)this.getSelectedTreeNode().getUserObject()).getLongNumber();
            if (number.startsWith(DEP) && !this.isPermission) {
                this.btnGroupAddNew.setEnabled(false);
                this.btnGroupEdit.setEnabled(false);
                this.btnGroupRemove.setEnabled(false);
                this.btnAddNew.setEnabled(false);
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
            } else if (number.startsWith(DEP) && this.isPermission) {
                this.btnGroupRemove.setEnabled(false);
                this.btnRemove.setEnabled(false);
            }
        } else if (this.getSelectedTreeNode() != null && !(this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) && (rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain)).length > 0) {
            IRow row = this.tblMain.getRow(rowIndex[0]);
            this.setBtnStatu((String)row.getCell("number").getValue());
        }
    }

    private void setBtnStatu(String number) {
        this.btnEdit.setEnabled(true);
        this.btnRemove.setEnabled(true);
        if (number.startsWith(DEP) && !this.isPermission) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else if (number.startsWith(DEP) && this.isPermission) {
            this.btnRemove.setEnabled(false);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.bottomPanel.add((Component)((Object)new ScriptPanel(this.txtContent)), (Object)"Center");
    }

    public void onLoad() throws Exception {
        this.schemeID = (String)this.getUIContext().get(SCHEME_ID);
        this.depend = (Project)this.getUIContext().get(PROJECT_DEPEND);
        this.metaType = (BOSObjectType)this.getUIContext().get(METATYPE);
        super.onLoad();
        this.setBtnStatus();
        this.regestKeyListener();
    }

    private void regestKeyListener() {
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!LibScriptListUI.this.isPermission) {
                        LibScriptListUI.this.isPermission = true;
                        LibScriptListUI.this.setBtnsStatu();
                    }
                    String oql = " where number like 'dep%'  and schemeID ='always_on' ";
                    LibScriptCollection libScriptCol = LibScriptFactory.getRemoteInstance().getLibScriptCollection(oql);
                    if (libScriptCol.size() > 0) {
                        LibScriptListUI.this.uploadScript(true);
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)"LibScriptListUI.scriptKeyListener", (Throwable)e1);
                }
            }
        };
        this.regestKeyStroke((JComponent)((Object)this), actionListener, 2);
        this.regestKeyStroke((JComponent)this.tblMain, actionListener, 0);
        KDTViewManager manager = this.tblMain.getViewManager();
        if (manager != null) {
            int n = manager.getViewCount();
            for (int i = 0; i < n; ++i) {
                BasicView view = manager.getView(i);
                this.regestKeyStroke((JComponent)view, actionListener, 0);
            }
        }
    }

    private void regestKeyStroke(JComponent comp, Action actionListener, int condition) {
        ActionMap actionMap = comp.getActionMap();
        actionMap.put("Key Action", actionListener);
        KeyStroke controlAltu = KeyStroke.getKeyStroke("alt U");
        InputMap inputMap = comp.getInputMap(condition);
        inputMap.put(controlAltu, "Key Action");
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        String number;
        super.treeMain_valueChanged(e);
        if (this.tblMain.getRowCount() <= 0) {
            String longNumber;
            this.txtContent.setText(null);
            this.btnUpload.setEnabled(false);
            if (!this.isIsIncludeChild() && this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo && !(longNumber = ((LibScriptTreeInfo)this.getSelectedTreeNode().getUserObject()).getLongNumber()).startsWith(DEP)) {
                String number2 = StringUtils.replace((String)longNumber, (String)"!", (String)"_");
                String oql = " where  number like '" + number2 + "%'  and schemeID ='" + this.schemeID + "' order by number ";
                LibScriptCollection libScriptCol = LibScriptFactory.getRemoteInstance().getLibScriptCollection(oql);
                if (libScriptCol.size() > 0) {
                    this.btnUpload.setEnabled(true);
                }
            }
        } else {
            this.btnUpload.setEnabled(true);
            if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
                number = ((LibScriptTreeInfo)this.getSelectedTreeNode().getUserObject()).getLongNumber();
                if (number.startsWith(DEP)) {
                    this.btnUpload.setEnabled(false);
                }
            } else {
                this.btnUpload.setEnabled(false);
            }
        }
        this.btnDownload.setEnabled(true);
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo && (number = ((LibScriptTreeInfo)this.getSelectedTreeNode().getUserObject()).getLongNumber()).startsWith(DEP)) {
            this.btnDownload.setEnabled(false);
        }
        this.setBtnsStatu();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        KDTSelectBlock b = e.getSelectBlock();
        int index = b.getBeginRow();
        IRow row = this.tblMain.getRow(index);
        if (row != null) {
            this.txtContent.setText((String)row.getCell("content").getValue());
            if (this.getSelectedTreeNode() != null && !(this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo)) {
                this.setBtnStatu((String)row.getCell("number").getValue());
            }
        } else {
            this.txtContent.setText(null);
        }
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            this.btnUpload.setEnabled(true);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (this.tblMain.getRowCount() <= 0) {
            this.btnUpload.setEnabled(false);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowIndex.length <= 0) {
            this.setSelectFirstRow(this.tblMain);
        }
    }

    @Override
    public void actionUpload_actionPerformed(ActionEvent e) throws Exception {
        this.uploadScript(false);
    }

    private void uploadScript(boolean isStandard) throws Exception {
        StringBuffer buffer = new StringBuffer();
        if (this.getSelectedTreeNode() == null) {
            return;
        }
        String longNumber = ((LibScriptTreeInfo)this.getSelectedTreeNode().getUserObject()).getLongNumber();
        String number = StringUtils.replace((String)longNumber, (String)"!", (String)"_");
        String oql = " where  number like '" + number + "%'  and schemeID ='" + this.schemeID + "' order by number ";
        String oqlTree = " where  longNumber like '" + longNumber + "%'  and schemeID ='" + this.schemeID + "' order by longNumber ";
        if (isStandard) {
            oql = " where number like 'dep%'  and schemeID ='always_on'  order by number ";
            oqlTree = " where longNumber like 'dep%'  and schemeID ='always_on' order by longNumber ";
        }
        LibScriptTreeCollection treeCol = LibScriptTreeFactory.getRemoteInstance().getLibScriptTreeCollection(oqlTree);
        int j = treeCol.size();
        for (int i = 0; i < j; ++i) {
            LibScriptTreeInfo libScriptTreeInfo = treeCol.get(i);
            buffer.append(TREEINFO + libScriptTreeInfo.getLongNumber());
            buffer.append("|");
            buffer.append(libScriptTreeInfo.getNumber());
            buffer.append("|");
            buffer.append(libScriptTreeInfo.getName());
            buffer.append("|");
            buffer.append(libScriptTreeInfo.getDescription());
            buffer.append("\n");
        }
        LibScriptCollection libScriptCol = LibScriptFactory.getRemoteInstance().getLibScriptCollection(oql);
        int j2 = libScriptCol.size();
        for (int i = 0; i < j2; ++i) {
            LibScriptInfo libScriptInfo = libScriptCol.get(i);
            buffer.append(TREELONGNUMBER + libScriptInfo.getNumber());
            buffer.append("|");
            buffer.append(libScriptInfo.getDescription());
            buffer.append("\n");
            buffer.append(libScriptInfo.getContent());
            buffer.append("\n");
        }
        Resource share = new Resource(number);
        ResFile file = new ResFile();
        file.fileName = isStandard ? DEPSTANDARDFILENAME : number + ".js";
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        String author = userInfo.getName();
        if (userInfo.getPerson() != null && !StringUtils.isEmpty((String)userInfo.getPerson().getName())) {
            author = userInfo.getPerson().getName();
        }
        file.fileContent = buffer.toString().getBytes("UTF-8");
        share.files.add(file);
        share.uname = author;
        share.id = longNumber;
        share.easver = String.valueOf(VersionManager.getPlatformVersion());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"type", (Object)"501");
        uiContext.put((Object)"share", (Object)share);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ResShareNewUI.class.getName(), (Map)uiContext);
        ResShareNewUI qfs = (ResShareNewUI)uiWindow.getUIObject();
        qfs.setUITitle("\u4e0a\u4f20\u51fd\u6570\u5230\u8d44\u6e90\u4e2d\u5fc3");
        uiWindow.show();
    }

    @Override
    public void actionDownload_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        TreePath path = this.treeMain.getSelectionPath();
        uiContext.put((Object)"type", (Object)"501");
        uiContext.put((Object)"selectTreeNode", (Object)this.getSelectedTreeNode());
        uiContext.put((Object)"schemeID", (Object)this.schemeID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ResShareCenterUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        this.initTree();
        this.treeMain.setSelectionPath(path);
        this.buildTreeFilter();
        this.execQuery();
        this.tblMain.setRefresh(true);
        this.setLocatePre(false);
        this.setSelectFirstRow(this.tblMain);
        this.setLocatePre(true);
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        if (MetaDataTypeList.UIOBJECT.equals((Object)this.metaType)) {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumberServerNode, CompareType.NOTLIKE));
        } else if (MetaDataTypeList.ENTITY.equals((Object)this.metaType)) {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumberClientNode, CompareType.NOTLIKE));
        }
        filter.getFilterItems().add(new FilterItemInfo("schemeID", (Object)this.schemeID));
        LibScriptListUI.getDefaultFilter(filter);
        return filter;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (MetaDataTypeList.UIOBJECT.equals((Object)this.metaType)) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)StringUtils.replace((String)longNumberServerNode, (String)"!", (String)"_"), CompareType.NOTLIKE));
        } else if (MetaDataTypeList.ENTITY.equals((Object)this.metaType)) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)StringUtils.replace((String)longNumberClientNode, (String)"!", (String)"_"), CompareType.NOTLIKE));
        }
        filter.getFilterItems().add(new FilterItemInfo("schemeID", (Object)this.schemeID));
        LibScriptListUI.getDefaultFilter(filter);
        return filter;
    }

    public static void getDefaultFilter(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("schemeID", (Object)"always_on"));
        int count = filter.getFilterItems().size();
        filter.setMaskString("");
        if (count > 0) {
            StringBuffer master = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                if (i == 1) {
                    master.append(" and (");
                } else if (i > 0) {
                    master.append(" OR ");
                }
                master.append("#");
                master.append(i);
                if (i != count - 1) continue;
                master.append(" )");
            }
            filter.setMaskString(master.toString());
        }
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareGroupUIContext(uiContext, e);
        uiContext.put((Object)PROJECT_DEPEND, (Object)this.depend);
        uiContext.put((Object)SCHEME_ID, (Object)this.schemeID);
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            uiContext.put((Object)"treeNode", this.getSelectedTreeNode().getUserObject());
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)PROJECT_DEPEND, (Object)this.depend);
        uiContext.put((Object)SCHEME_ID, (Object)this.schemeID);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LibScriptFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return LibScriptTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return LibScriptTreeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return "\u5305\u76ee\u5f55";
    }

    protected boolean canMoveDetailToRoot() {
        return false;
    }
}

