/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.LibScriptCollection;
import com.kingdee.eas.ep.LibScriptFactory;
import com.kingdee.eas.ep.LibScriptTreeFactory;
import com.kingdee.eas.ep.LibScriptTreeInfo;
import com.kingdee.eas.ep.client.LibScriptListUI;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class LibScriptTreeBuilder
implements ITreeBuilder {
    private String schemeID = null;
    private Project depend = null;
    private ILNTreeNodeCtrl ctrl = new DefaultLNTreeNodeCtrl((ITreeBase)LibScriptTreeFactory.getRemoteInstance());
    private int initalLevel = 3;
    private int expandLevel = 3;
    private BOSObjectType metaType = null;
    private SelectorItemCollection selector;

    public LibScriptTreeBuilder(String schemeID, Project depend, BOSObjectType metaType) throws Exception {
        this.schemeID = schemeID;
        this.depend = depend;
        this.metaType = metaType;
        this.selector = new SelectorItemCollection();
        this.selector.add(new SelectorItemInfo("*"));
    }

    public void setExpandLevel(int expandLevel) {
        this.expandLevel = expandLevel;
    }

    public KDTree buildTree(KDTree tree) throws Exception {
        if (tree == null) {
            tree = new KDTree(false);
        }
        KDTreeNode rootNode = new KDTreeNode((Object)"\u5305\u76ee\u5f55");
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)rootNode);
        tree.setShowsRootHandles(true);
        this.buildSchemeTree(tree, rootNode);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                    FilterInfo filter = LibScriptTreeBuilder.this.getTreeFilterInfo(treeNode);
                    if (filter != null) {
                        LibScriptTreeBuilder.this.getChildren(tree, treeNode, filter);
                    } else {
                        LibScriptTreeBuilder.this.getChildren(tree, treeNode);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                KDTree tree = (KDTree)e.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)e.getPath().getLastPathComponent();
                    FilterInfo filter = LibScriptTreeBuilder.this.getTreeFilterInfo(treeNode);
                    if (filter != null) {
                        LibScriptTreeBuilder.this.getChildren(tree, treeNode, filter);
                    } else {
                        LibScriptTreeBuilder.this.getChildren(tree, treeNode);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    private FilterInfo getTreeFilterInfo(KDTreeNode node) {
        FilterInfo filter = new FilterInfo();
        Object data = node.getUserObject();
        if (node == null || data == null) {
            return filter;
        }
        if (MetaDataTypeList.UIOBJECT.equals((Object)this.metaType)) {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)"dep!server%", CompareType.NOTLIKE));
        } else if (MetaDataTypeList.ENTITY.equals((Object)this.metaType)) {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)"dep!client%", CompareType.NOTLIKE));
        }
        if (data instanceof CustomizedSchemeInfo) {
            filter.getFilterItems().add(new FilterItemInfo("schemeID", (Object)((CustomizedSchemeInfo)data).getId()));
        } else if (data instanceof LibScriptTreeInfo) {
            filter.getFilterItems().add(new FilterItemInfo("schemeID", (Object)((LibScriptTreeInfo)data).getSchemeID()));
        }
        LibScriptListUI.getDefaultFilter(filter);
        return filter;
    }

    private void buildSchemeTree(KDTree tree, KDTreeNode rootNode) throws Exception {
        CustomizedSchemeInfo csi = CustomizedSchemeFactory.getRemoteInstance().getCustomizedSchemeInfo((IObjectPK)new ObjectUuidPK(this.schemeID));
        csi.setDisplayFormat("$alias");
        KDTreeNode sNode = new KDTreeNode((Object)csi);
        rootNode.add((MutableTreeNode)sNode);
        FilterInfo filter = this.getTreeFilterInfo(sNode);
        AbstractObjectCollection col = sNode.getUserObject() != null && sNode.getUserObject() instanceof TreeBaseInfo ? this.ctrl.getChildren((TreeBaseInfo)sNode.getUserObject(), this.initalLevel, filter, this.selector) : this.ctrl.getChildren(null, this.initalLevel, filter, this.selector);
        this.buildChildren(tree, sNode, col, this.initalLevel);
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    private void buildChildren(KDTree tree, KDTreeNode parentNode, AbstractObjectCollection col, int level) throws Exception {
        KDTreeNode beforeTreeNode = parentNode;
        TreeBaseInfo parentNodeInfo = null;
        if (parentNode.getUserObject() instanceof TreeBaseInfo) {
            parentNodeInfo = (TreeBaseInfo)parentNode.getUserObject();
        }
        for (TreeBaseInfo treeNodeInfo : col) {
            if (parentNodeInfo != null && treeNodeInfo.getLongNumber().equals(parentNodeInfo.getLongNumber())) {
                parentNode.setUserObject((Object)treeNodeInfo);
                continue;
            }
            KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
            if (treeNodeInfo.isIsLeaf() || treeNodeInfo.getLevel() < parentNode.getLevel() + level - 1) {
                treeNode.setVirtual(false);
                this.buildScriptTree(treeNode);
            } else {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
            }
            if (beforeTreeNode.getLevel() <= 1) {
                int index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            } else {
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((TreeBaseInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel && beforeTreeNode.getParent() != null; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
                int index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            }
            beforeTreeNode = treeNode;
        }
        this.buildScriptTree(parentNode);
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode);
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode, filter);
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel, filter);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    private void buildScriptTree(KDTreeNode node) throws Exception {
        if (node == null || !(node.getUserObject() instanceof LibScriptTreeInfo)) {
            return;
        }
        LibScriptTreeInfo tree = (LibScriptTreeInfo)node.getUserObject();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)tree.getId()));
        evi.setFilter(filter);
        SelectorItemCollection selector = evi.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("paramCount"));
        selector.add(new SelectorItemInfo("description"));
        LibScriptCollection col = LibScriptFactory.getRemoteInstance().getLibScriptCollection(evi);
        KDTreeNode n = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            n = new KDTreeNode((Object)col.get(i));
            node.add((MutableTreeNode)n);
        }
    }
}

