/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.LibScriptTreeFactory;
import com.kingdee.eas.ep.LibScriptTreeInfo;
import com.kingdee.eas.ep.client.AbstractLibScriptTreeEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LibScriptTreeEditUI
extends AbstractLibScriptTreeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LibScriptTreeEditUI.class);
    private String schemeID = null;
    private Project depend = null;
    private String parentNumber = null;

    public void onLoad() throws Exception {
        this.schemeID = (String)this.getUIContext().get("SCHEME_ID");
        this.depend = (Project)this.getUIContext().get("PROJECT_DEPEND");
        LibScriptTreeInfo tree = (LibScriptTreeInfo)this.getUIContext().get("treeNode");
        if (tree != null) {
            this.parentNumber = tree.getLongNumber();
        }
        super.onLoad();
        this.txtNumber.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.getNumericValue(e.getKeyChar()) == -1 && e.getKeyChar() != '\b') {
                    e.consume();
                }
            }
        });
        if (!StringUtils.isEmpty((String)this.parentNumber) && this.parentNumber.startsWith("dep")) {
            this.btnRemove.setEnabled(false);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LibScriptTreeFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("parent.id"));
        return selector;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String number = this.txtNumber.getText();
        String name = (String)this.txtName.getSelectedItemData();
        if (StringUtils.isEmpty((String)number)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5305\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)name)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
        }
        if (!this.isLetterAndDigit(number)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5305\u540d\u5fc5\u987b\u4e3a\u5b57\u6bcd\u3001\u6570\u5b57\u3001'_'\u4e4b\u95f4\u7684\u7ec4\u5408\uff0c\u6bd4\u5982eas_hr\uff0c\u4e14\u9996\u5b57\u7b26\u5fc5\u987b\u4e3a\u5b57\u6bcd");
            SysUtil.abort();
        }
        if (number.toLowerCase().contains("dep")) {
            MsgBox.showInfo((Component)((Object)this), (String)"\"dep\" \u662f\u7cfb\u7edf\u9884\u7559\u5173\u952e\u5b57  \uff0c \u5305\u540d\u4e2d\u4e0d\u80fd\u5305\u542b\u6b64\u5b57\u7b26\u4e32");
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    private boolean isLetterAndDigit(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return false;
        }
        String PROPERTY_REGEX = "[a-zA-Z]+[a-zA-Z0-9\\_]*";
        Pattern pattern = Pattern.compile(PROPERTY_REGEX);
        Matcher m = pattern.matcher(number);
        return m.matches();
    }

    @Override
    protected IObjectValue createNewData() {
        LibScriptTreeInfo objectValue = new LibScriptTreeInfo();
        if (this.parentNumber == null && "dep".equals(objectValue.getNumber()) || this.parentNumber != null && this.parentNumber.startsWith("dep")) {
            objectValue.setSchemeID("always_on");
        } else {
            objectValue.setSchemeID(this.schemeID);
        }
        return objectValue;
    }

    @Override
    protected void txtNumber_focusLost(FocusEvent e) throws Exception {
        super.txtNumber_focusLost(e);
        this.btnSubmit.setEnabled(true);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.btnSubmit.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (!"ADDNEW".equals(this.oprtState)) {
            return;
        }
        if (this.parentNumber == null && "dep".equals(this.editData.getNumber()) || this.parentNumber != null && this.parentNumber.startsWith("dep")) {
            this.editData.setSchemeID("always_on");
        }
    }
}

