/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.ILock;
import com.kingdee.eas.ep.LockFactory;
import com.kingdee.eas.ep.LockState;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.LockingUI;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.util.CryptoUtil;
import com.kingdee.util.StringUtils;
import java.util.Map;

public class LockManager {
    public static final String LOCKALIAS = "LockAlias";

    public LockState lock(Object owner, String pk) throws Exception {
        return this.lockAction(owner, pk, true);
    }

    private LockState lockAction(Object owner, String pk, boolean locking) throws Exception {
        LockState state = new LockState();
        state.setState(-1);
        UIContext uiContext = new UIContext(owner);
        if (!locking) {
            uiContext.put("NOT_DISPLAY_USER", Boolean.TRUE);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LockingUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        LockingUI ui = (LockingUI)uiWindow.getUIObject();
        if (!ui.isCancel()) {
            String alias = "";
            if (owner instanceof CoreUIObject && ((CoreUIObject)owner).getUIContext().containsKey(LOCKALIAS)) {
                alias = (String)((CoreUIObject)owner).getUIContext().get(LOCKALIAS);
            }
            IObjectPK logPK = LogUtil.beginLog(null, (String)"DEPLockingUI_lockAction", (BOSObjectType)BOSObjectType.create((String)"2C98D651"), (IObjectPK)new ObjectUuidPK(pk.contains("_") ? pk.substring(pk.lastIndexOf("_") + 1) : pk), (String)((locking ? "\u52a0\u9501" : "\u89e3\u9501") + "\u5bf9\u8c61\uff1a" + alias));
            String password = this.getEncryptPassword();
            String user = LockingUI.getUser();
            ILock lck = LockFactory.getRemoteInstance();
            LockState success = locking ? lck.lock(pk, password, user) : lck.unlock(pk, password);
            if (success.isSuccess()) {
                if (logPK != null) {
                    LogUtil.afterLog(null, (IObjectPK)logPK);
                }
                state.setState(1);
                return state;
            }
            state.setState(0);
            state.setUser(success.getUser());
            return state;
        }
        return state;
    }

    private String getEncryptPassword() throws Exception {
        String pass = LockingUI.getPassword();
        if (StringUtils.isEmpty((String)pass)) {
            return null;
        }
        pass = "00000000-0000-0000-0000-00000000000013B7DE7F" + pass.trim();
        return CryptoUtil.encrypt((String)pass);
    }

    public LockState unlock(Object owner, String pk) throws Exception {
        return this.lockAction(owner, pk, false);
    }

    public LockState unlockAll(Object owner, String pk) throws Exception {
        LockState state = new LockState();
        state.setState(-1);
        UIContext uiContext = new UIContext(owner);
        uiContext.put("NOT_DISPLAY_USER", Boolean.TRUE);
        uiContext.put("PASS_TIP", "\u8bf7\u8f93\u5165\u7ba1\u7406\u5458\u5bc6\u7801\u4f5c\u4e3a\u89e3\u9501\u53e3\u4ee4");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LockingUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        LockingUI ui = (LockingUI)uiWindow.getUIObject();
        if (!ui.isCancel()) {
            String alias = "";
            if (owner instanceof CoreUIObject && ((CoreUIObject)owner).getUIContext().containsKey(LOCKALIAS)) {
                alias = (String)((CoreUIObject)owner).getUIContext().get(LOCKALIAS);
            }
            IObjectPK logPK = LogUtil.beginLog(null, (String)"DEPLockingUI_unlockAll", (BOSObjectType)BOSObjectType.create((String)"2C98D651"), (IObjectPK)new ObjectUuidPK(pk.contains("_") ? pk.substring(pk.lastIndexOf("_") + 1) : pk), (String)("\u4f7f\u7528\u7ba1\u7406\u5458\u5bc6\u7801\u89e3\u9501\u5bf9\u8c61\uff1a" + alias));
            String pass = LockingUI.getPassword();
            UserInfo userInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
            boolean matchPassword = PermissionUtils.matchPasswordWithSecurity((UserInfo)userInfo, (String)pass);
            if (matchPassword) {
                ILock lck = LockFactory.getRemoteInstance();
                LockState success = lck.unlockAll(pk, "");
                if (success.isSuccess()) {
                    if (logPK != null) {
                        LogUtil.afterLog(null, (IObjectPK)logPK);
                    }
                    state.setState(1);
                    return state;
                }
                state.setState(0);
                state.setUser(success.getUser());
                return state;
            }
        }
        return state;
    }

    public LockState isLocked(Object owner, String pk) throws Exception {
        ILock lck = LockFactory.getRemoteInstance();
        String password = this.getEncryptPassword();
        LockState locked = lck.isLocked(pk, password);
        locked.setState(-1);
        int count = 0;
        while (locked.isLocked()) {
            UIContext uiContext = new UIContext(owner);
            uiContext.put("NOT_DISPLAY_USER", Boolean.TRUE);
            if (count > 0) {
                uiContext.put("PASS_TIP", "\u53e3\u4ee4\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LockingUI.class.getName(), (Map)uiContext);
            uiWindow.show();
            LockingUI ui = (LockingUI)uiWindow.getUIObject();
            if (!ui.isCancel()) {
                ++count;
                password = this.getEncryptPassword();
                locked = lck.isLocked(pk, password);
                if (locked.isLocked()) {
                    locked.setState(1);
                    continue;
                }
                locked.setState(0);
                return locked;
            }
            locked.setState(-1);
            return locked;
        }
        locked.setState(0);
        return locked;
    }

    public static String getLockPK(CustomizedUnitTreeNode node) {
        NodeTypeEnum type = node.getNodeType();
        if (NodeTypeEnum.ROOT.equals((Object)type)) {
            return node.getSchemeUnitID();
        }
        if (NodeTypeEnum.PERMISSION.equals((Object)type) || NodeTypeEnum.EXCEPTION.equals((Object)type) || NodeTypeEnum.CUSTOMIZED_UNIT.equals((Object)type)) {
            return node.getSchemeUnitID() + "_" + node.getUnitID();
        }
        if (NodeTypeEnum.ENTITY.equals((Object)type) || NodeTypeEnum.QUERY.equals((Object)type) || NodeTypeEnum.FACADE.equals((Object)type) || NodeTypeEnum.FUNCTION.equals((Object)type) || NodeTypeEnum.EDITUI.equals((Object)type) || NodeTypeEnum.LISTUI.equals((Object)type) || NodeTypeEnum.OTHERUI.equals((Object)type) || NodeTypeEnum.EDITUI_SCHEME.equals((Object)type) || NodeTypeEnum.LISTUI_SCHEME.equals((Object)type)) {
            return node.getSchemeUnitID() + "_" + node.getUnitID() + "_" + node.getMetadataPK();
        }
        return "NotDefined";
    }

    public static String getLockAlias(CustomizedUnitTreeNode node) {
        String lockAlias = "";
        while (node != null) {
            lockAlias = node.getText() + "_" + lockAlias;
            if (NodeTypeEnum.ROOT.equals((Object)node.getNodeType())) break;
            node = (CustomizedUnitTreeNode)((Object)node.getParent());
        }
        return lockAlias.substring(0, lockAlias.length() - 1);
    }
}

