/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.BOSObjectTypeEnum;
import com.kingdee.eas.ep.CustomizedSchemeCollection;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.AbstractMetaDataDebugUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class MetaDataDebugUI
extends AbstractMetaDataDebugUI {
    private static final Logger logger = CoreUIObject.getLogger(MetaDataDebugUI.class);
    private IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore(null);
    private IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
    private String F7_ACTION_KEY = "F7 Key Action";
    private String CTRLS_ACTION_KEY = "Ctrls Key Action";
    public static final String SELECTED_NODE = "selected node";
    private boolean isSaveMode = false;

    public void onLoad() throws Exception {
        super.onLoad();
        String schemeId = null;
        NodeTypeEnum nodeType = null;
        Object object = this.getUIContext().get(SELECTED_NODE);
        if (object instanceof CustomizedUnitTreeNode) {
            CustomizedUnitTreeNode selected = (CustomizedUnitTreeNode)((Object)object);
            this.txtPK.setText(selected.getMetadataPK());
            schemeId = selected.getCustomizedSchemeID();
            nodeType = selected.getNodeType();
        }
        CustomizedSchemeCollection collection = CustomizedSchemeFactory.getRemoteInstance().getCustomizedSchemeCollection();
        int size = collection.size();
        Object[] si = new SchemeInfo[size + 1];
        si[0] = new SchemeInfo("\u4e0d\u6307\u5b9a\u65b9\u6848", null, "");
        for (int i = 0; i < size; ++i) {
            CustomizedSchemeInfo info = collection.get(i);
            si[i + 1] = new SchemeInfo(info.getAlias(), info.getId().toString(), info.getName());
        }
        this.cmbProject.addItems(si);
        SchemeInfo schemeInfo = null;
        int length = this.cmbProject.getItemCount();
        for (int i = 0; i < length; ++i) {
            schemeInfo = (SchemeInfo)this.cmbProject.getItemAt(i);
            if (schemeInfo.getId() == null || !schemeInfo.getId().equals(schemeId)) continue;
            this.cmbProject.setSelectedIndex(i);
            break;
        }
        if (nodeType != null) {
            if (nodeType == NodeTypeEnum.ENTITY) {
                this.cmbType.setSelectedItem((Object)BOSObjectTypeEnum.ENTITY);
            } else if (nodeType == NodeTypeEnum.EDITUI || nodeType == NodeTypeEnum.LISTUI) {
                this.cmbType.setSelectedItem((Object)BOSObjectTypeEnum.UIOBJECT);
            } else if (nodeType == NodeTypeEnum.QUERY) {
                this.cmbType.setSelectedItem((Object)BOSObjectTypeEnum.JOINQUERY);
            } else if (nodeType == NodeTypeEnum.FUNCTION) {
                this.cmbType.setSelectedItem((Object)BOSObjectTypeEnum.FUNCTION);
            } else if (nodeType == NodeTypeEnum.FACADE) {
                this.cmbType.setSelectedItem((Object)BOSObjectTypeEnum.FACADE);
            } else if (nodeType == NodeTypeEnum.PERMISSION) {
                this.cmbType.setSelectedItem((Object)BOSObjectTypeEnum.PERMISSION);
            } else if (nodeType == NodeTypeEnum.ENUM) {
                this.cmbType.setSelectedItem((Object)BOSObjectTypeEnum.ENUM);
            }
        }
        AbstractAction f7Listener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetaDataDebugUI.this.setMetaDataSaveMode();
            }
        };
        AbstractAction ctrlSListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MetaDataDebugUI.this.btnSave.isVisible()) {
                    try {
                        MetaDataDebugUI.this.btnSave_actionPerformed(actionEvent);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handleError((Component)((Object)MetaDataDebugUI.this), e, "\u4fdd\u5b58\u51fa\u9519");
                    }
                }
            }
        };
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(1);
        actionMap.put(this.F7_ACTION_KEY, f7Listener);
        KeyStroke controlAlt7 = KeyStroke.getKeyStroke("F7");
        inputMap.put(controlAlt7, this.F7_ACTION_KEY);
        actionMap.put(this.CTRLS_ACTION_KEY, ctrlSListener);
        KeyStroke ctrls = KeyStroke.getKeyStroke(83, 2);
        inputMap.put(ctrls, this.CTRLS_ACTION_KEY);
        this.setActionMap(actionMap);
    }

    private void setMetaDataSaveMode() {
        this.btnSave.setVisible(!this.isSaveMode);
        this.txtInfo.setEditable(!this.isSaveMode);
        this.isSaveMode = !this.isSaveMode;
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        this.txtInfo.setText("");
        String pk = this.txtPK.getText();
        if (StringUtils.isEmpty((String)pk)) {
            MsgBox.showError((Component)((Object)this), (String)"\u60a8\u8981\u67e5\u8be2\u5143\u6570\u636e\u7684 PK \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        SchemeInfo si = (SchemeInfo)this.cmbProject.getSelectedItem();
        BOSObjectTypeEnum type = (BOSObjectTypeEnum)((Object)this.cmbType.getSelectedItem());
        BOSObjectType objType = BOSObjectType.create((String)type.getValue());
        try {
            if (StringUtils.isEmpty((String)si.getId())) {
                this.txtInfo.setText(this.mdstore.getXml((AbstractMetaDataValue)this.loader.get(objType, (IMetaDataPK)new MetaDataPK(pk))));
            } else {
                this.txtInfo.setText(this.mdstore.getXml(new Project(si.getId()), (IMetaDataPK)new MetaDataPK(pk), objType));
            }
        }
        catch (Exception ex) {
            this.txtInfo.setText("error when load metadata , please check whether it's not exist or metadata type you selected is not Correct.\r\n" + StringUtils.stackToString((Exception)ex));
            logger.error((Object)ex, (Throwable)ex);
        }
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        super.btnSave_actionPerformed(e);
        IMetadataStore mds = MetadataStoreFactory.getMetadataStore(null);
        String pk = this.txtPK.getText();
        SchemeInfo si = (SchemeInfo)this.cmbProject.getSelectedItem();
        BOSObjectTypeEnum type = (BOSObjectTypeEnum)((Object)this.cmbType.getSelectedItem());
        BOSObjectType objType = BOSObjectType.create((String)type.getValue());
        mds.saveXml(new Project(si.getId()), (IMetaDataPK)new MetaDataPK(pk), objType, this.txtInfo.getText());
        MsgBox.showInfo((Component)((Object)this), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    class SchemeInfo {
        private String name;
        private String alias;
        private String id;

        public SchemeInfo(String alias, String id, String name) {
            this.alias = alias;
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return StringUtils.isEmpty((String)this.alias) ? this.name : this.alias;
        }
    }
}

