/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.validate.IValidate;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.BOSObjectTypeEnum;
import com.kingdee.eas.ep.CustomizedSchemeCollection;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.AbstractMetadataCheckUI;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.client.validate.DynValidateListener;
import com.kingdee.eas.ep.client.validate.ValidateItem;
import com.kingdee.eas.ep.client.validate.ValidateList;
import com.kingdee.eas.ep.client.validate.VerifyOperator;
import com.kingdee.eas.ep.client.validate.VerifyReport;
import com.kingdee.eas.ep.client.validate.VerifyScene;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.log4j.Logger;

public class MetadataCheckUI
extends AbstractMetadataCheckUI {
    private static final Logger logger = CoreUIObject.getLogger(MetadataCheckUI.class);
    public static final String SELECTED_NODE = "selected node";
    private CustomizedUnitTreeNode selectedNode;
    private NodeTypeEnum nodeType;

    public void onLoad() throws Exception {
        super.onLoad();
        Object object = this.getUIContext().get(SELECTED_NODE);
        if (object != null && object instanceof CustomizedUnitTreeNode) {
            this.selectedNode = (CustomizedUnitTreeNode)((Object)object);
        }
        this.loadFields();
    }

    public MetadataCheckUI() throws Exception {
        this.cb_type.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.ep.BOSObjectTypeEnum").toArray());
        this.tb_message.setEditable(false);
        this.tf_scheme.setEditable(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        String metadatapk = this.selectedNode.getMetadataPK();
        if (StringUtils.isEmpty((String)metadatapk)) {
            return;
        }
        this.tf_pk.setText(metadatapk);
        NodeTypeEnum nodeType = this.selectedNode.getNodeType();
        if (nodeType != null) {
            if (NodeTypeEnum.ENTITY.equals((Object)nodeType)) {
                this.cb_type.setSelectedItem((Object)BOSObjectTypeEnum.ENTITY);
            } else if (NodeTypeEnum.EDITUI.equals((Object)nodeType) || NodeTypeEnum.LISTUI.equals((Object)nodeType)) {
                this.cb_type.setSelectedItem((Object)BOSObjectTypeEnum.UIOBJECT);
            } else if (NodeTypeEnum.QUERY.equals((Object)nodeType)) {
                this.cb_type.setSelectedItem((Object)BOSObjectTypeEnum.JOINQUERY);
            } else if (NodeTypeEnum.FUNCTION.equals((Object)nodeType)) {
                this.cb_type.setSelectedItem((Object)BOSObjectTypeEnum.FUNCTION);
            } else if (NodeTypeEnum.FACADE.equals((Object)nodeType)) {
                this.cb_type.setSelectedItem((Object)BOSObjectTypeEnum.FACADE);
            } else if (NodeTypeEnum.PERMISSION.equals((Object)nodeType)) {
                this.cb_type.setSelectedItem((Object)BOSObjectTypeEnum.PERMISSION);
            } else if (NodeTypeEnum.WEBEDITUI.equals((Object)nodeType) || NodeTypeEnum.WEBLISTUI.equals((Object)nodeType)) {
                this.cb_type.setSelectedItem((Object)BOSObjectTypeEnum.WEBUIOBJECT);
            } else if (NodeTypeEnum.ENUM.equals((Object)nodeType)) {
                this.cb_type.setSelectedItem((Object)BOSObjectTypeEnum.ENUM);
            }
        }
        StringBuffer projects = new StringBuffer();
        try {
            ICustomizedScheme schem = CustomizedSchemeFactory.getRemoteInstance();
            CustomizedSchemeCollection scCollection = schem.getCustomizedSchemeCollection("where id in (select fprojectid from T_CON_DynamicMetadata where fmetadatapk ='" + metadatapk + "')");
            if (scCollection != null) {
                for (int i = 0; i < scCollection.size(); ++i) {
                    CustomizedSchemeInfo csInfo = scCollection.get(i);
                    projects.append(csInfo.getName());
                    projects.append(";");
                }
            }
            if (projects.length() == 0) {
                String desc = "\u5f53\u524d\u65e0\u52a8\u6001\u6269\u5c55\u65b9\u6848\u4fee\u6539\u4e86\u6b64\u5143\u6570\u636e";
                this.tf_scheme.setText(desc);
            } else {
                String desc = "\u5f53\u524d\u4fee\u6539\u4e86\u6b64\u5143\u6570\u636e\u7684\u52a8\u6001\u6269\u5c55\u65b9\u6848\u6709 : ";
                this.tf_scheme.setText(desc + projects.toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)("error when loadfields : " + e.getMessage()));
        }
    }

    @Override
    protected void btn_validate_actionPerformed(ActionEvent e) throws Exception {
        VerifyReport report = new VerifyReport();
        DynValidateListener adapter = new DynValidateListener();
        report.registerListener(adapter);
        BOSObjectTypeEnum type = (BOSObjectTypeEnum)((Object)this.cb_type.getSelectedItem());
        BOSObjectType objType = BOSObjectType.create((String)type.getValue());
        IObjectValue vo = UictUtils.loadMD(objType, (IMetaDataPK)new MetaDataPK(this.tf_pk.getText().trim()));
        if (vo == null || vo instanceof AbstractMDValue && UictUtils.isEmptyMD((AbstractMDValue)vo)) {
            adapter.addError("error when load metadata , please check whether it's not exist or metadata type you selected is not Correct");
        } else {
            try {
                this.checkRefIntegrity(vo, report);
                com.kingdee.bos.metadata.validate.ValidateList validates = null;
                if (vo instanceof IValidate) {
                    validates = ((IValidate)vo).validate();
                }
                VerifyOperator operator = new VerifyOperator(report);
                operator.check(vo, VerifyScene.SAVA_SCENE);
                adapter.addValidates(validates);
            }
            catch (Exception ex) {
                adapter.addInfo("Occurd unknow error when checked ");
            }
        }
        this.resetMessages(adapter);
    }

    private void checkRefIntegrity(IObjectValue vo, VerifyReport report) {
        if (vo == null || vo instanceof AbstractMDValue && UictUtils.isEmptyMD((AbstractMDValue)vo)) {
            report.addError("error when load metadata , please check whether it's not exist or metadata type you selected is not Correct");
            return;
        }
        boolean isAbstract = false;
        if (vo instanceof EntityObjectInfo) {
            EntityObjectInfo en = (EntityObjectInfo)vo;
            isAbstract = en.isAbstract();
        }
        Stack<String> pathStack = new Stack<String>();
        pathStack.push("[ROOT]");
        EntityObjectInfo metaMeta = UictUtils.loadMD(vo.getBOSType());
        this.checkRefIntegrity(vo, metaMeta, isAbstract, pathStack, report);
    }

    private void resetMessages(DynValidateListener adapter) {
        this.tb_message.removeRows();
        if (adapter != null) {
            IRow row;
            String message;
            int i;
            ValidateList validates = adapter.getValidateList();
            ValidateItem[] items = validates.getItems();
            if (items.length == 0) {
                String message2 = " validate success ";
                IRow row2 = this.tb_message.addRow();
                row2.getCell(0).setValue((Object)message2);
                row2.getCell(1).setValue((Object)"info");
                return;
            }
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> fatals = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            block4: for (i = 0; i < items.length; ++i) {
                ValidateItem item = items[i];
                switch (item.getLevel()) {
                    case 1: {
                        if (errors.contains(item.getMessage())) continue block4;
                        errors.add(item.getMessage());
                        continue block4;
                    }
                    case 2: {
                        if (fatals.contains(item.getMessage())) continue block4;
                        fatals.add(item.getMessage());
                        continue block4;
                    }
                    default: {
                        if (warnings.contains(item.getMessage())) continue block4;
                        warnings.add(item.getMessage());
                    }
                }
            }
            for (i = 0; i < fatals.size(); ++i) {
                message = fatals.get(i).toString();
                row = this.tb_message.addRow();
                row.getCell(0).setValue((Object)message);
                row.getCell(1).setValue((Object)"fatal");
            }
            for (i = 0; i < errors.size(); ++i) {
                message = errors.get(i).toString();
                row = this.tb_message.addRow();
                row.getCell(0).setValue((Object)message);
                row.getCell(1).setValue((Object)"error");
            }
            for (i = 0; i < warnings.size(); ++i) {
                message = warnings.get(i).toString();
                row = this.tb_message.addRow();
                row.getCell(0).setValue((Object)message);
                row.getCell(1).setValue((Object)"warning");
            }
        }
    }

    private void checkRefIntegrity(IObjectValue ov, EntityObjectInfo meta, boolean isAbstract, Stack stack, VerifyReport report) {
        PropertyCollection props = meta.getInheritedProperties();
        PropertyInfo prop = null;
        LinkPropertyInfo linkProp = null;
        RelationshipInfo relation = null;
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            prop = props.get(i);
            if (!(prop instanceof LinkPropertyInfo) || !ov.containsKey(prop.getName())) continue;
            linkProp = (LinkPropertyInfo)prop;
            relation = linkProp.getRelationship();
            CardinalityType suppCaty = relation.getSupplierCardinality();
            if (suppCaty.equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || suppCaty.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
                EntityObjectInfo entity;
                IObjectValue o;
                int j;
                IObjectCollection oc = (IObjectCollection)ov.get(prop.getName());
                if (ov instanceof LogicalKeyInfo) {
                    for (j = 0; j < oc.size(); ++j) {
                        o = oc.getObject(j);
                        if (o.get("_state_") == null) continue;
                        try {
                            entity = UictUtils.loadMD(relation.getSupplierObject().getType());
                            stack.push(prop.getName() + "[" + this.keyString(entity, o) + "]");
                            this.processObjectNotExist(linkProp, relation, o, isAbstract, stack, report);
                            stack.pop();
                            continue;
                        }
                        catch (Exception e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                    }
                    continue;
                }
                for (j = 0; j < oc.size(); ++j) {
                    o = oc.getObject(j);
                    if (o.get("_state_") != null) {
                        try {
                            entity = UictUtils.loadMD(relation.getSupplierObject().getType());
                            stack.push(prop.getName() + "[" + this.keyString(entity, o) + "]");
                            this.processObjectNotExist(linkProp, relation, o, isAbstract, stack, report);
                            stack.pop();
                        }
                        catch (Exception e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                        continue;
                    }
                    try {
                        entity = UictUtils.loadMD(relation.getSupplierObject().getType());
                        if (relation.getType().equals((Object)RelationshipType.ASSOCIATION) || !relation.getType().equals((Object)RelationshipType.COMPOSITION)) continue;
                        stack.push(prop.getName() + "[" + this.keyString(entity, o) + "]");
                        this.checkRefIntegrity(o, entity, isAbstract, stack, report);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
                continue;
            }
            IObjectValue o = (IObjectValue)ov.get(prop.getName());
            if (o == null) continue;
            if (o.get("_state_") == null) {
                if (relation.getType().equals((Object)RelationshipType.ASSOCIATION) || !relation.getType().equals((Object)RelationshipType.COMPOSITION)) continue;
                stack.push(prop.getName());
                this.checkRefIntegrity(o, relation.getSupplierObject(), isAbstract, stack, report);
                continue;
            }
            stack.push(prop.getName());
            this.processObjectNotExist(linkProp, relation, o, isAbstract, stack, report);
            stack.pop();
        }
        stack.pop();
    }

    private void processObjectNotExist(LinkPropertyInfo linkProp, RelationshipInfo relation, IObjectValue o, boolean isAbstract, Stack stack, VerifyReport report) {
        if (isAbstract && "mappingField".equals(linkProp.getName()) && o instanceof ColumnInfo) {
            return;
        }
        report.addFatal("Reference Object {" + this.lineStack(stack) + "} not exists or not complete");
    }

    private String lineStack(Stack stack) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < stack.size(); ++i) {
            String ele = (String)stack.get(i);
            if (i > 0) {
                buff.append("->");
            }
            buff.append(ele);
        }
        return buff.toString();
    }

    private String keyString(EntityObjectInfo meta, IObjectValue ov) {
        StringBuffer buff = new StringBuffer();
        PropertyCollection pc = meta.getLogicalKey().getKeyPropertys();
        for (int i = 0; i < pc.size(); ++i) {
            PropertyInfo prop = pc.get(i);
            if (i > 0) {
                buff.append(",");
            }
            try {
                buff.append(prop.getName() + "=" + ov.getString(prop.getName()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buff.toString();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void cb_type_actionPerformed(ActionEvent e) throws Exception {
        super.cb_type_actionPerformed(e);
    }
}

