/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.bo.TransactionAttribute;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.client.AbstractMethodDefinitionUI;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.IEntityPanelListener;
import com.kingdee.eas.ep.client.SimpleMetaDataSelector;
import com.kingdee.eas.ep.client.util.DataTransUtils;
import com.kingdee.eas.ep.client.util.EditorCreator;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.tools.datatask.client.SimpleValueObjectInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class MethodDefinitionUI
extends AbstractMethodDefinitionUI
implements IEditorTabPanel {
    private static final Logger logger = CoreUIObject.getLogger(MethodDefinitionUI.class);
    private String customizedSchemeID;
    private Project depend;
    private AbstractMetaDataValue meta;
    private BOSObjectType metaType;
    private Set addListeners = new HashSet();
    private MethodInfo currentMethod = null;
    private int seq = 0;
    private boolean isDirty = false;
    private static final String METHOD_REGEX = "\\p{Lower}{1}\\p{ASCII}*";

    public MethodDefinitionUI(BOSObjectType metaType, AbstractMetaDataValue meta, String schemeID, Project depend) throws Exception {
        this.meta = meta;
        this.metaType = metaType;
        this.customizedSchemeID = schemeID;
        this.depend = depend;
        this.init();
    }

    public void setAddListeners(Set addListeners) {
        this.addListeners = addListeners;
    }

    public MethodDefinitionUI(EntityObjectInfo meta, String schemeID, Project depend) throws Exception {
        this(MetaDataTypeList.ENTITY, (AbstractMetaDataValue)meta, schemeID, depend);
    }

    @Override
    public void destory() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSave() throws Exception {
        Iterator iterator;
        this.isDirty = false;
        Set set = this.addListeners;
        synchronized (set) {
            iterator = new HashSet(this.addListeners).iterator();
        }
        while (iterator.hasNext()) {
            IEntityPanelListener listener = (IEntityPanelListener)iterator.next();
            listener.afterAddOrDel();
        }
    }

    @Override
    public void beforeSave() throws Exception {
        if (MetaDataTypeList.ENTITY.equals((Object)this.metaType)) {
            this.storeMethod(this.currentMethod);
        }
        this.verify();
    }

    MethodInfo createMethodInfo() {
        MethodInfo method = new MethodInfo();
        method.setName("newMethod" + this.seq++);
        method.setAlias(null);
        method.setDescription(null);
        method.setAccessLevel(AccessLevel.PUBLIC);
        method.setSubClassingMode(SubClassingMode.NORMAL);
        method.setTransactionAttribute(TransactionAttribute.REQUIRED);
        method.setConfigured(true);
        BizExceptionInfo exp = new BizExceptionInfo();
        exp.setPackage("com.kingdee.eas.common");
        exp.setName("EASBizException");
        method.getBizExceptions().add(exp);
        return method;
    }

    protected void verify() {
        if (MetaDataTypeList.ENTITY.equals((Object)this.metaType)) {
            EntityObjectInfo entity = (EntityObjectInfo)this.meta;
            MethodCollection methods = entity.getMethods();
            if (methods == null) {
                return;
            }
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                ParameterCollection parameters;
                MethodInfo methodInfo = methods.get(i);
                if (!methodInfo.isConfigured()) continue;
                String name = methodInfo.getName();
                if (!this.isLegalName(name)) {
                    MsgBox.showWarning((String)("\u65b9\u6cd5\u540d\u5fc5\u987b\u662f\u5408\u6cd5\u7684java\u6807\u8bc6\u7b26\u4e14\u9996\u5b57\u6bcd\u5c0f\u5199\u4e0d\u5141\u8bb8\u975eASCII\u5b57\u7b26 : \"" + methodInfo.getName() + "\""));
                    this.abort();
                }
                if ((parameters = methodInfo.getParameters()) == null) continue;
                int k = parameters.size();
                for (int j = 0; j < k; ++j) {
                    ParameterInfo param = parameters.get(j);
                    name = param.getName();
                    if (this.isLegalName(name)) continue;
                    MsgBox.showWarning((String)("\u65b9\u6cd5\u53c2\u6570\u540d\u5fc5\u987b\u662f\u5408\u6cd5\u7684java\u6807\u8bc6\u7b26\u4e14\u9996\u5b57\u6bcd\u5c0f\u5199\u4e0d\u5141\u8bb8\u975eASCII\u5b57\u7b26 : \"" + name + "\" @  \u65b9\u6cd5 : " + methodInfo.getName()));
                    this.abort();
                }
            }
        }
    }

    private boolean isLegalName(String name) {
        if (!StringUtils.isJavaIdentifier((String)name)) {
            return false;
        }
        Pattern pattern = Pattern.compile(METHOD_REGEX);
        Matcher m = pattern.matcher(name);
        return m.matches();
    }

    void storeMethod(MethodInfo method) {
        if (method == null) {
            return;
        }
        method.setName(this.txtName.getText());
        method.setAlias(this.txtAlias.getText());
        method.setDescription(this.txtDescription.getText());
        method.setAccessLevel((AccessLevel)this.cbAccessLevel.getSelectedItem());
        method.setSubClassingMode((SubClassingMode)this.cbInherit.getSelectedItem());
        method.setTransactionAttribute((TransactionAttribute)this.cbTransaction.getSelectedItem());
        String dataType = (String)this.cbReturnType.getSelectedItem();
        if ("ObjectValue".equals(dataType) || "ObjectCollection".equals(dataType)) {
            SimpleValueObjectInfo entity = (SimpleValueObjectInfo)this.prmtEntity.getData();
            if (entity != null) {
                method.setMetadataRef(entity.getValue());
            } else {
                String string = dataType = "ObjectValue".equals(dataType) ? "com.kingdee.bos.dao.IObjectValue" : "com.kingdee.bos.dao.IObjectCollection";
            }
        }
        if (dataType != null) {
            method.setDataType(dataType);
        }
        int size = this.tblParam.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblParam.getRow(i);
            this.storeParam(row);
        }
    }

    void storeParam(IRow row) {
        ParameterInfo param = (ParameterInfo)row.getUserObject();
        if (param == null) {
            return;
        }
        param.setName((String)row.getCell("name").getValue());
        param.setAlias((String)row.getCell("alias").getValue());
        String dataType = (String)row.getCell("type").getValue();
        if ("ObjectValue".equals(dataType) || "ObjectCollection".equals(dataType)) {
            SimpleValueObjectInfo entity = (SimpleValueObjectInfo)row.getCell("entity").getValue();
            if (entity != null) {
                param.setMetadataRef(entity.getValue());
            } else {
                dataType = "ObjectValue".equals(dataType) ? "com.kingdee.bos.dao.IObjectValue" : "com.kingdee.bos.dao.IObjectCollection";
            }
        }
        param.setDataType(dataType);
    }

    void loadMethod(MethodInfo method) {
        if (method == null) {
            return;
        }
        this.txtName.setText(method.getName());
        this.txtAlias.setText(method.getAlias());
        this.txtDescription.setText(method.getDescription());
        this.cbAccessLevel.setSelectedItem((Object)method.getAccessLevel());
        this.cbInherit.setSelectedItem((Object)method.getSubClassingMode());
        this.cbTransaction.setSelectedItem((Object)method.getTransactionAttribute());
        this.cbReturnType.setSelectedItem((Object)method.getDataType());
        String entity = method.getMetaDataRef();
        if (!StringUtils.isEmpty((String)entity)) {
            EntityObjectInfo me = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(entity), this.depend);
            this.prmtEntity.setData((Object)DataTransUtils.trans((AbstractMetaDataValue)me));
        }
        this.tblParam.removeRows();
        ParameterCollection params = method.getParameters();
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            ParameterInfo param = params.get(i);
            IRow row = this.tblParam.addRow();
            row.setUserObject((Object)param);
            row.getCell("name").setValue((Object)param.getName());
            row.getCell("alias").setValue((Object)param.getAlias());
            row.getCell("type").setValue((Object)param.getDataType());
            entity = param.getMetaDataRef();
            if (StringUtils.isEmpty((String)entity)) continue;
            EntityObjectInfo me = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(entity), this.depend);
            row.getCell("entity").setValue((Object)DataTransUtils.trans((AbstractMetaDataValue)me));
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.contMethods.addButton((JButton)this.btnAddMethod);
        this.contMethods.addButton((JButton)this.btnDelMethod);
    }

    private void init() {
        this.btnAddParam.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelParam.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnAddMethod.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDelMethod.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        MethodDefinitionUI.getCBEditor(this.cbAccessLevel, AccessLevel.class.getName(), false);
        MethodDefinitionUI.getCBEditor(this.cbInherit, SubClassingMode.class.getName(), false);
        MethodDefinitionUI.getCBEditor(this.cbTransaction, TransactionAttribute.class.getName(), false);
        this.prmtEntity.setSelector((KDPromptSelector)new SimpleMetaDataSelector((IUIObject)this, "bizentity", this.depend));
        this.prmtEntity.setEditable(false);
        this.prmtEntity.setEnabled(false);
        KDBizPromptBox prmtEntity1 = new KDBizPromptBox();
        prmtEntity1.setSelector((KDPromptSelector)new SimpleMetaDataSelector((IUIObject)this, "bizentity", this.depend));
        this.tblParam.checkParsed();
        this.tblParam.getColumn("entity").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtEntity1));
        this.tblParam.getColumn("type").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getDataTypeEditor(null)));
        EditorCreator.getDataTypeEditor(this.cbReturnType);
        this.lstMethods.setAutoscrolls(true);
        this.lstMethods.setSelectionMode(0);
        this.txtName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (MethodDefinitionUI.this.currentMethod != null) {
                    MethodDefinitionUI.this.currentMethod.setName(MethodDefinitionUI.this.txtName.getText());
                }
            }
        });
        this.cbReturnType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MethodDefinitionUI.this.prmtEntity.setData(null);
                Object item = e.getItem();
                MethodDefinitionUI.this.prmtEntity.setEnabled("ObjectValue".equals(item) || "ObjectCollection".equals(item));
            }
        });
        this.tblParam.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    if (MethodDefinitionUI.this.tblParam.getColumnIndex("type") == e.getColIndex()) {
                        MethodDefinitionUI.this.tblParam.getCell(e.getRowIndex(), "entity").setValue(null);
                        Object value = e.getValue();
                        MethodDefinitionUI.this.tblParam.getCell(e.getRowIndex(), "entity").getStyleAttributes().setLocked(!"ObjectValue".equals(value) && !"ObjectCollection".equals(value));
                    }
                }
                catch (Exception exc) {
                    MethodDefinitionUI.this.handUIException(exc);
                }
            }
        });
        this.lstMethods.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MethodDefinitionUI.this.storeMethod(MethodDefinitionUI.this.currentMethod);
                MethodDefinitionUI.this.currentMethod = (MethodInfo)MethodDefinitionUI.this.lstMethods.getSelectedValue();
                MethodDefinitionUI.this.loadMethod(MethodDefinitionUI.this.currentMethod);
            }
        });
        this.lstMethods.setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
    }

    @Override
    public void loadData() throws Exception {
        if (MetaDataTypeList.ENTITY.equals((Object)this.metaType)) {
            EntityObjectInfo entity = (EntityObjectInfo)this.meta;
            this.lstMethods.removeAllElements();
            MethodCollection methods = entity.getMethods();
            if (methods != null) {
                int size = methods.size();
                for (int i = 0; i < size; ++i) {
                    MethodInfo m = methods.get(i);
                    if (!m.isConfigured()) continue;
                    this.lstMethods.addElement((Object)m);
                }
            }
        }
    }

    public static KDComboBox getCBEditor(KDComboBox combo, String enumClassName, boolean isAddNull) {
        if (combo == null) {
            combo = new KDComboBox();
        }
        if (!StringUtils.isEmpty((String)enumClassName)) {
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            List enumList = EnumUtils.getEnumList((String)enumClassName);
            if (isAddNull) {
                model.addElement(null);
            }
            int size = enumList.size();
            for (int i = 0; i < size; ++i) {
                model.addElement(enumList.get(i));
            }
            combo.setModel(model);
        }
        return combo;
    }

    @Override
    public void setBosObjectType(BOSObjectType type) {
    }

    @Override
    public void setCustomizedSchemeID(String id) {
        this.customizedSchemeID = id;
    }

    @Override
    public void setDepends(Project depend) {
        this.depend = depend;
    }

    @Override
    public void setMetadataPK(String pk) {
    }

    @Override
    public CustomizedUnitUI getCustomizedUnitUI() {
        return null;
    }

    @Override
    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
    }

    @Override
    public void actionAddMethod_actionPerformed(ActionEvent e) throws Exception {
        MethodInfo method = this.createMethodInfo();
        this.lstMethods.addElement((Object)method);
        if (MetaDataTypeList.ENTITY.equals((Object)this.metaType)) {
            EntityObjectInfo entity = (EntityObjectInfo)this.meta;
            entity.getMethods().add(method);
        }
        this.isDirty = true;
    }

    @Override
    public void actionDelMethod_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstMethods.getSelectedIndex() < 0) {
            return;
        }
        MethodInfo m = (MethodInfo)this.lstMethods.getElement(this.lstMethods.getSelectedIndex());
        if (m == null) {
            return;
        }
        if (MetaDataTypeList.ENTITY.equals((Object)this.metaType)) {
            EntityObjectInfo entity = (EntityObjectInfo)this.meta;
            entity.getMethods().remove(m);
        }
        this.lstMethods.removeElement((Object)m);
        if (this.lstMethods.getElementCount() > 0) {
            this.lstMethods.setSelectedIndex(0);
        } else {
            this.txtName.setText(null);
            this.txtAlias.setText(null);
            this.txtDescription.setText(null);
            this.cbAccessLevel.setSelectedItem(null);
            this.cbInherit.setSelectedItem(null);
            this.cbTransaction.setSelectedItem(null);
            this.cbReturnType.setSelectedItem(null);
            this.prmtEntity.setData(null);
            this.tblParam.removeRows();
        }
        this.isDirty = true;
    }

    @Override
    public void actionAddParam_actionPerformed(ActionEvent e) throws Exception {
        ParameterInfo param = new ParameterInfo();
        IRow row = this.tblParam.addRow();
        row.setUserObject((Object)param);
        if (this.currentMethod != null) {
            this.currentMethod.getParameters().add(param);
        }
        this.isDirty = true;
    }

    @Override
    public void actionDelParam_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblParam);
        if (selectRows.length > 0) {
            IRow row = this.tblParam.removeRow(selectRows[0]);
            if (this.currentMethod != null) {
                this.currentMethod.getParameters().remove((ParameterInfo)row.getUserObject());
            }
        }
        this.isDirty = true;
    }

    @Override
    public void actionParamDown_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblParam);
        int count = this.tblParam.getRowCount();
        if (selectRows.length > 0 && selectRows[0] < count - 1) {
            IRow row = this.tblParam.removeRow(selectRows[0]);
            this.tblParam.addRow(selectRows[0] + 1, row);
            KDTableUtil.setSelectedRow((KDTable)this.tblParam, (int)(selectRows[0] + 1));
            if (this.currentMethod != null) {
                IObjectValue obj = this.currentMethod.getParameters().removeObject(selectRows[0]);
                this.currentMethod.getParameters().addObject(selectRows[0] + 1, obj);
            }
        }
    }

    @Override
    public void actionParamUp_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblParam);
        if (selectRows.length > 0 && selectRows[0] > 0) {
            IRow row = this.tblParam.removeRow(selectRows[0]);
            this.tblParam.addRow(selectRows[0] - 1, row);
            KDTableUtil.setSelectedRow((KDTable)this.tblParam, (int)(selectRows[0] - 1));
            if (this.currentMethod != null) {
                IObjectValue obj = this.currentMethod.getParameters().removeObject(selectRows[0]);
                this.currentMethod.getParameters().addObject(selectRows[0] - 1, obj);
            }
        }
    }

    @Override
    public Project getDepends() {
        return this.depend;
    }

    private static class CustomListCellRender
    extends DefaultKingdeeListCellRenderer {
        private CustomListCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ctrl = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            MethodInfo item = (MethodInfo)value;
            if (item.isConfigured()) {
                Color fc = Color.BLUE;
                Color bc = list.getBackground();
                if (isSelected) {
                    ctrl.setForeground(bc);
                    ctrl.setBackground(fc);
                } else {
                    ctrl.setForeground(fc);
                    ctrl.setBackground(bc);
                }
            }
            return ctrl;
        }
    }
}

