/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.ep.CustomizedSchemeCollection;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.client.AbstractNewCustomizedSchemeDialogUI;
import com.kingdee.eas.ep.client.ctrl.DependPromptBox;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NewCustomizedSchemeDialogUI
extends AbstractNewCustomizedSchemeDialogUI {
    private static final Logger logger = CoreUIObject.getLogger(NewCustomizedSchemeDialogUI.class);
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_VIEW = "VIEW";
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    private CustomizedSchemeInfo csInfo;

    public void onLoad() throws Exception {
        Map dataObjects;
        if (STATUS_VIEW.equals(this.oprtState)) {
            this.setAllInputDisabled();
        } else if (OprtState.EDIT.equals(this.oprtState) && (dataObjects = this.getDataObjects()) != null && dataObjects.get("InitDataObject") != null && dataObjects.get("InitDataObject") instanceof CustomizedSchemeInfo) {
            this.csInfo = (CustomizedSchemeInfo)dataObjects.get("InitDataObject");
        }
        this.txtName.setMaxLength(40);
        this.txtAlias.setMaxLength(40);
        this.txtDesc.setMaxLength(255);
        this.propDepend.setEditable(false);
        this.chkStart.setVisible(false);
        DependPromptBox selector = new DependPromptBox((IUIObject)this, (KDPromptBox)this.propDepend, this.csInfo);
        this.propDepend.setSelector((KDPromptSelector)selector);
        this.propDepend.setEnabledMultiSelection(true);
        this.propDepend.setDisplayFormat("$alias$");
        this.txtName.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                JTextField textField;
                if (Character.getNumericValue(e.getKeyChar()) == -1 && e.getKeyChar() != '\b') {
                    e.consume();
                }
                if ((textField = (JTextField)e.getSource()).getCaretPosition() == 0) {
                    e.setKeyChar(Character.toUpperCase(e.getKeyChar()));
                }
            }
        });
    }

    private boolean isLegalName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        String PROPERTY_REGEX = "[A-Z]+[a-zA-Z0-9]*";
        Pattern pattern = Pattern.compile(PROPERTY_REGEX);
        Matcher m = pattern.matcher(name);
        return m.matches();
    }

    private boolean validateInput() {
        String name = this.txtName.getText();
        if (StringUtils.isEmpty((String)name)) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        if (!this.isLegalName(this.txtName.getText())) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u540d\u79f0\u5fc5\u987b\u662f\u9996\u5b57\u6bcd\u5927\u5199\u7684\u5b57\u6bcd\u548c\u6570\u5b57\u7ec4\u5408\uff01");
            return false;
        }
        String alias = this.txtAlias.getText();
        if (StringUtils.isEmpty((String)alias)) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        try {
            ICustomizedScheme iCS = CustomizedSchemeFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("alias"));
            view.setSelector(selector);
            CoreBaseCollection collection = iCS.getCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                CustomizedSchemeInfo schemeInfo = (CustomizedSchemeInfo)collection.get(i);
                String name2 = schemeInfo.getName();
                if (name2 != null && name2.equalsIgnoreCase(name) && schemeInfo.getId() != null && !schemeInfo.getId().equals((Object)this.csInfo.getId())) {
                    ExceptionHandler.handleError((Component)((Object)this), null, "\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff01");
                    return false;
                }
                String alias2 = schemeInfo.getAlias();
                if (alias2 == null || !alias2.equalsIgnoreCase(alias) || schemeInfo.getId() == null || schemeInfo.getId().equals((Object)this.csInfo.getId())) continue;
                ExceptionHandler.handleError((Component)((Object)this), null, "\u65b9\u6848\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff01");
                return false;
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handleError((Component)((Object)this), e1, "\u8fdc\u7a0b\u8bbf\u95ee\u51fa\u9519");
            return false;
        }
        return true;
    }

    public void setData(CustomizedSchemeInfo csInfo) throws BOSException, EASBizException {
        this.csInfo = csInfo;
        this.txtName.setEditable(true);
        this.loadData();
    }

    public void loadData() {
        this.txtName.setText(this.csInfo.getName());
        this.txtAlias.setText(this.csInfo.getAlias());
        this.txtDesc.setText(this.csInfo.getDescription());
        this.chkStart.setSelected(this.csInfo.isStart());
        this.propDepend.setData((Object)this.getDepends(this.csInfo.getDepend()));
    }

    private CustomizedSchemeInfo[] getDepends(String ids) {
        if (!StringUtils.isEmpty((String)ids)) {
            try {
                String replace = ids.replace(';', ',');
                FilterInfo filter = new FilterInfo();
                FilterItemInfo item = new FilterItemInfo();
                item.setCompareType(CompareType.INCLUDE);
                item.setPropertyName("id");
                item.setCompareValue((Object)replace);
                filter.getFilterItems().add(item);
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                CustomizedSchemeCollection collection = CustomizedSchemeFactory.getRemoteInstance().getCustomizedSchemeCollection(view);
                CustomizedSchemeInfo[] schemes = new CustomizedSchemeInfo[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    schemes[i] = collection.get(i);
                }
                return schemes;
            }
            catch (BOSException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    protected void setAllInputDisabled() {
        this.txtName.setEnabled(false);
        this.txtAlias.setEnabled(false);
        this.txtDesc.setEnabled(false);
        this.chkStart.setEnabled(false);
        this.propDepend.setEnabled(false);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (STATUS_VIEW.equals(this.oprtState)) {
            this.EXIT_STATUS = CANCEL_EXIT;
            this.disposeUIWindow();
        }
        if (STATUS_ADDNEW.equals(this.oprtState)) {
            this.csInfo = new CustomizedSchemeInfo();
        }
        if (!this.validateInput()) {
            return;
        }
        this.csInfo.setName(this.txtName.getText());
        this.csInfo.setAlias(StringUtils.isEmpty((String)this.txtAlias.getText()) ? this.txtName.getText() : this.txtAlias.getText());
        this.csInfo.setDescription(this.txtDesc.getText());
        if (this.propDepend.getData() instanceof CustomizedSchemeInfo[]) {
            CustomizedSchemeInfo[] depends = (CustomizedSchemeInfo[])this.propDepend.getData();
            this.csInfo.setDepend(this.getDepend(depends));
        } else {
            this.csInfo.setDepend(null);
        }
        this.csInfo.setBuildNumber("CS_USERDEFINE");
        this.csInfo.setStart(this.chkStart.isSelected());
        ICustomizedScheme ics = CustomizedSchemeFactory.getRemoteInstance();
        IObjectPK logPK = null;
        logPK = this.csInfo.getId() == null ? LogUtil.beginLog(null, (String)"addNew", (BOSObjectType)this.csInfo.getBOSType(), null, (String)("\u65b0\u589e\u52a8\u6001\u6269\u5c55\u65b9\u6848\u3010" + this.csInfo.getAlias() + "\u3011")) : LogUtil.beginLog(null, (String)"update", (BOSObjectType)this.csInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(this.csInfo.getId()), (String)("\u4fee\u6539\u52a8\u6001\u6269\u5c55\u65b9\u6848\u3010" + this.csInfo.getAlias() + "\u3011"));
        IObjectPK pk = ics.submit(this.csInfo);
        if (logPK != null) {
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
        this.csInfo.setId(BOSUuid.read((String)pk.toString()));
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.disposeUIWindow();
    }

    private String getDepend(CustomizedSchemeInfo[] schemes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < schemes.length; ++i) {
            CustomizedSchemeInfo schemeInfo = schemes[i];
            buffer.append(schemeInfo.getId().toString());
            if (i == schemes.length - 1) continue;
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }
}

