/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.AbstractNewPermissionUI;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.NameListener;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NewEnumUI
extends AbstractNewPermissionUI {
    private static final Logger logger = CoreUIObject.getLogger(NewEnumUI.class);
    protected String customizedSchemedID;
    protected Project depend;
    private CustomizedUnitTreeNode parentNode;
    public static final String PARENTNODE = "parentnode";
    private CustomizedSchemeInfo csInfo = null;
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";

    public NewEnumUI() throws Exception {
        this.txtName.addKeyListener((KeyListener)new NameListener());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle("\u65b0\u589e\u679a\u4e3e");
        Map context = this.getUIContext();
        Object obj = context.get(PARENTNODE);
        if (obj != null && obj instanceof CustomizedUnitTreeNode) {
            this.parentNode = (CustomizedUnitTreeNode)((Object)obj);
        }
    }

    public void setCustomizedSchemedID(String customizedSchemedID) {
        this.customizedSchemedID = customizedSchemedID;
        try {
            this.csInfo = CustomizedSchemeFactory.getRemoteInstance().getCustomizedSchemeInfo((IObjectPK)new ObjectUuidPK(customizedSchemedID));
        }
        catch (Exception e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
    }

    public String getCustomizedSchemedID() {
        return this.customizedSchemedID;
    }

    public Project getDepend() {
        return this.depend;
    }

    public void setDepend(Project depend) {
        this.depend = depend;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.validateInput()) {
            return;
        }
        CustomizedUnitInfo unitInfo = this.createNewUnitInfo();
        BizEnumInfo pInfo = this.updatePermissionUnit(unitInfo);
        UictUtils.saveMetadata((AbstractMetaDataValue)pInfo, this.customizedSchemedID, this.depend);
        ICustomizedUnit bizInterface = CustomizedUnitFactory.getRemoteInstance();
        bizInterface.addnew((CoreBaseInfo)unitInfo);
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.disposeUIWindow();
    }

    private CustomizedUnitInfo createNewUnitInfo() {
        CustomizedUnitInfo cuInfo = new CustomizedUnitInfo();
        BOSUuid id = BOSUuid.create((BOSObjectType)cuInfo.getBOSType());
        cuInfo.setId(id);
        return cuInfo;
    }

    private BizEnumInfo updatePermissionUnit(CustomizedUnitInfo unitInfo) {
        String name = this.txtName.getText();
        String alias = this.txtAlias.getText();
        String longNumber = this.csInfo.getName() + "!" + name;
        String displayName = this.csInfo.getName() + "_" + name;
        BizEnumInfo enumInfo = new BizEnumInfo();
        enumInfo.setName(name);
        enumInfo.setAlias(alias);
        enumInfo.setDataType(BizEnumValueType.STRING);
        enumInfo.setDescription(this.txtDesc.getText());
        enumInfo.setPackage("com.kingdee.eas.custom");
        enumInfo.setClassName("com.kingdee.util.enums.DynamicEnum");
        enumInfo.setDynamic(true);
        unitInfo.setName(name);
        unitInfo.setDisplayName(displayName);
        unitInfo.setNumber(name);
        unitInfo.setLongNumber(longNumber);
        unitInfo.setAlias(alias);
        unitInfo.setNodeType(NodeTypeEnum.ENUM);
        unitInfo.setLevel(2);
        unitInfo.setIsLeaf(true);
        unitInfo.setMetaDataPK(enumInfo.getFullName());
        unitInfo.setParent((CustomizedUnitInfo)this.parentNode.getUserObject());
        unitInfo.setCustomizedSchemeID(this.csInfo.getId().toString());
        return enumInfo;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    private boolean validateInput() {
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        if (this.parentNode != null) {
            int n = this.parentNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeNode child = this.parentNode.getChildAt(i);
                if (!(child instanceof CustomizedUnitTreeNode)) continue;
                String text = ((CustomizedUnitTreeNode)((Object)child)).getText();
                if (!this.txtName.getText().equals(text)) continue;
                ExceptionHandler.handleError((Component)((Object)this), null, "\u540d\u79f0\u5df2\u5b58\u5728 \uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
                return false;
            }
        }
        return true;
    }

    public void setCustomizedUnitTreeNode(CustomizedUnitTreeNode parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }
}

