/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uict.RuleTypeEnum;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.BizConfigRes;
import com.kingdee.eas.ep.client.AbstractNewEventListUI;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.event.BizConfigEventDialog;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.BizEventDefHelper;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureEventCollection;
import com.kingdee.eas.ep.client.model.BizConfigureEventInfo;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class NewEventListUI
extends AbstractNewEventListUI {
    private static final Logger logger = CoreUIObject.getLogger(NewEventListUI.class);
    private BizConfigureItemInfo item;
    private Context context;
    private BizUnitInfo bizunit;

    @Override
    public void setDataObject(IObjectValue dataObject) {
        this.item = (BizConfigureItemInfo)dataObject;
    }

    @Override
    public void initUIContentLayout() {
        this.tblMain.checkParsed();
        this.btnEdit.setEnabled(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        super.initUIContentLayout();
    }

    public void setContext(Context context) {
        this.context = context;
        if (context != null) {
            this.bizunit = context.getEditorUI().getModel();
        }
    }

    @Override
    public void loadFields() {
        this.tblMain.removeRows();
        if (this.item != null) {
            this.tblMain.setUserObject((Object)this.item);
            BizConfigureEventCollection eventCollection = this.item.getConfigureEventCollection();
            if (eventCollection != null) {
                this.putDataToTable(eventCollection);
            }
        }
    }

    private void putDataToTable(BizConfigureEventCollection eventCollection) {
        BizConfigureEventInfo eventInfo = null;
        int m = eventCollection.size();
        for (int i = 0; i < m; ++i) {
            eventInfo = eventCollection.get(i);
            this.tblMain.addRow().setUserObject((Object)eventInfo);
            BindingUtility.setTableCellValue((KDTable)this.tblMain, (int)i, (String)"ruleName", (Object)eventInfo.getRuleName());
            BindingUtility.setTableCellValue((KDTable)this.tblMain, (int)i, (String)"ruleType", (Object)((RuleTypeEnum)RuleTypeEnum.getEnumMap().get(eventInfo.getRuleType())).getAlias());
            BindingUtility.setTableCellValue((KDTable)this.tblMain, (int)i, (String)"eventType", (Object)BizEventDefHelper.getLabelValueByEventType(eventInfo.getEventType().getName()));
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.showExistedEventDefinition();
    }

    private void showExistedEventDefinition() {
        try {
            BizConfigureEventInfo eventInfo = this.getSelectedEventInfo();
            if (eventInfo != null) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put("BIZ_CONFIG_EVENT_INFO", eventInfo);
                uiContext.put("BizConfigureItemInfo", this.tblMain.getUserObject());
                uiContext.put("BizFieldOwner", this.getBizFieldOwner(this.bizunit, this.item));
                uiContext.put("BizFieldInfo", this.getBizField(this.bizunit, this.item));
                this.showEventDefineDialog((Map)uiContext, Boolean.TRUE);
                this.autoSelect(eventInfo);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private BizConfigureEventInfo getSelectedEventInfo() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BizConfigRes.getString("BizConfigureEditUI.PLEASE_SELECT_EVENT_DEF"));
            return null;
        }
        int row = selectBlock.getEndRow();
        BizConfigureEventInfo eventInfo = (BizConfigureEventInfo)((Object)this.tblMain.getRow(row).getUserObject());
        return eventInfo;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        BizConfigureItemInfo bizConfigureItemInfo = (BizConfigureItemInfo)this.tblMain.getUserObject();
        BizConfigureTreeNode rootNode = (BizConfigureTreeNode)this.context.getEditorUI().getRootNode();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("BizConfigureItemInfo", bizConfigureItemInfo);
        uiContext.put("EVENT_RULE_COUNT", new Integer(EditUIEditorHelper.getEventRuleTotalCount(rootNode)));
        uiContext.put("BizFieldOwner", this.getBizFieldOwner(this.context.getEditorUI().getModel(), bizConfigureItemInfo));
        uiContext.put("BizFieldInfo", this.getBizField(this.context.getEditorUI().getModel(), bizConfigureItemInfo));
        this.showEventDefineDialog((Map)uiContext, Boolean.FALSE);
        int count = this.tblMain.getRowCount();
        if (count > 0) {
            this.tblMain.getSelectManager().select(count - 1, 0);
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        BizConfigureEventInfo eventInfo = this.getSelectedEventInfo();
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (eventInfo != null && MsgBox.showConfirm2New((Component)((Object)this), (String)BizConfigRes.getString("BizConfigureEditUI.WHETHER_DELETE_OR_NOT")) == 0) {
            AbstractBizConfigureItemInfo item = (AbstractBizConfigureItemInfo)this.tblMain.getUserObject();
            BizConfigureEventCollection eventCol = item.getConfigureEventCollection();
            eventCol.remove(eventInfo);
            this.refreshTableEventDef();
            if (rowIndex != null && rowIndex.length > 0) {
                int index = rowIndex[0];
                if (index == 0) {
                    this.tblMain.getSelectManager().select(0, 0);
                } else if (index > 0) {
                    this.tblMain.getSelectManager().select(0, 0);
                }
            }
        }
    }

    private void autoSelect(BizConfigureEventInfo event) {
        if (event == null) {
            if (this.tblMain.getRowCount() > 0) {
                this.tblMain.getSelectManager().select(0, 0);
            }
        } else {
            int n = this.tblMain.getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow row = this.tblMain.getRow(i);
                if (!event.equals(row.getUserObject())) continue;
                this.tblMain.getSelectManager().select(i, 0);
                return;
            }
        }
    }

    private void refreshTableEventDef() {
        BizConfigureEventCollection eventCollection;
        AbstractBizConfigureItemInfo item = (AbstractBizConfigureItemInfo)this.tblMain.getUserObject();
        this.tblMain.removeRows();
        if (item != null && (eventCollection = item.getConfigureEventCollection()) != null) {
            this.putDataToTable(eventCollection);
        }
    }

    private void showEventDefineDialog(Map uiContext, Boolean isModify) throws UIException {
        uiContext.put("BizUnitInfo", this.bizunit);
        uiContext.put("isModify", isModify);
        uiContext.put("OPRT_STATE", this.oprtState);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BizConfigEventDialog.class.getName(), uiContext);
        uiWindow.show();
        this.refreshTableEventDef();
    }

    private IObjectValue getBizFieldOwner(BizUnitInfo bizUnit, BizConfigureItemInfo item) {
        ComponentInfo entry = item.getEntry();
        if (entry != null) {
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(entry.getClassType())) {
                return BizUnitCtrl.getFieldByControlName((BizFieldCollection)bizUnit.getFields(), (String)entry.getName());
            }
            if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(entry.getClassType()) || "com.kingdee.bos.ctrl.web.DataGrid".equals(entry.getClassType())) {
                return this.getWebFieldByControlName(bizUnit, entry.getName());
            }
        }
        return bizUnit;
    }

    private BizFieldInfo getWebFieldByControlName(BizUnitInfo bizUnit, String name) {
        if (bizUnit == null || StringUtils.isEmpty((String)name)) {
            return null;
        }
        BizFieldCollection fields = bizUnit.getFields();
        if (fields == null) {
            return null;
        }
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (name.equalsIgnoreCase(bizField.getWebControlName())) {
                return bizField;
            }
            if (!(bizField instanceof BizGroupFieldInfo)) continue;
            BizFieldCollection subFields = ((BizGroupFieldInfo)bizField).getFields();
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                bizField = subFields.get(j);
                if (!name.equalsIgnoreCase(bizField.getWebControlName())) continue;
                return bizField;
            }
        }
        return null;
    }

    private BizFieldInfo getBizField(BizUnitInfo bizUnit, BizConfigureItemInfo item) {
        IObjectValue fieldOwner = this.getBizFieldOwner(bizUnit, item);
        if (item != null) {
            if (fieldOwner != null && fieldOwner instanceof BizGroupFieldInfo) {
                if (item instanceof BizConfigureItemInfo && item.getColumn() != null) {
                    return BizUnitCtrl.getFieldByControlName((BizFieldCollection)((BizGroupFieldInfo)fieldOwner).getFields(), (String)item.getColumn().getName());
                }
            } else {
                return BizUnitCtrl.getFieldByControlName((BizFieldCollection)bizUnit.getFields(), (String)item.getName());
            }
        }
        return null;
    }

    @Override
    protected void tableList_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        this.btnDelete.setEnabled(false);
        this.btnEdit.setEnabled(false);
        if (rowIndex != null && rowIndex.length > 0) {
            this.btnDelete.setEnabled(true);
            if (rowIndex.length == 1) {
                this.btnEdit.setEnabled(true);
            }
        }
    }
}

