/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.AbstractNewFloderDialogUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NewFloderDialogUI
extends AbstractNewFloderDialogUI {
    private static final Logger logger = CoreUIObject.getLogger(NewFloderDialogUI.class);
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    public static final String PARENTNODE = "parentnode";
    private CustomizedUnitTreeNode parentNode;
    private CustomizedUnitInfo dataObj;

    public NewFloderDialogUI() throws Exception {
        this.txtName.setMaxLength(60);
        this.txtDesc.setMaxLength(60);
    }

    private boolean validateInput() {
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        if (this.parentNode != null) {
            int n = this.parentNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeNode child = this.parentNode.getChildAt(i);
                if (!(child instanceof CustomizedUnitTreeNode)) continue;
                String text = ((CustomizedUnitTreeNode)((Object)child)).getText();
                if (!this.txtName.getText().equals(text) || (CustomizedUnitInfo)((CustomizedUnitTreeNode)((Object)child)).getUserObject() == this.dataObj) continue;
                ExceptionHandler.handleError((Component)((Object)this), null, "\u540d\u79f0\u5df2\u5b58\u5728 \uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
                return false;
            }
        }
        return true;
    }

    public void setCustomizedUnitInfo(CustomizedUnitInfo dataObj) {
        this.dataObj = dataObj;
        this.loadData();
    }

    public CustomizedUnitInfo getCustomizedUnitInfo() {
        return this.dataObj;
    }

    public void setCustomizedUnitTreeNode(CustomizedUnitTreeNode parentNode) {
        this.parentNode = parentNode;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map context = this.getUIContext();
        Object obj = context.get(PARENTNODE);
        if (obj != null && obj instanceof CustomizedUnitTreeNode) {
            this.parentNode = (CustomizedUnitTreeNode)((Object)obj);
        }
    }

    public void loadData() {
        if (this.dataObj != null) {
            this.txtName.setText(this.dataObj.getName());
            this.txtDesc.setText(this.dataObj.getDescription());
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.validateInput()) {
            return;
        }
        if (this.dataObj == null) {
            this.dataObj = new CustomizedUnitInfo();
        }
        this.dataObj.setName(this.txtName.getText());
        this.dataObj.setDisplayName(this.txtName.getText());
        this.dataObj.setDescription(this.txtDesc.getText());
        this.dataObj.setNodeType(NodeTypeEnum.FLODER);
        this.dataObj.setIsLeaf(false);
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }
}

