/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.EditUIConfigureFactory;
import com.kingdee.eas.ep.EditUIUserOrgUictCollection;
import com.kingdee.eas.ep.EditUIUserOrgUictFactory;
import com.kingdee.eas.ep.EditUIUserOrgUictInfo;
import com.kingdee.eas.ep.IEditUIConfigure;
import com.kingdee.eas.ep.IEditUIUserOrgUict;
import com.kingdee.eas.ep.client.AbstractNewUserOrgAssisgnUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class NewUserOrgAssisgnUI
extends AbstractNewUserOrgAssisgnUI {
    private static final Logger logger = CoreUIObject.getLogger(NewUserOrgAssisgnUI.class);
    private String bizpk = null;
    private String cfgid = null;
    public static final String UIOBJ_PK = "uiobjectpk";
    public static final String CONFIGURE_ID = "configureID";
    protected static final String COLUMN_USERNAME = "userName";
    protected static final String COLUMN_USERREALNAME = "userRealName";
    protected static final String COLUMN_ORGNUMBER = "orgNumber";
    protected static final String COLUMN_ORGNAME = "orgName";
    protected static final String COLUMN_UICONFIGNAME = "uiConfigName";
    protected static final String COLUMN_UICONFIGID = "uiConfigid";
    protected static final String COLUMN_USERORGUICTID = "userOrgUictID";
    protected static final String COLUMN_ORGUICTID = "OrgUictID";

    public void onLoad() throws Exception {
        this.getParameter();
        super.onLoad();
        this.tableAssisgn.checkParsed();
        this.tableAssisgn.getSelectManager().setSelectMode(10);
        this.tableAssisgn.getStyleAttributes().setLocked(true);
        this.loadTableData();
    }

    private void loadTableData() throws EASBizException, BOSException, Exception {
        this.tableAssisgn.removeRows();
        EditUIUserOrgUictCollection dataCollection = this.loadData();
        this.fillTable(dataCollection);
    }

    private EditUIUserOrgUictCollection loadData() throws BOSException {
        EditUIUserOrgUictCollection userUict = EditUIUserOrgUictFactory.getRemoteInstance().getEditUIUserOrgUictCollection("select id ,configure.id , configure.name , configure.number , user.id,user.name,user.number,org.id,org.number ,org.name where configure =  '" + this.cfgid + "' ");
        return userUict;
    }

    private void fillTable(EditUIUserOrgUictCollection dataCollection) {
        if (dataCollection != null) {
            int n = dataCollection.size();
            for (int i = 0; i < n; ++i) {
                String orgName;
                String orgNumber;
                String userName;
                String userNumber;
                EditUIUserOrgUictInfo data = dataCollection.get(i);
                IRow row = this.tableAssisgn.addRow();
                Color colr = new Color(255, 255, 255);
                if (data.getUser() == null) {
                    userName = userNumber = "\u6240\u6709\u7528\u6237";
                    colr = new Color(255, 246, 224);
                } else {
                    userNumber = data.getUser().getNumber();
                    userName = data.getUser().getName();
                }
                if (data.getOrg() == null) {
                    orgName = orgNumber = "\u6240\u6709\u7ec4\u7ec7";
                    colr = new Color(255, 246, 246);
                } else {
                    orgNumber = data.getOrg().getNumber();
                    orgName = data.getOrg().getName();
                }
                row.getCell(COLUMN_USERNAME).setValue((Object)userNumber);
                row.getCell(COLUMN_USERREALNAME).setValue((Object)userName);
                row.getCell(COLUMN_ORGNUMBER).setValue((Object)orgNumber);
                row.getCell(COLUMN_ORGNAME).setValue((Object)orgName);
                row.getCell(COLUMN_UICONFIGNAME).setValue((Object)data.getConfigure().getName());
                row.getCell(COLUMN_UICONFIGID).setValue((Object)data.getConfigure().getId());
                row.getCell(COLUMN_USERORGUICTID).setValue((Object)new ObjectUuidPK(data.getId()));
                row.getStyleAttributes().setBackground(colr);
            }
        }
    }

    private void getParameter() {
        this.bizpk = (String)this.getUIContext().get(UIOBJ_PK);
        this.cfgid = (String)this.getUIContext().get(CONFIGURE_ID);
    }

    @Override
    public void actionCancelAssign_actionPerformed(ActionEvent e) throws Exception {
        this.tableAssisgn.getSelectManager().getBlocks();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tableAssisgn);
        if (selectRows.length > 0) {
            ObjectUuidPK[] ids = new ObjectUuidPK[selectRows.length];
            for (int i = 0; i < selectRows.length; ++i) {
                int rowIndex = selectRows[i];
                IRow row = this.tableAssisgn.getRow(rowIndex);
                ids[i] = (ObjectUuidPK)row.getCell(COLUMN_USERORGUICTID).getValue();
            }
            IEditUIUserOrgUict instance = EditUIUserOrgUictFactory.getRemoteInstance();
            instance.delete((IObjectPK[])ids);
        }
        this.loadTableData();
    }

    protected IEditUIConfigure getBizInterface() throws Exception {
        return EditUIConfigureFactory.getRemoteInstance();
    }
}

