/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ui.face.AbstractUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.ep.client.ExtendMethodInterceptor;
import com.kingdee.eas.ep.client.UIParam;
import com.kingdee.eas.ep.plugin.PluginCacheClient;
import com.kingdee.eas.framework.client.customized.PlatformParam;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import org.apache.log4j.Logger;

public class PlugInProxyFactory {
    private static final Logger logger = Logger.getLogger(PlugInProxyFactory.class);
    private static Map cache = new HashMap();

    private PlugInProxyFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preLoad() {
        if (!PlatformParam.useCustomizedPlatform()) {
            return;
        }
        String eas_home = System.getProperty("EAS_HOME");
        String dir = eas_home + "/client/deploy/client/UIPreload.lst";
        String uiName = null;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            isr = new InputStreamReader(new FileInputStream(dir));
            reader = new BufferedReader(isr);
            String ui = reader.readLine();
            while (ui != null) {
                uiName = new String(ui.getBytes(), "UTF-8").trim();
                if (PlugInProxyFactory.isExtended(uiName)) {
                    PlugInProxyFactory.getUIObject(uiName);
                    logger.info((Object)("DEP PreLoaded UI: " + uiName));
                }
                ui = reader.readLine();
            }
        }
        catch (Exception e) {
            if (uiName != null) {
                logger.error((Object)("UIPreLoad Error: " + uiName), (Throwable)e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static IUIObject getUIObject(String uiName) throws UIException {
        Factory ui;
        Class sc = PlugInProxyFactory.getClass(uiName);
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(sc);
        enhancer.setClassLoader(sc.getClassLoader());
        enhancer.setUseFactory(true);
        enhancer.setCallbackTypes(new Class[]{ExtendMethodInterceptor.class});
        Class newClass = enhancer.createClass();
        cache.put(uiName, newClass);
        try {
            ui = (Factory)newClass.newInstance();
        }
        catch (Exception e) {
            throw new UIException(e.getMessage(), (Throwable)e);
        }
        ui.setCallbacks(new Callback[]{new ExtendMethodInterceptor()});
        return (IUIObject)ui;
    }

    public static IUIObject createUIObject(String uiName, UIParam param) throws UIException {
        if (!PlatformParam.useCustomizedPlatform() || !PlugInProxyFactory.isExtended(param.getMetaPK())) {
            return AbstractUIFactory.createUIObjectNoInit((String)uiName);
        }
        Callback[] callbacks = new Callback[]{new ExtendMethodInterceptor(param.getMetaPK(), param)};
        long millis = System.currentTimeMillis();
        Class newClass = (Class)cache.get(uiName);
        if (newClass == null) {
            Class sc = PlugInProxyFactory.getClass(uiName);
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(sc);
            enhancer.setClassLoader(sc.getClassLoader());
            enhancer.setUseFactory(true);
            enhancer.setCallbackTypes(new Class[]{ExtendMethodInterceptor.class});
            newClass = enhancer.createClass();
            cache.put(uiName, newClass);
        }
        Factory ui = null;
        try {
            ui = (Factory)newClass.newInstance();
            ui.setCallbacks(callbacks);
            logger.info((Object)("UI use plugin proxy. UIName is:" + ui.getClass().getName()));
            logger.info((Object)("Create UI Proxy use:" + (System.currentTimeMillis() - millis) + "ms"));
        }
        catch (Exception e) {
            throw new UIException(e.getMessage(), (Throwable)e);
        }
        return (IUIObject)ui;
    }

    public static boolean isExtended(String uiName) throws UIException {
        if (!StringUtils.isEmpty((String)uiName)) {
            try {
                return PluginCacheClient.isExtend(uiName);
            }
            catch (Exception e) {
                throw new UIException(e.getMessage(), e.getCause());
            }
        }
        return false;
    }

    private static Class getClass(String name) throws UIException {
        Class<?> c = null;
        try {
            try {
                c = Class.forName(name + "CTEx", false, AbstractUIFactory.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                try {
                    c = Class.forName(name + "PIEx", false, AbstractUIFactory.class.getClassLoader());
                }
                catch (ClassNotFoundException _) {
                    c = Class.forName(name);
                }
            }
        }
        catch (Exception e) {
            throw new UIException("Can not create ui object!", (Throwable)e);
        }
        return c;
    }
}

