/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.ep.client.AbstractPlugInUI;
import com.kingdee.eas.ep.client.DebugWindow;
import com.kingdee.eas.ep.client.DebuggerEvent;
import com.kingdee.eas.ep.client.EvaluatorUI;
import com.kingdee.eas.ep.client.ScriptUI;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class PlugInUI
extends AbstractPlugInUI
implements DebugWindow {
    private static final Logger logger = CoreUIObject.getLogger(PlugInUI.class);
    public static final Icon RESUME_ICON = new ImageIcon(PlugInUI.class.getResource("icon/resume_co.gif"));
    public static final Icon STEP_INTO_ICON = new ImageIcon(PlugInUI.class.getResource("icon/stepinto_co.gif"));
    public static final Icon STEP_OVER_ICON = new ImageIcon(PlugInUI.class.getResource("icon/stepover_co.gif"));
    public static final Icon STEP_RETURN_ICON = new ImageIcon(PlugInUI.class.getResource("icon/stepreturn_co.gif"));
    public static final Icon DEBUG_ICON = new ImageIcon(PlugInUI.class.getResource("icon/debug_exc.gif"));
    private IUIWindow parentWindow = null;
    private DebuggerEvent event = null;
    private volatile boolean end = false;
    private KDWorkButton btnMaxSize = null;
    private boolean isMax = false;
    private Rectangle winSize = null;

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnMaxSize = new KDWorkButton();
        this.btnMaxSize.setName("btnMaxSize");
        this.btnMaxSize.setIcon(EASResource.getIcon((String)"imgTbtn_suitbest"));
        this.btnMaxSize.setToolTipText("\u6700\u5927\u5316");
        this.toolBar.add((Component)this.btnMaxSize);
        this.btnMaxSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window dialog = ComponentUtil.getOwnerWindow(null);
                if (!PlugInUI.this.isMax) {
                    PlugInUI.this.winSize = dialog.getBounds();
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
                    Rectangle desktopBounds = new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom);
                    dialog.setBounds(0, 0, desktopBounds.width, desktopBounds.height);
                    dialog.validate();
                    PlugInUI.this.btnMaxSize.setIcon(EASResource.getIcon((String)"imgTbtn_trimsize"));
                    PlugInUI.this.btnMaxSize.setToolTipText("\u8fd8\u539f");
                } else {
                    dialog.setBounds(PlugInUI.this.winSize);
                    dialog.validate();
                    PlugInUI.this.btnMaxSize.setIcon(EASResource.getIcon((String)"imgTbtn_suitbest"));
                    PlugInUI.this.btnMaxSize.setToolTipText("\u6700\u5927\u5316");
                }
                PlugInUI.this.isMax = !PlugInUI.this.isMax;
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnGo.setIcon(RESUME_ICON);
        this.btnStepInto.setIcon(STEP_INTO_ICON);
        this.btnStepOut.setIcon(STEP_OVER_ICON);
        this.btnStepReturn.setIcon(STEP_RETURN_ICON);
        this.btnBreak.setIcon(DEBUG_ICON);
        this.btnBreak.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void actionBreak_actionPerformed(ActionEvent e) throws Exception {
        this.event.setBreak();
    }

    @Override
    public void actionGo_actionPerformed(ActionEvent e) throws Exception {
        this.event.go();
    }

    @Override
    public void actionStepInto_actionPerformed(ActionEvent e) throws Exception {
        this.event.stepInto();
    }

    @Override
    public void actionStepOut_actionPerformed(ActionEvent e) throws Exception {
        this.event.stepOut();
    }

    @Override
    public void actionStepReturn_actionPerformed(ActionEvent e) throws Exception {
        this.event.stepOver();
    }

    @Override
    public void debuggerEventPerformed(DebuggerEvent event) {
        event.register();
        this.event = event;
    }

    @Override
    public void addScriptUI(ScriptUI scriptUI, EvaluatorUI evaluatorUI) {
        if (scriptUI == null) {
            return;
        }
        this.split.add((Component)((Object)scriptUI), (Object)"top");
        if (evaluatorUI == null) {
            return;
        }
        this.split.add((Component)((Object)evaluatorUI), (Object)"bottom");
        this.doLayout();
    }

    protected boolean checkBeforeWindowClosing() {
        return this.end;
    }

    @Override
    public void close() {
        try {
            this.end = true;
            this.actionExitCurrent_actionPerformed(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void open() {
        this.end = false;
        this.parentWindow.show();
    }

    public void setWindow(IUIWindow w) {
        this.parentWindow = w;
    }
}

