/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.appframework.uistatemanage.ActionPluginCallBack;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.eas.ep.IPlugIn;
import com.kingdee.eas.ep.PlugInCollection;
import com.kingdee.eas.ep.PlugInFactory;
import com.kingdee.eas.ep.PlugInInfo;
import com.kingdee.eas.ep.PlugInScriptInfo;
import com.kingdee.eas.ep.client.UIParam;
import com.kingdee.eas.ep.plugin.ExtendMethodInfo;
import com.kingdee.eas.ep.plugin.PluginCacheClient;
import com.kingdee.eas.ep.plugin.PluginUtils;
import com.kingdee.eas.ep.plugin.ScriptExecutorFactotry;
import com.kingdee.eas.ep.plugin.ScriptInfo;
import com.kingdee.eas.ep.plugin.ScriptReference;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;

public class PluginService
implements IBindService,
ActionPluginCallBack {
    private static final Logger logger = Logger.getLogger(PluginService.class);
    private String metaName = null;
    private UIParam param = null;
    private CoreUIObject ui;

    public PluginService(String metaName) {
        this(metaName, null);
    }

    public PluginService(String metaName, UIParam param) {
        this.metaName = metaName;
        this.param = param;
    }

    public PluginService(CoreUIObject ui) {
        this(ui, null);
    }

    public PluginService(CoreUIObject ui, UIParam param) {
        this.ui = ui;
        this.setMetaName();
        this.param = param;
    }

    public void setUIParam(Object param) {
        this.param = (UIParam)param;
    }

    private void setMetaName() {
        if (this.ui != null && this.ui.getMetaDataPK() != null) {
            this.metaName = StringUtils.replace((String)this.ui.getMetaDataPK().toString(), (String)File.separator, (String)".");
        }
    }

    private String getMetaName() {
        if (this.metaName == null) {
            this.setMetaName();
        }
        return this.metaName;
    }

    public void beforeActionPerformed(Map serviceContext) throws Throwable {
        String metaName = this.getMetaName();
        if (!PluginCacheClient.isActionExtend(metaName)) {
            return;
        }
        Map uiContext = (Map)serviceContext.get("UICONTEXT");
        LowTimer t = new LowTimer();
        t.reset();
        IItemAction act = (IItemAction)serviceContext.get("ACTION");
        if (act != null) {
            String actionName = act.getClass().getName();
            actionName = actionName.indexOf("$") >= 0 ? actionName.substring(actionName.indexOf("$") + 1) : act.getItemAction().getActionName();
            PlugInCollection piCol = PluginCacheClient.getPlugin(metaName, PluginUtils.getExtendPoint(actionName));
            ExtendMethodInfo mInfo = PluginUtils.getExtendMethodInfo(actionName, act.getActionEvent());
            if (piCol != null) {
                PlugInInfo p = null;
                PlugInScriptInfo ps = null;
                String script = null;
                int size = piCol.size();
                for (int i = 0; i < size; ++i) {
                    p = piCol.get(i);
                    ps = p.getScriptBefore();
                    if (ps == null || StringUtils.isEmpty((String)(script = ScriptReference.getScript(null, ps)))) continue;
                    this.executeScript(this.param, mInfo, new ScriptInfo(script, ps.isDebug(), p.getSchemeID()));
                }
            }
            logger.info((Object)("Execute action script use time:" + t.msValue() + "ms"));
        }
    }

    public void afterActionPerformed(Map serviceContext) throws Throwable {
        String metaName = this.getMetaName();
        if (!PluginCacheClient.isActionExtend(metaName)) {
            return;
        }
        LowTimer t = new LowTimer();
        t.reset();
        IItemAction act = (IItemAction)serviceContext.get("ACTION");
        if (act != null) {
            String actionName = act.getClass().getName();
            actionName = actionName.indexOf("$") >= 0 ? actionName.substring(actionName.indexOf("$") + 1) : act.getItemAction().getActionName();
            IPlugIn ip = PlugInFactory.getRemoteInstance();
            PlugInCollection piCol = ip.getPlugIn(this.getMetaName(), PluginUtils.getExtendPoint(actionName));
            ExtendMethodInfo mInfo = PluginUtils.getExtendMethodInfo(actionName, act.getActionEvent());
            if (piCol != null) {
                PlugInInfo p = null;
                PlugInScriptInfo ps = null;
                String script = null;
                int size = piCol.size();
                for (int i = 0; i < size; ++i) {
                    p = piCol.get(i);
                    ps = p.getScriptAfter();
                    if (ps == null || StringUtils.isEmpty((String)(script = ScriptReference.getScript(null, ps)))) continue;
                    this.executeScript(this.param, mInfo, new ScriptInfo(script, ps.isDebug(), p.getSchemeID()));
                }
            }
            logger.info((Object)("Execute action script use time: " + t.msValue() + "ms"));
        }
    }

    protected Object executeScript(UIParam param, ExtendMethodInfo mInfo, ScriptInfo script) throws Exception {
        return ScriptExecutorFactotry.getClientInstance().execute(param, mInfo, script);
    }

    public void finalActionPerformed(Map serviceContext) throws Throwable {
    }
}

