/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ep.client.CustomFilterBuilder;
import com.kingdee.eas.ep.client.DataProviderSetting;
import com.kingdee.eas.ep.client.GetDataDialog;
import com.kingdee.eas.ep.client.GetDataTaskAdapter;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.HashSet;
import javax.swing.SwingUtilities;

public class PrintUtility {
    private CoreUI ui;
    private KDTable tblMain;
    private String keyField;
    private BizDataProvider bizProvider;
    protected final String DS_BASEINFO = "baseInfo";
    protected final String DS_APPROVEINFO = "approveInfo";

    public PrintUtility(CoreUI ui, KDTable tblMain, String keyField, BizDataProvider bizProvider) {
        this.ui = ui;
        this.tblMain = tblMain;
        this.keyField = keyField;
        this.bizProvider = bizProvider;
    }

    public void batchPrint(final boolean isPrintPreview) throws Exception {
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            @Override
            public Object exec() throws Exception {
                PrintUtility.this.execTaodaAction(isPrintPreview);
                return null;
            }
        });
        dlg.show();
    }

    private void execTaodaAction(boolean isPrintPreview) {
        KDNoteHelper noteHelper = new KDNoteHelper();
        DefaultNoteDataProvider dataProvider = this.getDefaultNoteDataProvider();
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        DataProviderSetting.addDataSource(dataProvider, this.getDataProviderSetting());
        if (isPrintPreview) {
            noteHelper.printPreview(this.bizProvider.getPrintPath(), (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)this.ui));
        } else {
            noteHelper.print(this.bizProvider.getPrintPath(), (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)this.ui), true);
        }
    }

    private DefaultNoteDataProvider getDefaultNoteDataProvider() {
        return new DefaultNoteDataProvider();
    }

    protected DataProviderSetting getDataProviderSetting() {
        String dsName = "baseInfo";
        String query = this.bizProvider.getPrintQuery(dsName);
        if (StringUtils.isEmpty((String)query)) {
            return null;
        }
        DataProviderSetting mainDs = new DataProviderSetting(dsName);
        mainDs.setQueryPK((IMetaDataPK)new MetaDataPK(query));
        mainDs.setFilter(new DataProviderSetting.ICustomFilter(){

            @Override
            public void build(CustomFilterBuilder builder) {
                builder.setFilter(PrintUtility.this.getSelectedBillIDFilter("baseInfo"));
            }
        });
        dsName = "approveInfo";
        query = this.bizProvider.getPrintQuery(dsName);
        if (!StringUtils.isEmpty((String)query)) {
            DataProviderSetting subDs = new DataProviderSetting(dsName);
            subDs.setQueryPK((IMetaDataPK)new MetaDataPK(query));
            subDs.setForeignKey(this.bizProvider.getPrintQueryBillID(dsName));
            mainDs.append(subDs);
        }
        return mainDs;
    }

    private FilterInfo getSelectedBillIDFilter(String dsName) {
        FilterInfo filter = new FilterInfo();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length <= 0) {
            return filter;
        }
        IRow row = null;
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < selectRows.length; ++i) {
            row = this.tblMain.getRow(selectRows[i]);
            set.add(row.getCell(this.keyField).getValue());
        }
        filter.getFilterItems().add(new FilterItemInfo(this.bizProvider.getPrintQueryBillID(dsName), set, CompareType.INCLUDE));
        return filter;
    }

    static interface BizDataProvider {
        public String getPrintPath();

        public String getPrintQuery(String var1);

        public String getPrintQueryBillID(String var1);
    }
}

