/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.eas.ep.client.DebugWindow;
import com.kingdee.eas.ep.client.DebuggerEvent;
import com.kingdee.eas.ep.client.EvaluatorUI;
import com.kingdee.eas.ep.client.PlugInUI;
import com.kingdee.eas.ep.client.ScriptUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToolBar;

class RemoteDebugUI
extends JFrame
implements DebugWindow,
ActionListener {
    private JToolBar toolBar;
    private DebuggerEvent event = null;
    private KDPanel contentPane = null;
    private KDSplitPane split = null;

    RemoteDebugUI() {
        this.init();
    }

    private void init() {
        JButton stepOutButton;
        JButton stepOverButton;
        JButton stepIntoButton;
        JButton goButton;
        JButton breakButton;
        this.toolBar = new JToolBar();
        String[] toolTips = new String[]{"\u8bbe\u7f6e\u65ad\u70b9", "\u7ee7\u7eed\u6267\u884c", "\u5355\u6b65\u8df3\u5165", "\u5355\u6b65\u8fd4\u56de", "\u5355\u6b65\u8df3\u8fc7"};
        int count = 0;
        JButton button = breakButton = new JButton("\u8bbe\u7f6e\u65ad\u70b9");
        button.setActionCommand("Break");
        button.setEnabled(false);
        button.setToolTipText(toolTips[count++]);
        button.setVisible(false);
        button.addActionListener(this);
        button.setIcon(PlugInUI.DEBUG_ICON);
        button = goButton = new JButton("\u7ee7\u7eed\u6267\u884c");
        button.setActionCommand("Go");
        button.setEnabled(true);
        button.setToolTipText(toolTips[count++]);
        button.addActionListener(this);
        button.setIcon(PlugInUI.RESUME_ICON);
        button = stepIntoButton = new JButton("\u5355\u6b65\u8df3\u5165");
        button.setActionCommand("Step Into");
        button.setEnabled(true);
        button.setToolTipText(toolTips[count++]);
        button.addActionListener(this);
        button.setIcon(PlugInUI.STEP_INTO_ICON);
        button = stepOverButton = new JButton("\u5355\u6b65\u8fd4\u56de");
        button.setActionCommand("Step Over");
        button.setEnabled(true);
        button.setToolTipText(toolTips[count++]);
        button.addActionListener(this);
        button.setIcon(PlugInUI.STEP_OVER_ICON);
        button = stepOutButton = new JButton("\u5355\u6b65\u8df3\u8fc7");
        button.setActionCommand("Step Out");
        button.setEnabled(true);
        button.setToolTipText(toolTips[count++]);
        button.addActionListener(this);
        button.setIcon(PlugInUI.STEP_RETURN_ICON);
        Dimension dim = stepOverButton.getPreferredSize();
        breakButton.setPreferredSize(dim);
        breakButton.setMinimumSize(dim);
        breakButton.setMaximumSize(dim);
        breakButton.setSize(dim);
        goButton.setPreferredSize(dim);
        goButton.setMinimumSize(dim);
        goButton.setMaximumSize(dim);
        stepIntoButton.setPreferredSize(dim);
        stepIntoButton.setMinimumSize(dim);
        stepIntoButton.setMaximumSize(dim);
        stepOverButton.setPreferredSize(dim);
        stepOverButton.setMinimumSize(dim);
        stepOverButton.setMaximumSize(dim);
        stepOutButton.setPreferredSize(dim);
        stepOutButton.setMinimumSize(dim);
        stepOutButton.setMaximumSize(dim);
        this.toolBar.add(breakButton);
        this.toolBar.add(goButton);
        this.toolBar.add(stepIntoButton);
        this.toolBar.add(stepOverButton);
        this.toolBar.add(stepOutButton);
        this.contentPane = new KDPanel();
        this.contentPane.setLayout((LayoutManager)new KDLayout());
        this.contentPane.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 600, 500));
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.contentPane, "Center");
        this.setTitle("EAS\u6269\u5c55\u811a\u672c\u8fdc\u7a0b\u8c03\u8bd5\u5ba2\u6237\u7aef");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (this.event != null) {
                this.event.go();
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    @Override
    public void addScriptUI(ScriptUI scriptUI, EvaluatorUI evaluatorUI) {
        if (this.split != null) {
            this.contentPane.remove((Component)this.split);
        }
        this.split = new KDSplitPane(0);
        this.split.setName("split");
        this.split.setOneTouchExpandable(true);
        this.split.setDividerLocation(350);
        this.split.setBounds(new Rectangle(0, 0, 600, 500));
        this.contentPane.add((Component)this.split, (Object)new KDLayout.Constraints(0, 0, 600, 500, 15));
        if (scriptUI == null) {
            return;
        }
        this.split.add((Component)((Object)scriptUI), (Object)"top");
        if (evaluatorUI == null) {
            return;
        }
        this.split.add((Component)((Object)evaluatorUI), (Object)"bottom");
        this.repaint();
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    @Override
    public void debuggerEventPerformed(DebuggerEvent event) {
        this.event = event;
    }

    @Override
    public void open() {
        this.setSize(620, 550);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (this.event == null) {
            return;
        }
        if (cmd.equals("Step Over")) {
            this.event.stepOver();
        } else if (cmd.equals("Step Into")) {
            this.event.stepInto();
        } else if (cmd.equals("Step Out")) {
            this.event.stepOut();
        } else if (cmd.equals("Go")) {
            this.event.go();
        } else if (cmd.equals("Break")) {
            this.event.setBreak();
        }
    }
}

