/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.eas.ep.RemoteDebugStub;
import com.kingdee.eas.ep.client.DebugCallback;
import com.kingdee.eas.ep.client.DebugWindow;
import com.kingdee.eas.ep.client.DebuggerEvent;
import com.kingdee.eas.ep.client.EvaluatorUI;
import com.kingdee.eas.ep.client.RemoteDebugManager;
import com.kingdee.eas.ep.client.ScriptUI;
import com.kingdee.eas.ep.debug.IDebugger;
import com.kingdee.eas.ep.debug.RemoteGuiCallback;
import com.kingdee.eas.ep.lightRemote.RemoteContext;
import javax.swing.SwingUtilities;

public class RemoteScriptUI
extends ScriptUI
implements RemoteGuiCallback {
    private RemoteDebugStub stub = null;
    private DebugWindow window = null;

    public RemoteScriptUI(Long key) {
        this.stub = new RemoteDebugStub(key);
        this.stub.setDebugUI(this);
        RemoteContext ctx = RemoteDebugManager.getContext();
        final IDebugger debugger = ctx != null ? (IDebugger)ctx.createObject("com.kingdee.eas.ep.debug.DebuggerProxy", IDebugger.class, new Class[]{Long.class}, new Object[]{key}) : null;
        this.stub.setDebugger(debugger);
        this.window = RemoteDebugManager.getDebugWindow();
        this.window.debuggerEventPerformed(new DebuggerEvent(debugger, this));
        EvaluatorUI evaluatorUI = new EvaluatorUI();
        evaluatorUI.setDebugger(new DebugCallback(){

            @Override
            public String eval(String expr) {
                if (debugger != null) {
                    return debugger.eval(expr);
                }
                return null;
            }

            @Override
            public boolean stringIsCompilableUnit(String str) {
                if (debugger != null) {
                    return debugger.stringIsCompilableUnit(str);
                }
                return false;
            }
        });
        this.window.addScriptUI(this, evaluatorUI);
    }

    @Override
    public void open() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.window.open();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RemoteScriptUI.this.window.open();
                }
            });
        }
    }

    @Override
    public void close() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.window.close();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RemoteScriptUI.this.window.close();
                }
            });
        }
    }
}

