/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.ConfigurableCaret;

public class ScriptArea
extends RSyntaxTextArea {
    private static final long serialVersionUID = -25032065448563720L;
    private Caret tmpCaret;

    public ScriptArea() {
        this.setFont(new Font("Monospaced", 0, 12));
        this.setSyntaxEditingStyle("text/javascript");
    }

    public void select(int pos) {
        if (pos >= 0) {
            JViewport vp = (JViewport)this.getParent();
            Rectangle viewRect = vp.getViewRect();
            int h = pos * this.getLineHeight();
            if (viewRect.y + viewRect.height < h + this.getLineHeight()) {
                viewRect.y = h - viewRect.height / 3;
                this.scrollRectToVisible(viewRect);
            } else if (viewRect.y > h) {
                viewRect.y = h;
                this.scrollRectToVisible(viewRect);
            }
            this.addDebugLineHighlight(pos);
        }
    }

    public void setCaret(Caret caret) {
        if (!(caret instanceof ConfigurableCaret)) {
            if (this.tmpCaret == null) {
                this.tmpCaret = new ConfigurableCaret();
            }
            caret = this.tmpCaret;
        }
        super.setCaret(caret);
    }

    private void addDebugLineHighlight(int pos) {
        Color color = Color.GREEN;
        this.removeAllLineHighlights();
        try {
            this.addLineHighlight(pos, color);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

