/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.EPException;
import com.kingdee.eas.ep.PlugInCollection;
import com.kingdee.eas.ep.PlugInFactory;
import com.kingdee.eas.ep.PlugInInfo;
import com.kingdee.eas.ep.PlugInScriptInfo;
import com.kingdee.eas.ep.client.PagePanel;
import com.kingdee.eas.ep.client.ScriptArea;
import com.kingdee.eas.ep.client.ScriptPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.ep.client.script.ClassCompletionProvider;
import com.kingdee.eas.ep.client.script.ImportAction;
import com.kingdee.eas.ep.client.script.MethodCompletionProvider;
import com.kingdee.eas.ep.client.util.UserBehaviorCollector;
import com.kingdee.eas.ep.plugin.PluginCacheClient;
import com.kingdee.eas.ep.plugin.ScriptReference;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.fife.ep.ui.autocomplete.AutoCompletion;
import org.fife.ep.ui.autocomplete.CompletionProvider;

public class ScriptCodeUI
extends PagePanel {
    private KDTabbedPane mainPanel = null;
    private KDWorkButton btnRefresh = null;
    private KDWorkButton btnSave = null;
    private KDButton btnExample = null;
    private KDLabel linkLabel = null;
    private KDCheckBox cbOver = null;
    private KDCheckBox cbDebug = null;
    private ScriptArea txtScriptBefore = null;
    private ScriptArea txtScriptAfter = null;
    private ScriptPanel pScriptBefore = null;
    private ScriptPanel pScriptAfter = null;
    private PlugInInfo plugIn = null;
    private int curIndex = 0;
    private boolean isMax = false;
    private Rectangle winSize = null;
    private int type = 0;
    private List scriptChanged = new ArrayList();

    ScriptCodeUI() {
        this(0);
    }

    public ScriptCodeUI(int type) {
        this.type = type;
        this.init();
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setMethodReturnSupport(boolean support) {
        this.cbOver.setVisible(support);
    }

    public ScriptArea getTxtScriptBefore() {
        return this.txtScriptBefore;
    }

    public ScriptArea getTxtScriptAfter() {
        return this.txtScriptAfter;
    }

    public PlugInInfo getPlugIn() {
        return this.plugIn;
    }

    private void init() {
        this.setBounds(new Rectangle(0, 0, 600, 400));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 600, 400));
        this.cbDebug = new KDCheckBox("\u8c03\u8bd5\u6a21\u5f0f\u6267\u884c");
        this.add((Component)this.cbDebug, new KDLayout.Constraints(3, 2, 100, 19, 5));
        this.cbOver = new KDCheckBox("\u524d\u7f6e\u811a\u672c\u6267\u884c\u540e\u8fd4\u56de");
        this.add((Component)this.cbOver, new KDLayout.Constraints(113, 2, 138, 19, 5));
        this.cbOver.setSelected(false);
        this.cbOver.setVisible(false);
        this.linkLabel = new KDLabel();
        this.linkLabel.setText("\u5347\u7ea7880\u8868\u683c\u76d1\u542c\u811a\u672c\u62a5\u9519\u89e3\u51b3\u65b9\u6848");
        this.linkLabel.setToolTipText("\u5347\u7ea7880\u8868\u683c\u76d1\u542c\u811a\u672c\u62a5\u9519\u89e3\u51b3\u65b9\u6848");
        this.linkLabel.setForeground(Color.red);
        this.linkLabel.setHorizontalAlignment(0);
        this.linkLabel.setVerticalAlignment(0);
        this.linkLabel.setCursor(new Cursor(12));
        this.linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FrameWorkUtils.openByDefaultBrowser((String)"https://vip.kingdee.com/article/380751295466020096");
            }
        });
        this.add((Component)this.linkLabel, new KDLayout.Constraints(250, 2, 200, 19, 9));
        this.btnExample = new KDButton();
        this.btnExample.setOpaque(false);
        this.btnExample.setForeground(Color.RED);
        this.btnExample.setText("\u811a\u672c\u53c2\u8003");
        this.btnExample.setToolTipText("\u811a\u672c\u53c2\u8003");
        this.add((Component)this.btnExample, new KDLayout.Constraints(452, 2, 83, 19, 9));
        this.btnSave = new KDWorkButton();
        this.btnSave.setName("btnSave");
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setToolTipText("\u4fdd\u5b58");
        this.add((Component)this.btnSave, new KDLayout.Constraints(541, 2, 22, 19, 9));
        this.btnRefresh = new KDWorkButton();
        this.btnRefresh.setName("btnRefresh");
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnRefresh.setToolTipText("\u8fd8\u539f");
        this.add((Component)this.btnRefresh, new KDLayout.Constraints(568, 2, 22, 19, 9));
        this.txtScriptBefore = new ScriptArea();
        this.txtScriptBefore.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ScriptCodeUI.this.curIndex = 1;
            }
        });
        this.pScriptBefore = new ScriptPanel(this.txtScriptBefore);
        this.txtScriptAfter = new ScriptArea();
        this.txtScriptAfter.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ScriptCodeUI.this.curIndex = 2;
            }
        });
        this.pScriptAfter = new ScriptPanel(this.txtScriptAfter);
        int mask = 8;
        ClassCompletionProvider cp = new ClassCompletionProvider();
        MethodCompletionProvider mp = new MethodCompletionProvider(this.type);
        mp.setParameterizedCompletionParams('(', ",", ')');
        AutoCompletion ac = new AutoCompletion(new CompletionProvider[]{cp, mp});
        ac.install((JTextComponent)((Object)this.txtScriptBefore));
        ac.setTriggerKey(KeyStroke.getKeyStroke(47, mask));
        ac.setParameterAssistanceEnabled(true);
        ac = new AutoCompletion(new CompletionProvider[]{cp, mp});
        ac.install((JTextComponent)((Object)this.txtScriptAfter));
        ac.setTriggerKey(KeyStroke.getKeyStroke(47, mask));
        ac.setParameterAssistanceEnabled(true);
        ImportAction importAction = new ImportAction();
        importAction.install((JTextComponent)((Object)this.txtScriptBefore));
        importAction.install((JTextComponent)((Object)this.txtScriptAfter));
        this.mainPanel = new KDTabbedPane();
        this.mainPanel.setBounds(new Rectangle(0, 0, 600, 378));
        this.mainPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 22, 600, 378));
        this.mainPanel.addTab("\u524d\u7f6e\u811a\u672c", (Component)((Object)this.pScriptBefore));
        this.mainPanel.addTab("\u540e\u7f6e\u811a\u672c", (Component)((Object)this.pScriptAfter));
        this.mainPanel.setSelectedIndex(1);
        this.add((Component)this.mainPanel, new KDLayout.Constraints(0, 22, 600, 378, 15));
        this.btnExample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptCodeUI.this.doExample();
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptCodeUI.this.doSave();
            }
        });
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScriptCodeUI.this.plugIn != null) {
                    ScriptCodeUI.this.loadScript(ScriptCodeUI.this.plugIn.getId());
                }
            }
        });
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptCodeUI.this.doSave();
            }
        };
        ActionMap actionMap = this.getActionMap();
        actionMap.put("CSTLSACTION", actionListener);
        KeyStroke controlAlt7 = KeyStroke.getKeyStroke(83, 2);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(controlAlt7, "CSTLSACTION");
        this.setActionMap(actionMap);
    }

    public void beforeSave(PlugInInfo plugin) throws EPException {
        String schemeID = plugin.getSchemeID();
        if (CustomSchemeUtil.isSystemScheme(schemeID)) {
            throw new EPException(EPException.SYSTEM_SCHEME_NOT_MODIFY);
        }
    }

    protected void doSave() {
        try {
            if (this.plugIn == null) {
                return;
            }
            this.beforeSave(this.plugIn);
            this.plugIn.setOver(this.cbOver.isSelected());
            PlugInScriptInfo script = this.plugIn.getScriptBefore();
            this.plugIn.getSchemeID();
            if (script == null) {
                script = new PlugInScriptInfo();
                this.plugIn.setScriptBefore(script);
            }
            String content = this.txtScriptBefore.getText();
            script.setContent(content);
            script.setDebug(this.cbDebug.isSelected());
            script.setReference(ScriptReference.getLibScriptIds(null, ScriptReference.parse(content), this.plugIn.getSchemeID()));
            script = this.plugIn.getScriptAfter();
            if (script == null) {
                script = new PlugInScriptInfo();
                this.plugIn.setScriptAfter(script);
            }
            content = this.txtScriptAfter.getText();
            script.setContent(content);
            script.setDebug(this.cbDebug.isSelected());
            script.setReference(ScriptReference.getLibScriptIds(null, ScriptReference.parse(content), this.plugIn.getSchemeID()));
            IObjectPK pk = PlugInFactory.getRemoteInstance().submit(this.plugIn);
            MsgBox.showInfo((Component)((Object)this), (String)"\u6269\u5c55\u811a\u672c\u4fdd\u5b58\u6210\u529f");
            BOSUuid id = null;
            if (pk != null) {
                id = BOSUuid.read((String)pk.toString());
            }
            PluginCacheClient.loadData();
            this.loadScript(id);
            UserBehaviorCollector.fireSavePluginScript(this.plugIn);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected void doExample() {
        String url = "http://mbos.kingdee.com/doc/wiki.html?key=depScript";
        FrameWorkUtils.openByDefaultBrowser((String)url);
    }

    private void loadScript(BOSUuid pluginID) {
        try {
            if (pluginID == null) {
                PlugInCollection pcol = PlugInFactory.getRemoteInstance().getPlugIn(this.plugIn.getSchemeID(), this.plugIn.getOwner(), this.plugIn.getPoint());
                if (pcol != null && pcol.size() > 0) {
                    this.plugIn = pcol.get(0);
                }
            } else if (PlugInFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(pluginID))) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("point.*"));
                selector.add(new SelectorItemInfo("point.param.*"));
                selector.add(new SelectorItemInfo("scriptBefore.*"));
                selector.add(new SelectorItemInfo("scriptAfter.*"));
                this.plugIn = PlugInFactory.getRemoteInstance().getPlugInInfo((IObjectPK)new ObjectUuidPK(pluginID), selector);
            } else if (this.plugIn != null) {
                this.plugIn.setId(null);
                this.plugIn.setScriptBefore(null);
                this.plugIn.setScriptAfter(null);
            }
            this.firePluginChanged(this.plugIn);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        this.loadScript(this.plugIn);
    }

    private void firePluginChanged(PlugInInfo plugIn) {
        int size = this.scriptChanged.size();
        for (int i = 0; i < size; ++i) {
            ((ScriptChangedListener)this.scriptChanged.get(i)).scriptChanged(plugIn);
        }
    }

    private void handUIException(Exception e) {
        ExceptionHandler.handle((Throwable)e);
    }

    public void appendScript(String script) {
        if (this.curIndex == 0) {
            return;
        }
        ScriptArea area = null;
        area = this.curIndex == 1 ? this.txtScriptBefore : this.txtScriptAfter;
        if (area != null) {
            int position = area.getCaretPosition();
            area.insert(script, position);
        }
    }

    public void loadScript(PlugInInfo plugIn) {
        this.plugIn = plugIn;
        if (plugIn != null) {
            this.cbDebug.setSelected(false);
            PlugInScriptInfo script = plugIn.getScriptBefore();
            if (script != null) {
                this.txtScriptBefore.setText(script.getContent());
                this.cbDebug.setSelected(script.isDebug());
            } else {
                this.txtScriptBefore.setText(null);
            }
            script = plugIn.getScriptAfter();
            if (script != null) {
                this.txtScriptAfter.setText(script.getContent());
                this.cbDebug.setSelected(script.isDebug());
            } else {
                this.txtScriptAfter.setText(null);
            }
            this.cbOver.setSelected(plugIn.isOver());
        } else {
            this.txtScriptBefore.setText(null);
            this.txtScriptAfter.setText(null);
        }
    }

    public void setState(boolean enable) {
        this.cbDebug.setEnabled(enable);
        this.cbOver.setEnabled(enable);
        this.txtScriptBefore.setEnabled(enable);
        this.txtScriptAfter.setEnabled(enable);
        this.btnRefresh.setEnabled(enable);
        this.btnSave.setEnabled(enable);
        if (!enable) {
            this.cbDebug.setSelected(false);
            this.cbOver.setSelected(false);
            this.txtScriptBefore.setText(null);
            this.txtScriptAfter.setText(null);
        }
    }

    public void registerScriptChangedListener(ScriptChangedListener listener) {
        this.scriptChanged.add(listener);
    }

    static interface ScriptChangedListener {
        public void scriptChanged(PlugInInfo var1);
    }
}

