/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.DebugSkeleton;
import com.kingdee.eas.ep.client.PlugInUI;
import com.kingdee.eas.ep.client.UIParam;
import com.kingdee.eas.ep.plugin.ExtendMethodInfo;
import com.kingdee.eas.ep.plugin.IScriptExecutor;
import com.kingdee.eas.ep.plugin.Logger4Script;
import com.kingdee.eas.ep.plugin.Param;
import com.kingdee.eas.ep.plugin.PluginUtils;
import com.kingdee.eas.ep.plugin.ScriptExecuteException;
import com.kingdee.eas.ep.plugin.ScriptInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptExecutor
implements IScriptExecutor {
    private static final Logger logger = Logger.getLogger(ScriptExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Param pluginCtx, ExtendMethodInfo mInfo, ScriptInfo script) throws ScriptExecuteException, EASBizException {
        UIParam param = (UIParam)pluginCtx;
        Object result = null;
        Logger4Script.info("extend point:" + mInfo);
        Logger4Script.info("script info:" + script);
        Logger4Script.info("Script execute start:" + System.currentTimeMillis());
        if (script.isDebug() && SwingUtilities.isEventDispatchThread()) {
            IUIWindow w = ScriptExecutor.getDebuggerWindow((CoreUIObject)param.getUI());
            PlugInUI ui = (PlugInUI)w.getUIObject();
            ui.setWindow(w);
            DebugSkeleton db = new DebugSkeleton(ui, param, mInfo);
            db.debug(script.getScript());
            PluginUtils.handleScriptException(null, db.getDebugException(), script);
        } else {
            Context ctx = Context.enter();
            ScriptableObject scope = ctx.initStandardObjects();
            scope.put("pluginCtx", (Scriptable)scope, (Object)param);
            scope.put("methodCtx", (Scriptable)scope, (Object)mInfo);
            try {
                result = ctx.evaluateString((Scriptable)scope, script.getScript(), null, 0, null);
            }
            catch (Throwable e) {
                try {
                    PluginUtils.handleScriptException(null, e, script);
                }
                catch (ScriptExecuteException se) {
                    MsgBox.showDetailAndOK(null, (String)"\u6269\u5c55\u811a\u672c\u6267\u884c\u5f02\u5e38\n\u70b9\u51fb\u201c\u8be6\u7ec6\u4fe1\u606f\u201d\u67e5\u770b\u62a5\u9519\u4fe1\u606f", (String)se.getMessage(), (int)0);
                    SysUtil.abort();
                }
            }
            finally {
                Context.exit();
            }
            Logger4Script.info("Script execute end:" + System.currentTimeMillis());
        }
        return result;
    }

    private static IUIWindow getDebuggerWindow(CoreUIObject parent) {
        UIContext uiContext = new UIContext((Object)parent);
        IUIWindow uiWindow = null;
        try {
            uiWindow = SwingUtilities.getWindowAncestor((Component)parent) != null && SwingUtilities.getWindowAncestor((Component)parent) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PlugInUI.class.getName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PlugInUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uiWindow;
    }
}

