/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.eas.ep.client.InterruptCallback;
import com.kingdee.eas.ep.client.PagePanel;
import com.kingdee.eas.ep.client.ScriptWindow;
import com.kingdee.eas.ep.debug.GuiCallback;
import com.kingdee.eas.ep.debug.ISourceInfo;
import com.kingdee.eas.ep.debug.IStackFrame;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.SwingUtilities;

public class ScriptUI
extends PagePanel
implements GuiCallback {
    private EventQueue awtEventQueue;
    ScriptWindow scriptWindow = null;
    private InterruptCallback interruptImpl = null;

    ScriptUI() {
        this.setBounds(new Rectangle(0, 0, 400, 400));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 400, 400));
        this.scriptWindow = new ScriptWindow(this, null);
        this.add((Component)((Object)this.scriptWindow.scriptPanel), new KDLayout.Constraints(0, 0, 400, 400, 15));
        this.doLayout();
    }

    static String getShortName(String url) {
        int lastSlash = url.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = url.lastIndexOf(92);
        }
        String shortName = url;
        if (lastSlash >= 0 && lastSlash + 1 < url.length()) {
            shortName = url.substring(lastSlash + 1);
        }
        return shortName;
    }

    @Override
    public void dispatchNextGuiEvent() throws InterruptedException {
        AWTEvent event;
        EventQueue queue = this.awtEventQueue;
        if (queue == null) {
            this.awtEventQueue = queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        if ((event = queue.getNextEvent()) instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else {
            Object source = event.getSource();
            if (source instanceof Component) {
                Component comp = (Component)source;
                comp.dispatchEvent(event);
            } else if (source instanceof MenuComponent) {
                ((MenuComponent)source).dispatchEvent(event);
            }
        }
    }

    @Override
    public void enterInterrupt(IStackFrame lastFrame, String threadTitle, String alertMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enterInterruptImpl(lastFrame, threadTitle, alertMessage);
        } else {
            RunProxy proxy = new RunProxy(this, 1);
            proxy.lastFrame = lastFrame;
            proxy.threadTitle = threadTitle;
            proxy.alertMessage = alertMessage;
            SwingUtilities.invokeLater(proxy);
        }
    }

    void showStopLine(IStackFrame frame) {
        String sourceName = frame.getUrl();
        if (sourceName != null) {
            int lineNumber = frame.getLineNumber();
            this.updateScriptWindow(frame.sourceInfo(), lineNumber);
        }
    }

    protected void updateScriptWindow(ISourceInfo sourceInfo, int line) {
        this.scriptWindow.updateText(sourceInfo);
        if (line != -1) {
            this.scriptWindow.setPosition(line - 1);
        }
    }

    void enterInterruptImpl(IStackFrame lastFrame, String threadTitle, String alertMessage) {
        this.showStopLine(lastFrame);
        if (this.interruptImpl != null) {
            this.interruptImpl.enterInterruptImpl(lastFrame, threadTitle, alertMessage);
        }
    }

    @Override
    public boolean isGuiEventThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    @Override
    public void updateSourceText(ISourceInfo sourceInfo) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateScriptWindow(sourceInfo, -1);
        } else {
            RunProxy proxy = new RunProxy(this, 0);
            proxy.sourceInfo = sourceInfo;
            SwingUtilities.invokeLater(proxy);
        }
    }

    class RunProxy
    implements Runnable {
        static final int UPDATE_SOURCE_TEXT = 0;
        static final int ENTER_INTERRUPT = 1;
        private ScriptUI debugGui;
        private int type;
        String text;
        ISourceInfo sourceInfo;
        IStackFrame lastFrame;
        String threadTitle;
        String alertMessage;

        public RunProxy(ScriptUI debugGui, int type) {
            this.debugGui = debugGui;
            this.type = type;
        }

        @Override
        public void run() {
            switch (this.type) {
                case 0: {
                    this.debugGui.updateScriptWindow(this.sourceInfo, -1);
                    break;
                }
                case 1: {
                    this.debugGui.enterInterruptImpl(this.lastFrame, this.threadTitle, this.alertMessage);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(this.type));
                }
            }
        }
    }
}

