/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.eas.ep.client.ScriptArea;
import com.kingdee.eas.ep.client.ScriptPanel;
import com.kingdee.eas.ep.client.ScriptUI;
import com.kingdee.eas.ep.debug.ISourceInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.text.BadLocationException;

public class ScriptWindow
implements ActionListener {
    private static final long serialVersionUID = -6212382604952082370L;
    private ScriptUI debugGui;
    private ISourceInfo sourceInfo;
    ScriptArea textArea;
    ScriptPanel scriptPanel;
    int currentPos;

    public int getPosition(int line) {
        int result = -1;
        try {
            result = this.textArea.getLineStartOffset(line);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return result;
    }

    public boolean isBreakPoint(int line) {
        return this.sourceInfo.breakableLine(line) && this.sourceInfo.breakpoint(line);
    }

    public void toggleBreakPoint(int line) {
        if (!this.isBreakPoint(line)) {
            this.setBreakPoint(line);
        } else {
            this.clearBreakPoint(line);
        }
    }

    public void setBreakPoint(int line) {
        boolean changed;
        if (this.sourceInfo.breakableLine(line) && (changed = this.sourceInfo.breakpoint(line, true))) {
            this.scriptPanel.toggleBookmark(line);
        }
    }

    public void clearBreakPoint(int line) {
        boolean changed;
        if (this.sourceInfo.breakableLine(line) && (changed = this.sourceInfo.breakpoint(line, false))) {
            this.scriptPanel.toggleBookmark(line);
        }
    }

    public ScriptWindow(ScriptUI debugGui, ISourceInfo sourceInfo) {
        this.debugGui = debugGui;
        this.sourceInfo = sourceInfo;
        this.currentPos = -1;
        this.textArea = new ScriptArea();
        this.scriptPanel = new ScriptPanel(this.textArea);
        this.scriptPanel.enableBreakPointSet();
        Component[] components = this.scriptPanel.getGutter().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            try {
                Class<?> iconRowHeaderClazz = Class.forName("org.fife.ui.rtextarea.IconRowHeader");
                if (comp == null || !iconRowHeaderClazz.isAssignableFrom(comp.getClass())) continue;
                MouseListener[] mouseListeners = components[i].getMouseListeners();
                for (int j = 0; j < mouseListeners.length; ++j) {
                    MouseListener ls = mouseListeners[j];
                    if (ls == null || !iconRowHeaderClazz.isAssignableFrom(ls.getClass())) continue;
                    comp.removeMouseListener(ls);
                    comp.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            try {
                                int offs = ScriptWindow.this.textArea.viewToModel(e.getPoint());
                                if (offs > -1) {
                                    int line = ScriptWindow.this.textArea.getLineOfOffset(offs);
                                    ScriptWindow.this.toggleBreakPoint(line + 1);
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.updateText(sourceInfo);
    }

    public String getUrl() {
        return this.sourceInfo.url();
    }

    public void updateText(ISourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        if (sourceInfo == null) {
            return;
        }
        String newText = sourceInfo.source();
        if (!this.textArea.getText().equals(newText)) {
            this.textArea.setText(newText);
            int pos = 0;
            if (this.currentPos != -1) {
                pos = this.currentPos;
            }
            this.textArea.select(pos);
        }
    }

    public void setPosition(int pos) {
        this.textArea.select(pos);
        this.currentPos = pos;
        this.scriptPanel.repaint();
    }

    public void select(int start, int end) {
        int docEnd = this.textArea.getDocument().getLength();
        this.textArea.select(docEnd, docEnd);
        this.textArea.select(start, end);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (!cmd.equals("Cut")) {
            if (cmd.equals("Copy")) {
                this.textArea.copy();
            } else if (cmd.equals("Paste")) {
                // empty if block
            }
        }
    }
}

