/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.AbstractTreeBaseCustomNewListUI;
import com.kingdee.eas.ep.client.util.ListUICustom;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class TreeBaseCustomNewListUI
extends AbstractTreeBaseCustomNewListUI {
    private static final Logger logger = CoreUIObject.getLogger(TreeBaseCustomNewListUI.class);
    private ListUICustom custom = null;

    public TreeBaseCustomNewListUI() throws Exception {
        this.addTableListener();
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    public void initLayout() {
        try {
            this.loadCustomConfig();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initLayout();
    }

    private void loadCustomConfig() throws Exception {
        this.custom = new ListUICustom(this.getUIContext());
        this.custom.init();
        this.setUITitle(this.custom.getUiTitle());
        this.mainQueryPK = this.custom.getMainQueryPK();
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        if (this.custom == null) {
            return null;
        }
        return this.custom.getMetaDataPK();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        this.custom.prepareUIContext(uiContext, e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.custom.unPrepareUIContext(this.getUIContext());
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        this.custom.unPrepareUIContext(this.getUIContext());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.custom.unPrepareUIContext(this.getUIContext());
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.custom.unPrepareUIContext(this.getUIContext());
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return this.custom.getBizInterface();
    }

    public void setUITitle(String title) {
        if ((title == "" || title == null) && this.custom != null) {
            title = this.custom.getUiTitle();
        }
        super.setUITitle(title);
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return (ITreeBase)this.custom.getBizInterface();
    }

    protected String getLongNumberFieldName() {
        return "longNumber";
    }

    protected String getRootName() {
        return this.custom.getUiTitle();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancle", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
        }
        this.refreshList();
        this.actionCancelCancel.setEnabled(false);
        this.actionCancel.setEnabled(true);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refreshList();
        this.actionCancelCancel.setEnabled(true);
        this.actionCancel.setEnabled(false);
    }

    public IRow getSelectedRow(KDTable tblMain) {
        this.checkSelected();
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            SysUtil.abort();
        }
        IRow row = tblMain.getRow(selectBlock.getTop());
        return row;
    }

    private void addTableListener() {
        this.tblMain.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int i = e.getSelectBlock().getTop();
                if (i >= 0) {
                    IRow row = TreeBaseCustomNewListUI.this.getSelectedRow(TreeBaseCustomNewListUI.this.tblMain);
                    Integer isAccepted = (Integer)row.getCell("deletedStatus").getValue();
                    DeletedStatusEnum deletedStatus = null;
                    if (isAccepted != null) {
                        deletedStatus = DeletedStatusEnum.getEnum((int)isAccepted);
                    }
                    if (deletedStatus == DeletedStatusEnum.DELETED) {
                        TreeBaseCustomNewListUI.this.actionCancelCancel.setEnabled(true);
                        TreeBaseCustomNewListUI.this.actionCancel.setEnabled(false);
                    } else {
                        TreeBaseCustomNewListUI.this.actionCancelCancel.setEnabled(false);
                        TreeBaseCustomNewListUI.this.actionCancel.setEnabled(true);
                    }
                }
            }
        });
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        if (e != null && e.getNewLeadSelectionPath() == null) {
            return;
        }
        if (this.getSelectedTreeNode() != null && !(this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) && this.getSelectedTreeNode().isRoot()) {
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(false);
        }
    }
}

