/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.ctrl;

import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.ep.client.policy.tab.ICustomizedUnitTabPolicy;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EditorTabbedPane
extends KDTabbedPane
implements ChangeListener,
MouseListener {
    private static final long serialVersionUID = -6572788437357426307L;
    private static Logger logger = Logger.getLogger(EditorTabbedPane.class);
    protected CustomizedUnitUI ui;
    private List tabItemPolicy = new ArrayList();
    private int tabIndex = 0;

    public EditorTabbedPane() {
        this.addChangeListener(this);
        this.addHeadMouseListener(this);
    }

    public void add(Component component, Object constraints, int index) {
        super.add(component, constraints, index);
        if (component instanceof IEditorTabPanel) {
            this.fireAddTab((IEditorTabPanel)((Object)component));
        }
    }

    public Component add(Component component, int index) {
        Component comp = super.add(component, index);
        if (component instanceof IEditorTabPanel) {
            this.fireAddTab((IEditorTabPanel)((Object)component));
        }
        return comp;
    }

    public void add(Component component, Object constraints) {
        super.add(component, constraints);
        if (component instanceof IEditorTabPanel) {
            this.fireAddTab((IEditorTabPanel)((Object)component));
        }
    }

    public Component add(Component component) {
        Component comp = super.add(component);
        if (component instanceof IEditorTabPanel) {
            this.fireAddTab((IEditorTabPanel)((Object)component));
        }
        return comp;
    }

    public void addEditorTabPolicy(ICustomizedUnitTabPolicy policy) {
        this.tabItemPolicy.add(policy);
        policy.setCustomizedUnitUI(this.getCustomizedUnitUI());
        policy.setTabPanel(this);
    }

    public void removeEditorTabPolicy(ICustomizedUnitTabPolicy policy) {
        this.tabItemPolicy.remove(policy);
    }

    public CustomizedUnitUI getCustomizedUnitUI() {
        return this.ui;
    }

    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
        this.ui = ui;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.tabIndex != this.getSelectedIndex() && this.isCorrectIndex(this.tabIndex) && this.isCorrectIndex(this.getSelectedIndex())) {
            IEditorTabPanel tabOld = (IEditorTabPanel)((Object)this.getComponentAt(this.tabIndex));
            IEditorTabPanel tabNew = (IEditorTabPanel)((Object)this.getComponentAt(this.getSelectedIndex()));
            this.tabIndex = this.getSelectedIndex();
            this.fireSelectedChange(tabNew, tabOld, e);
        }
    }

    private boolean isCorrectIndex(int index) {
        return index >= 0 && index <= this.getTabCount() - 1;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int index;
        if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && this.isCorrectIndex(index = this.getSelectedIndex()) && this.ui != null && this.ui.getEditorPanel() != null) {
            IEditorTabPanel tab = (IEditorTabPanel)((Object)this.getComponentAt(index));
            if (!this.isEnabledAt(index)) {
                return;
            }
            if (tab.isDirty() && this.needSave(tab) && !CustomSchemeUtil.isStartScheme(tab.getDepends().getId())) {
                int result = MsgBox.showConfirm3((Component)((Object)this.ui), (String)"\u6570\u636e\u8fd8\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u8fdb\u884c\u4fdd\u5b58\uff1f");
                if (0 == result) {
                    this.ui.getEditorPanel().doSave(index);
                    this.ui.getEditorPanel().removeTabPanel(index);
                    this.fireCloseTab(tab, e);
                } else if (1 == result) {
                    this.ui.getEditorPanel().removeTabPanel(index);
                    this.fireCloseTab(tab, e);
                }
            } else {
                this.ui.getEditorPanel().removeTabPanel(index);
                this.fireCloseTab(tab, e);
            }
        }
    }

    private boolean needSave(IEditorTabPanel tab) {
        try {
            Project depends = tab.getDepends();
            String id = depends.getId();
            return !CustomSchemeUtil.isSystemScheme(id);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return true;
        }
    }

    public void fireCloseTab(IEditorTabPanel closeTab, MouseEvent e) {
        Iterator iter = this.tabItemPolicy.iterator();
        while (iter.hasNext()) {
            ((ICustomizedUnitTabPolicy)iter.next()).fireCloseTab(closeTab, e);
        }
    }

    public void fireSelectedChange(IEditorTabPanel newTab, IEditorTabPanel oldTab, ChangeEvent e) {
        Iterator iter = this.tabItemPolicy.iterator();
        while (iter.hasNext()) {
            ((ICustomizedUnitTabPolicy)iter.next()).fireSelectedChange(newTab, oldTab, e);
        }
    }

    public void fireAddTab(IEditorTabPanel addTab) {
        Iterator iter = this.tabItemPolicy.iterator();
        while (iter.hasNext()) {
            ((ICustomizedUnitTabPolicy)iter.next()).fireAddTab(addTab);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

