/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.ctrl;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeComboBoxUI;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.ep.client.ctrl.MyIconRenderer;
import com.kingdee.eas.ep.client.ctrl.TreePopup;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TreeComboBox
extends JComboBox {
    private KDTree tree;
    private static final int popupHeight = 200;

    public TreeComboBox() {
        this(new KDTree());
    }

    public TreeComboBox(KDTree tree) {
        this(tree, new MyIconRenderer());
    }

    public TreeComboBox(KDTree tree, TreeCellRenderer treeCellRenderer) {
        this(tree, treeCellRenderer, false);
    }

    public TreeComboBox(KDTree tree, TreeCellRenderer treeCellRenderer, boolean showRoot) {
        this.setTree(tree);
        tree.setCellRenderer(treeCellRenderer);
        if (!showRoot) {
            tree.expandPath(new TreePath(tree.getModel().getRoot()));
            tree.setRootVisible(false);
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        this.setSelectedItem(root);
    }

    public void setTree(KDTree tree) {
        this.tree = tree;
        if (tree != null) {
            this.setRenderer(new TreeComboBoxRenderer());
        }
        this.updateUI();
    }

    public KDTree getTree() {
        return this.tree;
    }

    @Override
    public void setSelectedItem(Object node) {
        this.tree.setSelectionNode((DefaultKingdeeTreeNode)node);
        this.getModel().setSelectedItem(node);
    }

    public Object getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getSelectedItem();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    @Override
    public void updateUI() {
        ComboBoxUI cui = (ComboBoxUI)UIManager.getUI(this);
        if (cui instanceof KingdeeComboBoxUI) {
            cui = new MetalTreeComboBoxUI();
        }
        this.setUI(cui);
    }

    private class TreeComboBoxRenderer
    extends DefaultListCellRenderer {
        private TreeComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)value;
                TreeCellRenderer treeCellRenderer = TreeComboBox.this.tree.getCellRenderer();
                JLabel lb = (JLabel)treeCellRenderer.getTreeCellRendererComponent((JTree)TreeComboBox.this.tree, node, isSelected, false, node.isLeaf(), index, cellHasFocus);
                return lb;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    class KingdeeTreeComboBoxUI
    extends KingdeeComboBoxUI {
        KingdeeTreeComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new TreePopup(this.comboBox, 200);
        }
    }

    class MetalTreeComboBoxUI
    extends MetalComboBoxUI {
        MetalTreeComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            return new TreePopup(this.comboBox, 200);
        }
    }
}

